/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.mzdb.PeakelDetectorQueue;
import fr.profi.mzdb.PeakelDetectorQueueEntry;
import fr.profi.mzdb.algo.feature.extraction.UnsupervisedPeakelDetector;
import fr.profi.mzdb.model.PeakList;
import fr.profi.mzdb.model.PeakListCollection;
import fr.profi.mzdb.model.PeakListTree;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.RunSliceHeader;
import java.io.Serializable;
import rx.lang.scala.Observable;
import rx.lang.scala.Observable$;
import rx.lang.scala.Scheduler;
import rx.lang.scala.Subscriber;
import rx.lang.scala.schedulers.ExecutionContextScheduler;
import rx.lang.scala.schedulers.ExecutionContextScheduler$;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LongMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4A\u0001E\t\u00011!A\u0011\u0006\u0001BC\u0002\u0013\u0005!\u0006\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003,\u0011!y\u0003A!b\u0001\n\u0003\u0001\u0004\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011q\u0002!Q1A\u0005\u0002uB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IA\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0006\t\")!\n\u0001C\u0001\u0017\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0006BB5\u0001A\u0003%A\u000bC\u0004k\u0001\t\u0007I\u0011B6\t\rI\u0004\u0001\u0015!\u0003m\u0011\u001d\u0019\bA1A\u0005\nMCa\u0001\u001e\u0001!\u0002\u0013!\u0006\"B;\u0001\t\u0003\u0019&A\u0006)fC.,G\u000eR3uK\u000e$xN]\"p]N,X.\u001a:\u000b\u0005I\u0019\u0012\u0001B7{I\nT!\u0001F\u000b\u0002\u000bA\u0014xNZ5\u000b\u0003Y\t!A\u001a:\u0004\u0001M\u0019\u0001!G\u0010\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\t\u0001s%D\u0001\"\u0015\t\u00113%\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002%K\u0005AA/\u001f9fg\u00064WMC\u0001'\u0003\r\u0019w.\\\u0005\u0003Q\u0005\u00121\u0002T1{s2{wmZ5oO\u0006q1m\u001c8tk6,'OT;nE\u0016\u0014X#A\u0016\u0011\u0005ia\u0013BA\u0017\u001c\u0005\rIe\u000e^\u0001\u0010G>t7/^7fe:+XNY3sA\u0005q\u0001/Z1lK2$U\r^3di>\u0014X#A\u0019\u0011\u0005IJT\"A\u001a\u000b\u0005Q*\u0014AC3yiJ\f7\r^5p]*\u0011agN\u0001\bM\u0016\fG/\u001e:f\u0015\tA\u0014#\u0001\u0003bY\u001e|\u0017B\u0001\u001e4\u0005i)fn];qKJ4\u0018n]3e!\u0016\f7.\u001a7EKR,7\r^8s\u0003=\u0001X-Y6fY\u0012+G/Z2u_J\u0004\u0013!\u00043fi\u0016\u001cGo\u001c:Rk\u0016,X-F\u0001?!\ty\u0004)D\u0001\u0012\u0013\t\t\u0015CA\nQK\u0006\\W\r\u001c#fi\u0016\u001cGo\u001c:Rk\u0016,X-\u0001\beKR,7\r^8s#V,W/\u001a\u0011\u0002\u000f\u0015DXmY\"uqB\u0011Q\tS\u0007\u0002\r*\u0011qiG\u0001\u000bG>t7-\u001e:sK:$\u0018BA%G\u0005a)\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t1{\u0005+\u0015\u000b\u0003\u001b:\u0003\"a\u0010\u0001\t\u000b\rC\u00019\u0001#\t\u000b%B\u0001\u0019A\u0016\t\u000b=B\u0001\u0019A\u0019\t\u000bqB\u0001\u0019\u0001 \u0002\u001d\r|G\u000eZ(cg\u0016\u0014h/\u00192mKV\tA\u000bE\u0002V7vk\u0011A\u0016\u0006\u00039]S!\u0001W-\u0002\t1\fgn\u001a\u0006\u00025\u0006\u0011!\u000f_\u0005\u00039Z\u0013!b\u00142tKJ4\u0018M\u00197f!\u0011Qbl\u000b1\n\u0005}[\"A\u0002+va2,'\u0007E\u0002\u001bC\u000eL!AY\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019\f\u0012!B7pI\u0016d\u0017B\u00015f\u0005\u0019\u0001V-Y6fY\u0006y1m\u001c7e\u001f\n\u001cXM\u001d<bE2,\u0007%\u0001\tfq\u0016\u001c7\t\u001e=TG\",G-\u001e7feV\tA\u000e\u0005\u0002na6\taN\u0003\u0002p-\u0006Q1o\u00195fIVdWM]:\n\u0005Et'!G#yK\u000e,H/[8o\u0007>tG/\u001a=u'\u000eDW\rZ;mKJ\f\u0011#\u001a=fG\u000e#\bpU2iK\u0012,H.\u001a:!\u0003Q\u0019wN\u001c4jOV\u0014X\rZ(cg\u0016\u0014h/\u00192mK\u0006)2m\u001c8gS\u001e,(/\u001a3PEN,'O^1cY\u0016\u0004\u0013AC8cg\u0016\u0014h/\u00192mK\u0002")
public class PeakelDetectorConsumer
implements LazyLogging {
    private final int consumerNumber;
    private final UnsupervisedPeakelDetector peakelDetector;
    private final PeakelDetectorQueue detectorQueue;
    private final Observable<Tuple2<Object, Peakel[]>> coldObservable;
    private final ExecutionContextScheduler execCtxScheduler;
    private final Observable<Tuple2<Object, Peakel[]>> configuredObservable;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        PeakelDetectorConsumer peakelDetectorConsumer = this;
        synchronized (peakelDetectorConsumer) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public int consumerNumber() {
        return this.consumerNumber;
    }

    public UnsupervisedPeakelDetector peakelDetector() {
        return this.peakelDetector;
    }

    public PeakelDetectorQueue detectorQueue() {
        return this.detectorQueue;
    }

    private Observable<Tuple2<Object, Peakel[]>> coldObservable() {
        return this.coldObservable;
    }

    private ExecutionContextScheduler execCtxScheduler() {
        return this.execCtxScheduler;
    }

    private Observable<Tuple2<Object, Peakel[]>> configuredObservable() {
        return this.configuredObservable;
    }

    public Observable<Tuple2<Object, Peakel[]>> observable() {
        return this.configuredObservable();
    }

    public static final /* synthetic */ PeakList $anonfun$coldObservable$2(LongMap curPeaklistBySpectrumId$1, long specId) {
        return (PeakList)curPeaklistBySpectrumId$1.getOrNull(specId);
    }

    public static final /* synthetic */ boolean $anonfun$coldObservable$3(RunSliceHeader rsHeader$1, Peakel p) {
        return p.getApexMz() >= rsHeader$1.getBeginMz() && p.getApexMz() <= rsHeader$1.getEndMz();
    }

    public static final /* synthetic */ void $anonfun$coldObservable$1(PeakelDetectorConsumer $this, Subscriber subscriber) {
        try {
            boolean hasFinished = false;
            while (!hasFinished) {
                Peakel[] peakelArray;
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                BoxedUnit boxedUnit3;
                BoxedUnit boxedUnit4;
                PeakelDetectorQueueEntry queueEntry = $this.detectorQueue().dequeue();
                if (queueEntry == null) {
                    hasFinished = true;
                    if ($this.logger().underlying().isDebugEnabled()) {
                        $this.logger().underlying().debug(new StringBuilder(34).append("exiting feature detector consumer ").append($this.consumerNumber()).toString());
                        boxedUnit4 = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit4 = BoxedUnit.UNIT;
                    continue;
                }
                RunSliceHeader rsHeader = queueEntry.rsHeader();
                int rsNumber = queueEntry.rsHeader().getNumber();
                PeakListTree pklTree = queueEntry.pklTree();
                LongMap<PeakList> curPeaklistBySpectrumId = queueEntry.curPeaklistBySpectrumId();
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug("unsupervised processing of run slice {} in consumer {}", new Object[]{BoxesRunTime.boxToInteger((int)rsNumber), BoxesRunTime.boxToInteger((int)$this.consumerNumber())});
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                PeakList[] curRsPeakLists = (PeakList[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(pklTree.spectrumIds())).map((Function1 & Serializable & scala.Serializable)specId -> PeakelDetectorConsumer.$anonfun$coldObservable$2(curPeaklistBySpectrumId, BoxesRunTime.unboxToLong((Object)specId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PeakList.class)));
                PeakListCollection curRsPeakListColl = new PeakListCollection(curRsPeakLists);
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug(new StringBuilder(53).append("sorting #").append(curRsPeakListColl.peaksCount()).append(" peaks by descending intensity in run slice ").append(rsNumber).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                int[][] curRsPeaksCoords = curRsPeakListColl.getPeaksCoordsSortedByDescIntensity();
                int[] highestPeakCoords = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])curRsPeaksCoords)).head();
                int[] lowestPeakCoords = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])curRsPeaksCoords)).last();
                float highestIntensity = curRsPeakListColl.getPeakAt(highestPeakCoords[0], highestPeakCoords[1]).getIntensity();
                float lowestIntensity = curRsPeakListColl.getPeakAt(lowestPeakCoords[0], lowestPeakCoords[1]).getIntensity();
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug(new StringBuilder(41).append("Peak intensity range in run slice ").append(rsNumber).append(" = ").append(lowestIntensity).append(" to ").append(highestIntensity).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                PeakListTree peakListTree = pklTree;
                synchronized (peakListTree) {
                    peakelArray = $this.peakelDetector().detectPeakels(pklTree, curRsPeakListColl, curRsPeaksCoords);
                }
                Peakel[] peakels = (Peakel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelArray)).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)PeakelDetectorConsumer.$anonfun$coldObservable$3(rsHeader, p)));
                subscriber.onNext((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)rsNumber), (Object)peakels));
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug(new StringBuilder(28).append("found ").append(peakels.length).append(" peakels in run slice ").append(rsNumber).toString());
                    boxedUnit4 = BoxedUnit.UNIT;
                    continue;
                }
                boxedUnit4 = BoxedUnit.UNIT;
            }
            subscriber.onCompleted();
        }
        catch (Throwable t) {
            subscriber.onError(t);
        }
    }

    public PeakelDetectorConsumer(int consumerNumber, UnsupervisedPeakelDetector peakelDetector, PeakelDetectorQueue detectorQueue, ExecutionContextExecutor execCtx) {
        this.consumerNumber = consumerNumber;
        this.peakelDetector = peakelDetector;
        this.detectorQueue = detectorQueue;
        LazyLogging.$init$((LazyLogging)this);
        this.coldObservable = Observable$.MODULE$.apply((Function1 & Serializable & scala.Serializable)subscriber -> {
            PeakelDetectorConsumer.$anonfun$coldObservable$1(this, subscriber);
            return BoxedUnit.UNIT;
        });
        this.execCtxScheduler = ExecutionContextScheduler$.MODULE$.apply((ExecutionContext)execCtx);
        this.configuredObservable = this.coldObservable().subscribeOn((Scheduler)this.execCtxScheduler());
    }
}

