/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.exporter;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.algo.signal.detection.SmartPeakelFinder;
import fr.profi.mzdb.algo.signal.detection.SmartPeakelFinder$;
import fr.profi.mzdb.algo.signal.filtering.BaselineRemover;
import fr.profi.mzdb.algo.signal.filtering.BaselineRemover$;
import fr.profi.mzdb.algo.signal.filtering.PartialSavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoother;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoothingConfig;
import fr.profi.mzdb.algo.signal.filtering.SavitzkyGolaySmoothingConfig$;
import fr.profi.mzdb.algo.signal.filtering.XicBinner;
import fr.profi.mzdb.algo.signal.filtering.XicBinnerConfig;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.util.math.DerivativeAnalysis;
import fr.profi.mzdb.util.math.DerivativeAnalysis$;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class SQLitePeakelStorer$ {
    public static SQLitePeakelStorer$ MODULE$;
    private final SavitzkyGolaySmoother sgSmoother;
    private final PartialSavitzkyGolaySmoother psgSmoother;
    private final XicBinner xicBinner;
    private final SmartPeakelFinder peakelFinder;

    static {
        new SQLitePeakelStorer$();
    }

    public SavitzkyGolaySmoother sgSmoother() {
        return this.sgSmoother;
    }

    public PartialSavitzkyGolaySmoother psgSmoother() {
        return this.psgSmoother;
    }

    public XicBinner xicBinner() {
        return this.xicBinner;
    }

    public SmartPeakelFinder peakelFinder() {
        return this.peakelFinder;
    }

    public void storePeakels(Seq<Peakel> peakels, File dbLocation) {
        Predef$.MODULE$.println((Object)new StringBuilder(11).append("nb peakels:").append(peakels.length()).toString());
        SQLiteConnection connection = new SQLiteConnection(dbLocation);
        connection.open(true);
        connection.exec("PRAGMA temp_store=2;");
        connection.exec("PRAGMA cache_size=8000;");
        connection.exec("CREATE TABLE peakel ( id INTEGER,\n mz REAL,\n time REAL,\n apex REAL,\n ms1_count INTEGER,\n factor REAL,\n xic BLOB,\n smoothed_xic BLOB,\n noise_free_xic BLOB,\n found_peakels BLOB,\n mini_maxi TEXT\n)");
        connection.exec("BEGIN TRANSACTION");
        SQLiteStatement stmt = connection.prepare("INSERT INTO peakel VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", true);
        peakels.foreach((Function1 & Serializable & scala.Serializable)peakel -> {
            Tuple2[] tuple2Array;
            Tuple2[] xic = (Tuple2[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(peakel.elutionTimes())).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(peakel.intensityValues())).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$1 -> x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            byte[] chartBytes = MODULE$.createXicChart(xic, MODULE$.createXicChart$default$2());
            double oscillationFactor = MODULE$.peakelFinder().calcOscillationFactor(xic);
            Tuple2<Object, Object>[] smoothedXic = MODULE$.psgSmoother().smoothTimeIntensityPairs(xic);
            byte[] smoothedChartBytes = MODULE$.createXicChart(smoothedXic, MODULE$.createXicChart$default$2());
            Tuple2<Object, Object>[] baselineAnalysis = new BaselineRemover(BaselineRemover$.MODULE$.$lessinit$greater$default$1(), BaselineRemover$.MODULE$.$lessinit$greater$default$2()).removeBaseLine(xic);
            byte[] baselineAnalysisChartBytes = MODULE$.createXicChart(baselineAnalysis, MODULE$.createXicChart$default$2());
            Tuple2<Object, Object>[] peakelsIndices = MODULE$.peakelFinder().findPeakelsIndices(xic);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelsIndices)).isEmpty()) {
                tuple2Array = xic;
            } else {
                ArrayBuffer mergedXicBuffer = new ArrayBuffer(xic.length);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peakelsIndices)).foreach((Function1 & Serializable & scala.Serializable)peakelIndices -> {
                    Tuple2[] peaks = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xic)).slice(peakelIndices._1$mcI$sp(), peakelIndices._2$mcI$sp() + 1);
                    mergedXicBuffer.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaks)).head())._1()) - 0.1f))), (Object)BoxesRunTime.boxToDouble((double)0.0)));
                    mergedXicBuffer.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaks)));
                    return mergedXicBuffer.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)((Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaks)).last())._1()) + 0.1f))), (Object)BoxesRunTime.boxToDouble((double)0.0)));
                });
                tuple2Array = (Tuple2[])mergedXicBuffer.toArray(ClassTag$.MODULE$.apply(Tuple2.class));
            }
            Tuple2[] mergedXic = tuple2Array;
            byte[] mergedXicChartBytes = MODULE$.createXicChart(mergedXic, MODULE$.createXicChart$default$2());
            DerivativeAnalysis.ILocalDerivativeChange[] miniMaxi = DerivativeAnalysis$.MODULE$.findSignificantMiniMaxi((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])smoothedXic)).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToDouble((double)x$2._2$mcD$sp()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), 3, 0.66f);
            int j = 0;
            stmt.bind(++j, peakel.getId());
            stmt.bind(++j, peakel.getMz());
            stmt.bind(++j, (double)peakel.getApexElutionTime());
            stmt.bind(++j, (double)peakel.getApexIntensity());
            stmt.bind(++j, peakel.getSpectrumIds().length);
            stmt.bind(++j, oscillationFactor);
            stmt.bind(++j, chartBytes);
            stmt.bind(++j, smoothedChartBytes);
            stmt.bind(++j, baselineAnalysisChartBytes);
            stmt.bind(++j, mergedXicChartBytes);
            stmt.bind(++j, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])miniMaxi)).map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(2).append(m.value()).append("(").append(m.isMaximum()).append(")").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("\t"));
            stmt.step();
            return stmt.reset();
        });
        connection.exec("COMMIT TRANSACTION");
        connection.dispose();
    }

    public byte[] createXicChart(Tuple2<Object, Object>[] xic, float scaling) {
        XYSeries series = new XYSeries((Comparable)((Object)"XIC"));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xic)).foreach((Function1 & Serializable & scala.Serializable)dataPoint -> {
            series.add((double)(BoxesRunTime.unboxToFloat((Object)dataPoint._1()) * scaling), dataPoint._2$mcD$sp());
            return BoxedUnit.UNIT;
        });
        XYSeriesCollection xyDataset = new XYSeriesCollection(series);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"XIC", (String)"Time", (String)"Intensity", (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        BufferedImage bi = this.chartToImage(chart, 400, 300);
        return ChartUtils.encodeAsPNG((BufferedImage)bi);
    }

    public float createXicChart$default$2() {
        return 0.016666668f;
    }

    public BufferedImage chartToImage(JFreeChart chart, int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2 = img.createGraphics();
        chart.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
        g2.dispose();
        return img;
    }

    private SQLitePeakelStorer$() {
        MODULE$ = this;
        this.sgSmoother = new SavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(SavitzkyGolaySmoothingConfig$.MODULE$.apply$default$1(), SavitzkyGolaySmoothingConfig$.MODULE$.apply$default$2(), SavitzkyGolaySmoothingConfig$.MODULE$.apply$default$3()));
        int x$1 = 1;
        int x$2 = SavitzkyGolaySmoothingConfig$.MODULE$.apply$default$1();
        int x$3 = SavitzkyGolaySmoothingConfig$.MODULE$.apply$default$2();
        this.psgSmoother = new PartialSavitzkyGolaySmoother(new SavitzkyGolaySmoothingConfig(x$2, x$3, x$1));
        this.xicBinner = new XicBinner(new XicBinnerConfig(5));
        this.peakelFinder = new SmartPeakelFinder(SmartPeakelFinder$.MODULE$.$lessinit$greater$default$1(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$2(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$3(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$4(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$5(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$6(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$7(), SmartPeakelFinder$.MODULE$.$lessinit$greater$default$8());
    }
}

