/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer.mgf;

import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.algo.LegacyIsotopicPatternScorer$;
import fr.profi.mzdb.db.model.params.Precursor;
import fr.profi.mzdb.io.writer.mgf.DefaultPrecursorComputer;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A4Aa\u0003\u0007\u00013!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003&\u0001\u0011\u0005a\u0005C\u0005*\u0001\u0001\u0007\t\u0019!C\u0005U!I1\b\u0001a\u0001\u0002\u0004%I\u0001\u0010\u0005\n\u0005\u0002\u0001\r\u0011!Q!\n-BQa\u0011\u0001\u0005B\u0011CQ\u0001\u0015\u0001\u0005\nECQa\u0017\u0001\u0005BqCQA\u0019\u0001\u0005B\rDQa\u001c\u0001\u0005B\r\u0014\u0011%S:pY\u0006$\u0018n\u001c8XS:$wn\u001e)sK\u000e,(o]8s\u000bb$(/Y2u_JT!!\u0004\b\u0002\u00075<gM\u0003\u0002\u0010!\u00051qO]5uKJT!!\u0005\n\u0002\u0005%|'BA\n\u0015\u0003\u0011i'\u0010\u001a2\u000b\u0005U1\u0012!\u00029s_\u001aL'\"A\f\u0002\u0005\u0019\u00148\u0001A\n\u0003\u0001i\u0001\"a\u0007\u000f\u000e\u00031I!!\b\u0007\u00031\u0011+g-Y;miB\u0013XmY;sg>\u00148i\\7qkR,'/\u0001\u0005nuR{G\u000e\u0015)N!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u00151En\\1u\u0003\u0019a\u0014N\\5u}Q\u0011q\u0005\u000b\t\u00037\u0001AQA\b\u0002A\u0002}\ta\u0002\\1tiB\u0013X\rZ5di&|g.F\u0001,!\u0011\u0001CF\f\u001b\n\u00055\n#A\u0002+va2,'\u0007\u0005\u00020e5\t\u0001G\u0003\u00022%\u0005)Qn\u001c3fY&\u00111\u0007\r\u0002\u000f'B,7\r\u001e:v[\"+\u0017\rZ3s!\t)\u0014(D\u00017\u0015\t\ttG\u0003\u00029)\u0005\u0011Qn]\u0005\u0003uY\u0012\u0011\u0004\u00165f_J,G/[2bY&\u001bx\u000e^8qKB\u000bG\u000f^3s]\u0006\u0011B.Y:u!J,G-[2uS>tw\fJ3r)\ti\u0004\t\u0005\u0002!}%\u0011q(\t\u0002\u0005+:LG\u000fC\u0004B\t\u0005\u0005\t\u0019A\u0016\u0002\u0007a$\u0013'A\bmCN$\bK]3eS\u000e$\u0018n\u001c8!\u000399W\r\u001e)sK\u000e,(o]8s\u001bj$2!\u0012%O!\t\u0001c)\u0003\u0002HC\t1Ai\\;cY\u0016DQ!\u0013\u0004A\u0002)\u000baA]3bI\u0016\u0014\bCA&M\u001b\u0005\u0011\u0012BA'\u0013\u0005)i%\u0010\u00122SK\u0006$WM\u001d\u0005\u0006\u001f\u001a\u0001\rAL\u0001\u000fgB,7\r\u001e:v[\"+\u0017\rZ3s\u0003m9W\r\u001e\"fgRL5o\u001c;pa&\u001c\u0007+\u0019;uKJtW*\u0019;dQR)!+\u0016,X3B\u0019\u0001e\u0015\u001b\n\u0005Q\u000b#AB(qi&|g\u000eC\u0003J\u000f\u0001\u0007!\nC\u0003P\u000f\u0001\u0007a\u0006C\u0003Y\u000f\u0001\u0007Q)\u0001\u0004qe\u0016\u001cWJ\u001f\u0005\u00065\u001e\u0001\raH\u0001\u0005i&lW-\u0001\nhKR\u0004&/Z2veN|'o\u00115be\u001e,GcA/aCB\u0011\u0001EX\u0005\u0003?\u0006\u00121!\u00138u\u0011\u0015I\u0005\u00021\u0001K\u0011\u0015y\u0005\u00021\u0001/\u000359W\r^'fi\"|GMT1nKR\tA\r\u0005\u0002fY:\u0011aM\u001b\t\u0003O\u0006j\u0011\u0001\u001b\u0006\u0003Sb\ta\u0001\u0010:p_Rt\u0014BA6\"\u0003\u0019\u0001&/\u001a3fM&\u0011QN\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-\f\u0013\u0001E4fi6+G\u000f[8e-\u0016\u00148/[8o\u0001")
public class IsolationWindowPrecursorExtractor
extends DefaultPrecursorComputer {
    private final float mzTolPPM;
    private Tuple2<SpectrumHeader, TheoreticalIsotopePattern> lastPrediction;

    private Tuple2<SpectrumHeader, TheoreticalIsotopePattern> lastPrediction() {
        return this.lastPrediction;
    }

    private void lastPrediction_$eq(Tuple2<SpectrumHeader, TheoreticalIsotopePattern> x$1) {
        this.lastPrediction = x$1;
    }

    public double getPrecursorMz(MzDbReader reader, SpectrumHeader spectrumHeader) {
        double d;
        Option<TheoreticalIsotopePattern> bestPattern;
        double precMz;
        float time = spectrumHeader.getElutionTime();
        Precursor precursor = spectrumHeader.getPrecursor();
        Double altPrecMz = this.refinePrecMz(reader, precursor, precMz = precursor.parseFirstSelectedIonMz(), this.mzTolPPM, time, 5.0f);
        if (altPrecMz != null) {
            precMz = Predef$.MODULE$.Double2double(altPrecMz);
        }
        if ((bestPattern = this.getBestIsotopicPatternMatch(reader, spectrumHeader, precMz, time)).isDefined()) {
            this.lastPrediction_$eq((Tuple2<SpectrumHeader, TheoreticalIsotopePattern>)new Tuple2((Object)spectrumHeader, bestPattern.get()));
            d = ((TheoreticalIsotopePattern)bestPattern.get()).monoMz();
        } else {
            this.logger.info("no prediction : returns precursorMz");
            d = precMz;
        }
        return d;
    }

    private Option<TheoreticalIsotopePattern> getBestIsotopicPatternMatch(MzDbReader reader, SpectrumHeader spectrumHeader, double precMz, float time) {
        None$ none$;
        SpectrumSlice[] slices = reader.getMsSpectrumSlices(precMz - (double)5, precMz + (double)5, time - 5.0f, time + 5.0f);
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])slices)).isEmpty()) {
            SpectrumSlice slice = (SpectrumSlice)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])slices)).minBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToFloat((float)IsolationWindowPrecursorExtractor.$anonfun$getBestIsotopicPatternMatch$1(time, x)), (Ordering)Ordering.Float$.MODULE$);
            Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns = LegacyIsotopicPatternScorer$.MODULE$.calcIsotopicPatternHypotheses(slice.getData(), precMz, this.mzTolPPM);
            Tuple2<Object, TheoreticalIsotopePattern> bestPattern = LegacyIsotopicPatternScorer$.MODULE$.selectBestPatternHypothese(putativePatterns, LegacyIsotopicPatternScorer$.MODULE$.selectBestPatternHypothese$default$2());
            none$ = new Some(bestPattern._2());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getPrecursorCharge(MzDbReader reader, SpectrumHeader spectrumHeader) {
        int n;
        Integer charge = spectrumHeader.getPrecursorCharge();
        if (Predef$.MODULE$.Integer2int(charge) > 0) {
            n = Predef$.MODULE$.Integer2int(charge);
            return n;
        }
        if (this.lastPrediction() != null) {
            SpectrumHeader spectrumHeader2 = spectrumHeader;
            Object object = this.lastPrediction()._1();
            if (!(spectrumHeader2 != null ? !spectrumHeader2.equals(object) : object != null)) {
                if (!BoxesRunTime.equalsNumObject((Number)charge, (Object)BoxesRunTime.boxToInteger((int)((TheoreticalIsotopePattern)this.lastPrediction()._2()).charge()))) {
                    this.logger.info(new StringBuilder(41).append("scan ").append(spectrumHeader.getInitialId()).append(" : change predicted charge from ").append(charge).append(" to ").append(((TheoreticalIsotopePattern)this.lastPrediction()._2()).charge()).toString());
                }
                n = ((TheoreticalIsotopePattern)this.lastPrediction()._2()).charge();
                return n;
            }
        }
        float time = spectrumHeader.getElutionTime();
        Double precMz = spectrumHeader.getPrecursorMz();
        Option<TheoreticalIsotopePattern> bestPattern = this.getBestIsotopicPatternMatch(reader, spectrumHeader, Predef$.MODULE$.Double2double(precMz), time);
        if (!bestPattern.isDefined()) {
            n = Predef$.MODULE$.Integer2int(charge);
            return n;
        }
        if (!BoxesRunTime.equalsNumObject((Number)charge, (Object)BoxesRunTime.boxToInteger((int)((TheoreticalIsotopePattern)bestPattern.get()).charge()))) {
            this.logger.info(new StringBuilder(33).append("change predicted charge from ").append(charge).append(" to ").append(((TheoreticalIsotopePattern)bestPattern.get()).charge()).toString());
        }
        n = ((TheoreticalIsotopePattern)bestPattern.get()).charge();
        return n;
    }

    public String getMethodName() {
        return "Proline refined precursor mz";
    }

    public String getMethodVersion() {
        return "1.1";
    }

    public static final /* synthetic */ float $anonfun$getBestIsotopicPatternMatch$1(float time$1, SpectrumSlice x) {
        return Math.abs(x.getHeader().getElutionTime() - time$1);
    }

    public IsolationWindowPrecursorExtractor(float mzTolPPM) {
        this.mzTolPPM = mzTolPPM;
        super(mzTolPPM);
    }
}

