/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.writer.mgf;

import com.almworks.sqlite4java.SQLiteException;
import fr.profi.ms.model.TheoreticalIsotopePattern;
import fr.profi.mzdb.MzDbReader;
import fr.profi.mzdb.Settings$;
import fr.profi.mzdb.algo.DotProductPatternScorer$;
import fr.profi.mzdb.db.model.params.AbstractXMLParamTree;
import fr.profi.mzdb.db.model.params.IsolationWindowParamTree;
import fr.profi.mzdb.db.model.params.Precursor;
import fr.profi.mzdb.db.model.params.param.CVEntry;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.db.model.params.param.UserParam;
import fr.profi.mzdb.io.writer.mgf.DefaultPrecursorComputer;
import fr.profi.mzdb.io.writer.mgf.IsotopicPatternMatch;
import fr.profi.mzdb.io.writer.mgf.IsotopicPatternMatch$;
import fr.profi.mzdb.io.writer.mgf.MgfBoostPrecursorExtractor$;
import fr.profi.mzdb.io.writer.mgf.MgfPrecursor;
import fr.profi.mzdb.io.writer.mgf.ScanSelectorModes$;
import fr.profi.mzdb.io.writer.mgf.SpectrumDataSource;
import fr.profi.mzdb.model.IonMobilityMode;
import fr.profi.mzdb.model.IonMobilityType;
import fr.profi.mzdb.model.Peak;
import fr.profi.mzdb.model.Spectrum;
import fr.profi.mzdb.model.SpectrumHeader;
import fr.profi.mzdb.model.SpectrumSlice;
import fr.profi.util.metrics.Metric;
import java.io.Serializable;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015u!B\u0013'\u0011\u0003\u0019d!B\u001b'\u0011\u00031\u0004\"B\u001f\u0002\t\u0003q\u0004\"B \u0002\t\u0003\u0001\u0005bB,\u0002#\u0003%\t\u0001\u0017\u0005\bM\u0006\t\n\u0011\"\u0001Y\u0011\u001d9\u0017!%A\u0005\u0002!Dq!\\\u0001\u0012\u0002\u0013\u0005a\u000eC\u0004t\u0003E\u0005I\u0011\u0001;\t\u000fy\f\u0011\u0013!C\u0001\u007f\"A\u0011\u0011B\u0001\u0012\u0002\u0013\u0005\u0001NB\u00036M\u0001\tY\u0001C\u0005\u0002\u0014-\u0011\t\u0011)A\u0005a\"I\u0011QC\u0006\u0003\u0002\u0003\u0006IA\u0017\u0005\n\u0003/Y!\u0011!Q\u0001\niC\u0011\"!\u0007\f\u0005\u0003\u0005\u000b\u0011\u00026\t\u0013\u0005m1B!A!\u0002\u0013\u0001\b\"CA\u000f\u0017\t\u0005\t\u0015!\u0003w\u0011)\tyb\u0003B\u0001B\u0003%\u00111\u0001\u0005\n\u0003CY!\u0011!Q\u0001\n)Da!P\u0006\u0005\u0002\u0005\r\u0002\"CA\u001c\u0017\t\u0007I\u0011BA\u001d\u0011!\tYe\u0003Q\u0001\n\u0005m\u0002bBA'\u0017\u0011\u0005\u0013q\n\u0005\b\u0003{[A\u0011BA`\u0011\u001d\t)o\u0003C\u0005\u0003ODq!a<\f\t\u0013\t\t\u0010C\u0004\u0003\u0002-!IAa\u0001\t\u000f\t\u001d1\u0002\"\u0003\u0003\n!9!1D\u0006\u0005\u0002\tu\u0001b\u0002B\u001a\u0017\u0011%!Q\u0007\u0005\b\u0005\u0007ZA\u0011\tB#\u0011\u001d\u00119e\u0003C!\u0005\u000bBqA!\u0013\f\t\u0003\u0011Y\u0005C\u0004\u0003T-!\tA!\u0016\t\u000f\t%4\u0002\"\u0001\u0003l!9!QO\u0006\u0005\u0002\t]\u0014AG'hM\n{wn\u001d;Qe\u0016\u001cWO]:pe\u0016CHO]1di>\u0014(BA\u0014)\u0003\riwM\u001a\u0006\u0003S)\naa\u001e:ji\u0016\u0014(BA\u0016-\u0003\tIwN\u0003\u0002.]\u0005!QN\u001f3c\u0015\ty\u0003'A\u0003qe>4\u0017NC\u00012\u0003\t1'o\u0001\u0001\u0011\u0005Q\nQ\"\u0001\u0014\u000355;gMQ8pgR\u0004&/Z2veN|'/\u0012=ue\u0006\u001cGo\u001c:\u0014\u0005\u00059\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002g\u0005\t\"/Z1e\u0013>tWj\u001c2jY&$\u0018p\u0011,\u0015\u0005\u0005{\u0005c\u0001\u001dC\t&\u00111)\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0015ceB\u0001$K!\t9\u0015(D\u0001I\u0015\tI%'\u0001\u0004=e>|GOP\u0005\u0003\u0017f\na\u0001\u0015:fI\u00164\u0017BA'O\u0005\u0019\u0019FO]5oO*\u00111*\u000f\u0005\u0006!\u000e\u0001\r!U\u0001\u000fgB,7\r\u001e:v[\"+\u0017\rZ3s!\t\u0011V+D\u0001T\u0015\t!F&A\u0003n_\u0012,G.\u0003\u0002W'\nq1\u000b]3diJ,X\u000eS3bI\u0016\u0014\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'F\u0001ZU\tQV\f\u0005\u000297&\u0011A,\u000f\u0002\b\u0005>|G.Z1oW\u0005q\u0006CA0e\u001b\u0005\u0001'BA1c\u0003%)hn\u00195fG.,GM\u0003\u0002ds\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0015\u0004'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"T#A5+\u0005)l\u0006C\u0001\u001dl\u0013\ta\u0017HA\u0002J]R\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012*T#A8+\u0005Al\u0006C\u0001\u001dr\u0013\t\u0011\u0018HA\u0003GY>\fG/A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0002k*\u0012a/\u0018\t\u0003ojt!\u0001\u000e=\n\u0005e4\u0013!E*dC:\u001cV\r\\3di>\u0014Xj\u001c3fg&\u00111\u0010 \u0002\u0006-\u0006dW/Z\u0005\u0003{f\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"!!\u0001+\u0007\u0005\rQ\fE\u00029\u0003\u000bI1!a\u0002:\u0005\u0019!u.\u001e2mK\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIa\u001a2aCA\u0007!\r!\u0014qB\u0005\u0004\u0003#1#\u0001\u0007#fM\u0006,H\u000e\u001e)sK\u000e,(o]8s\u0007>l\u0007/\u001e;fe\u0006AQN\u001f+pYB\u0003V*A\u0005vg\u0016DU-\u00193fe\u0006)Qo]3T/\u0006!2o^'bqB\u0013XmY;sg>\u00148oQ8v]R\fAc]<J]R,gn]5usRC'/Z:i_2$\u0017\u0001D:dC:\u001cV\r\\3di>\u0014\u0018\u0001\u00049jMRC'/Z:i_2$\u0017!\u0004:b].$\u0006N]3tQ>dG\r\u0006\n\u0002&\u0005\u001d\u0012\u0011FA\u0016\u0003[\ty#!\r\u00024\u0005U\u0002C\u0001\u001b\f\u0011\u0019\t\u0019\u0002\u0006a\u0001a\"A\u0011Q\u0003\u000b\u0011\u0002\u0003\u0007!\f\u0003\u0005\u0002\u0018Q\u0001\n\u00111\u0001[\u0011!\tI\u0002\u0006I\u0001\u0002\u0004Q\u0007\u0002CA\u000e)A\u0005\t\u0019\u00019\t\u0011\u0005uA\u0003%AA\u0002YD\u0011\"a\b\u0015!\u0003\u0005\r!a\u0001\t\u0011\u0005\u0005B\u0003%AA\u0002)\fa!\\3ue&\u001cWCAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nq!\\3ue&\u001c7OC\u0002\u0002F9\nA!\u001e;jY&!\u0011\u0011JA \u0005\u0019iU\r\u001e:jG\u00069Q.\u001a;sS\u000e\u0004\u0013\u0001E4fi6;g\r\u0015:fGV\u00148o\u001c:t)\u0019\t\t&!\u0018\u0002jA)\u0001(a\u0015\u0002X%\u0019\u0011QK\u001d\u0003\u000b\u0005\u0013(/Y=\u0011\u0007Q\nI&C\u0002\u0002\\\u0019\u0012A\"T4g!J,7-\u001e:t_JDq!a\u0018\u0018\u0001\u0004\t\t'\u0001\u0006nu\u0012\u0013'+Z1eKJ\u0004B!a\u0019\u0002f5\tA&C\u0002\u0002h1\u0012!\"\u0014>EEJ+\u0017\rZ3s\u0011\u0015\u0001v\u00031\u0001RQ\u00159\u0012QNAD!\u0015A\u0014qNA:\u0013\r\t\t(\u000f\u0002\u0007i\"\u0014xn^:\u0011\t\u0005U\u00141Q\u0007\u0003\u0003oRA!!\u001f\u0002|\u0005Y1/\u001d7ji\u0016$$.\u0019<b\u0015\u0011\ti(a \u0002\u0011\u0005dWn^8sWNT!!!!\u0002\u0007\r|W.\u0003\u0003\u0002\u0006\u0006]$aD*R\u0019&$X-\u0012=dKB$\u0018n\u001c82\ry!\u0015\u0011RA^c%\u0019\u00131RAJ\u0003c\u000b)*\u0006\u0003\u0002\u000e\u0006=U#\u0001#\u0005\u000f\u0005E\u0005A1\u0001\u0002\u001c\n\tA+\u0003\u0003\u0002\u0016\u0006]\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002\u001af\na\u0001\u001e5s_^\u001c\u0018\u0003BAO\u0003G\u00032\u0001OAP\u0013\r\t\t+\u000f\u0002\b\u001d>$\b.\u001b8h!\u0011\t)+a+\u000f\u0007a\n9+C\u0002\u0002*f\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002.\u0006=&!\u0003+ie><\u0018M\u00197f\u0015\r\tI+O\u0019\nG\u0005M\u0016QWA\\\u00033s1\u0001OA[\u0013\r\tI*O\u0019\u0006EaJ\u0014\u0011\u0018\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005M\u0014aG0d_6\u0004X\u000f^3Qe\u0016\u001cWO]:peNKwM\\1m%\u0006t7\u000e\u0006\u0004\u0002B\u0006=\u00171\u001c\t\u0007q\u0005\r'.a2\n\u0007\u0005\u0015\u0017H\u0001\u0004UkBdWM\r\t\u0005q\t\u000bI\rE\u0002S\u0003\u0017L1!!4T\u0005\u0011\u0001V-Y6\t\u000f\u0005E\u0007\u00041\u0001\u0002T\u0006y\u0001/\u0019;uKJtW*\u0019;dQ>\u0003H\u000f\u0005\u00039\u0005\u0006U\u0007c\u0001\u001b\u0002X&\u0019\u0011\u0011\u001c\u0014\u0003)%\u001bx\u000e^8qS\u000e\u0004\u0016\r\u001e;fe:l\u0015\r^2i\u0011\u001d\ti\u000e\u0007a\u0001\u0003?\fAb\u001d9fGR\u0014X/\u001c#bi\u0006\u00042\u0001NAq\u0013\r\t\u0019O\n\u0002\u0013'B,7\r\u001e:v[\u0012\u000bG/Y*pkJ\u001cW-\u0001\u000f`G>l\u0007/\u001e;f!J,7-\u001e:t_J\u001c\u0016n\u001a8bYJ\u000bG/[8\u0015\r\u0005%\u00181^Aw!\u0015A\u00141\u00199q\u0011\u001d\t\t.\u0007a\u0001\u0003'Dq!!8\u001a\u0001\u0004\ty.\u0001\n`EVLG\u000eZ'hMB\u0013XmY;sg>\u0014H\u0003CAz\u0003k\fI0!@\u0011\ta\u0012\u0015q\u000b\u0005\u0007\u0003oT\u0002\u0019\u00019\u0002\tQLW.\u001a\u0005\b\u0003wT\u0002\u0019AA\u0002\u0003A\u0011XMZ5oK\u0012\fE\u000e\u001e)sK\u000el%\u0010\u0003\u0004\u0002\u0000j\u0001\rA[\u0001\u0007G\"\f'oZ3\u0002+};W\r\u001e%fC\u0012,'\u000f\u0015:fGV\u00148o\u001c:NuR!\u00111\u0001B\u0003\u0011\u0015\u00016\u00041\u0001R\u0003ay&-^5mIN\u0003Xm\u0019;sk6$\u0015\r^1T_V\u00148-\u001a\u000b\t\u0003?\u0014YAa\u0004\u0003\u0012!9!Q\u0002\u000fA\u0002\u0005\u0005\u0014A\u0002:fC\u0012,'\u000fC\u0003Q9\u0001\u0007\u0011\u000bC\u0004\u0002\u001eq\u0001\rAa\u0005\u0011\u0007]\u0014)\"\u0003\u0003\u0003\u0018\te!\u0001E*dC:\u001cV\r\\3di>\u0014Xj\u001c3f\u0015\tIh%A\u000e`aJ,G-[2u!J,7-\u001e:t_J4%o\\7UCJ<W\r\u001e\u000b\t\u0005?\u0011ICa\u000b\u00030AA\u0001H!\t\u0003&\u0011\u000b\u0019.C\u0002\u0003$e\u0012a\u0001V;qY\u0016\u001c\u0004\u0003\u0002\u001dC\u0005O\u0001b\u0001OAb\u0003\u0007Q\u0007bBAo;\u0001\u0007\u0011q\u001c\u0005\b\u0005[i\u0002\u0019AA\u0002\u0003\u0019\u0001(/Z2Nu\"1!\u0011G\u000fA\u0002)\fq\u0001^1sO\u0016$(,A\r`M&tG-S:pi>\u0004\u0018n\u0019)biR,'O\\'bi\u000eDGCBAk\u0005o\u0011\t\u0005C\u0004\u0003:y\u0001\rAa\u000f\u0002\u001bM\u0004Xm\u0019;sk6\u001cF.[2f!\r\u0011&QH\u0005\u0004\u0005\u007f\u0019&!D*qK\u000e$(/^7TY&\u001cW\rC\u0004\u0003.y\u0001\r!a\u0001\u0002\u001b\u001d,G/T3uQ>$g*Y7f)\u0005!\u0015\u0001E4fi6+G\u000f[8e-\u0016\u00148/[8o\u0003-!W/\u001c9NKR\u0014\u0018nY:\u0015\u0005\t5\u0003c\u0001\u001d\u0003P%\u0019!\u0011K\u001d\u0003\tUs\u0017\u000e^\u0001\u000fKb$(/Y2u'^\u001bF/\u0019;t)!\u00119Fa\u0019\u0003f\t\u001d\u0004CB#\u0003Z\u0011\u0013i&C\u0002\u0003\\9\u00131!T1q!\rA$qL\u0005\u0004\u0005CJ$aA!os\"9\u0011q\f\u0012A\u0002\u0005\u0005\u0004\"\u0002)#\u0001\u0004\t\u0006BBA\nE\u0001\u0007\u0001/A\u000bfqR\u0014\u0018m\u0019;Qe\u0016\u001cWO]:peN#\u0018\r^:\u0015\u0015\t]#Q\u000eB8\u0005c\u0012\u0019\bC\u0004\u0002`\r\u0002\r!!\u0019\t\u000bA\u001b\u0003\u0019A)\t\u000f\t52\u00051\u0001\u0002\u0004!1\u00111C\u0012A\u0002A\fQ$\u001a=ue\u0006\u001cG\u000f\u0015:fGV\u00148o\u001c:Jg>$x\u000e]3t'R\fGo\u001d\u000b\r\u0005/\u0012IHa\u001f\u0003~\t}$1\u0011\u0005\b\u0003?\"\u0003\u0019AA1\u0011\u0015\u0001F\u00051\u0001R\u0011\u001d\u0011i\u0003\na\u0001\u0003\u0007AaA!!%\u0001\u0004Q\u0017!\u00029sK\u000eT\u0006BBA\nI\u0001\u0007\u0001\u000f")
public class MgfBoostPrecursorExtractor
extends DefaultPrecursorComputer {
    private final float mzTolPPM;
    private final boolean useHeader;
    private final boolean useSW;
    private final int swMaxPrecursorsCount;
    private final float swIntensityThreshold;
    private final Enumeration.Value scanSelector;
    private final double pifThreshold;
    private final int rankThreshold;
    private final Metric metric;

    public static int $lessinit$greater$default$8() {
        return MgfBoostPrecursorExtractor$.MODULE$.$lessinit$greater$default$8();
    }

    public static double $lessinit$greater$default$7() {
        return MgfBoostPrecursorExtractor$.MODULE$.$lessinit$greater$default$7();
    }

    public static Enumeration.Value $lessinit$greater$default$6() {
        return MgfBoostPrecursorExtractor$.MODULE$.$lessinit$greater$default$6();
    }

    public static float $lessinit$greater$default$5() {
        return MgfBoostPrecursorExtractor$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return MgfBoostPrecursorExtractor$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return MgfBoostPrecursorExtractor$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return MgfBoostPrecursorExtractor$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<String> readIonMobilityCV(SpectrumHeader spectrumHeader) {
        return MgfBoostPrecursorExtractor$.MODULE$.readIonMobilityCV(spectrumHeader);
    }

    private Metric metric() {
        return this.metric;
    }

    public MgfPrecursor[] getMgfPrecursors(MzDbReader mzDbReader, SpectrumHeader spectrumHeader) throws SQLiteException {
        ObjectRef precursors = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        ObjectRef headerPrecursor = ObjectRef.create(null);
        if (this.useHeader) {
            SpectrumDataSource spectrumData = this._buildSpectrumDataSource(mzDbReader, spectrumHeader, this.scanSelector);
            Peak[] altPrecursorPeaks = spectrumData.getCandidatePeaksFromIsolationWindow(this.swIntensityThreshold);
            double headerPrecMz = this._getHeaderPrecursorMz(spectrumHeader);
            double refinedHeaderMz = BoxesRunTime.unboxToDouble((Object)spectrumData.getNearestPeak(headerPrecMz, this.mzTolPPM).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4.getMz())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> headerPrecMz));
            Tuple3<Option<Tuple2<Object, Object>>, String, Option<IsotopicPatternMatch>> tuple3 = this._predictPrecursorFromTarget(spectrumData, refinedHeaderMz, Predef$.MODULE$.Integer2int(spectrumHeader.getPrecursorCharge()));
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Option predictionOpt = (Option)tuple3._1();
            String predictionNote = (String)tuple3._2();
            Option patternMatchOpt = (Option)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)predictionOpt, (Object)predictionNote, (Object)patternMatchOpt);
            Tuple3 tuple33 = tuple32;
            Option predictionOpt2 = (Option)tuple33._1();
            String predictionNote2 = (String)tuple33._2();
            Option patternMatchOpt2 = (Option)tuple33._3();
            Tuple2 tuple2 = (Tuple2)predictionOpt2.get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double refinedHeaderPrecMz = tuple2._1$mcD$sp();
            int charge = tuple2._2$mcI$sp();
            Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(refinedHeaderPrecMz, charge);
            Tuple2.mcDI.sp sp3 = sp2;
            double refinedHeaderPrecMz2 = sp3._1$mcD$sp();
            int charge2 = sp3._2$mcI$sp();
            Option<MgfPrecursor> precursorOpt = this._buildMgfPrecursor(spectrumHeader.getElutionTime(), refinedHeaderPrecMz2, charge2);
            if (precursorOpt.isDefined()) {
                MgfPrecursor precursor = (MgfPrecursor)precursorOpt.get();
                if (Math.abs(1000000.0 * (headerPrecMz - refinedHeaderPrecMz2) / headerPrecMz) > (double)this.mzTolPPM) {
                    precursor.addAnnotation("source", (Object)"isotope.header");
                } else {
                    precursor.addAnnotation("source", (Object)"monoisotope.header");
                }
                if (spectrumData.nearestSlice().isDefined()) {
                    precursor.addAnnotation("ms1.scan.number", (Object)BoxesRunTime.boxToLong((long)((Spectrum)spectrumData.nearestSlice().get()).getHeader().getSpectrumId()));
                }
                precursor.addAnnotation("in.sw", (Object)BoxesRunTime.boxToBoolean((boolean)spectrumData.isInIsolationWindow(refinedHeaderPrecMz2)));
                precursor.addAnnotation("scan.number", (Object)BoxesRunTime.boxToLong((long)spectrumHeader.getSpectrumId()));
                precursor.addAnnotation("prediction", (Object)predictionNote2);
                if (patternMatchOpt2.isDefined()) {
                    precursor.addAnnotation("prediction.pattern.score", (Object)BoxesRunTime.boxToDouble((double)((IsotopicPatternMatch)patternMatchOpt2.get()).score()));
                }
                precursor.addAnnotation("filtered.peaks.count.sw", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altPrecursorPeaks)).size()));
                Tuple2<Object, Object> tuple22 = this._computePrecursorSignalRatio((Option<IsotopicPatternMatch>)patternMatchOpt2, spectrumData);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                float totalRatio = BoxesRunTime.unboxToFloat((Object)tuple22._1());
                float maxRatio = BoxesRunTime.unboxToFloat((Object)tuple22._2());
                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)totalRatio), (Object)BoxesRunTime.boxToFloat((float)maxRatio));
                Tuple2 tuple24 = tuple23;
                float totalRatio2 = BoxesRunTime.unboxToFloat((Object)tuple24._1());
                float maxRatio2 = BoxesRunTime.unboxToFloat((Object)tuple24._2());
                precursor.addAnnotation("precursor.signal.total.sw", (Object)BoxesRunTime.boxToFloat((float)totalRatio2));
                precursor.addAnnotation("precursor.signal.max.sw", (Object)BoxesRunTime.boxToFloat((float)maxRatio2));
                Tuple2<Object, Option<Peak>> tuple25 = this._computePrecursorSignalRank((Option<IsotopicPatternMatch>)patternMatchOpt2, spectrumData);
                if (tuple25 == null) {
                    throw new MatchError(tuple25);
                }
                int precRank = tuple25._1$mcI$sp();
                Option maxPrecPeakInSW = (Option)tuple25._2();
                Tuple2 tuple26 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)precRank), (Object)maxPrecPeakInSW);
                Tuple2 tuple27 = tuple26;
                int precRank2 = tuple27._1$mcI$sp();
                Option maxPrecPeakInSW2 = (Option)tuple27._2();
                precursor.addAnnotation("precursor.rank.sw", (Object)BoxesRunTime.boxToInteger((int)precRank2));
                if (maxPrecPeakInSW2.isDefined()) {
                    precursor.addAnnotation("precursor.intensity.sw", (Object)BoxesRunTime.boxToFloat((float)((Peak)maxPrecPeakInSW2.get()).getIntensity()));
                }
                headerPrecursor.elem = precursor;
                precursors.elem = (Seq)((Seq)precursors.elem).$colon$plus((Object)precursor, Seq$.MODULE$.canBuildFrom());
            }
            if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)charge2), (Object)spectrumHeader.getPrecursorCharge())) {
                this.metric().incr("header_charge_changed");
            }
            if (Math.abs(1000000.0 * (headerPrecMz - refinedHeaderPrecMz2) / headerPrecMz) > (double)this.mzTolPPM) {
                this.metric().incr("header_mz_changed");
            }
        }
        if (this.useSW) {
            Seq scanSelectors = this.scanSelector.equals((Object)ScanSelectorModes$.MODULE$.ALL()) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{ScanSelectorModes$.MODULE$.SAME_CYCLE(), ScanSelectorModes$.MODULE$.MASTER_SCAN(), ScanSelectorModes$.MODULE$.NEAREST()})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{this.scanSelector}));
            ObjectRef previousSpectrumDataIndexes = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
            scanSelectors.foreach((Function1 & Serializable & scala.Serializable)selector -> {
                MgfBoostPrecursorExtractor.$anonfun$getMgfPrecursors$3(this, mzDbReader, spectrumHeader, previousSpectrumDataIndexes, precursors, headerPrecursor, selector);
                return BoxedUnit.UNIT;
            });
        }
        precursors.elem = (Seq)((Seq)precursors.elem).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$getMgfPrecursors$9(this, p)));
        ((IterableLike)((Seq)precursors.elem).zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MgfBoostPrecursorExtractor.$anonfun$getMgfPrecursors$10(spectrumHeader, x0$1);
            return BoxedUnit.UNIT;
        });
        return (MgfPrecursor[])((Seq)precursors.elem).toArray(ClassTag$.MODULE$.apply(MgfPrecursor.class));
    }

    private Tuple2<Object, Option<Peak>> _computePrecursorSignalRank(Option<IsotopicPatternMatch> patternMatchOpt, SpectrumDataSource spectrumData) {
        Tuple2 tuple2;
        if (patternMatchOpt.isDefined()) {
            Peak[] peaks = (Peak[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumData.getAllPeaksFromIsolationWindow())).sortBy((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToFloat((float)x$13.getIntensity()), (Ordering)Ordering.Float$.MODULE$))).reverse();
            List patternPeaksInSW = (List)((List)((IsotopicPatternMatch)patternMatchOpt.get()).matchingPeaks().filter((Function1 & Serializable & scala.Serializable)po -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$_computePrecursorSignalRank$2(spectrumData, po)))).map((Function1 & Serializable & scala.Serializable)x$14 -> (Peak)x$14.get(), List$.MODULE$.canBuildFrom());
            if (patternPeaksInSW.isEmpty()) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)-2), (Object)None$.MODULE$);
            } else {
                Peak patternMaxPeakInSW = (Peak)patternPeaksInSW.maxBy((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToFloat((float)x$15.getIntensity()), (Ordering)Ordering.Float$.MODULE$);
                IntRef rank = IntRef.create((int)0);
                Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaks)).foreach((Function1 & Serializable & scala.Serializable)p -> {
                    MgfBoostPrecursorExtractor.$anonfun$_computePrecursorSignalRank$6(patternMaxPeakInSW, rank, p);
                    return BoxedUnit.UNIT;
                }));
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)rank.elem), (Object)new Some((Object)patternMaxPeakInSW));
            }
        } else {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)None$.MODULE$);
        }
        return tuple2;
    }

    private Tuple2<Object, Object> _computePrecursorSignalRatio(Option<IsotopicPatternMatch> patternMatchOpt, SpectrumDataSource spectrumData) {
        Tuple2 tuple2;
        if (patternMatchOpt.isDefined()) {
            Peak[] peaks = spectrumData.getAllPeaksFromIsolationWindow();
            List patternPeaksInSW = (List)((List)((IsotopicPatternMatch)patternMatchOpt.get()).matchingPeaks().filter((Function1 & Serializable & scala.Serializable)po -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$_computePrecursorSignalRatio$1(spectrumData, po)))).map((Function1 & Serializable & scala.Serializable)x$16 -> (Peak)x$16.get(), List$.MODULE$.canBuildFrom());
            float precIntensity = BoxesRunTime.unboxToFloat((Object)patternPeaksInSW.foldLeft((Object)BoxesRunTime.boxToFloat((float)0.0f), (Function2 & Serializable & scala.Serializable)(s, p) -> BoxesRunTime.boxToFloat((float)MgfBoostPrecursorExtractor.$anonfun$_computePrecursorSignalRatio$3(BoxesRunTime.unboxToFloat((Object)s), p))));
            float totalIntensity = BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaks)).foldLeft((Object)BoxesRunTime.boxToFloat((float)0.0f), (Function2 & Serializable & scala.Serializable)(s, p) -> BoxesRunTime.boxToFloat((float)MgfBoostPrecursorExtractor.$anonfun$_computePrecursorSignalRatio$4(BoxesRunTime.unboxToFloat((Object)s), p))));
            float maxPatternRatio = !patternPeaksInSW.isEmpty() && !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaks)).isEmpty() ? BoxesRunTime.unboxToFloat((Object)((TraversableOnce)patternPeaksInSW.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToFloat((float)x$17.getIntensity()), List$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Float$.MODULE$)) / BoxesRunTime.unboxToFloat((Object)new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])peaks)).map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToFloat((float)x$18.getIntensity()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float())))).max((Ordering)Ordering.Float$.MODULE$)) : 0.0f;
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)(precIntensity / totalIntensity)), (Object)BoxesRunTime.boxToFloat((float)maxPatternRatio));
        } else {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)-1.0f), (Object)BoxesRunTime.boxToFloat((float)-1.0f));
        }
        return tuple2;
    }

    private Option<MgfPrecursor> _buildMgfPrecursor(float time, double refinedAltPrecMz, int charge) {
        return charge != 0 ? new Some((Object)new MgfPrecursor(refinedAltPrecMz, charge, time)) : None$.MODULE$;
    }

    private double _getHeaderPrecursorMz(SpectrumHeader spectrumHeader) {
        return Predef$.MODULE$.Double2double(spectrumHeader.getPrecursorMz());
    }

    private SpectrumDataSource _buildSpectrumDataSource(MzDbReader reader, SpectrumHeader spectrumHeader, Enumeration.Value scanSelector) {
        Option<String> cvOpt;
        int masterScanIndex;
        UserParam masterScanUP;
        float time = spectrumHeader.getElutionTime();
        Precursor precursor = spectrumHeader.getPrecursor();
        IsolationWindowParamTree iw = precursor.getIsolationWindow();
        if (iw == null) {
            return null;
        }
        CVEntry[] cvEntries = (CVEntry[])((Object[])new CVEntry[]{CVEntry.ISOLATION_WINDOW_LOWER_OFFSET, CVEntry.ISOLATION_WINDOW_TARGET_MZ, CVEntry.ISOLATION_WINDOW_UPPER_OFFSET});
        CVParam[] cvParams = iw.getCVParams(cvEntries);
        float lowerMzOffset = new StringOps(Predef$.MODULE$.augmentString(cvParams[0].getValue())).toFloat();
        float targetMz = new StringOps(Predef$.MODULE$.augmentString(cvParams[1].getValue())).toFloat();
        float upperMzOffset = new StringOps(Predef$.MODULE$.augmentString(cvParams[2].getValue())).toFloat();
        float minmz = targetMz - lowerMzOffset;
        float maxmz = targetMz + upperMzOffset;
        float minrt = time - (float)5;
        float maxrt = time + (float)5;
        None$ nearestSlice = None$.MODULE$;
        if (scanSelector.equals((Object)ScanSelectorModes$.MODULE$.MASTER_SCAN()) && (masterScanUP = ((AbstractXMLParamTree)spectrumHeader.getScanList().getScans().get(0)).getUserParam("[Thermo Trailer Extra]Master Scan Number:")) != null && (masterScanIndex = new StringOps(Predef$.MODULE$.augmentString(masterScanUP.getValue())).toInt()) >= 0) {
            Spectrum masterScan = reader.getSpectrum((long)masterScanIndex);
            nearestSlice = new Some((Object)new SpectrumSlice(masterScan.getHeader(), masterScan.getData().mzRangeFilter((double)(minmz - (float)5), (double)(maxmz + (float)5))));
        }
        SpectrumSlice[] spectrumSlices = reader.getMsSpectrumSlices((double)(minmz - (float)5), (double)(maxmz + (float)5), minrt, maxrt);
        IonMobilityMode ionMobilityMode = reader.getIonMobilityMode();
        boolean hasIonMobility = ionMobilityMode != null && ionMobilityMode.getIonMobilityType().equals((Object)IonMobilityType.FAIMS);
        Option<String> option = cvOpt = hasIonMobility ? MgfBoostPrecursorExtractor$.MODULE$.readIonMobilityCV(spectrumHeader) : None$.MODULE$;
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).isEmpty()) {
            Option sliceOpt;
            if ((scanSelector.equals((Object)ScanSelectorModes$.MODULE$.SAME_CYCLE()) || scanSelector.equals((Object)ScanSelectorModes$.MODULE$.MASTER_SCAN()) && !nearestSlice.isDefined()) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).nonEmpty() && (sliceOpt = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).find((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$_buildSpectrumDataSource$1(spectrumHeader, hasIonMobility, cvOpt, x)))).isDefined()) {
                nearestSlice = sliceOpt;
            }
            if (scanSelector.equals((Object)ScanSelectorModes$.MODULE$.NEAREST()) || !nearestSlice.isDefined()) {
                float time2 = spectrumHeader.getElutionTime();
                SpectrumSlice[] filteredSlices = (SpectrumSlice[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$_buildSpectrumDataSource$2(hasIonMobility, cvOpt, x)));
                SpectrumSlice slice = (SpectrumSlice)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredSlices)).minBy((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToFloat((float)MgfBoostPrecursorExtractor.$anonfun$_buildSpectrumDataSource$3(time2, x)), (Ordering)Ordering.Float$.MODULE$);
                nearestSlice = new Some((Object)slice);
            }
        }
        return new SpectrumDataSource(spectrumHeader, new float[]{minmz, maxmz}, (Option<SpectrumSlice>)nearestSlice);
    }

    public Tuple3<Option<Tuple2<Object, Object>>, String, Option<IsotopicPatternMatch>> _predictPrecursorFromTarget(SpectrumDataSource spectrumData, double precMz, int targetZ) {
        Tuple3 tuple3;
        Option<SpectrumSlice> spectrumSlice = spectrumData.getNearestSpectrumSlice();
        if (spectrumSlice.isDefined()) {
            Peak nearestPeak = ((Spectrum)spectrumSlice.get()).getNearestPeak(precMz, (double)this.mzTolPPM);
            if (nearestPeak == null) {
                this.metric().incr("no_peak_in_MS_survey");
                if (targetZ > 0) {
                    return new Tuple3((Object)new Some((Object)new Tuple2.mcDI.sp(precMz, targetZ)), (Object)"no peak in the MS survey", (Object)None$.MODULE$);
                }
                return new Tuple3((Object)None$.MODULE$, (Object)"no peak in the MS survey", (Object)None$.MODULE$);
            }
            IsotopicPatternMatch bestPatternMatch = this._findIsotopicPatternMatch((SpectrumSlice)spectrumSlice.get(), precMz);
            TheoreticalIsotopePattern pattern = bestPatternMatch.theoreticalPattern();
            if (!((Option)bestPatternMatch.matchingPeaks().apply(0)).isDefined()) {
                this.metric().incr("prediction_without_isotope0");
            }
            if (!((Option)bestPatternMatch.matchingPeaks().apply(1)).isDefined()) {
                this.metric().incr("prediction_without_isotope1");
            }
            if (!((Option)bestPatternMatch.matchingPeaks().apply(1)).isDefined()) {
                if (pattern.charge() <= 1) {
                    this.metric().incr("ignored.prediction_without isotope1.predicted_1+");
                }
                if (targetZ > 0) {
                    return new Tuple3((Object)new Some((Object)new Tuple2.mcDI.sp(precMz, targetZ)), (Object)"no isotope 2 in prediction", (Object)None$.MODULE$);
                }
                return new Tuple3((Object)None$.MODULE$, (Object)"no isotope 2 in prediction", (Object)None$.MODULE$);
            }
            if (pattern.charge() > 1) {
                double predictedMz = ((Option)bestPatternMatch.matchingPeaks().apply(0)).isDefined() ? ((Peak)((Option)bestPatternMatch.matchingPeaks().apply(0)).get()).getMz() : pattern.monoMz();
                tuple3 = new Tuple3((Object)new Some((Object)new Tuple2.mcDI.sp(predictedMz, pattern.charge())), (Object)"pattern prediction", (Object)new Some((Object)bestPatternMatch));
            } else if (targetZ <= 0) {
                double predictedMz = ((Option)bestPatternMatch.matchingPeaks().apply(0)).isDefined() ? ((Peak)((Option)bestPatternMatch.matchingPeaks().apply(0)).get()).getMz() : pattern.monoMz();
                tuple3 = new Tuple3((Object)new Some((Object)new Tuple2.mcDI.sp(predictedMz, pattern.charge())), (Object)"pattern prediction 1+", (Object)new Some((Object)bestPatternMatch));
            } else {
                this.metric().incr("ignored.predicted_1+");
                tuple3 = new Tuple3((Object)new Some((Object)new Tuple2.mcDI.sp(precMz, targetZ)), (Object)"ignored 1+ prediction", (Object)None$.MODULE$);
            }
        } else {
            this.metric().incr("no_spectrum_slice_found");
            tuple3 = targetZ > 0 ? new Tuple3((Object)new Some((Object)new Tuple2.mcDI.sp(precMz, targetZ)), (Object)"no spectrum slice found", (Object)None$.MODULE$) : new Tuple3((Object)None$.MODULE$, (Object)"no spectrum slice found", (Object)None$.MODULE$);
        }
        return tuple3;
    }

    private IsotopicPatternMatch _findIsotopicPatternMatch(SpectrumSlice spectrumSlice, double precMz) {
        Tuple2<Object, TheoreticalIsotopePattern>[] putativePatterns = DotProductPatternScorer$.MODULE$.calcIsotopicPatternHypotheses(spectrumSlice.getData(), precMz, this.mzTolPPM);
        Tuple2<Object, TheoreticalIsotopePattern> bestPattern = DotProductPatternScorer$.MODULE$.selectBestPatternHypothese(putativePatterns, DotProductPatternScorer$.MODULE$.selectBestPatternHypothese$default$2());
        double targetMz = precMz;
        double previousMz = 0.0;
        while (Math.abs(1000000.0 * (targetMz - previousMz) / targetMz) > (double)this.mzTolPPM && Math.abs(1000000.0 * (targetMz - ((TheoreticalIsotopePattern)bestPattern._2()).monoMz()) / targetMz) > (double)this.mzTolPPM) {
            previousMz = targetMz;
            targetMz = ((TheoreticalIsotopePattern)bestPattern._2()).monoMz();
            putativePatterns = DotProductPatternScorer$.MODULE$.calcIsotopicPatternHypothesesFromCharge(spectrumSlice.getData(), targetMz, ((TheoreticalIsotopePattern)bestPattern._2()).charge(), this.mzTolPPM);
            bestPattern = DotProductPatternScorer$.MODULE$.selectBestPatternHypothese(putativePatterns, DotProductPatternScorer$.MODULE$.selectBestPatternHypothese$default$2());
        }
        return IsotopicPatternMatch$.MODULE$.apply(bestPattern._1$mcD$sp(), (TheoreticalIsotopePattern)bestPattern._2(), spectrumSlice, this.mzTolPPM);
    }

    public String getMethodName() {
        return "Proline/MGFBoost refined precursor mz";
    }

    public String getMethodVersion() {
        return "3.6.3";
    }

    public void dumpMetrics() {
        this.logger.info(this.metric().toString());
    }

    public Map<String, Object> extractSWStats(MzDbReader mzDbReader, SpectrumHeader spectrumHeader, float mzTolPPM) {
        ObjectRef result;
        block3: {
            float time;
            result = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
            Precursor precursor = spectrumHeader.getPrecursor();
            SpectrumSlice[] spectrumSlices = this._getSpectrumSlicesInIsolationWindow(mzDbReader, precursor, time = spectrumHeader.getElutionTime(), 5.0f);
            if (spectrumSlices == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).isEmpty()) {
                result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cause"), (Object)"no spectrum slice"));
                return (Map)result.elem;
            }
            result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header.moz"), (Object)BoxesRunTime.boxToDouble((double)this._getHeaderPrecursorMz(spectrumHeader))));
            result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header.charge"), (Object)spectrumHeader.getPrecursorCharge()));
            IsolationWindowParamTree iw = precursor.getIsolationWindow();
            float sw_center = new StringOps(Predef$.MODULE$.augmentString(iw.getCVParam(CVEntry.ISOLATION_WINDOW_TARGET_MZ).getValue())).toFloat();
            result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sw_center.moz"), (Object)BoxesRunTime.boxToFloat((float)sw_center)));
            result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sw_center.lower_offset"), (Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(iw.getCVParam(CVEntry.ISOLATION_WINDOW_LOWER_OFFSET).getValue())).toFloat())));
            result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sw_center.upper_offset"), (Object)BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString(iw.getCVParam(CVEntry.ISOLATION_WINDOW_UPPER_OFFSET).getValue())).toFloat())));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).isEmpty()) break block3;
            SpectrumSlice[] closestSlice = (SpectrumSlice[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])spectrumSlices)).filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$extractSWStats$1(spectrumHeader, x$19)));
            Peak[] allPeaks = (Peak[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])closestSlice)).flatMap((Function1 & Serializable & scala.Serializable)x$20 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$20.toPeaks())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Peak.class)));
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks)).isEmpty()) {
                Peak maxPeak = (Peak)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks)).maxBy((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToFloat((float)x$21.getIntensity()), (Ordering)Ordering.Float$.MODULE$);
                result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sw_content.max_intensity"), (Object)BoxesRunTime.boxToFloat((float)maxPeak.getIntensity())));
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                    result$1.elem = ((Map)result$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(17).append("sw_content_").append(i).append(".count").toString()), (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks)).filter((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$extractSWStats$5(i, maxPeak, x$22))))).size())));
                });
                Peak[] precMzArray = (Peak[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks)).sortBy((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToFloat((float)x$23.getIntensity()), (Ordering)Ordering.Float$.MODULE$))).reverse();
                Tuple2 swPrecMz = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])precMzArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).minBy((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)MgfBoostPrecursorExtractor.$anonfun$extractSWStats$7(sw_center, x0$1)), (Ordering)Ordering.Double$.MODULE$);
                result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sw_center.peak.moz"), (Object)BoxesRunTime.boxToDouble((double)((Peak)swPrecMz._1()).getMz())));
                result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sw_center.peak.intensity"), (Object)BoxesRunTime.boxToFloat((float)((Peak)swPrecMz._1()).getIntensity())));
                result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sw_center.peak.rank"), (Object)BoxesRunTime.boxToInteger((int)swPrecMz._2$mcI$sp())));
            } else {
                result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cause"), (Object)"empty_sw"));
            }
        }
        return (Map)result.elem;
    }

    public Map<String, Object> extractPrecursorStats(MzDbReader mzDbReader, SpectrumHeader spectrumHeader, double precMz, float mzTolPPM) {
        ObjectRef result = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"found"), (Object)"false"));
        float time = spectrumHeader.getElutionTime();
        Precursor precursor = spectrumHeader.getPrecursor();
        SpectrumDataSource spectrumData = this._buildSpectrumDataSource(mzDbReader, spectrumHeader, ScanSelectorModes$.MODULE$.SAME_CYCLE());
        if (spectrumData.nearestSlice() == null) {
            result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cause"), (Object)"no spectrum slice"));
            return (Map)result.elem;
        }
        double headerMoz = this._getHeaderPrecursorMz(spectrumHeader);
        result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header.moz"), (Object)BoxesRunTime.boxToDouble((double)headerMoz)));
        result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header.charge"), (Object)spectrumHeader.getPrecursorCharge()));
        result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header.found"), (Object)"false"));
        double headerPrecMz = this._getHeaderPrecursorMz(spectrumHeader);
        double refinedHeaderPrecMz = BoxesRunTime.unboxToDouble((Object)spectrumData.getNearestPeak(headerPrecMz, mzTolPPM).map((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToDouble((double)x$24.getMz())).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> headerPrecMz));
        Tuple3<Option<Tuple2<Object, Object>>, String, Option<IsotopicPatternMatch>> tuple3 = this._predictPrecursorFromTarget(spectrumData, refinedHeaderPrecMz, Predef$.MODULE$.Integer2int(spectrumHeader.getPrecursorCharge()));
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Option predictionOpt = (Option)tuple3._1();
        String predictionNote = (String)tuple3._2();
        Option patternMatchOpt = (Option)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)predictionOpt, (Object)predictionNote, (Object)patternMatchOpt);
        Tuple3 tuple33 = tuple32;
        Option predictionOpt2 = (Option)tuple33._1();
        String predictionNote2 = (String)tuple33._2();
        Option patternMatchOpt2 = (Option)tuple33._3();
        result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header.prediction.note"), (Object)predictionNote2));
        if (predictionOpt2.isDefined()) {
            result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header.prediction.moz"), (Object)BoxesRunTime.boxToDouble((double)((Tuple2)predictionOpt2.get())._1$mcD$sp())));
            result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header.prediction.charge"), (Object)BoxesRunTime.boxToInteger((int)((Tuple2)predictionOpt2.get())._2$mcI$sp())));
        }
        IsolationWindowParamTree iw = precursor.getIsolationWindow();
        float sw_center = new StringOps(Predef$.MODULE$.augmentString(iw.getCVParam(CVEntry.ISOLATION_WINDOW_TARGET_MZ).getValue())).toFloat();
        result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sw_center.moz"), (Object)BoxesRunTime.boxToFloat((float)sw_center)));
        if (!spectrumData.nearestSlice().isEmpty()) {
            Peak[] allPeaks = spectrumData.getCandidatePeaksFromIsolationWindow(this.swIntensityThreshold);
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks)).isEmpty()) {
                Option<SpectrumSlice> spectrumSlice;
                Peak maxPeak = (Peak)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks)).maxBy((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToFloat((float)x$26.getIntensity()), (Ordering)Ordering.Float$.MODULE$);
                Peak[] swPrecMzArray = (Peak[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks)).sortBy((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToFloat((float)x$27.getIntensity()), (Ordering)Ordering.Float$.MODULE$))).reverse();
                IntRef rank = IntRef.create((int)0);
                Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])swPrecMzArray)).foreach((Function1 & Serializable & scala.Serializable)swPrecMz -> {
                    MgfBoostPrecursorExtractor.$anonfun$extractPrecursorStats$6(this, rank, result, spectrumData, allPeaks, mzTolPPM, precMz, swPrecMz);
                    return BoxedUnit.UNIT;
                }));
                Peak[] precMzArray = (Peak[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks)).filter((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$extractPrecursorStats$13(this, maxPeak, x$32))))).sortBy((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToFloat((float)x$33.getIntensity()), (Ordering)Ordering.Float$.MODULE$))).reverse();
                Tuple2 swPrecMz = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])precMzArray)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).minBy((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToDouble((double)MgfBoostPrecursorExtractor.$anonfun$extractPrecursorStats$15(sw_center, x0$5)), (Ordering)Ordering.Double$.MODULE$);
                Tuple3<Option<Tuple2<Object, Object>>, String, Option<IsotopicPatternMatch>> tuple34 = this._predictPrecursorFromTarget(spectrumData, ((Peak)swPrecMz._1()).getMz(), 0);
                if (tuple34 == null) {
                    throw new MatchError(tuple34);
                }
                Option altPredictionOpt = (Option)tuple34._1();
                String altPredictionNote = (String)tuple34._2();
                Option altPatternMatchOpt = (Option)tuple34._3();
                Tuple3 tuple35 = new Tuple3((Object)altPredictionOpt, (Object)altPredictionNote, (Object)altPatternMatchOpt);
                Tuple3 tuple36 = tuple35;
                Option altPredictionOpt2 = (Option)tuple36._1();
                String altPredictionNote2 = (String)tuple36._2();
                Option altPatternMatchOpt2 = (Option)tuple36._3();
                result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"swcenter.prediction.note"), (Object)altPredictionNote2));
                result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"swcenter.initial.moz"), (Object)BoxesRunTime.boxToDouble((double)((Peak)swPrecMz._1()).getMz())));
                result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"swcenter.initial.intensity"), (Object)BoxesRunTime.boxToFloat((float)((Peak)swPrecMz._1()).getIntensity())));
                result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"swcenter.initial.rank"), (Object)BoxesRunTime.boxToInteger((int)swPrecMz._2$mcI$sp())));
                if (altPredictionOpt2.isDefined()) {
                    double altprecMz = ((Tuple2)altPredictionOpt2.get())._1$mcD$sp();
                    result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"swcenter.prediction.moz"), (Object)BoxesRunTime.boxToDouble((double)altprecMz)));
                    result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"swcenter.prediction.charge"), (Object)BoxesRunTime.boxToInteger((int)((Tuple2)altPredictionOpt2.get())._2$mcI$sp())));
                    Tuple2[] altprecursors = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks)).sortBy((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToFloat((float)x$35.getIntensity()), (Ordering)Ordering.Float$.MODULE$))).reverse())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x0$6 -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$extractPrecursorStats$17(altprecMz, mzTolPPM, x0$6)));
                    if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altprecursors)).isEmpty()) {
                        Tuple2 altprecursor = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altprecursors)).minBy((Function1 & Serializable & scala.Serializable)x0$7 -> BoxesRunTime.boxToDouble((double)MgfBoostPrecursorExtractor.$anonfun$extractPrecursorStats$18(altprecMz, x0$7)), (Ordering)Ordering.Double$.MODULE$);
                        result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"swcenter.prediction.intensity"), (Object)BoxesRunTime.boxToFloat((float)((Peak)altprecursor._1()).getIntensity())));
                        result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"swcenter.prediction.rank"), (Object)BoxesRunTime.boxToInteger((int)altprecursor._2$mcI$sp())));
                    }
                }
                if ((spectrumSlice = spectrumData.getNearestSpectrumSlice()).isDefined()) {
                    Peak nearestPeak;
                    Peak nearestPeak2;
                    Object object = ((Map)result.elem).apply((Object)"found");
                    String string = "true";
                    if ((object == null ? string != null : !object.equals(string)) && (nearestPeak2 = ((Spectrum)spectrumSlice.get()).getNearestPeak(precMz, (double)mzTolPPM)) != null) {
                        result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"found"), (Object)"outside"));
                    }
                    if ((nearestPeak = ((Spectrum)(spectrumSlice = spectrumData.getNearestSpectrumSlice()).get()).getNearestPeak(headerMoz, (double)mzTolPPM)) != null) {
                        result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"header.found"), (Object)"true"));
                    }
                }
            } else {
                result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cause"), (Object)"no peaks in MS1"));
            }
        } else {
            result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cause"), (Object)"no spectrum slice"));
        }
        return (Map)result.elem;
    }

    public Map<String, Object> extractPrecursorIsotopesStats(MzDbReader mzDbReader, SpectrumHeader spectrumHeader, double precMz, int precZ, float mzTolPPM) {
        ObjectRef result = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"found"), (Object)"false"));
        float time = spectrumHeader.getElutionTime();
        Precursor precursor = spectrumHeader.getPrecursor();
        SpectrumDataSource spectrumData = this._buildSpectrumDataSource(mzDbReader, spectrumHeader, ScanSelectorModes$.MODULE$.SAME_CYCLE());
        if (spectrumData.nearestSlice() == null) {
            result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cause"), (Object)"no spectrum slice"));
            return (Map)result.elem;
        }
        if (!spectrumData.nearestSlice().isEmpty()) {
            Peak[] allPeaks = spectrumData.getCandidatePeaksFromIsolationWindow(this.swIntensityThreshold);
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks)).isEmpty()) {
                Peak maxPeak = (Peak)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks)).maxBy((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToFloat((float)x$36.getIntensity()), (Ordering)Ordering.Float$.MODULE$);
                Peak[] swPrecMzArray = (Peak[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks)).sortBy((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToFloat((float)x$37.getIntensity()), (Ordering)Ordering.Float$.MODULE$))).reverse();
                Option<SpectrumSlice> ms1Slice = spectrumData.getNearestSpectrumSlice();
                IntRef rank = IntRef.create((int)0);
                Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])swPrecMzArray)).foreach((Function1 & Serializable & scala.Serializable)swPrecMz -> {
                    MgfBoostPrecursorExtractor.$anonfun$extractPrecursorIsotopesStats$4(precMz, mzTolPPM, result, rank, precZ, ms1Slice, swPrecMz);
                    return BoxedUnit.UNIT;
                }));
            } else {
                result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cause"), (Object)"no peaks in MS1"));
            }
        } else {
            result.elem = ((Map)result.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cause"), (Object)"no spectrum slice"));
        }
        return (Map)result.elem;
    }

    public static final /* synthetic */ boolean $anonfun$getMgfPrecursors$4(ObjectRef swPrecursors$1, int maxPrec$1, Peak altPrecursorPeak) {
        return ((Seq)swPrecursors$1.elem).length() < maxPrec$1;
    }

    public static final /* synthetic */ boolean $anonfun$getMgfPrecursors$6(MgfBoostPrecursorExtractor $this, double refinedAltPrecMz$1, int charge$1, MgfPrecursor p) {
        return Math.abs(1000000.0 * (Predef$.MODULE$.Double2double(p.getPrecMz()) - refinedAltPrecMz$1) / Predef$.MODULE$.Double2double(p.getPrecMz())) < (double)$this.mzTolPPM && BoxesRunTime.equalsNumObject((Number)p.getCharge(), (Object)BoxesRunTime.boxToInteger((int)charge$1));
    }

    public static final /* synthetic */ void $anonfun$getMgfPrecursors$5(MgfBoostPrecursorExtractor $this, SpectrumDataSource spectrumData$1, ObjectRef swPrecursors$1, SpectrumHeader spectrumHeader$1, IntRef rank$1, Peak[] altPrecursorPeaks$1, Enumeration.Value selector$1, ObjectRef headerPrecursor$1, Peak altPrecursorPeak) {
        Tuple3<Option<Tuple2<Object, Object>>, String, Option<IsotopicPatternMatch>> tuple3 = $this._predictPrecursorFromTarget(spectrumData$1, altPrecursorPeak.getMz(), 0);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Option altPredictionOpt = (Option)tuple3._1();
        String altPredictionNote = (String)tuple3._2();
        Option altPatternMatchOpt = (Option)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)altPredictionOpt, (Object)altPredictionNote, (Object)altPatternMatchOpt);
        Tuple3 tuple33 = tuple32;
        Option altPredictionOpt2 = (Option)tuple33._1();
        String altPredictionNote2 = (String)tuple33._2();
        Option altPatternMatchOpt2 = (Option)tuple33._3();
        if (altPredictionOpt2.isDefined()) {
            Tuple2 tuple2 = (Tuple2)altPredictionOpt2.get();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double refinedAltPrecMz = tuple2._1$mcD$sp();
            int charge = tuple2._2$mcI$sp();
            Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(refinedAltPrecMz, charge);
            Tuple2.mcDI.sp sp3 = sp2;
            double refinedAltPrecMz2 = sp3._1$mcD$sp();
            int charge2 = sp3._2$mcI$sp();
            if (charge2 > 1 && charge2 <= Settings$.MODULE$.maxIsotopicChargeState()) {
                if (!((Seq)swPrecursors$1.elem).exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$getMgfPrecursors$6($this, refinedAltPrecMz2, charge2, p)))) {
                    Option<MgfPrecursor> altPrecursorOpt = $this._buildMgfPrecursor(spectrumHeader$1.getElutionTime(), refinedAltPrecMz2, charge2);
                    if (altPrecursorOpt.isDefined()) {
                        MgfPrecursor altPrecursor = (MgfPrecursor)altPrecursorOpt.get();
                        altPrecursor.addAnnotation("source", (Object)"sw");
                        altPrecursor.addAnnotation("ms1.scan.number", (Object)BoxesRunTime.boxToLong((long)((Spectrum)spectrumData$1.nearestSlice().get()).getHeader().getSpectrumId()));
                        altPrecursor.addAnnotation("in.sw", (Object)BoxesRunTime.boxToBoolean((boolean)spectrumData$1.isInIsolationWindow(refinedAltPrecMz2)));
                        altPrecursor.addAnnotation("scan.number", (Object)BoxesRunTime.boxToLong((long)spectrumHeader$1.getSpectrumId()));
                        altPrecursor.addAnnotation("rank", (Object)BoxesRunTime.boxToInteger((int)rank$1.elem));
                        altPrecursor.addAnnotation("prediction", (Object)altPredictionNote2);
                        if (altPatternMatchOpt2.isDefined()) {
                            altPrecursor.addAnnotation("prediction.pattern.score", (Object)BoxesRunTime.boxToDouble((double)((IsotopicPatternMatch)altPatternMatchOpt2.get()).score()));
                        }
                        altPrecursor.addAnnotation("filtered.peaks.count.sw", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altPrecursorPeaks$1)).size()));
                        Tuple2<Object, Object> tuple22 = $this._computePrecursorSignalRatio((Option<IsotopicPatternMatch>)altPatternMatchOpt2, spectrumData$1);
                        if (tuple22 == null) {
                            throw new MatchError(tuple22);
                        }
                        float totalRatio = BoxesRunTime.unboxToFloat((Object)tuple22._1());
                        float maxRatio = BoxesRunTime.unboxToFloat((Object)tuple22._2());
                        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)totalRatio), (Object)BoxesRunTime.boxToFloat((float)maxRatio));
                        Tuple2 tuple24 = tuple23;
                        float totalRatio2 = BoxesRunTime.unboxToFloat((Object)tuple24._1());
                        float maxRatio2 = BoxesRunTime.unboxToFloat((Object)tuple24._2());
                        altPrecursor.addAnnotation("precursor.signal.total.sw", (Object)BoxesRunTime.boxToFloat((float)totalRatio2));
                        altPrecursor.addAnnotation("precursor.signal.max.sw", (Object)BoxesRunTime.boxToFloat((float)maxRatio2));
                        Tuple2<Object, Option<Peak>> tuple25 = $this._computePrecursorSignalRank((Option<IsotopicPatternMatch>)altPatternMatchOpt2, spectrumData$1);
                        if (tuple25 == null) {
                            throw new MatchError(tuple25);
                        }
                        int precRank = tuple25._1$mcI$sp();
                        Option maxPrecPeakInSW = (Option)tuple25._2();
                        Tuple2 tuple26 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)precRank), (Object)maxPrecPeakInSW);
                        Tuple2 tuple27 = tuple26;
                        int precRank2 = tuple27._1$mcI$sp();
                        Option maxPrecPeakInSW2 = (Option)tuple27._2();
                        altPrecursor.addAnnotation("precursor.rank.sw", (Object)BoxesRunTime.boxToInteger((int)precRank2));
                        if (maxPrecPeakInSW2.isDefined()) {
                            altPrecursor.addAnnotation("precursor.intensity.sw", (Object)BoxesRunTime.boxToFloat((float)((Peak)maxPrecPeakInSW2.get()).getIntensity()));
                        }
                        altPrecursor.addAnnotation("scan.selector", (Object)selector$1.toString());
                        Object l = altPrecursor.getAnnotation("rank");
                        swPrecursors$1.elem = (Seq)((Seq)swPrecursors$1.elem).$colon$plus((Object)altPrecursor, Seq$.MODULE$.canBuildFrom());
                    }
                } else if ((MgfPrecursor)headerPrecursor$1.elem != null && !((MgfPrecursor)headerPrecursor$1.elem).getAnnotation("source").toString().contains("sw") && Math.abs(1000000.0 * (Predef$.MODULE$.Double2double(((MgfPrecursor)headerPrecursor$1.elem).getPrecMz()) - refinedAltPrecMz2) / Predef$.MODULE$.Double2double(((MgfPrecursor)headerPrecursor$1.elem).getPrecMz())) < (double)$this.mzTolPPM && BoxesRunTime.equalsNumObject((Number)((MgfPrecursor)headerPrecursor$1.elem).getCharge(), (Object)BoxesRunTime.boxToInteger((int)charge2))) {
                    ((MgfPrecursor)headerPrecursor$1.elem).addAnnotation("source", (Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(((MgfPrecursor)headerPrecursor$1.elem).getAnnotation("source")), " & sw"));
                    ((MgfPrecursor)headerPrecursor$1.elem).addAnnotation("rank", (Object)BoxesRunTime.boxToInteger((int)rank$1.elem));
                }
            }
        }
        ++rank$1.elem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getMgfPrecursors$8(MgfBoostPrecursorExtractor $this, MgfPrecursor swPrecursor$1, MgfPrecursor p) {
        if (!(Math.abs(1000000.0 * (Predef$.MODULE$.Double2double(p.getPrecMz()) - Predef$.MODULE$.Double2double(swPrecursor$1.getPrecMz())) / Predef$.MODULE$.Double2double(p.getPrecMz())) < (double)$this.mzTolPPM)) return false;
        Integer n = p.getCharge();
        Integer n2 = swPrecursor$1.getCharge();
        if (n != null) {
            if (!((Object)n).equals(n2)) return false;
            return true;
        }
        if (n2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$getMgfPrecursors$7(MgfBoostPrecursorExtractor $this, ObjectRef precursors$1, MgfPrecursor swPrecursor) {
        block0: {
            if (((Seq)precursors$1.elem).exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$getMgfPrecursors$8($this, swPrecursor, p)))) break block0;
            precursors$1.elem = (Seq)((Seq)precursors$1.elem).$colon$plus((Object)swPrecursor, Seq$.MODULE$.canBuildFrom());
        }
    }

    public static final /* synthetic */ void $anonfun$getMgfPrecursors$3(MgfBoostPrecursorExtractor $this, MzDbReader mzDbReader$1, SpectrumHeader spectrumHeader$1, ObjectRef previousSpectrumDataIndexes$1, ObjectRef precursors$1, ObjectRef headerPrecursor$1, Enumeration.Value selector) {
        block0: {
            SpectrumDataSource spectrumData = $this._buildSpectrumDataSource(mzDbReader$1, spectrumHeader$1, selector);
            if (!spectrumData.nearestSlice().isDefined() || ((Seq)previousSpectrumDataIndexes$1.elem).contains((Object)BoxesRunTime.boxToLong((long)((Spectrum)spectrumData.nearestSlice().get()).getHeader().getSpectrumId()))) break block0;
            previousSpectrumDataIndexes$1.elem = (Seq)((Seq)previousSpectrumDataIndexes$1.elem).$colon$plus((Object)BoxesRunTime.boxToLong((long)((Spectrum)spectrumData.nearestSlice().get()).getHeader().getSpectrumId()), Seq$.MODULE$.canBuildFrom());
            Peak[] altPrecursorPeaks = spectrumData.getCandidatePeaksFromIsolationWindow($this.swIntensityThreshold);
            ObjectRef swPrecursors = ObjectRef.create((Object)((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)((Seq)precursors$1.elem), Seq$.MODULE$.canBuildFrom())));
            int maxPrec = ((Seq)swPrecursors.elem).length() + $this.swMaxPrecursorsCount;
            IntRef rank = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altPrecursorPeaks)).withFilter((Function1 & Serializable & scala.Serializable)altPrecursorPeak -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$getMgfPrecursors$4(swPrecursors, maxPrec, altPrecursorPeak))).foreach((Function1 & Serializable & scala.Serializable)altPrecursorPeak -> {
                MgfBoostPrecursorExtractor.$anonfun$getMgfPrecursors$5($this, spectrumData, swPrecursors, spectrumHeader$1, rank, altPrecursorPeaks, selector, headerPrecursor$1, altPrecursorPeak);
                return BoxedUnit.UNIT;
            });
            ((Seq)swPrecursors.elem).foreach((Function1 & Serializable & scala.Serializable)swPrecursor -> {
                MgfBoostPrecursorExtractor.$anonfun$getMgfPrecursors$7($this, precursors$1, swPrecursor);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$getMgfPrecursors$9(MgfBoostPrecursorExtractor $this, MgfPrecursor p) {
        Object rank = p.getAnnotation("rank");
        float totalRatio = BoxesRunTime.unboxToFloat((Object)p.getAnnotation("precursor.signal.total.sw"));
        return (rank == null || BoxesRunTime.unboxToInt((Object)rank) <= $this.rankThreshold) && (totalRatio < 0.0f || (double)totalRatio >= $this.pifThreshold);
    }

    public static final /* synthetic */ void $anonfun$getMgfPrecursors$10(SpectrumHeader spectrumHeader$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MgfPrecursor p = (MgfPrecursor)tuple2._1();
        int idx = tuple2._2$mcI$sp();
        p.addAnnotation("mgf.id", (Object)new StringBuilder(1).append(spectrumHeader$1.getSpectrumId()).append(".").append(idx + 1).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$_computePrecursorSignalRank$2(SpectrumDataSource spectrumData$2, Option po) {
        return po.isDefined() && spectrumData$2.isInIsolationWindow(((Peak)po.get()).getMz());
    }

    public static final /* synthetic */ void $anonfun$_computePrecursorSignalRank$6(Peak patternMaxPeakInSW$1, IntRef rank$2, Peak p) {
        if (p.compareTo(patternMaxPeakInSW$1) == 0) {
            throw Breaks$.MODULE$.break();
        }
        ++rank$2.elem;
    }

    public static final /* synthetic */ boolean $anonfun$_computePrecursorSignalRatio$1(SpectrumDataSource spectrumData$3, Option po) {
        return po.isDefined() && spectrumData$3.isInIsolationWindow(((Peak)po.get()).getMz());
    }

    public static final /* synthetic */ float $anonfun$_computePrecursorSignalRatio$3(float s, Peak p) {
        return s + p.getIntensity();
    }

    public static final /* synthetic */ float $anonfun$_computePrecursorSignalRatio$4(float s, Peak p) {
        return s + p.getIntensity();
    }

    public static final /* synthetic */ boolean $anonfun$_buildSpectrumDataSource$1(SpectrumHeader spectrumHeader$2, boolean hasIonMobility$1, Option cvOpt$1, SpectrumSlice x) {
        return x.getHeader().getCycle() == spectrumHeader$2.getCycle() && (!hasIonMobility$1 || BoxesRunTime.equals((Object)cvOpt$1.get(), (Object)MgfBoostPrecursorExtractor$.MODULE$.readIonMobilityCV(x.getHeader()).get()));
    }

    public static final /* synthetic */ boolean $anonfun$_buildSpectrumDataSource$2(boolean hasIonMobility$1, Option cvOpt$1, SpectrumSlice x) {
        return !hasIonMobility$1 || BoxesRunTime.equals((Object)cvOpt$1.get(), (Object)MgfBoostPrecursorExtractor$.MODULE$.readIonMobilityCV(x.getHeader()).get());
    }

    public static final /* synthetic */ float $anonfun$_buildSpectrumDataSource$3(float time$1, SpectrumSlice x) {
        return Math.abs(x.getHeader().getElutionTime() - time$1);
    }

    public static final /* synthetic */ boolean $anonfun$extractSWStats$1(SpectrumHeader spectrumHeader$3, SpectrumSlice x$19) {
        return x$19.getHeader().getCycle() == spectrumHeader$3.getCycle();
    }

    public static final /* synthetic */ boolean $anonfun$extractSWStats$5(int i$1, Peak maxPeak$2, Peak x$22) {
        return (double)x$22.getIntensity() >= (double)i$1 / 10.0 * (double)maxPeak$2.getIntensity();
    }

    public static final /* synthetic */ double $anonfun$extractSWStats$7(float sw_center$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Peak p = (Peak)tuple2._1();
        double d = package$.MODULE$.abs(p.getMz() - (double)sw_center$1);
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$extractPrecursorStats$8(double altprecMz$1, float mzTolPPM$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Peak peak = (Peak)tuple2._1();
        boolean bl = package$.MODULE$.abs(1000000.0 * (peak.getMz() - altprecMz$1) / altprecMz$1) <= (double)mzTolPPM$2;
        return bl;
    }

    public static final /* synthetic */ double $anonfun$extractPrecursorStats$9(double altprecMz$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Peak peak = (Peak)tuple2._1();
        double d = package$.MODULE$.abs(peak.getMz() - altprecMz$1);
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$extractPrecursorStats$11(double altprecMz$2, float mzTolPPM$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Peak peak = (Peak)tuple2._1();
        boolean bl = package$.MODULE$.abs(1000000.0 * (peak.getMz() - altprecMz$2) / altprecMz$2) <= (double)mzTolPPM$2;
        return bl;
    }

    public static final /* synthetic */ double $anonfun$extractPrecursorStats$12(double altprecMz$2, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Peak peak = (Peak)tuple2._1();
        double d = package$.MODULE$.abs(peak.getMz() - altprecMz$2);
        return d;
    }

    public static final /* synthetic */ void $anonfun$extractPrecursorStats$6(MgfBoostPrecursorExtractor $this, IntRef rank$3, ObjectRef result$2, SpectrumDataSource spectrumData$4, Peak[] allPeaks$2, float mzTolPPM$2, double precMz$1, Peak swPrecMz) {
        if (rank$3.elem == 0) {
            result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rank0.initial.intensity"), (Object)BoxesRunTime.boxToFloat((float)swPrecMz.getIntensity())));
            result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rank0.initial.moz"), (Object)BoxesRunTime.boxToDouble((double)swPrecMz.getMz())));
            Tuple3<Option<Tuple2<Object, Object>>, String, Option<IsotopicPatternMatch>> tuple3 = $this._predictPrecursorFromTarget(spectrumData$4, swPrecMz.getMz(), 0);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Option altPredictionOpt = (Option)tuple3._1();
            String altPredictionNote = (String)tuple3._2();
            Option altPatternMatchOpt = (Option)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)altPredictionOpt, (Object)altPredictionNote, (Object)altPatternMatchOpt);
            Tuple3 tuple33 = tuple32;
            Option altPredictionOpt2 = (Option)tuple33._1();
            String altPredictionNote2 = (String)tuple33._2();
            Option altPatternMatchOpt2 = (Option)tuple33._3();
            result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rank0.prediction.note"), (Object)altPredictionNote2));
            if (altPredictionOpt2.isDefined()) {
                double altprecMz = ((Tuple2)altPredictionOpt2.get())._1$mcD$sp();
                result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rank0.prediction.moz"), (Object)BoxesRunTime.boxToDouble((double)altprecMz)));
                result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rank0.prediction.charge"), (Object)BoxesRunTime.boxToInteger((int)((Tuple2)altPredictionOpt2.get())._2$mcI$sp())));
                Tuple2[] altprecursors = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks$2)).sortBy((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToFloat((float)x$29.getIntensity()), (Ordering)Ordering.Float$.MODULE$))).reverse())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$extractPrecursorStats$8(altprecMz, mzTolPPM$2, x0$1)));
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altprecursors)).isEmpty()) {
                    Tuple2 altprecursor = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altprecursors)).minBy((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)MgfBoostPrecursorExtractor.$anonfun$extractPrecursorStats$9(altprecMz, x0$2)), (Ordering)Ordering.Double$.MODULE$);
                    result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rank0.prediction.intensity"), (Object)BoxesRunTime.boxToFloat((float)((Peak)altprecursor._1()).getIntensity())));
                    result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rank0.prediction.rank"), (Object)BoxesRunTime.boxToInteger((int)altprecursor._2$mcI$sp())));
                }
            }
        }
        if (Math.abs(1000000.0 * (precMz$1 - swPrecMz.getMz()) / precMz$1) < (double)mzTolPPM$2) {
            result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"found"), (Object)"true"));
            result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident.initial.moz"), (Object)BoxesRunTime.boxToDouble((double)precMz$1)));
            result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident.initial.rank"), (Object)BoxesRunTime.boxToInteger((int)rank$3.elem)));
            result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident.initial.intensity"), (Object)BoxesRunTime.boxToFloat((float)swPrecMz.getIntensity())));
            Tuple3<Option<Tuple2<Object, Object>>, String, Option<IsotopicPatternMatch>> tuple3 = $this._predictPrecursorFromTarget(spectrumData$4, swPrecMz.getMz(), 0);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            Option altPredictionOpt = (Option)tuple3._1();
            String altPredictionNote = (String)tuple3._2();
            Option altPatternMatchOpt = (Option)tuple3._3();
            Tuple3 tuple34 = new Tuple3((Object)altPredictionOpt, (Object)altPredictionNote, (Object)altPatternMatchOpt);
            Tuple3 tuple35 = tuple34;
            Option altPredictionOpt3 = (Option)tuple35._1();
            String altPredictionNote3 = (String)tuple35._2();
            Option altPatternMatchOpt3 = (Option)tuple35._3();
            result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident.prediction.note"), (Object)altPredictionNote3));
            if (altPredictionOpt3.isDefined()) {
                double altprecMz = ((Tuple2)altPredictionOpt3.get())._1$mcD$sp();
                result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident.prediction.moz"), (Object)BoxesRunTime.boxToDouble((double)altprecMz)));
                result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident.prediction.charge"), (Object)BoxesRunTime.boxToInteger((int)((Tuple2)altPredictionOpt3.get())._2$mcI$sp())));
                Tuple2[] altprecursors = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allPeaks$2)).sortBy((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToFloat((float)x$31.getIntensity()), (Ordering)Ordering.Float$.MODULE$))).reverse())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)MgfBoostPrecursorExtractor.$anonfun$extractPrecursorStats$11(altprecMz, mzTolPPM$2, x0$3)));
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altprecursors)).isEmpty()) {
                    Tuple2 altprecursor = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])altprecursors)).minBy((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToDouble((double)MgfBoostPrecursorExtractor.$anonfun$extractPrecursorStats$12(altprecMz, x0$4)), (Ordering)Ordering.Double$.MODULE$);
                    result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident.prediction.intensity"), (Object)BoxesRunTime.boxToFloat((float)((Peak)altprecursor._1()).getIntensity())));
                    result$2.elem = ((Map)result$2.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident.prediction.rank"), (Object)BoxesRunTime.boxToInteger((int)altprecursor._2$mcI$sp())));
                }
            }
            throw Breaks$.MODULE$.break();
        }
        ++rank$3.elem;
    }

    public static final /* synthetic */ boolean $anonfun$extractPrecursorStats$13(MgfBoostPrecursorExtractor $this, Peak maxPeak$3, Peak x$32) {
        return x$32.getIntensity() > $this.swIntensityThreshold * maxPeak$3.getIntensity();
    }

    public static final /* synthetic */ double $anonfun$extractPrecursorStats$15(float sw_center$2, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Peak p = (Peak)tuple2._1();
        double d = package$.MODULE$.abs(p.getMz() - (double)sw_center$2);
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$extractPrecursorStats$17(double altprecMz$3, float mzTolPPM$2, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Peak peak = (Peak)tuple2._1();
        boolean bl = package$.MODULE$.abs(1000000.0 * (peak.getMz() - altprecMz$3) / altprecMz$3) <= (double)mzTolPPM$2;
        return bl;
    }

    public static final /* synthetic */ double $anonfun$extractPrecursorStats$18(double altprecMz$3, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Peak peak = (Peak)tuple2._1();
        double d = package$.MODULE$.abs(peak.getMz() - altprecMz$3);
        return d;
    }

    public static final /* synthetic */ void $anonfun$extractPrecursorIsotopesStats$4(double precMz$2, float mzTolPPM$3, ObjectRef result$3, IntRef rank$4, int precZ$1, Option ms1Slice$1, Peak swPrecMz) {
        if (Math.abs(1000000.0 * (precMz$2 - swPrecMz.getMz()) / precMz$2) < (double)mzTolPPM$3) {
            result$3.elem = ((Map)result$3.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"found"), (Object)"true"));
            result$3.elem = ((Map)result$3.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident.initial.moz"), (Object)BoxesRunTime.boxToDouble((double)precMz$2)));
            result$3.elem = ((Map)result$3.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident.initial.rank"), (Object)BoxesRunTime.boxToInteger((int)rank$4.elem)));
            result$3.elem = ((Map)result$3.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident.initial.intensity"), (Object)BoxesRunTime.boxToFloat((float)swPrecMz.getIntensity())));
            DoubleRef previousMz = DoubleRef.create((double)precMz$2);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
                double isotopeMz = previousMz$1.elem + 1.0027 / (double)precZ$1;
                Peak isotopicPeak = ((Spectrum)ms1Slice$1.get()).getNearestPeak(isotopeMz, (double)mzTolPPM$3);
                if (isotopicPeak != null) {
                    double shift = (double)precZ$1 * (isotopicPeak.getMz() - previousMz$1.elem);
                    result$3.elem = ((Map)result$3.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(20).append("ident.isotope.shift.").append(k).toString()), (Object)BoxesRunTime.boxToDouble((double)shift)));
                    result$3.elem = ((Map)result$3.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(24).append("ident.isotope.shift.ppm.").append(k).toString()), (Object)BoxesRunTime.boxToDouble((double)(1000000.0 * package$.MODULE$.abs((isotopicPeak.getMz() - isotopeMz) / isotopicPeak.getMz())))));
                    result$3.elem = ((Map)result$3.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(24).append("ident.isotope.shift.abs.").append(k).toString()), (Object)BoxesRunTime.boxToDouble((double)(isotopicPeak.getMz() - precMz$2))));
                    previousMz$1.elem = isotopicPeak.getMz();
                } else {
                    previousMz$1.elem = isotopeMz;
                }
            });
            throw Breaks$.MODULE$.break();
        }
        ++rank$4.elem;
    }

    public MgfBoostPrecursorExtractor(float mzTolPPM, boolean useHeader, boolean useSW, int swMaxPrecursorsCount, float swIntensityThreshold, Enumeration.Value scanSelector, double pifThreshold, int rankThreshold) {
        this.mzTolPPM = mzTolPPM;
        this.useHeader = useHeader;
        this.useSW = useSW;
        this.swMaxPrecursorsCount = swMaxPrecursorsCount;
        this.swIntensityThreshold = swIntensityThreshold;
        this.scanSelector = scanSelector;
        this.pifThreshold = pifThreshold;
        this.rankThreshold = rankThreshold;
        super(mzTolPPM);
        this.metric = new Metric("MgfBoost");
    }
}

