/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.peakeldb.io;

import com.almworks.sqlite4java.SQLiteBackup;
import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.model.Peakel;
import fr.profi.mzdb.model.PeakelDataMatrix;
import fr.profi.mzdb.model.PeakelDataMatrix$;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import rx.lang.scala.Observable;
import rx.lang.scala.Observable$;
import rx.lang.scala.Subscriber;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PeakelDbReader$ {
    public static PeakelDbReader$ MODULE$;
    private final double SQLITE_RTREE_UB_CORR;
    private final double SQLITE_RTREE_LB_CORR;
    private final PearsonsCorrelation PEARSON;

    static {
        new PeakelDbReader$();
    }

    private double SQLITE_RTREE_UB_CORR() {
        return this.SQLITE_RTREE_UB_CORR;
    }

    private double SQLITE_RTREE_LB_CORR() {
        return this.SQLITE_RTREE_LB_CORR;
    }

    private PearsonsCorrelation PEARSON() {
        return this.PEARSON;
    }

    public Seq<Object> findPeakelIdsInRangeFromPeakelDB(SQLiteConnection sqliteConn, double minMz, double maxMz, float minTime, float maxTime) {
        String peakelIdRtreeSqlQuery = "SELECT id, min_mz, max_mz FROM peakel_rtree WHERE min_mz >= ? AND max_mz <= ? AND min_time >= ? AND max_time <= ?";
        SQLiteStatement peakelIdStmt = sqliteConn.prepare(peakelIdRtreeSqlQuery, false);
        ArrayBuffer peakelIds = new ArrayBuffer();
        try {
            peakelIdStmt.bind(1, minMz * this.SQLITE_RTREE_LB_CORR()).bind(2, maxMz * this.SQLITE_RTREE_UB_CORR()).bind(3, (double)minTime).bind(4, (double)maxTime);
            while (peakelIdStmt.step()) {
                double mz1 = peakelIdStmt.columnDouble(1);
                double mz2 = peakelIdStmt.columnDouble(2);
                Object object = mz1 >= minMz || mz2 <= maxMz ? peakelIds.$plus$eq((Object)BoxesRunTime.boxToInteger((int)peakelIdStmt.columnInt(0))) : BoxedUnit.UNIT;
            }
        }
        finally {
            peakelIdStmt.dispose();
        }
        return peakelIds;
    }

    public Observable<Peakel[]> streamPeakels(File peakelFile) {
        return Observable$.MODULE$.apply((Function1 & Serializable & scala.Serializable)subscriber -> {
            PeakelDbReader$.$anonfun$streamPeakels$1(peakelFile, subscriber);
            return BoxedUnit.UNIT;
        });
    }

    public ArrayBuffer<Peakel> loadAllPeakels(SQLiteConnection sqliteConn, int sizeHint) {
        return this.loadManyPeakels(sqliteConn, sizeHint, this.loadManyPeakels$default$3());
    }

    public int loadAllPeakels$default$2() {
        return 50000;
    }

    public ArrayBuffer<Peakel> loadManyPeakels(SQLiteConnection sqliteConn, int sizeHint, Option<Function1<Object, Object>> idPredicate) {
        File dbFile = sqliteConn.getDatabaseFile();
        if (dbFile != null) {
            this._readWholeFile(sqliteConn.getDatabaseFile());
        }
        String peakelSqlQuery = "SELECT id, peaks, left_hwhm_mean, left_hwhm_cv, right_hwhm_mean, right_hwhm_cv FROM peakel;";
        return this._loadPeakelsForQuery(sqliteConn, peakelSqlQuery, sizeHint, idPredicate);
    }

    public int loadManyPeakels$default$2() {
        return 50000;
    }

    public Option<Function1<Object, Object>> loadManyPeakels$default$3() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public SQLiteConnection loadPeakelDbInMemory(SQLiteConnection peakelDb) {
        void var3_3;
        SQLiteBackup backup = peakelDb.initializeBackup(null);
        SQLiteConnection memPeakelDb = backup.getDestinationConnection();
        while (!backup.isFinished()) {
            backup.backupStep(-1);
        }
        backup.dispose(false);
        return var3_3;
    }

    private void _readWholeFile(File file) {
        FileInputStream fis = new FileInputStream(file);
        byte[] b = new byte[0x100000];
        while (fis.available() != 0) {
            fis.read(b);
        }
        fis.close();
    }

    public ArrayBuffer<Peakel> _loadPeakelsForIds(SQLiteConnection sqliteConn, Seq<Object> peakelIds) {
        String peakelPkSqlQuery = new StringBuilder(106).append("SELECT id, peaks, left_hwhm_mean, left_hwhm_cv, ").append("right_hwhm_mean, right_hwhm_cv FROM peakel WHERE id IN (").append(peakelIds.mkString(",")).append(");").toString();
        ArrayBuffer<Peakel> peakels = this._loadPeakelsForQuery(sqliteConn, peakelPkSqlQuery, peakelIds.length(), this._loadPeakelsForQuery$default$4());
        Predef$.MODULE$.assert(peakelIds.length() == peakels.length(), (Function0 & Serializable & scala.Serializable)() -> "invalid number of retrieved peakels from peakelDB file");
        return peakels;
    }

    private ArrayBuffer<Peakel> _loadPeakelsForQuery(SQLiteConnection sqliteConn, String sqlQuery, int sizeHint, Option<Function1<Object, Object>> idPredicate) {
        SQLiteStatement peakelStmt = sqliteConn.prepare(sqlQuery, false);
        ArrayBuffer peakels = new ArrayBuffer(sizeHint);
        try {
            if (idPredicate.isDefined()) {
                while (peakelStmt.step()) {
                    Object object = ((Function1)idPredicate.get()).apply$mcZI$sp(peakelStmt.columnInt(0)) ? peakels.$plus$eq((Object)this._buildPeakel(peakelStmt)) : BoxedUnit.UNIT;
                }
            } else {
                while (peakelStmt.step()) {
                    peakels.$plus$eq((Object)this._buildPeakel(peakelStmt));
                }
            }
        }
        finally {
            peakelStmt.dispose();
        }
        return peakels;
    }

    private int _loadPeakelsForQuery$default$3() {
        return 100;
    }

    private Option<Function1<Object, Object>> _loadPeakelsForQuery$default$4() {
        return None$.MODULE$;
    }

    private Peakel _buildPeakel(SQLiteStatement peakelStmt) {
        int peakelId = peakelStmt.columnInt(0);
        byte[] peakelMessageAsBytes = peakelStmt.columnBlob(1);
        PeakelDataMatrix peakelMessage = PeakelDataMatrix$.MODULE$.unpack(peakelMessageAsBytes);
        Tuple2<Object, Object> tuple2 = peakelMessage.integratePeakel();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        float intensitySum = BoxesRunTime.unboxToFloat((Object)tuple2._1());
        float area = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToFloat((float)intensitySum), (Object)BoxesRunTime.boxToFloat((float)area));
        Tuple2 tuple23 = tuple22;
        float intensitySum2 = BoxesRunTime.unboxToFloat((Object)tuple23._1());
        float area2 = BoxesRunTime.unboxToFloat((Object)tuple23._2());
        return new Peakel(peakelId, peakelMessage, intensitySum2, area2, (float)peakelStmt.columnDouble(2), (float)peakelStmt.columnDouble(3), (float)peakelStmt.columnDouble(4), (float)peakelStmt.columnDouble(5));
    }

    public static final /* synthetic */ void $anonfun$streamPeakels$1(File peakelFile$1, Subscriber subscriber) {
        SQLiteConnection sqliteConn = new SQLiteConnection(peakelFile$1);
        sqliteConn.openReadonly();
        try {
            ArrayBuffer<Peakel> peakelsBuffer = MODULE$.loadAllPeakels(sqliteConn, MODULE$.loadAllPeakels$default$2());
            subscriber.onNext(peakelsBuffer.toArray(ClassTag$.MODULE$.apply(Peakel.class)));
            subscriber.onCompleted();
        }
        finally {
            sqliteConn.dispose();
        }
    }

    private PeakelDbReader$() {
        MODULE$ = this;
        this.SQLITE_RTREE_UB_CORR = 1.00000012;
        this.SQLITE_RTREE_LB_CORR = 0.99999988;
        this.PEARSON = new PearsonsCorrelation();
    }
}

