/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.chemistry.algo;

import fr.profi.chemistry.model.AbstractMolecularEntityComposition;
import fr.profi.chemistry.model.AminoAcidTableLike;
import fr.profi.chemistry.model.Atom;
import fr.profi.chemistry.model.AtomComposition;
import fr.profi.chemistry.model.AtomTableLike;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0014)\u0001EB\u0001\u0002\u000f\u0001\u0003\u0006\u0004%\t!\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005u!A\u0011\t\u0001BC\u0002\u0013\u0005!\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003D\u0011\u00159\u0005\u0001\"\u0001I\u0011\u001di\u0005A1A\u0005\n9CaA\u0015\u0001!\u0002\u0013y\u0005bB*\u0001\u0005\u0004%IA\u0014\u0005\u0007)\u0002\u0001\u000b\u0011B(\t\u000fU\u0003!\u0019!C\u0005\u001d\"1a\u000b\u0001Q\u0001\n=Cqa\u0016\u0001C\u0002\u0013%a\n\u0003\u0004Y\u0001\u0001\u0006Ia\u0014\u0005\b3\u0002\u0011\r\u0011\"\u0003O\u0011\u0019Q\u0006\u0001)A\u0005\u001f\"91\f\u0001b\u0001\n\u0013a\u0006B\u00021\u0001A\u0003%Q\fC\u0004b\u0001\t\u0007I\u0011\u0002/\t\r\t\u0004\u0001\u0015!\u0003^\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Daa\u001b\u0001!\u0002\u0013)\u0007b\u00027\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007[\u0002\u0001\u000b\u0011B3\t\u000f9\u0004!\u0019!C\u0005I\"1q\u000e\u0001Q\u0001\n\u0015Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004\u007f\u0001\u0001\u0006IA\u001d\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002!A\u0011q\u0003\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0001\u0002\u001c!A\u0011Q\u0004\u0001!\u0002\u0013\t\t\u0002C\u0005\u0002 \u0001\u0011\r\u0011\"\u0001\u0002\"!A\u00111\u0005\u0001!\u0002\u0013\tY\u0001C\u0004\u0002&\u0001!\t!a\n\t\u0013\u0005u\u0002!%A\u0005\u0002\u0005}\u0002\"CA+\u0001E\u0005I\u0011AA,\u0011\u001d\tY\u0006\u0001C\u0005\u0003;Bq!!)\u0001\t\u0003\t\u0019KA\tBm\u0016\u0014\u0018mZ5oK\u000e{W\u000e];uKJT!!\u000b\u0016\u0002\t\u0005dwm\u001c\u0006\u0003W1\n\u0011b\u00195f[&\u001cHO]=\u000b\u00055r\u0013!\u00029s_\u001aL'\"A\u0018\u0002\u0005\u0019\u00148\u0001A\n\u0003\u0001I\u0002\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012a!\u00118z%\u00164\u0017aB1b)\u0006\u0014G.Z\u000b\u0002uA\u00111HP\u0007\u0002y)\u0011QHK\u0001\u0006[>$W\r\\\u0005\u0003\u007fq\u0012!#Q7j]>\f5-\u001b3UC\ndW\rT5lK\u0006A\u0011-\u0019+bE2,\u0007%A\u0005bi>lG+\u00192mKV\t1\t\u0005\u0002<\t&\u0011Q\t\u0010\u0002\u000e\u0003R|W\u000eV1cY\u0016d\u0015n[3\u0002\u0015\u0005$x.\u001c+bE2,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004\u0013.c\u0005C\u0001&\u0001\u001b\u0005A\u0003\"\u0002\u001d\u0006\u0001\u0004Q\u0004\"B!\u0006\u0001\u0004\u0019\u0015AB\"`\u0003R{U*F\u0001P!\tY\u0004+\u0003\u0002Ry\t!\u0011\t^8n\u0003\u001d\u0019u,\u0011+P\u001b\u0002\na\u0001S0B)>k\u0015a\u0002%`\u0003R{U\nI\u0001\u0007\u001f~\u000bEkT'\u0002\u000f={\u0016\tV(NA\u00051ajX!U\u001f6\u000bqAT0B)>k\u0005%\u0001\u0004T?\u0006#v*T\u0001\b'~\u000bEkT'!\u00035i\u0015JT0D?N{&+\u0011+J\u001fV\tQ\f\u0005\u00024=&\u0011q\f\u000e\u0002\u0004\u0013:$\u0018AD'J\u001d~\u001bulU0S\u0003RKu\nI\u0001\u000e\u001b&su\fS0T?J\u000bE+S(\u0002\u001d5Kej\u0018%`'~\u0013\u0016\tV%PA\u0005y\u0001jX\"`%\u0006#\u0016jT0S\u0003:;U)F\u0001f!\u0011\u0019d\r[/\n\u0005\u001d$$A\u0002+va2,'\u0007\u0005\u00024S&\u0011!\u000e\u000e\u0002\u0006\r2|\u0017\r^\u0001\u0011\u0011~\u001buLU!U\u0013>{&+\u0011(H\u000b\u0002\nqBT0P?J\u000bE+S(`%\u0006su)R\u0001\u0011\u001d~{uLU!U\u0013>{&+\u0011(H\u000b\u0002\nqbQ0O?J\u000bE+S(`%\u0006su)R\u0001\u0011\u0007~suLU!U\u0013>{&+\u0011(H\u000b\u0002\nA#\u00192v]\u0012\fgnY3SC:<WMQ=Bi>lW#\u0001:\u0011\tMTx* \b\u0003ib\u0004\"!\u001e\u001b\u000e\u0003YT!a\u001e\u0019\u0002\rq\u0012xn\u001c;?\u0013\tIH'\u0001\u0004Qe\u0016$WMZ\u0005\u0003wr\u00141!T1q\u0015\tIH\u0007\u0005\u00034M\"D\u0017!F1ck:$\u0017M\\2f%\u0006tw-\u001a\"z\u0003R|W\u000eI\u0001\u0017G>l\u0007o\\:ji&|g.\u00113kkN$X.\u001a8ugV\u0011\u00111\u0001\t\u0006g\u0005\u0015\u0011\u0011B\u0005\u0004\u0003\u000f!$!B!se\u0006L\bCB\u001ag\u0003\u0017\t\t\u0002E\u0002<\u0003\u001bI1!a\u0004=\u0005=\tEo\\7D_6\u0004xn]5uS>t\u0007cA\u001a\u0002\u0014%\u0019\u0011Q\u0003\u001b\u0003\r\u0011{WO\u00197f\u0003]\u0019w.\u001c9pg&$\u0018n\u001c8BI*,8\u000f^7f]R\u001c\b%A\u0007bm\u0016\u0014\u0018mZ3B\u00036\u000b7o]\u000b\u0003\u0003#\ta\"\u0019<fe\u0006<W-Q!NCN\u001c\b%\u0001\fbm\u0016\u0014\u0018mZ3Bi>l7i\\7q_NLG/[8o+\t\tY!A\fbm\u0016\u0014\u0018mZ3Bi>l7i\\7q_NLG/[8oA\u0005\u00012m\\7qkR,\u0017I^3sC\u001eLg.\u001a\u000b\t\u0003S\tY#a\f\u0002:A)1GZA\u0006;\"9\u0011Q\u0006\u0012A\u0002\u0005E\u0011\u0001D2p[B|WO\u001c3NCN\u001c\b\"CA\u0019EA\u0005\t\u0019AA\u001a\u0003A\tGM[;ti\u0006\u0013WO\u001c3b]\u000e,7\u000fE\u00024\u0003kI1!a\u000e5\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u000f#!\u0003\u0005\r\u0001[\u0001\u000bC\u0012TW*Y:t)>d\u0017AG2p[B,H/Z!wKJ\fw-\u001b8fI\u0011,g-Y;mi\u0012\u0012TCAA!U\u0011\t\u0019$a\u0011,\u0005\u0005\u0015\u0003\u0003BA$\u0003#j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u00145\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\nIEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!dY8naV$X-\u0011<fe\u0006<\u0017N\\3%I\u00164\u0017-\u001e7uIM*\"!!\u0017+\u0007!\f\u0019%\u0001\u0010`G>l\u0007/\u001e;f\u0007>l\u0007o\\:ji&|g.\u00113kkN$X.\u001a8ugRQ\u0011qLA3\u0003\u007f\n\u0019)!#\u0011\u0007M\n\t'C\u0002\u0002dQ\u0012A!\u00168ji\"9\u0011qM\u0013A\u0002\u0005%\u0014\u0001H2p[B,H/\u001a3D_6\u0004xn]5uS>t')\u001f$pe6,H.\u0019\t\t\u0003W\n)(!\u001f\u0002\f5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0004nkR\f'\r\\3\u000b\u0007\u0005MD'\u0001\u0006d_2dWm\u0019;j_:LA!a\u001e\u0002n\t9\u0001*Y:i\u001b\u0006\u0004\bcA:\u0002|%\u0019\u0011Q\u0010?\u0003\rM#(/\u001b8h\u0011\u001d\t\t)\na\u0001\u0003\u0017\tq\u0002\\1ti\u000e{WNY5oCRLwN\u001c\u0005\b\u0003\u000b+\u0003\u0019AAD\u0003\u0015\tGo\\7t!\u0011\u0019\u0014QA(\t\u000f\u0005-U\u00051\u0001\u0002\u000e\u0006\u0019\u0012\r\u001a6D_VtGOU1oO\u0016\u0014\u00150\u0011;p[B)1O_(\u0002\u0010B!\u0011\u0011SAN\u001d\u0011\t\u0019*a&\u000f\u0007U\f)*C\u00016\u0013\r\tI\nN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti*a(\u0003\u000bI\u000bgnZ3\u000b\u0007\u0005eE'\u0001\ndC2\u001c\u0017I^3sC\u001e,\u0017)Q\"pk:$HcA/\u0002&\"9\u0011q\u0015\u0014A\u0002\u0005E\u0011\u0001B7bgN\u0004")
public class AveragineComputer {
    private final AminoAcidTableLike aaTable;
    private final AtomTableLike atomTable;
    private final Atom C_ATOM;
    private final Atom H_ATOM;
    private final Atom O_ATOM;
    private final Atom N_ATOM;
    private final Atom S_ATOM;
    private final int MIN_C_S_RATIO;
    private final int MIN_H_S_RATIO;
    private final Tuple2<Object, Object> H_C_RATIO_RANGE;
    private final Tuple2<Object, Object> N_O_RATIO_RANGE;
    private final Tuple2<Object, Object> C_N_RATIO_RANGE;
    private final Map<Atom, Tuple2<Object, Object>> abundanceRangeByAtom;
    private final Tuple2<AtomComposition, Object>[] compositionAdjustments;
    private final double averageAAMass;
    private final AtomComposition averageAtomComposition;

    public AminoAcidTableLike aaTable() {
        return this.aaTable;
    }

    public AtomTableLike atomTable() {
        return this.atomTable;
    }

    private Atom C_ATOM() {
        return this.C_ATOM;
    }

    private Atom H_ATOM() {
        return this.H_ATOM;
    }

    private Atom O_ATOM() {
        return this.O_ATOM;
    }

    private Atom N_ATOM() {
        return this.N_ATOM;
    }

    private Atom S_ATOM() {
        return this.S_ATOM;
    }

    private int MIN_C_S_RATIO() {
        return this.MIN_C_S_RATIO;
    }

    private int MIN_H_S_RATIO() {
        return this.MIN_H_S_RATIO;
    }

    private Tuple2<Object, Object> H_C_RATIO_RANGE() {
        return this.H_C_RATIO_RANGE;
    }

    private Tuple2<Object, Object> N_O_RATIO_RANGE() {
        return this.N_O_RATIO_RANGE;
    }

    private Tuple2<Object, Object> C_N_RATIO_RANGE() {
        return this.C_N_RATIO_RANGE;
    }

    private Map<Atom, Tuple2<Object, Object>> abundanceRangeByAtom() {
        return this.abundanceRangeByAtom;
    }

    private Tuple2<AtomComposition, Object>[] compositionAdjustments() {
        return this.compositionAdjustments;
    }

    public double averageAAMass() {
        return this.averageAAMass;
    }

    public AtomComposition averageAtomComposition() {
        return this.averageAtomComposition;
    }

    public Tuple2<AtomComposition, Object> computeAveragine(double compoundMass, boolean adjustAbundances, float adjMassTol) {
        Object object;
        AtomComposition avgAtomComp = this.averageAtomComposition().clone();
        avgAtomComp.fitToMonoMass(compoundMass);
        int matchingAdjustmentsCount = 0;
        if (adjustAbundances) {
            avgAtomComp.roundAbundances();
            double deltaMass = avgAtomComp.getMonoMass() - compoundMass;
            if (package$.MODULE$.abs(deltaMass) > (double)adjMassTol) {
                int avgAtomCount = this.calcAverageAACount(compoundMass);
                Map expectedAbRangeByAtom = (Map)this.abundanceRangeByAtom().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Atom atom = (Atom)tuple2._1();
                    Tuple2 abRange = (Tuple2)tuple2._2();
                    Tuple2 newAbRange = abRange.copy((Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)abRange._1()) * (float)avgAtomCount)), (Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)abRange._2()) * (float)avgAtomCount)));
                    Tuple2 tuple22 = new Tuple2((Object)atom, (Object)newAbRange);
                    return tuple22;
                }, Map$.MODULE$.canBuildFrom());
                Tuple2[] matchingAdjustments = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.compositionAdjustments())).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AveragineComputer.$anonfun$computeAveragine$2(this, deltaMass, adjMassTol, avgAtomComp, expectedAbRangeByAtom, x0$2))))).sortBy((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToDouble((double)AveragineComputer.$anonfun$computeAveragine$11(deltaMass, x0$3)), (Ordering)Ordering.Double$.MODULE$);
                matchingAdjustmentsCount = matchingAdjustments.length;
                object = !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matchingAdjustments)).isEmpty() ? avgAtomComp.$plus$eq((AbstractMolecularEntityComposition)matchingAdjustments[0]._1()) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return new Tuple2((Object)avgAtomComp, (Object)BoxesRunTime.boxToInteger((int)matchingAdjustmentsCount));
    }

    public boolean computeAveragine$default$2() {
        return true;
    }

    public float computeAveragine$default$3() {
        return 0.01f;
    }

    private void _computeCompositionAdjustments(HashMap<String, AtomComposition> computedCompositionByFormula, AtomComposition lastCombination, Atom[] atoms, Map<Atom, Range> adjCountRangeByAtom) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])atoms)).isEmpty()) {
            return;
        }
        HashMap<Atom, Object> lastAbundanceMap = lastCombination.abundanceMap();
        Atom curAtom = (Atom)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])atoms)).head();
        Atom[] remainingAtoms = (Atom[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])atoms)).tail();
        Range adjCountRange = (Range)adjCountRangeByAtom.apply((Object)curAtom);
        adjCountRange.foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)atomCount -> {
            BoxedUnit boxedUnit;
            HashMap newAbundanceMap = (HashMap)lastAbundanceMap.clone();
            newAbundanceMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)curAtom), (Object)BoxesRunTime.boxToFloat((float)atomCount)));
            AtomComposition newComposition = new AtomComposition((HashMap<Atom, Object>)newAbundanceMap);
            String formula = newComposition.toFormula();
            if (!computedCompositionByFormula.contains((Object)formula)) {
                AveragineComputer averagineComputer = this;
                synchronized (averagineComputer) {
                    HashMap hashMap = computedCompositionByFormula.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)formula), (Object)newComposition));
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl11 : MonitorExitStatement: MONITOREXIT : var10_10
                    boxedUnit = hashMap;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this._computeCompositionAdjustments(computedCompositionByFormula, newComposition, remainingAtoms, adjCountRangeByAtom);
        });
    }

    public int calcAverageAACount(double mass) {
        return package$.MODULE$.round((float)(mass / this.averageAAMass()));
    }

    public static final /* synthetic */ void $anonfun$compositionAdjustments$1(AveragineComputer $this, AtomComposition atomComposition) {
        block1: {
            block0: {
                int nbH = -1 * (int)(atomComposition.getMonoMass() / $this.H_ATOM().monoMass());
                atomComposition.abundanceMap().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.H_ATOM()), (Object)BoxesRunTime.boxToFloat((float)nbH)));
                if (!(atomComposition.getMonoMass() > 0.5 * $this.H_ATOM().monoMass())) break block0;
                atomComposition.abundanceMap().update((Object)$this.H_ATOM(), (Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)atomComposition.abundanceMap().apply((Object)$this.H_ATOM())) - 1.0f)));
                break block1;
            }
            if (!(atomComposition.getMonoMass() < -0.5 * $this.H_ATOM().monoMass())) break block1;
            atomComposition.abundanceMap().update((Object)$this.H_ATOM(), (Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)atomComposition.abundanceMap().apply((Object)$this.H_ATOM())) + 1.0f)));
        }
    }

    public static final /* synthetic */ boolean $anonfun$computeAveragine$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$computeAveragine$4(BooleanRef hasExpectedAbundances$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean bl = hasExpectedAbundances$1.elem;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$computeAveragine$5(Map expectedAbRangeByAtom$1, BooleanRef hasExpectedAbundances$1, Tuple2 x$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            Tuple2 expectedAbRange;
            Atom atom = (Atom)tuple2._1();
            float ab = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            if (ab < BoxesRunTime.unboxToFloat((Object)(expectedAbRange = (Tuple2)expectedAbRangeByAtom$1.apply((Object)atom))._1()) || ab > BoxesRunTime.unboxToFloat((Object)expectedAbRange._2())) {
                hasExpectedAbundances$1.elem = false;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$computeAveragine$2(AveragineComputer $this, double deltaMass$1, float adjMassTol$1, AtomComposition avgAtomComp$1, Map expectedAbRangeByAtom$1, Tuple2 x0$2) {
        boolean bl;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            AtomComposition adj = (AtomComposition)tuple2._1();
            double monoMass = tuple2._2$mcD$sp();
            if (package$.MODULE$.abs(deltaMass$1 + monoMass) > (double)adjMassTol$1) {
                bl = false;
            } else {
                AbstractMolecularEntityComposition<Atom> tmpComp = avgAtomComp$1.clone().$plus$eq(adj);
                HashMap<Atom, Object> tmpAbundanceMap = tmpComp.abundanceMap();
                BooleanRef hasExpectedAbundances = BooleanRef.create((boolean)true);
                tmpAbundanceMap.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AveragineComputer.$anonfun$computeAveragine$3(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AveragineComputer.$anonfun$computeAveragine$4(hasExpectedAbundances, x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    AveragineComputer.$anonfun$computeAveragine$5(expectedAbRangeByAtom$1, hasExpectedAbundances, x$2);
                    return BoxedUnit.UNIT;
                });
                if (hasExpectedAbundances.elem) {
                    float sulfurAb;
                    float carbonAb = BoxesRunTime.unboxToFloat((Object)tmpAbundanceMap.getOrElse((Object)$this.C_ATOM(), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f));
                    float hydrogenAb = BoxesRunTime.unboxToFloat((Object)tmpAbundanceMap.getOrElse((Object)$this.H_ATOM(), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f));
                    float oxygenAb = BoxesRunTime.unboxToFloat((Object)tmpAbundanceMap.getOrElse((Object)$this.O_ATOM(), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f));
                    float nitrogenAb = BoxesRunTime.unboxToFloat((Object)tmpAbundanceMap.getOrElse((Object)$this.O_ATOM(), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f));
                    float hcRatio = hydrogenAb / carbonAb;
                    float noRatio = hydrogenAb / carbonAb;
                    float cnRatio = hydrogenAb / carbonAb;
                    if (hcRatio < BoxesRunTime.unboxToFloat((Object)$this.H_C_RATIO_RANGE()._1()) || hcRatio > (float)$this.H_C_RATIO_RANGE()._2$mcI$sp()) {
                        hasExpectedAbundances.elem = false;
                    } else if (noRatio < BoxesRunTime.unboxToFloat((Object)$this.N_O_RATIO_RANGE()._1()) || noRatio > (float)$this.N_O_RATIO_RANGE()._2$mcI$sp()) {
                        hasExpectedAbundances.elem = false;
                    } else if (cnRatio < BoxesRunTime.unboxToFloat((Object)$this.C_N_RATIO_RANGE()._1()) || cnRatio > (float)$this.C_N_RATIO_RANGE()._2$mcI$sp()) {
                        hasExpectedAbundances.elem = false;
                    }
                    if (hasExpectedAbundances.elem && (sulfurAb = BoxesRunTime.unboxToFloat((Object)tmpAbundanceMap.getOrElse((Object)$this.S_ATOM(), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f))) > 0.0f) {
                        float minHydrogenAb;
                        float minCarbonAb = (float)$this.MIN_C_S_RATIO() * sulfurAb;
                        if (carbonAb < minCarbonAb) {
                            hasExpectedAbundances.elem = false;
                        }
                        if (hydrogenAb < (minHydrogenAb = (float)$this.MIN_H_S_RATIO() * sulfurAb)) {
                            hasExpectedAbundances.elem = false;
                        }
                    }
                }
                bl = hasExpectedAbundances.elem;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ double $anonfun$computeAveragine$11(double deltaMass$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double monoMass = tuple2._2$mcD$sp();
        double d = package$.MODULE$.abs(deltaMass$1 + monoMass);
        return d;
    }

    public AveragineComputer(AminoAcidTableLike aaTable, AtomTableLike atomTable) {
        this.aaTable = aaTable;
        this.atomTable = atomTable;
        this.C_ATOM = atomTable.getAtom("C");
        this.H_ATOM = atomTable.getAtom("H");
        this.O_ATOM = atomTable.getAtom("O");
        this.N_ATOM = atomTable.getAtom("N");
        this.S_ATOM = atomTable.getAtom("S");
        this.MIN_C_S_RATIO = 5;
        this.MIN_H_S_RATIO = 8;
        this.H_C_RATIO_RANGE = new Tuple2((Object)BoxesRunTime.boxToFloat((float)0.90909094f), (Object)BoxesRunTime.boxToInteger((int)2));
        this.N_O_RATIO_RANGE = new Tuple2((Object)BoxesRunTime.boxToFloat((float)0.33333334f), (Object)BoxesRunTime.boxToInteger((int)4));
        this.C_N_RATIO_RANGE = new Tuple2((Object)BoxesRunTime.boxToFloat((float)1.5f), (Object)BoxesRunTime.boxToInteger((int)9));
        this.abundanceRangeByAtom = aaTable.getAbundanceRangeByAtom(atomTable);
        HashMap computedCompositionByFormula = new HashMap();
        this._computeCompositionAdjustments((HashMap<String, AtomComposition>)computedCompositionByFormula, new AtomComposition((HashMap<Atom, Object>)new HashMap()), (Atom[])((Object[])new Atom[]{this.C_ATOM(), this.O_ATOM(), this.N_ATOM(), this.S_ATOM()}), (Map<Atom, Range>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.C_ATOM()), (Object)scala.package$.MODULE$.Range().inclusive(-30, 30)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.O_ATOM()), (Object)scala.package$.MODULE$.Range().inclusive(-6, 6)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.N_ATOM()), (Object)scala.package$.MODULE$.Range().inclusive(-10, 10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.S_ATOM()), (Object)scala.package$.MODULE$.Range().inclusive(0, 2))}))));
        computedCompositionByFormula.values().foreach((Function1 & Serializable & scala.Serializable)atomComposition -> {
            AveragineComputer.$anonfun$compositionAdjustments$1(this, atomComposition);
            return BoxedUnit.UNIT;
        });
        this.compositionAdjustments = (Tuple2[])((TraversableOnce)computedCompositionByFormula.values().map((Function1 & Serializable & scala.Serializable)c -> new Tuple2(c, (Object)BoxesRunTime.boxToDouble((double)c.getMonoMass())), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        this.averageAAMass = aaTable.averageAAMass();
        this.averageAtomComposition = aaTable.getAverageAtomComposition(atomTable);
    }
}

