/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.chemistry.algo;

import fr.profi.chemistry.algo.IsoelectricPointComputer$;
import fr.profi.chemistry.algo.IsoelectricPointComputer$NumericOps$;
import fr.profi.chemistry.algo.PkSymbol$;
import fr.profi.chemistry.algo.PkType$;
import fr.profi.chemistry.model.AminoAcidComposition;
import fr.profi.chemistry.model.AminoAcidResidue;
import fr.profi.chemistry.model.AminoAcidTableLike;
import java.io.Serializable;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.FloatRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t-q!B\u00181\u0011\u0003Id!B\u001e1\u0011\u0003a\u0004\"B\"\u0002\t\u0003!\u0005bB#\u0002\u0005\u0004%IA\u0012\u0005\u0007\u0015\u0006\u0001\u000b\u0011B$\t\u000f-\u000b!\u0019!C\u0005\r\"1A*\u0001Q\u0001\n\u001dCq!T\u0001C\u0002\u0013%a\n\u0003\u0004S\u0003\u0001\u0006Ia\u0014\u0005\b'\u0006\u0011\r\u0011\"\u0003O\u0011\u0019!\u0016\u0001)A\u0005\u001f\"9Q+\u0001b\u0001\n\u00131\u0006BB6\u0002A\u0003%q\u000bC\u0004m\u0003\t\u0007I\u0011B7\t\rE\f\u0001\u0015!\u0003o\u0011\u001d\u0011\u0018A1A\u0005\n5Daa]\u0001!\u0002\u0013qg\u0001\u0002;\u0002\u0007UD\u0001\"_\t\u0003\u0006\u0004%\tA\u0014\u0005\tuF\u0011\t\u0011)A\u0005\u001f\")1)\u0005C\u0001w\"1q0\u0005C\u0001\u0003\u0003Aaa`\t\u0005\u0002\u0005\u001d\u0001\"CA\u0006#\u0005\u0005I\u0011IA\u0007\u0011%\t)\"EA\u0001\n\u0003\n9\u0002C\u0005\u0002*\u0005\t\t\u0011b\u0001\u0002,!I\u0011qF\u0001\u0012\u0002\u0013\u0005\u0011\u0011G\u0004\n\u0003S\t\u0011\u0011!E\u0001\u000372\u0001\u0002^\u0001\u0002\u0002#\u0005\u0011Q\f\u0005\u0007\u0007r!\t!a\u0018\t\u000f\u0005\u0005D\u0004\"\u0002\u0002d!9\u0011Q\u000e\u000f\u0005\u0006\u0005=\u0004\"CA<9\u0005\u0005IQAA=\u0011%\ti\bHA\u0001\n\u000b\tyHB\u0003<a\u0001\t9\t\u0003\u0006\u0002\n\n\u0012\t\u0011)A\u0005\u0003\u0017C!\"a&#\u0005\u0003\u0005\u000b\u0011BA\u001b\u0011\u0019\u0019%\u0005\"\u0001\u0002\u001a\"9\u0011\u0011\u0015\u0012\u0005\u0002\u0005\r\u0006bBAXE\u0011%\u0011\u0011\u0017\u0005\n\u0003\u001f\u0014\u0013\u0013!C\u0005\u0003#Dq!!6#\t\u0013\t9\u000eC\u0005\u0002j\n\n\n\u0011\"\u0003\u0002l\"I\u0011q\u001e\u0012\u0012\u0002\u0013%\u00111\u001e\u0005\n\u0003c\u0014\u0013\u0013!C\u0005\u0003gDq!a>#\t\u0013\tI\u0010C\u0004\u0002\u0000\n\"IA!\u0001\u00021%\u001bx.\u001a7fGR\u0014\u0018n\u0019)pS:$8i\\7qkR,'O\u0003\u00022e\u0005!\u0011\r\\4p\u0015\t\u0019D'A\u0005dQ\u0016l\u0017n\u001d;ss*\u0011QGN\u0001\u0006aJ|g-\u001b\u0006\u0002o\u0005\u0011aM]\u0002\u0001!\tQ\u0014!D\u00011\u0005aI5o\\3mK\u000e$(/[2Q_&tGoQ8naV$XM]\n\u0003\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001:\u0003A\u0019\u0005*\u0011*H\u000b~\u0003&+R\"J'&{e*F\u0001H!\tq\u0004*\u0003\u0002J\u007f\t1Ai\\;cY\u0016\f\u0011c\u0011%B%\u001e+u\f\u0015*F\u0007&\u001b\u0016j\u0014(!\u00031\u0001\u0006j\u0018)S\u000b\u000eK5+S(O\u00035\u0001\u0006j\u0018)S\u000b\u000eK5+S(OA\u0005!\u0001kS0B+\u0005y\u0005C\u0001 Q\u0013\t\tvHA\u0003GY>\fG/A\u0003Q\u0017~\u000b\u0005%\u0001\u0003Q\u0017~\u0013\u0015!\u0002)L?\n\u0003\u0013A\u00069beRL\u0017\r\\!dS\u0012\u0014\u0015m]3NCB\u0004\u0018N\\4\u0016\u0003]\u0003B\u0001W/`O6\t\u0011L\u0003\u0002[7\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u00039~\n!bY8mY\u0016\u001cG/[8o\u0013\tq\u0016LA\u0002NCB\u0004\"\u0001Y2\u000f\u0005i\n\u0017B\u000121\u0003!\u00016nU=nE>d\u0017B\u00013f\u0005\u00151\u0016\r\\;f\u0013\t1wHA\u0006F]VlWM]1uS>t\u0007C\u00015d\u001d\tQ\u0014.\u0003\u0002ka\u00051\u0001k\u001b+za\u0016\fq\u0003]1si&\fG.Q2jI\n\u000b7/Z'baBLgn\u001a\u0011\u0002\u0017\u0019,H\u000e\\!dS\u0012\u001cV\r^\u000b\u0002]B\u0019\u0001l\\0\n\u0005AL&aA*fi\u0006aa-\u001e7m\u0003\u000eLGmU3uA\u0005Ya-\u001e7m\u0005\u0006\u001cXmU3u\u000311W\u000f\u001c7CCN,7+\u001a;!\u0005)qU/\\3sS\u000e|\u0005o]\n\u0003#Y\u0004\"AP<\n\u0005a|$AB!osZ\u000bG.A\u0003wC2,X-\u0001\u0004wC2,X\r\t\u000b\u0003yz\u0004\"!`\t\u000e\u0003\u0005AQ!\u001f\u000bA\u0002=\u000bA\u0002\n;j[\u0016\u001cH\u0005^5nKN$2aTA\u0002\u0011\u0019\t)!\u0006a\u0001\u001f\u0006)\u0001o\\<feR\u0019q)!\u0003\t\r\u0005\u0015a\u00031\u0001H\u0003!A\u0017m\u001d5D_\u0012,GCAA\b!\rq\u0014\u0011C\u0005\u0004\u0003'y$aA%oi\u00061Q-];bYN$B!!\u0007\u0002 A\u0019a(a\u0007\n\u0007\u0005uqHA\u0004C_>dW-\u00198\t\u0013\u0005\u0005\u0002$!AA\u0002\u0005\r\u0012a\u0001=%cA\u0019a(!\n\n\u0007\u0005\u001drHA\u0002B]f\f!BT;nKJL7m\u00149t)\ra\u0018Q\u0006\u0005\u0006sf\u0001\raT\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005M\"\u0006BA\u001b\u0003\u0013\u0002b!a\u000e\u0002F}{e\u0002BA\u001d\u0003\u0003\u00022!a\u000f@\u001b\t\tiDC\u0002\u0002@a\na\u0001\u0010:p_Rt\u0014bAA\"\u007f\u00051\u0001K]3eK\u001aL1AXA$\u0015\r\t\u0019eP\u0016\u0003\u0003\u0017\u0002B!!\u0014\u0002X5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&A\u0005v]\u000eDWmY6fI*\u0019\u0011QK \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002Z\u0005=#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dKB\u0011Q\u0010H\n\u00039u\"\"!a\u0017\u0002/\u0011\"\u0018.\\3tIQLW.Z:%Kb$XM\\:j_:\u0004D\u0003BA3\u0003S\"2aTA4\u0011\u0019\t)A\ba\u0001\u001f\"1\u00111\u000e\u0010A\u0002q\fQ\u0001\n;iSN\fq\u0003\n;j[\u0016\u001cH\u0005^5nKN$S\r\u001f;f]NLwN\\\u0019\u0015\t\u0005E\u0014Q\u000f\u000b\u0004\u000f\u0006M\u0004BBA\u0003?\u0001\u0007q\t\u0003\u0004\u0002l}\u0001\r\u0001`\u0001\u0013Q\u0006\u001c\bnQ8eK\u0012*\u0007\u0010^3og&|g\u000e\u0006\u0003\u0002\u000e\u0005m\u0004BBA6A\u0001\u0007A0\u0001\tfcV\fGn\u001d\u0013fqR,gn]5p]R!\u0011\u0011QAC)\u0011\tI\"a!\t\u0013\u0005\u0005\u0012%!AA\u0002\u0005\r\u0002BBA6C\u0001\u0007Ap\u0005\u0002#{\u00059\u0011-\u0019+bE2,\u0007\u0003BAG\u0003'k!!a$\u000b\u0007\u0005E%'A\u0003n_\u0012,G.\u0003\u0003\u0002\u0016\u0006=%AE!nS:|\u0017iY5e)\u0006\u0014G.\u001a'jW\u0016\fq\u0001]6UC\ndW\r\u0006\u0004\u0002\u001c\u0006u\u0015q\u0014\t\u0003u\tBq!!#&\u0001\u0004\tY\tC\u0005\u0002\u0018\u0016\u0002\n\u00111\u0001\u00026\u0005I1m\\7qkR,\u0007+\u0013\u000b\u0004\u001f\u0006\u0015\u0006bBATM\u0001\u0007\u0011\u0011V\u0001\u000bC\u0006\u001cV-];f]\u000e,\u0007\u0003BA\u001c\u0003WKA!!,\u0002H\t11\u000b\u001e:j]\u001e\fqcX2p[B,H/Z!qaJ|\u00070[7bi&4X\rU%\u0015\r\u0005M\u0016\u0011XAe!\u0011q\u0014QW(\n\u0007\u0005]vH\u0001\u0004PaRLwN\u001c\u0005\b\u0003w;\u0003\u0019AA_\u00031\t'-\u001e8eC:\u001cW-T1q!\u001d\ty,!2\u0002*>k!!!1\u000b\u0007\u0005\r7,A\u0004nkR\f'\r\\3\n\t\u0005\u001d\u0017\u0011\u0019\u0002\b\u0011\u0006\u001c\b.T1q\u0011%\tYm\nI\u0001\u0002\u0004\ti-\u0001\tnS:\f5-\u001b3CCN,7i\\;oiB)a(!.\u0002\u0010\u0005\tslY8naV$X-\u00119qe>D\u0018.\\1uSZ,\u0007+\u0013\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001b\u0016\u0005\u0003\u001b\fI%A\u000b`G>l\u0007/\u001e;f)\",wN]3uS\u000e\fG\u000eU%\u0015\u0013=\u000bI.!8\u0002b\u0006\u0015\bbBAnS\u0001\u0007\u0011QX\u0001\u000fC\u0006\f%-\u001e8eC:\u001cW-T1q\u0011!\ty.\u000bI\u0001\u0002\u0004y\u0015A\u00019I\u0011!\t\u0019/\u000bI\u0001\u0002\u0004y\u0015A\u00033fYR\f\u0007+\u0019:b[\"I\u0011q]\u0015\u0011\u0002\u0003\u0007\u0011qB\u0001\u000e[\u0006D\u0018\n^3sCRLwN\\:\u0002?}\u001bw.\u001c9vi\u0016$\u0006.Z8sKRL7-\u00197Q\u0013\u0012\"WMZ1vYR$#'\u0006\u0002\u0002n*\u001aq*!\u0013\u0002?}\u001bw.\u001c9vi\u0016$\u0006.Z8sKRL7-\u00197Q\u0013\u0012\"WMZ1vYR$3'A\u0010`G>l\u0007/\u001e;f)\",wN]3uS\u000e\fG\u000eU%%I\u00164\u0017-\u001e7uIQ*\"!!>+\t\u0005=\u0011\u0011J\u0001\u0016?\u000e|W\u000e];uKB\u0013x\u000e^3j]\u000eC\u0017M]4f)\u00159\u00151`A\u007f\u0011\u001d\tY.\fa\u0001\u0003{Ca!a8.\u0001\u00049\u0015!F0d_6\u0004X\u000f^3QCJ$\u0018.\u00197DQ\u0006\u0014x-\u001a\u000b\u0006\u000f\n\r!q\u0001\u0005\u0007\u0005\u000bq\u0003\u0019A$\u0002\tY\fG.\r\u0005\u0007\u0005\u0013q\u0003\u0019A$\u0002\tY\fGN\r")
public class IsoelectricPointComputer {
    private final AminoAcidTableLike aaTable;
    private final Map<Enumeration.Value, Object> pkTable;

    public static Map<Enumeration.Value, Object> $lessinit$greater$default$2() {
        return IsoelectricPointComputer$.MODULE$.$lessinit$greater$default$2();
    }

    public static float NumericOps(float f) {
        return IsoelectricPointComputer$.MODULE$.NumericOps(f);
    }

    public float computePI(String aaSequence) {
        HashMap abundanceMap = (HashMap)new AminoAcidComposition(aaSequence, this.aaTable).abundanceMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            AminoAcidResidue aa = (AminoAcidResidue)tuple2._1();
            float aaCount = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)aa.symbol()), (Object)BoxesRunTime.boxToFloat((float)aaCount));
            return tuple22;
        }, HashMap$.MODULE$.canBuildFrom());
        abundanceMap.update((Object)PkSymbol$.MODULE$.enumToString(PkSymbol$.MODULE$.N_TERM()), (Object)BoxesRunTime.boxToFloat((float)1.0f));
        abundanceMap.update((Object)PkSymbol$.MODULE$.enumToString(PkSymbol$.MODULE$.C_TERM()), (Object)BoxesRunTime.boxToFloat((float)1.0f));
        Option<Object> approxPIOpt = this._computeApproximativePI((HashMap<String, Object>)abundanceMap, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
        float approxPI = approxPIOpt.isDefined() ? BoxesRunTime.unboxToFloat((Object)approxPIOpt.get()) : 7.0f;
        float delta = approxPIOpt.isDefined() ? 1.0f : 4.0f;
        return this._computeTheoreticalPI((HashMap<String, Object>)abundanceMap, approxPI, delta, this._computeTheoreticalPI$default$4());
    }

    private Option<Object> _computeApproximativePI(HashMap<String, Object> abundanceMap, Option<Object> minAcidBaseCount) {
        HashMap acidBaseCounts = (HashMap)HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PkType$.MODULE$.ACID()), (Object)BoxesRunTime.boxToFloat((float)1.0f)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)PkType$.MODULE$.BASE()), (Object)BoxesRunTime.boxToFloat((float)1.0f))}));
        FloatRef acidBaseCount = FloatRef.create((float)0.0f);
        IsoelectricPointComputer$.MODULE$.fr$profi$chemistry$algo$IsoelectricPointComputer$$partialAcidBaseMapping().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)IsoelectricPointComputer.$anonfun$_computeApproximativePI$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            IsoelectricPointComputer.$anonfun$_computeApproximativePI$2(abundanceMap, acidBaseCounts, acidBaseCount, x$1);
            return BoxedUnit.UNIT;
        });
        if (minAcidBaseCount.isDefined() && acidBaseCount.elem < (float)BoxesRunTime.unboxToInt((Object)minAcidBaseCount.get())) {
            return None$.MODULE$;
        }
        float R = BoxesRunTime.unboxToFloat((Object)acidBaseCounts.apply((Object)PkType$.MODULE$.ACID())) / BoxesRunTime.unboxToFloat((Object)acidBaseCounts.apply((Object)PkType$.MODULE$.BASE()));
        double pI = (double)IsoelectricPointComputer$.MODULE$.fr$profi$chemistry$algo$IsoelectricPointComputer$$PK_B() + package$.MODULE$.log10(0.5 * ((double)((1.0f - R) / R) + package$.MODULE$.sqrt((double)(IsoelectricPointComputer$NumericOps$.MODULE$.$times$times$extension0(IsoelectricPointComputer$.MODULE$.NumericOps((1.0f - R) / R), 2.0f) + IsoelectricPointComputer$NumericOps$.MODULE$.$times$times$extension0(IsoelectricPointComputer$.MODULE$.NumericOps((float)4 / R * (float)10), IsoelectricPointComputer$.MODULE$.fr$profi$chemistry$algo$IsoelectricPointComputer$$PK_A() - IsoelectricPointComputer$.MODULE$.fr$profi$chemistry$algo$IsoelectricPointComputer$$PK_B())))));
        return new Some((Object)BoxesRunTime.boxToFloat((float)((float)pI)));
    }

    private Option<Object> _computeApproximativePI$default$2() {
        return None$.MODULE$;
    }

    private float _computeTheoreticalPI(HashMap<String, Object> aaAbundanceMap, float pH, float deltaParam, int maxIterations) {
        double pI = pH;
        float delta = deltaParam;
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(0.0, 0.0);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        double previousPI = sp2._1$mcD$sp();
        double previousCharge = sp2._2$mcD$sp();
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(previousPI, previousCharge);
        Tuple2.mcDD.sp sp4 = sp3;
        double previousPI2 = sp4._1$mcD$sp();
        double previousCharge2 = sp4._2$mcD$sp();
        for (int iterCount = 0; iterCount <= maxIterations; ++iterCount) {
            double charge = this._computeProteinCharge(aaAbundanceMap, pI);
            if (package$.MODULE$.abs(charge) <= IsoelectricPointComputer$.MODULE$.fr$profi$chemistry$algo$IsoelectricPointComputer$$CHARGE_PRECISION()) {
                return (float)pI;
            }
            if (previousCharge2 != 0.0 && previousPI2 != 0.0 && charge != previousCharge2) {
                Tuple2 equationParams = fr.profi.util.math.package$.MODULE$.calcLineParams(previousCharge2, previousPI2, charge, pI);
                previousPI2 = pI;
                pI = equationParams._2$mcD$sp();
            } else {
                previousPI2 = pI;
                pI = charge > 0.0 ? (pI += (double)delta) : (pI -= (double)delta);
                delta /= (float)2;
            }
            previousCharge2 = charge;
        }
        return (float)pI;
    }

    private float _computeTheoreticalPI$default$2() {
        return 7.0f;
    }

    private float _computeTheoreticalPI$default$3() {
        return 4.0f;
    }

    private int _computeTheoreticalPI$default$4() {
        return 100;
    }

    private double _computeProteinCharge(HashMap<String, Object> aaAbundanceMap, double pH) {
        DoubleRef charge = DoubleRef.create((double)0.0);
        this.pkTable.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)IsoelectricPointComputer.$anonfun$_computeProteinCharge$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            IsoelectricPointComputer.$anonfun$_computeProteinCharge$2(this, aaAbundanceMap, charge, pH, x$3);
            return BoxedUnit.UNIT;
        });
        return charge.elem;
    }

    private double _computePartialCharge(double val1, double val2) {
        double cRatio = IsoelectricPointComputer$NumericOps$.MODULE$.$times$times$extension1(IsoelectricPointComputer$.MODULE$.NumericOps(10.0f), val1 - val2);
        return cRatio / (cRatio + 1.0);
    }

    public static final /* synthetic */ boolean $anonfun$_computeApproximativePI$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$_computeApproximativePI$2(HashMap abundanceMap$1, HashMap acidBaseCounts$1, FloatRef acidBaseCount$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Enumeration.Value aa = (Enumeration.Value)tuple2._1();
        Enumeration.Value pkType = (Enumeration.Value)tuple2._2();
        abundanceMap$1.get((Object)PkSymbol$.MODULE$.enumToString(aa)).foreach((Function1)(JFunction1.mcVF.sp & Serializable & scala.Serializable)aaCount -> {
            acidBaseCounts$1.update((Object)pkType, (Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)acidBaseCounts$1.apply((Object)pkType)) + aaCount)));
            acidBaseCount$1.elem += aaCount;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$_computeProteinCharge$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$_computeProteinCharge$2(IsoelectricPointComputer $this, HashMap aaAbundanceMap$1, DoubleRef charge$1, double pH$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Enumeration.Value pkSymbol = (Enumeration.Value)tuple2._1();
        float pK = BoxesRunTime.unboxToFloat((Object)tuple2._2());
        aaAbundanceMap$1.get((Object)PkSymbol$.MODULE$.enumToString(pkSymbol)).foreach((Function1)(JFunction1.mcVF.sp & Serializable & scala.Serializable)aaCount -> {
            block1: {
                if (IsoelectricPointComputer$.MODULE$.fr$profi$chemistry$algo$IsoelectricPointComputer$$fullAcidSet().contains((Object)pkSymbol)) {
                    charge$1.elem -= (double)aaCount * $this._computePartialCharge(pH$1, pK);
                }
                if (!IsoelectricPointComputer$.MODULE$.fr$profi$chemistry$algo$IsoelectricPointComputer$$fullBaseSet().contains((Object)pkSymbol)) break block1;
                charge$1.elem += (double)aaCount * $this._computePartialCharge(pK, pH$1);
            }
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public IsoelectricPointComputer(AminoAcidTableLike aaTable, Map<Enumeration.Value, Object> pkTable) {
        this.aaTable = aaTable;
        this.pkTable = pkTable;
    }

    public static final class NumericOps {
        private final float value;

        public float value() {
            return this.value;
        }

        public float $times$times(float power) {
            return IsoelectricPointComputer$NumericOps$.MODULE$.$times$times$extension0(this.value(), power);
        }

        public double $times$times(double power) {
            return IsoelectricPointComputer$NumericOps$.MODULE$.$times$times$extension1(this.value(), power);
        }

        public int hashCode() {
            return IsoelectricPointComputer$NumericOps$.MODULE$.hashCode$extension(this.value());
        }

        public boolean equals(Object x$1) {
            return IsoelectricPointComputer$NumericOps$.MODULE$.equals$extension(this.value(), x$1);
        }

        public NumericOps(float value) {
            this.value = value;
        }
    }
}

