/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.ms.algo;

import fr.profi.chemistry.model.AbundanceMapOps$;
import fr.profi.chemistry.model.Atom;
import fr.profi.chemistry.model.AtomComposition;
import fr.profi.chemistry.model.AtomIsotopeComposition;
import fr.profi.chemistry.model.AtomIsotopicVariant;
import fr.profi.ms.model.IsotopeCombination;
import fr.profi.ms.model.IsotopeDistribution;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class IsotopeDistributionComputer$ {
    public static IsotopeDistributionComputer$ MODULE$;

    static {
        new IsotopeDistributionComputer$();
    }

    public final int TARGETED_ATOM_COUNT_INCREMENT() {
        return 1024;
    }

    public IsotopeDistribution computeIsotopeDistribution(AtomComposition compoundAtomComposition, int charge, Map<Tuple2<Atom, Object>, IsotopeCombination[]> isotopeCombinationMap, float minProba) {
        HashMap<Atom, Object> compoundAtomCountByAtom = compoundAtomComposition.abundanceMap();
        Atom[] atoms = (Atom[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])compoundAtomCountByAtom.keys().toArray(ClassTag$.MODULE$.apply(Atom.class)))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.symbol(), (Ordering)Ordering.String$.MODULE$);
        IsotopeCombination emptyCombination = new IsotopeCombination((Map<AtomIsotopicVariant, Object>)Predef$.MODULE$.Map().empty(), 1.0);
        ArrayBuffer computedCombinations = new ArrayBuffer();
        this._combineIsotopeCombinations((ArrayBuffer<IsotopeCombination>)computedCombinations, emptyCombination, compoundAtomCountByAtom, isotopeCombinationMap, atoms, minProba);
        Predef$.MODULE$.require(!computedCombinations.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "can't find an appropriate isotope combination");
        return new IsotopeDistribution((IsotopeCombination[])computedCombinations.toArray(ClassTag$.MODULE$.apply(IsotopeCombination.class)), charge);
    }

    public float computeIsotopeDistribution$default$4() {
        return 0.0f;
    }

    private void _combineIsotopeCombinations(ArrayBuffer<IsotopeCombination> computedCombinations, IsotopeCombination lastCombination, HashMap<Atom, Object> compoundAtomCountByAtom, Map<Tuple2<Atom, Object>, IsotopeCombination[]> isotopeCombinationMap, Atom[] atoms, float minProba) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])atoms)).isEmpty()) {
            IsotopeDistributionComputer$ isotopeDistributionComputer$ = this;
            synchronized (isotopeDistributionComputer$) {
                computedCombinations.$plus$eq((Object)lastCombination);
            }
            return;
        }
        Atom curAtom = (Atom)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])atoms)).head();
        float curAtomCount = BoxesRunTime.unboxToFloat((Object)compoundAtomCountByAtom.apply((Object)curAtom));
        Atom[] remainingAtoms = (Atom[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])atoms)).tail();
        Option matchingIsotopeCombinationsOpt = isotopeCombinationMap.get((Object)new Tuple2((Object)curAtom, (Object)BoxesRunTime.boxToFloat((float)curAtomCount)));
        Predef$.MODULE$.require(matchingIsotopeCombinationsOpt.isDefined(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("provided computedCombinations has no entry for atom ").append(curAtom.symbol()).append(" with abundance ").append(curAtomCount).toString());
        IsotopeCombination[] matchingIsotopeCombinations = (IsotopeCombination[])matchingIsotopeCombinationsOpt.get();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matchingIsotopeCombinations)).isEmpty()) {
            throw new Exception(new StringBuilder(39).append("can't find a combination for #").append(curAtomCount).append(" atom of ").append(curAtom).toString());
        }
        double lastProb = lastCombination.probability();
        IsotopeCombination[] filteredIsotopesCombinations = (IsotopeCombination[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matchingIsotopeCombinations)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)IsotopeDistributionComputer$.$anonfun$_combineIsotopeCombinations$2(lastProb, minProba, x$2)));
        IsotopeCombination[] finalIsotopesCombinations = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredIsotopesCombinations)).isEmpty() ? (IsotopeCombination[])((Object[])new IsotopeCombination[]{(IsotopeCombination)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matchingIsotopeCombinations)).maxBy((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)x$3.probability()), (Ordering)Ordering.Double$.MODULE$)}) : matchingIsotopeCombinations;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])finalIsotopesCombinations)).foreach((Function1 & Serializable & scala.Serializable)isotopeCombination -> {
            IsotopeDistributionComputer$.$anonfun$_combineIsotopeCombinations$4(lastCombination, computedCombinations, compoundAtomCountByAtom, isotopeCombinationMap, remainingAtoms, minProba, isotopeCombination);
            return BoxedUnit.UNIT;
        });
    }

    private float _combineIsotopeCombinations$default$6() {
        return 0.0f;
    }

    public Map<Tuple2<Atom, Object>, IsotopeCombination[]> computeIsotopicVariantCombinations(Map<Atom, Object> maxAtomCountByAtom, float minProba) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        maxAtomCountByAtom.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)IsotopeDistributionComputer$.$anonfun$computeIsotopicVariantCombinations$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            IsotopeDistributionComputer$.$anonfun$computeIsotopicVariantCombinations$2(minProba, mapBuilder, x$6);
            return BoxedUnit.UNIT;
        });
        return (Map)mapBuilder.result();
    }

    public float computeIsotopicVariantCombinations$default$2() {
        return 0.0f;
    }

    public IsotopeCombination[] computeAtomIsotopicVariantCombinations(Atom atom, int maxAtomCount, float minProba) {
        Predef$.MODULE$.require(maxAtomCount >= 1, (Function0 & Serializable & scala.Serializable)() -> "maxAtomCount must be >= 1");
        Predef$.MODULE$.require(minProba >= 0.0f && minProba <= 1.0f, (Function0 & Serializable & scala.Serializable)() -> "minProba must be a number between 0 and 1");
        AtomIsotopicVariant[] atomIsotopes = atom.isotopicVariants();
        HashMap computedCombinationByFormula = new HashMap();
        computedCombinationByFormula.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)new IsotopeCombination((Map<AtomIsotopicVariant, Object>)Predef$.MODULE$.Map().empty(), 1.0)));
        this._computeIsotopicVariantCombinations((HashMap<String, IsotopeCombination>)computedCombinationByFormula, atomIsotopes, 0, maxAtomCount, minProba);
        return (IsotopeCombination[])computedCombinationByFormula.values().toArray(ClassTag$.MODULE$.apply(IsotopeCombination.class));
    }

    public float computeAtomIsotopicVariantCombinations$default$3() {
        return 0.0f;
    }

    private void _computeIsotopicVariantCombinations(HashMap<String, IsotopeCombination> computedCombinationByFormula, AtomIsotopicVariant[] atomIsotopes, int lastTargetedAtomCount, int maxAtomCount, float minProba) {
        while (lastTargetedAtomCount != maxAtomCount) {
            int curTargetedAtomCount = package$.MODULE$.min(lastTargetedAtomCount + 1024, maxAtomCount);
            computedCombinationByFormula.par().foreach((Function1 & Serializable & scala.Serializable)computedCombination -> {
                IsotopeDistributionComputer$.$anonfun$_computeIsotopicVariantCombinations$1(lastTargetedAtomCount, computedCombinationByFormula, atomIsotopes, curTargetedAtomCount, minProba, computedCombination);
                return BoxedUnit.UNIT;
            });
            lastTargetedAtomCount = curTargetedAtomCount;
        }
        return;
    }

    private void _createNewIsotopeCombinations(HashMap<String, IsotopeCombination> computedCombinationByFormula, Seq<IsotopeCombination> lastCombinations, AtomIsotopicVariant[] atomIsotopes, int targetedAtomCount, float minProba) {
        while (!lastCombinations.isEmpty()) {
            ArrayBuffer newCombinationsBuffers = new ArrayBuffer(atomIsotopes.length);
            lastCombinations.foreach((Function1 & Serializable & scala.Serializable)lastCombination -> {
                IsotopeDistributionComputer$.$anonfun$_createNewIsotopeCombinations$1(targetedAtomCount, atomIsotopes, computedCombinationByFormula, minProba, newCombinationsBuffers, lastCombination);
                return BoxedUnit.UNIT;
            });
            lastCombinations = newCombinationsBuffers;
        }
        return;
    }

    public static final /* synthetic */ boolean $anonfun$_combineIsotopeCombinations$2(double lastProb$1, float minProba$1, IsotopeCombination x$2) {
        return x$2.probability() * lastProb$1 >= (double)minProba$1;
    }

    public static final /* synthetic */ void $anonfun$_combineIsotopeCombinations$4(IsotopeCombination lastCombination$1, ArrayBuffer computedCombinations$1, HashMap compoundAtomCountByAtom$1, Map isotopeCombinationMap$1, Atom[] remainingAtoms$1, float minProba$1, IsotopeCombination isotopeCombination) {
        double newProbability = lastCombination$1.probability() * isotopeCombination.probability();
        HashMap<AtomIsotopicVariant, Object> newAbundanceMap = lastCombination$1.getCloneOfMutableAbundanceMap();
        AbundanceMapOps$.MODULE$.addAbundanceMap(newAbundanceMap, isotopeCombination.abundanceMap());
        IsotopeCombination newCombination = new IsotopeCombination((Map<AtomIsotopicVariant, Object>)newAbundanceMap.toMap(Predef$.MODULE$.$conforms()), newProbability);
        MODULE$._combineIsotopeCombinations((ArrayBuffer<IsotopeCombination>)computedCombinations$1, newCombination, (HashMap<Atom, Object>)compoundAtomCountByAtom$1, (Map<Tuple2<Atom, Object>, IsotopeCombination[]>)isotopeCombinationMap$1, remainingAtoms$1, minProba$1);
    }

    public static final /* synthetic */ boolean $anonfun$computeIsotopicVariantCombinations$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$computeIsotopicVariantCombinations$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$computeIsotopicVariantCombinations$2(float minProba$2, Builder mapBuilder$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Atom atom = (Atom)tuple2._1();
        int maxAtomCount = tuple2._2$mcI$sp();
        IsotopeCombination[] isotopeCombinations = MODULE$.computeAtomIsotopicVariantCombinations(atom, maxAtomCount, minProba$2);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])isotopeCombinations)).groupBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToFloat((float)x$4.atomCount())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)IsotopeDistributionComputer$.$anonfun$computeIsotopicVariantCombinations$4(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            float atomCount = BoxesRunTime.unboxToFloat((Object)tuple2._1());
            IsotopeCombination[] combinations = (IsotopeCombination[])tuple2._2();
            Builder builder = mapBuilder$1.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)atom, (Object)BoxesRunTime.boxToFloat((float)atomCount))), (Object)combinations));
            return builder;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$_computeIsotopicVariantCombinations$1(int lastTargetedAtomCount$1, HashMap computedCombinationByFormula$1, AtomIsotopicVariant[] atomIsotopes$1, int curTargetedAtomCount$1, float minProba$3, Tuple2 computedCombination) {
        block1: {
            Tuple2 tuple2 = computedCombination;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String formula = (String)tuple2._1();
            IsotopeCombination combination = (IsotopeCombination)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)formula, (Object)combination);
            Tuple2 tuple23 = tuple22;
            String formula2 = (String)tuple23._1();
            IsotopeCombination combination2 = (IsotopeCombination)tuple23._2();
            if (combination2.atomCount() != (float)lastTargetedAtomCount$1) break block1;
            MODULE$._createNewIsotopeCombinations((HashMap<String, IsotopeCombination>)computedCombinationByFormula$1, (Seq<IsotopeCombination>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IsotopeCombination[]{combination2}))), atomIsotopes$1, curTargetedAtomCount$1, minProba$3);
        }
    }

    public static final /* synthetic */ void $anonfun$_createNewIsotopeCombinations$1(int targetedAtomCount$1, AtomIsotopicVariant[] atomIsotopes$2, HashMap computedCombinationByFormula$2, float minProba$4, ArrayBuffer newCombinationsBuffers$1, IsotopeCombination lastCombination) {
        block0: {
            float atomCount = lastCombination.atomCount();
            if (!(atomCount < (float)targetedAtomCount$1)) break block0;
            Map<AtomIsotopicVariant, Object> lastAbundanceMap = lastCombination.abundanceMap();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])atomIsotopes$2)).foreach((Function1 & Serializable & scala.Serializable)atomIsotope -> {
                BoxedUnit boxedUnit;
                HashMap newAbundanceMap = new HashMap();
                newAbundanceMap.$plus$plus$eq((TraversableOnce)lastAbundanceMap);
                newAbundanceMap.getOrElseUpdate(atomIsotope, (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> 0.0f);
                newAbundanceMap.update(atomIsotope, (Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)newAbundanceMap.apply(atomIsotope)) + 1.0f)));
                String formula = new AtomIsotopeComposition((HashMap<AtomIsotopicVariant, Object>)newAbundanceMap).toFormula();
                if (!computedCombinationByFormula$2.contains((Object)formula)) {
                    float newIsotopeCount = BoxesRunTime.unboxToFloat((Object)newAbundanceMap.apply(atomIsotope));
                    float newAtomCount = atomCount + 1.0f;
                    double newProba = lastCombination.probability() * (double)atomIsotope.isotope().abundance() * (double)newAtomCount / (double)newIsotopeCount;
                    if (newProba >= (double)minProba$4) {
                        IsotopeCombination newCombination = new IsotopeCombination((Map<AtomIsotopicVariant, Object>)newAbundanceMap.toMap(Predef$.MODULE$.$conforms()), newProba);
                        IsotopeDistributionComputer$ isotopeDistributionComputer$ = MODULE$;
                        synchronized (isotopeDistributionComputer$) {
                            computedCombinationByFormula$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)formula), (Object)newCombination));
                        }
                        boxedUnit = newCombinationsBuffers$1.$plus$eq((Object)newCombination);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            });
        }
    }

    private IsotopeDistributionComputer$() {
        MODULE$ = this;
    }
}

