/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.beans.BeanUtils;
import com.l2fprod.common.propertysheet.AbstractProperty;
import com.l2fprod.common.propertysheet.Property;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class DefaultProperty
extends AbstractProperty {
    private String name;
    private String displayName;
    private String shortDescription;
    private Class type;
    private boolean editable = true;
    private String category;
    private Property parent;
    private List subProperties = new ArrayList();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void readFromObject(Object object) {
        try {
            Method method = BeanUtils.getReadMethod(object.getClass(), this.getName());
            if (method != null) {
                Object value = method.invoke(object, null);
                this.initializeValue(value);
                if (value != null) {
                    Iterator iter = this.subProperties.iterator();
                    while (iter.hasNext()) {
                        Property subProperty = (Property)iter.next();
                        subProperty.readFromObject(value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void writeToObject(Object object) {
        try {
            Method method = BeanUtils.getWriteMethod(object.getClass(), this.getName(), this.getType());
            if (method != null) {
                method.invoke(object, this.getValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setValue(Object value) {
        Object parentValue;
        super.setValue(value);
        if (this.parent != null && (parentValue = this.parent.getValue()) != null) {
            this.writeToObject(parentValue);
            this.parent.setValue(parentValue);
        }
        if (value != null) {
            Iterator iter = this.subProperties.iterator();
            while (iter.hasNext()) {
                Property subProperty = (Property)iter.next();
                subProperty.readFromObject(value);
            }
        }
    }

    public int hashCode() {
        return 28 + (this.name != null ? this.name.hashCode() : 3) + (this.displayName != null ? this.displayName.hashCode() : 94) + (this.shortDescription != null ? this.shortDescription.hashCode() : 394) + (this.category != null ? this.category.hashCode() : 34) + (this.type != null ? this.type.hashCode() : 39) + Boolean.valueOf(this.editable).hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        DefaultProperty dp = (DefaultProperty)other;
        return this.compare(this.name, dp.name) && this.compare(this.displayName, dp.displayName) && this.compare(this.shortDescription, dp.shortDescription) && this.compare(this.category, dp.category) && this.compare(this.type, dp.type) && this.editable == dp.editable;
    }

    private boolean compare(Object o1, Object o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    public String toString() {
        return "name=" + this.getName() + ", displayName=" + this.getDisplayName() + ", type=" + this.getType() + ", category=" + this.getCategory() + ", editable=" + this.isEditable() + ", value=" + this.getValue();
    }

    public Property getParentProperty() {
        return this.parent;
    }

    public void setParentProperty(Property parent) {
        this.parent = parent;
    }

    public Property[] getSubProperties() {
        return this.subProperties.toArray(new Property[this.subProperties.size()]);
    }

    public void clearSubProperties() {
        Iterator iter = this.subProperties.iterator();
        while (iter.hasNext()) {
            Property subProp = (Property)iter.next();
            if (!(subProp instanceof DefaultProperty)) continue;
            ((DefaultProperty)subProp).setParentProperty(null);
        }
        this.subProperties.clear();
    }

    public void addSubProperties(Collection subProperties) {
        this.subProperties.addAll(subProperties);
        Iterator iter = this.subProperties.iterator();
        while (iter.hasNext()) {
            Property subProp = (Property)iter.next();
            if (!(subProp instanceof DefaultProperty)) continue;
            ((DefaultProperty)subProp).setParentProperty(this);
        }
    }

    public void addSubProperties(Property[] subProperties) {
        this.addSubProperties(Arrays.asList(subProperties));
    }

    public void addSubProperty(Property subProperty) {
        this.subProperties.add(subProperty);
        if (subProperty instanceof DefaultProperty) {
            ((DefaultProperty)subProperty).setParentProperty(this);
        }
    }
}

