/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dock.container;

import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.dock.container.DockComponentListener;
import fr.proline.studio.dock.container.DockContainer;
import fr.proline.studio.dock.container.DockMaximizeInterface;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class DockComponent
extends DockContainer {
    private final String m_windowKey;
    private String m_title;
    private final Icon m_icon;
    private DockComponentListener m_componentListener = null;
    private DockMaximizeInterface m_maximizeInterface = null;
    private int m_properties = 0;
    public static final int PROP_NONE = 0;
    public static final int PROP_CLOSE = 1;
    public static final int PROP_MINIMIZE = 2;

    public DockComponent(AbstractTopPanel topPanel, int properties) {
        this(topPanel.getTopPanelIdentifierKey(), topPanel.getTitle(), topPanel.getIcon() != null ? new ImageIcon(topPanel.getIcon()) : null, topPanel, properties);
        topPanel.addTopPanelListener(this);
    }

    public DockComponent(String windowKey, String title, Icon icon, JComponent component, int properties) {
        this.m_windowKey = windowKey;
        this.m_title = title;
        this.m_icon = icon;
        this.m_component = component;
        this.m_properties = properties;
    }

    public void setDockComponentListener(DockComponentListener listener) {
        this.m_componentListener = listener;
    }

    public void removeDockComponentListener() {
        this.m_componentListener = null;
    }

    @Override
    public void getTopPanels(HashSet<AbstractTopPanel> set) {
        if (this.m_component instanceof AbstractTopPanel) {
            set.add((AbstractTopPanel)this.m_component);
        }
    }

    @Override
    public void propertyChanged(String property) {
        if (property.equals("TITLE") && this.m_component instanceof AbstractTopPanel) {
            this.setTitle(((AbstractTopPanel)this.m_component).getTitle());
        }
    }

    @Override
    public DockContainer search(String windowKey) {
        if (this.m_windowKey == null) {
            return null;
        }
        if (this.m_windowKey.equals(windowKey)) {
            return this;
        }
        return null;
    }

    @Override
    public DockContainer searchZoneArea(String zoneArea) {
        if (this.m_zoneArea != null && this.m_zoneArea.equals(zoneArea)) {
            return this;
        }
        return null;
    }

    @Override
    public void findAllDockComponents(ArrayList<DockComponent> components) {
        components.add(this);
    }

    @Override
    public void toFront() {
        this.getParent().toFront(this);
    }

    public void maximize() {
        if (this.m_maximizeInterface != null) {
            this.m_maximizeInterface.maximize();
        }
    }

    public void setMaximizeInterface(DockMaximizeInterface maximizeInterface) {
        this.m_maximizeInterface = maximizeInterface;
    }

    public void addProperties(int properties) {
        this.m_properties |= properties;
    }

    public boolean canClose() {
        return (1 & this.m_properties) != 0;
    }

    public boolean canMinimize() {
        return (2 & this.m_properties) != 0;
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
        if (this.m_componentListener != null) {
            this.m_componentListener.titleChanged();
        }
    }

    public Icon getIcon() {
        return null;
    }

    @Override
    public void check() {
    }
}

