/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dock.container;

import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.dock.container.DockComponent;
import fr.proline.studio.dock.container.DockContainer;
import fr.proline.studio.dock.container.DockContainerMulti;
import fr.proline.studio.dock.container.DockContainerTab;
import fr.proline.studio.dock.container.DockReplaceInterface;
import fr.proline.studio.dock.dragdrop.OverArea;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public class DockContainerSplit
extends DockContainerMulti
implements DockReplaceInterface {
    private DockContainerMulti m_leftContainer;
    private DockContainerMulti m_rightContainer;

    public DockContainerMulti getLeftContainer() {
        return this.m_leftContainer;
    }

    public DockContainerMulti getRightContainer() {
        return this.m_rightContainer;
    }

    @Override
    public void getTopPanels(HashSet<AbstractTopPanel> set) {
        this.m_leftContainer.getTopPanels(set);
        this.m_rightContainer.getTopPanels(set);
    }

    @Override
    public DockContainer search(String windowKey) {
        DockContainer containerSearched = this.m_leftContainer.search(windowKey);
        if (containerSearched != null) {
            return containerSearched;
        }
        containerSearched = this.m_rightContainer.search(windowKey);
        if (containerSearched != null) {
            return containerSearched;
        }
        return null;
    }

    @Override
    public DockContainer searchZoneArea(String zoneArea) {
        if (this.m_zoneArea != null && this.m_zoneArea.equals(zoneArea)) {
            return this;
        }
        DockContainer containerSearched = this.m_leftContainer.searchZoneArea(zoneArea);
        if (containerSearched != null) {
            return containerSearched;
        }
        containerSearched = this.m_rightContainer.searchZoneArea(zoneArea);
        if (containerSearched != null) {
            return containerSearched;
        }
        return null;
    }

    @Override
    public void findAllDockComponents(ArrayList<DockComponent> components) {
        this.m_leftContainer.findAllDockComponents(components);
        this.m_rightContainer.findAllDockComponents(components);
    }

    public void add(boolean horizontal, DockContainerMulti leftContainer, DockContainerMulti rightContainer) {
        this.m_leftContainer = leftContainer;
        this.m_rightContainer = rightContainer;
        JSplitPane splitPane = new JSplitPane(horizontal ? 1 : 0, leftContainer.getComponent(), rightContainer.getComponent());
        this.m_component = splitPane;
        leftContainer.setParent(this);
        rightContainer.setParent(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JSplitPane)DockContainerSplit.this.m_component).setDividerLocation(0.5);
            }
        });
    }

    public void addLeft(DockContainerMulti leftContainer) {
        ((JSplitPane)this.m_component).setRightComponent(leftContainer.getComponent());
        leftContainer.setParent(this);
    }

    public void addRight(DockContainerMulti rightContainer) {
        ((JSplitPane)this.m_component).setRightComponent(rightContainer.getComponent());
        rightContainer.setParent(this);
    }

    @Override
    public OverArea getOverArea(Point pointOnScreen) {
        OverArea overArea = this.m_leftContainer.getOverArea(pointOnScreen);
        if (overArea != null) {
            return overArea;
        }
        return this.m_rightContainer.getOverArea(pointOnScreen);
    }

    @Override
    public void replace(DockContainerMulti previous, DockContainerMulti next) {
        final JSplitPane splitPane = (JSplitPane)this.m_component;
        final int oldLocation = splitPane.getDividerLocation();
        if (this.m_leftContainer == previous) {
            splitPane.remove(this.m_leftContainer.getComponent());
            splitPane.setLeftComponent(next.getComponent());
            this.m_leftContainer = next;
            next.setParent(this);
            splitPane.revalidate();
            splitPane.repaint();
        } else if (this.m_rightContainer == previous) {
            splitPane.remove(this.m_rightContainer.getComponent());
            splitPane.setRightComponent(next.getComponent());
            this.m_rightContainer = next;
            next.setParent(this);
            splitPane.revalidate();
            splitPane.repaint();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                splitPane.setDividerLocation(oldLocation);
            }
        });
    }

    @Override
    public void remove(DockContainer container) {
        if (!this.m_canRemoveChildren) {
            return;
        }
        JSplitPane splitPane = (JSplitPane)this.m_component;
        splitPane.remove(this.m_leftContainer.getComponent());
        splitPane.remove(this.m_rightContainer.getComponent());
        DockContainerMulti keptContainer = this.m_leftContainer == container ? this.m_rightContainer : this.m_leftContainer;
        this.m_leftContainer = null;
        this.m_rightContainer = null;
        ((DockReplaceInterface)((Object)this.getParent())).replace(this, keptContainer);
    }

    @Override
    public boolean isEmpty() {
        return this.m_leftContainer.isEmpty() && this.m_rightContainer.isEmpty();
    }

    @Override
    public DockContainerTab searchTab(int idContainer) {
        DockContainerTab tab = this.m_leftContainer.searchTab(idContainer);
        if (tab != null) {
            return tab;
        }
        return this.m_rightContainer.searchTab(idContainer);
    }

    @Override
    public void check() {
        DockContainerMulti c = this.m_leftContainer;
        if (c.getParent() != this) {
            System.err.println("Wrong Parent");
        }
        if (c.getComponent().getParent() != this.getComponent()) {
            System.err.println("Wrong Parent AWT");
        }
        c.check();
        c = this.m_rightContainer;
        if (c.getParent() != this) {
            System.err.println("Wrong Parent");
        }
        if (c.getComponent().getParent() != this.getComponent()) {
            System.err.println("Wrong Parent AWT");
        }
        c.check();
    }
}

