/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.dock.gui;

import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.dock.container.DockComponent;
import fr.proline.studio.dock.container.DockComponentListener;
import fr.proline.studio.dock.container.DockContainer;
import fr.proline.studio.dock.container.DockContainerTab;
import fr.proline.studio.dock.dragdrop.DockingExportTransferHandler;
import fr.proline.studio.utils.IconManager;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class TabbedPaneLabel
extends JPanel
implements DockComponentListener {
    final DockContainerTab m_dockContainerTab;
    final DockContainer m_dockComponent;
    private DockingExportTransferHandler m_transferHandler;
    private MouseEvent m_mouseBegin;
    private boolean m_exportAsDrag = false;
    private JLabel m_titleLabel;
    private JButton m_closeButton = null;
    private JButton m_minimizeButton = null;

    public TabbedPaneLabel(DockContainerTab dockContainerTab, DockComponent dockComponent) {
        this.m_dockContainerTab = dockContainerTab;
        this.m_dockComponent = dockComponent;
        dockComponent.setDockComponentListener(this);
        this.initComponents(dockComponent);
        this.m_transferHandler = new DockingExportTransferHandler(dockContainerTab, dockComponent);
        this.setTransferHandler(this.m_transferHandler);
    }

    private void initComponents(DockComponent content) {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setOpaque(false);
        this.m_titleLabel = new JLabel(content.getTitle());
        this.m_titleLabel.setIcon(content.getIcon());
        this.m_titleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.m_titleLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                TabbedPaneLabel.this.m_mouseBegin = evt;
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                TabbedPaneLabel.this.m_mouseBegin = null;
                if (evt.isPopupTrigger()) {
                    TabbedPaneLabel.this.popup(evt.getX(), evt.getY());
                } else if (!TabbedPaneLabel.this.m_exportAsDrag) {
                    ((JTabbedPane)TabbedPaneLabel.this.m_dockContainerTab.getComponent()).setSelectedComponent(TabbedPaneLabel.this.m_dockComponent.getComponent());
                }
                TabbedPaneLabel.this.m_exportAsDrag = false;
            }
        });
        this.m_titleLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                TabbedPaneLabel.this.mouseDraggedImpl(evt);
            }
        });
        this.add(this.m_titleLabel);
        if (content.canClose()) {
            this.m_closeButton = new JButton();
            this.m_closeButton.setIcon(IconManager.getIcon(IconManager.IconType.CROSS_SMALL12));
            this.m_closeButton.setBorderPainted(false);
            this.m_closeButton.setContentAreaFilled(false);
            this.m_closeButton.setMargin(new Insets(0, 0, 0, 0));
            this.m_closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    int closeTab;
                    if (TabbedPaneLabel.this.m_dockComponent.getComponent() instanceof AbstractTopPanel && ((AbstractTopPanel)TabbedPaneLabel.this.m_dockComponent.getComponent()).warnBeforeClosing() && (closeTab = JOptionPane.showConfirmDialog(null, "Are you sure tou want to close this Windows ? " + ((AbstractTopPanel)TabbedPaneLabel.this.m_dockComponent.getComponent()).getWarnClosingMessage(), "Close Warning", 0, 2)) == 1) {
                        return;
                    }
                    TabbedPaneLabel.this.m_dockContainerTab.remove(TabbedPaneLabel.this.m_dockComponent);
                    if (TabbedPaneLabel.this.m_dockComponent.getComponent() instanceof AbstractTopPanel) {
                        ((AbstractTopPanel)TabbedPaneLabel.this.m_dockComponent.getComponent()).componentClosed();
                    }
                }
            });
            this.add(this.m_closeButton);
        }
        if (content.canMinimize()) {
            this.m_minimizeButton = new JButton();
            this.m_minimizeButton.setIcon(IconManager.getIcon(IconManager.IconType.MINIFY));
            this.m_minimizeButton.setBorderPainted(false);
            this.m_minimizeButton.setContentAreaFilled(false);
            this.m_minimizeButton.setMargin(new Insets(0, 0, 0, 0));
            this.m_minimizeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TabbedPaneLabel.this.m_dockContainerTab.remove(TabbedPaneLabel.this.m_dockComponent);
                    TabbedPaneLabel.this.m_dockContainerTab.minimize(TabbedPaneLabel.this.m_dockComponent);
                }
            });
            this.add(this.m_minimizeButton);
        }
    }

    private void mouseDraggedImpl(MouseEvent evt) {
        int dy;
        int dx;
        if (this.m_mouseBegin != null && (dx = this.m_mouseBegin.getX() - evt.getX()) * dx + (dy = this.m_mouseBegin.getY() - evt.getY()) * dy > 16) {
            JComponent component = this.m_dockComponent.getComponent();
            JTabbedPane tabbedPane = (JTabbedPane)this.m_dockContainerTab.getComponent();
            int index = tabbedPane.indexOfComponent(component);
            tabbedPane.setSelectedIndex(index);
            this.m_transferHandler.exportAsDrag(this, this.m_mouseBegin, 2);
            this.m_mouseBegin = null;
            this.m_exportAsDrag = true;
        }
    }

    public void popup(int x, int y) {
        JComponent component = this.m_dockComponent.getComponent();
        if (component instanceof AbstractTopPanel) {
            Action[] actions = ((AbstractTopPanel)component).getActions((DockComponent)this.m_dockComponent);
            if (actions == null) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            for (Action action : actions) {
                if (action == null) {
                    popup.addSeparator();
                    continue;
                }
                popup.add(action);
            }
            popup.show(this, x, y);
        }
    }

    @Override
    public void titleChanged() {
        this.m_titleLabel.setText(this.m_dockComponent.getTitle());
        this.m_titleLabel.repaint();
    }
}

