/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.export;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.export.ExporterInterface;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelXMLExporter
implements ExporterInterface {
    private XSSFWorkbook m_wb;
    private Sheet m_sheet;
    private int m_curRow = 0;
    private int m_curCell = 0;
    private Row m_row;
    private String m_filePath = null;
    private boolean m_decorated = false;

    @Override
    public void start(String filePath) {
        if (!((String)filePath).endsWith(this.getFileExtension())) {
            filePath = (String)filePath + this.getFileExtension();
        }
        this.m_wb = new XSSFWorkbook();
        this.m_filePath = filePath;
    }

    @Override
    public void startSheet(String pageName) {
        this.m_sheet = this.m_wb.createSheet(pageName);
        this.m_curRow = 0;
    }

    @Override
    public void startRow() {
        this.m_row = this.m_sheet.createRow(this.m_curRow);
        ++this.m_curRow;
        this.m_curCell = 0;
    }

    @Override
    public void addCell(String t, ArrayList<ExportFontData> fonts) {
        Cell cell = this.m_row.createCell(this.m_curCell);
        if (this.getDecorated() && fonts != null) {
            XSSFRichTextString rich = new XSSFRichTextString(t);
            for (int i = 0; i < fonts.size(); ++i) {
                int startIndex = fonts.get(i).getStartIndex();
                int stopIndex = fonts.get(i).getStopIndex();
                short color = fonts.get(i).getColor();
                XSSFFont currentFont = this.m_wb.createFont();
                if (currentFont == null) continue;
                currentFont.setColor(color);
                if (fonts.get(i).getTextWeight() == 1) {
                    currentFont.setBold(true);
                } else if (fonts.get(i).getTextWeight() == 2) {
                    currentFont.setItalic(true);
                }
                if (startIndex < 0 || stopIndex > t.length()) continue;
                rich.applyFont(startIndex, stopIndex, (Font)currentFont);
            }
            cell.setCellValue((RichTextString)rich);
        } else if (NumberUtils.isCreatable((String)t)) {
            double d = Double.parseDouble(t);
            cell.setCellValue(d);
        } else {
            cell.setCellValue(t);
        }
        ++this.m_curCell;
    }

    @Override
    public void end() throws IOException {
        FileOutputStream fileOut = new FileOutputStream(this.m_filePath);
        this.m_wb.write((OutputStream)fileOut);
        fileOut.flush();
        fileOut.close();
    }

    @Override
    public void setDecorated(boolean decorated) {
        this.m_decorated = decorated;
    }

    @Override
    public boolean getDecorated() {
        return this.m_decorated;
    }

    @Override
    public String getFileExtension() {
        return ".xlsx";
    }
}

