/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.WindowManager;
import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.PlotBaseAbstract;
import fr.proline.studio.graphics.PlotXYAbstract;
import fr.proline.studio.graphics.cursor.AbstractCursor;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.utils.IconManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Axis {
    protected static final Stroke DASHED = new BasicStroke(1.0f, 1, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);
    protected static final Logger m_logger = LoggerFactory.getLogger(Axis.class);
    protected ArrayList<PlotBaseAbstract> m_plots;
    protected String m_title = null;
    protected Font m_titleFont = null;
    protected FontMetrics m_titleFontMetrics;
    protected Font m_valuesFont = null;
    protected FontMetrics m_valuesFontMetrics = null;
    protected Font m_valuesDiagonalFont = null;
    protected int m_x;
    protected int m_y;
    protected int m_width;
    protected int m_height;
    protected double m_minValue;
    protected double m_maxValue;
    protected double m_lockedMinValue = Double.NaN;
    protected double m_minTick;
    protected double m_maxTick;
    protected double m_tickSpacing;
    protected DecimalFormat m_df;
    protected DecimalFormat m_dfPlot;
    protected int m_fractionalDigits = -1;
    protected int m_integerDigits = -1;
    protected boolean m_log = false;
    protected boolean m_selected = false;
    protected boolean m_isInteger = false;
    protected boolean m_isEnum = false;
    protected boolean m_isPixel = false;
    protected boolean m_displayTitle = true;
    protected BasePlotPanel m_plotPanel;
    protected AxisRangePanel m_rangePanel;
    protected boolean m_mustDrawDiagonalLabels = false;
    protected int m_labelMinWidth = 0;
    protected int m_labelMaxWidth = 0;
    protected int m_minimumAxisHeight = 0;
    private boolean m_maxZoomDone = false;
    private boolean m_rangeModifiedByUser = false;
    protected static final double LOG_MIN_VALUE = 1.0E-12;

    public boolean displayAxis() {
        return !this.m_isPixel;
    }

    public boolean displayTitle() {
        return this.m_displayTitle;
    }

    public void setDisplayTitle(boolean b) {
        this.m_displayTitle = b;
    }

    public Axis(BasePlotPanel p) {
        this.m_plots = new ArrayList();
        this.m_plotPanel = p;
        this.m_rangePanel = new AxisRangePanel(this);
    }

    public void checkMaxZoomOutDone() {
        if (this.m_log) {
            double min = Math.log10(this.m_minValue <= 1.0E-12 ? 1.0E-12 : this.m_minValue);
            double max = Math.log10(this.m_maxValue <= 1.0E-12 ? 1.0E-11 : this.m_maxValue);
            this.m_maxZoomDone = (max - min) / Math.pow(10.0, this.m_tickSpacing) * (double)this.m_width > 1.0E10;
        } else {
            this.m_maxZoomDone = (this.m_maxValue - this.m_minValue) / this.m_tickSpacing * (double)this.m_width > 1.0E10;
        }
    }

    public boolean isMaxZoomOutReached() {
        return this.m_maxZoomDone;
    }

    public ArrayList<PlotBaseAbstract> getPlots() {
        return this.m_plots;
    }

    public boolean hasPlot(PlotBaseAbstract plot) {
        return this.m_plots.contains(plot);
    }

    public boolean hasPlots() {
        return !this.m_plots.isEmpty();
    }

    public void setPlot(PlotBaseAbstract plot) {
        this.m_plots.clear();
        this.m_plots.add(plot);
    }

    public void clearPlots() {
        this.m_plots.clear();
    }

    public void addPlot(PlotXYAbstract plot) {
        this.m_plots.add(plot);
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public BasePlotPanel getPlotPanel() {
        return this.m_plotPanel;
    }

    public AxisRangePanel getRangePanel() {
        return this.m_rangePanel;
    }

    public int getMiniMumAxisHeight(int minHeightFromParent) {
        return StrictMath.max(this.m_minimumAxisHeight, minHeightFromParent);
    }

    public void setSpecificities(boolean isInteger, boolean isEnum, boolean isPixel) {
        this.m_isInteger = isInteger;
        this.m_isEnum = isEnum;
        this.m_isPixel = isPixel;
    }

    public boolean isEnum() {
        return this.m_isEnum;
    }

    public void setLog(boolean log) {
        this.m_log = log;
        this.m_df = null;
        this.updatePlotsForLog();
    }

    public void updatePlotsForLog() {
        for (PlotBaseAbstract plot : this.m_plots) {
            plot.update();
        }
    }

    public boolean isLog() {
        return this.m_log;
    }

    public boolean canBeInLog() {
        return !this.m_isEnum;
    }

    public void setSize(int x, int y, int width, int height) {
        this.m_x = x;
        this.m_y = y;
        this.m_width = width;
        this.m_height = height;
    }

    public boolean getRangeModifiedByUser() {
        return this.m_rangeModifiedByUser;
    }

    public void setRangeModifiedByUser(boolean rangeModifiedByUser) {
        this.m_rangeModifiedByUser = rangeModifiedByUser;
    }

    public void setRange(double min, double max, boolean rangeModifiedByUser) {
        this.setRange(min, max);
        this.setRangeModifiedByUser(rangeModifiedByUser);
    }

    public void setRange(double min, double max) {
        this.m_minValue = !Double.isNaN(this.m_lockedMinValue) && min < this.m_lockedMinValue && this.m_lockedMinValue < max ? this.m_lockedMinValue : min;
        this.m_maxValue = max;
        this.m_minTick = this.m_minValue;
        this.m_maxTick = max;
    }

    public void lockMinValue(Double min) {
        this.m_lockedMinValue = min;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public String getTitle() {
        return this.m_title;
    }

    public boolean setSelected(boolean v) {
        boolean changed = v ^ this.m_selected;
        this.m_selected = v;
        return changed;
    }

    public boolean isSelected() {
        return this.m_selected;
    }

    public abstract void paint(Graphics2D var1);

    public abstract void paintCursor(Graphics2D var1, AbstractCursor var2, boolean var3);

    public abstract int valueToPixel(double var1);

    public abstract double pixelToValue(int var1);

    public abstract double deltaPixelToDeltaValue(int var1);

    public abstract double deltaPixelToLogMultValue(int var1);

    public double getMinValue() {
        if (this.m_log && this.m_minValue <= 1.0E-12) {
            return 1.0E-12;
        }
        return this.m_minValue;
    }

    public double getMaxValue() {
        if (this.m_log && this.m_maxValue <= 1.0E-11) {
            return 1.0E-11;
        }
        return this.m_maxValue;
    }

    public double getMinTick() {
        if (this.m_log) {
            return Math.pow(10.0, this.m_minTick);
        }
        return this.m_minTick;
    }

    public double getMaxTick() {
        if (this.m_log) {
            return Math.pow(10.0, this.m_maxTick);
        }
        return this.m_maxTick;
    }

    public int getWidth() {
        return this.m_width;
    }

    public int getHeight() {
        return this.m_height;
    }

    public boolean inside(int x, int y) {
        return x >= this.m_x && x < this.m_x + this.m_width && y > this.m_y && y < this.m_y + this.m_height;
    }

    protected DecimalFormat selectDecimalFormat(int fractionalDigits, int integerDigits) {
        Object pattern;
        if (this.m_log) {
            pattern = "0.0E0";
        } else if (fractionalDigits <= 0) {
            pattern = integerDigits > 4 ? "0.0E0" : "#";
        } else if (fractionalDigits > 3) {
            pattern = "0.0";
            --fractionalDigits;
            while (fractionalDigits > 0) {
                pattern = (String)pattern + "#";
                --fractionalDigits;
            }
            pattern = (String)pattern + "E0";
        } else {
            pattern = "#.";
            while (fractionalDigits > 0) {
                pattern = (String)pattern + "#";
                --fractionalDigits;
            }
        }
        DecimalFormat df = new DecimalFormat((String)pattern);
        DecimalFormatSymbols sym = DecimalFormatSymbols.getInstance();
        sym.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(sym);
        return new DecimalFormat((String)pattern);
    }

    protected DecimalFormat selectLogDecimalFormat() {
        return new DecimalFormat("0.0E0");
    }

    public DecimalFormat getExternalDecimalFormat() {
        return this.m_dfPlot;
    }

    public static class AxisRangePanel
    extends JPanel {
        private JTextField m_minTextField;
        private JTextField m_maxTextField;
        private Axis m_axis;

        public AxisRangePanel(Axis axis) {
            this.m_axis = axis;
            this.setBorder(BorderFactory.createLineBorder(Color.darkGray, 1, true));
            this.setOpaque(true);
            this.setLayout(new FlowLayout());
            JButton closeButton = new JButton(IconManager.getIcon(IconManager.IconType.CROSS_SMALL7));
            closeButton.setMargin(new Insets(0, 0, 0, 0));
            closeButton.setFocusPainted(false);
            closeButton.setContentAreaFilled(false);
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                }
            });
            this.m_minTextField = new JTextField(8);
            this.m_minTextField.setToolTipText("Set axis lower bound");
            this.m_minTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.updateRange();
                }
            });
            this.m_maxTextField = new JTextField(8);
            this.m_maxTextField.setToolTipText("Set axis upper bound");
            this.m_maxTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.updateRange();
                }
            });
            this.add(closeButton);
            this.add(this.m_minTextField);
            this.add(new JLabel(" to "));
            this.add(this.m_maxTextField);
            Dimension d = this.getPreferredSize();
            this.setBounds(0, 0, (int)d.getWidth(), (int)d.getHeight());
            MouseAdapter dragGestureAdapter = new MouseAdapter(){
                int dX;
                int dY;

                @Override
                public void mouseDragged(MouseEvent e) {
                    int parentY;
                    Component panel = e.getComponent();
                    int newX = e.getLocationOnScreen().x - this.dX;
                    int newY = e.getLocationOnScreen().y - this.dY;
                    Container parentComponent = panel.getParent();
                    int parentX = parentComponent.getX();
                    if (newX < parentX) {
                        newX = parentX;
                    }
                    if (newY < (parentY = parentComponent.getY())) {
                        newY = parentY;
                    }
                    int parentWidth = parentComponent.getWidth();
                    if (newX + panel.getWidth() > parentWidth - parentX) {
                        newX = parentWidth - parentX - panel.getWidth();
                    }
                    int parentHeight = parentComponent.getHeight();
                    if (newY + panel.getHeight() > parentHeight - parentY) {
                        newY = parentHeight - parentY - panel.getHeight();
                    }
                    panel.setLocation(newX, newY);
                    this.dX = e.getLocationOnScreen().x - panel.getX();
                    this.dY = e.getLocationOnScreen().y - panel.getY();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    JPanel panel = (JPanel)e.getComponent();
                    panel.setCursor(Cursor.getPredefinedCursor(13));
                    this.dX = e.getLocationOnScreen().x - panel.getX();
                    this.dY = e.getLocationOnScreen().y - panel.getY();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    JPanel panel = (JPanel)e.getComponent();
                    panel.setCursor(null);
                }
            };
            this.addMouseMotionListener(dragGestureAdapter);
            this.addMouseListener(dragGestureAdapter);
            this.setVisible(false);
        }

        private void updateRange() {
            double min;
            double max;
            if (this.m_maxTextField.getText().isEmpty() || this.m_minTextField.getText().isEmpty()) {
                return;
            }
            try {
                max = Double.parseDouble(this.m_maxTextField.getText().trim());
                min = Double.parseDouble(this.m_minTextField.getText().trim());
            }
            catch (NumberFormatException nfe) {
                InfoDialog errorDialog = new InfoDialog(WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Error", "Min or max value contains non numerical values.", false);
                errorDialog.setButtonName(0, "OK");
                errorDialog.setButtonVisible(1, false);
                errorDialog.centerToWindow(WindowManager.getDefault().getMainWindow());
                errorDialog.setVisible(true);
                return;
            }
            if (min < max) {
                if (this.m_axis.isLog()) {
                    min = Math.pow(10.0, min);
                    max = Math.pow(10.0, max);
                }
                this.m_axis.setRange(min, max, true);
                this.m_axis.m_plotPanel.repaintUpdateDoubleBuffer();
            } else {
                InfoDialog errorDialog = new InfoDialog(WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Error", "Min value cannot be greater than or equal to the max value.", false);
                errorDialog.setButtonVisible(1, false);
                errorDialog.centerToWindow(WindowManager.getDefault().getMainWindow());
                errorDialog.setVisible(true);
            }
        }
    }

    public static interface EnumYInterface {
        public String getEnumValueY(int var1, boolean var2, Axis var3);
    }

    public static interface EnumXInterface {
        public String getEnumValueX(int var1, boolean var2);
    }
}

