/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics;

import fr.proline.studio.graphics.PlotHistogram;
import java.util.ArrayList;
import java.util.HashSet;

public enum PlotType {
    HISTOGRAM_PLOT("Histogram", false, "on", null, "as"),
    SCATTER_PLOT("Scatter Plot", false, "X Axis:", "Y Axis:", null),
    VENN_DIAGRAM_PLOT("Venn Diagram", true, "Data:", null, null),
    PARALLEL_COORDINATES_PLOT("Parallel Coordinates", true, "Data:", null, null),
    LINEAR_PLOT("Linear Plot", false, "X Axis:", "Y Axis:", null);

    public static PlotType[] ALL_PLOTS;
    public static PlotType[] LINEAR_PLOTS;
    private final boolean m_illimitedAxis;
    private final String m_name;
    private final String m_xLabel;
    private final String m_yLabel;
    private final String m_zLabel;

    private PlotType(String name, boolean illimitedAxis, String xLabel, String yLabel, String zLabel) {
        this.m_name = name;
        this.m_illimitedAxis = illimitedAxis;
        this.m_xLabel = xLabel;
        this.m_yLabel = yLabel;
        this.m_zLabel = zLabel;
    }

    public boolean needsMultiData() {
        return this.m_illimitedAxis;
    }

    public boolean needsX() {
        return this.m_xLabel != null && !this.m_illimitedAxis;
    }

    public boolean needsY() {
        return this.m_yLabel != null && !this.m_illimitedAxis;
    }

    public boolean needsZ() {
        return this.m_zLabel != null && !this.m_illimitedAxis;
    }

    public String getXLabel() {
        return this.m_xLabel;
    }

    public String getYLabel() {
        return this.m_yLabel;
    }

    public String getZLabel() {
        return this.m_zLabel;
    }

    public String toString() {
        return this.m_name;
    }

    public HashSet<Class> getAcceptedXValues() {
        HashSet<Class> acceptedValues = new HashSet<Class>(3);
        switch (this) {
            case VENN_DIAGRAM_PLOT: 
            case HISTOGRAM_PLOT: {
                acceptedValues.add(Double.class);
                acceptedValues.add(Float.class);
                acceptedValues.add(Integer.class);
                acceptedValues.add(Long.class);
                break;
            }
            case SCATTER_PLOT: 
            case LINEAR_PLOT: 
            case PARALLEL_COORDINATES_PLOT: {
                acceptedValues.add(Double.class);
                acceptedValues.add(Float.class);
                acceptedValues.add(Integer.class);
                acceptedValues.add(String.class);
                acceptedValues.add(Long.class);
            }
        }
        return acceptedValues;
    }

    public HashSet<Class> getAcceptedValuesAsParam() {
        HashSet<Class> acceptedValues = new HashSet<Class>(2);
        switch (this) {
            case VENN_DIAGRAM_PLOT: 
            case HISTOGRAM_PLOT: 
            case PARALLEL_COORDINATES_PLOT: {
                break;
            }
            case SCATTER_PLOT: 
            case LINEAR_PLOT: {
                acceptedValues.add(Double.class);
                acceptedValues.add(Float.class);
                acceptedValues.add(Integer.class);
            }
        }
        return acceptedValues;
    }

    public ArrayList<String> getZValues() {
        switch (this) {
            case HISTOGRAM_PLOT: {
                ArrayList<String> zParams = new ArrayList<String>();
                zParams.add(PlotHistogram.HISTOGRAM_COUNT);
                zParams.add(PlotHistogram.HISTOGRAM_PERCENTAGE);
                return zParams;
            }
        }
        return null;
    }

    static {
        ALL_PLOTS = new PlotType[]{HISTOGRAM_PLOT, SCATTER_PLOT, VENN_DIAGRAM_PLOT, PARALLEL_COORDINATES_PLOT};
        LINEAR_PLOTS = new PlotType[]{LINEAR_PLOT};
    }
}

