/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.cursor;

import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.XAxis;
import fr.proline.studio.graphics.YAxis;
import fr.proline.studio.graphics.cursor.AbstractCursor;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class VerticalCursor
extends AbstractCursor {
    private int m_positionX;

    public VerticalCursor(BasePlotPanel plotPanel, double value) {
        super(plotPanel);
        this.m_value = value;
    }

    public void setValue(double value) {
        this.m_value = value;
        XAxis xAxis = this.m_plotPanel.getXAxis();
        this.m_positionX = xAxis.valueToPixel(this.m_value);
    }

    @Override
    public void paint(Graphics2D g) {
        Stroke prevStroke = g.getStroke();
        g.setStroke(this.m_selected ? AbstractCursor.LINE2_STROKE : this.m_stroke);
        XAxis xAxis = this.m_plotPanel.getXAxis();
        YAxis yAxis = this.m_plotPanel.getYAxis();
        this.m_positionX = xAxis.valueToPixel(this.m_value);
        int y1 = yAxis.valueToPixel(yAxis.getMinValue());
        int y2 = yAxis.valueToPixel(yAxis.getMaxValue());
        g.setColor(this.m_color);
        g.drawLine(this.m_positionX, y1, this.m_positionX, y2);
        xAxis.paintCursor(g, this, this.m_selected);
        g.setStroke(prevStroke);
    }

    @Override
    public boolean insideXY(int x, int y) {
        if (!this.m_selectable) {
            return false;
        }
        return x >= this.m_positionX - 2 && x <= this.m_positionX + 2;
    }

    @Override
    public void moveDXY(int deltaX, int deltaY) {
        this.m_positionX += deltaX;
        XAxis xAxis = this.m_plotPanel.getXAxis();
        this.m_value = xAxis.pixelToValue(this.m_positionX);
        double min = xAxis.getMinValue();
        if (this.m_minValue != null && this.m_minValue > min) {
            min = this.m_minValue;
        }
        if (this.m_value < min) {
            this.m_value = min;
            this.m_positionX = xAxis.valueToPixel(min);
        }
        double max = xAxis.getMaxValue();
        if (this.m_maxValue != null && this.m_maxValue < max) {
            max = this.m_maxValue;
        }
        if (this.m_value > max) {
            this.m_value = max;
            this.m_positionX = xAxis.valueToPixel(max);
        }
        if (this.m_actionListenerList != null) {
            ActionEvent e = new ActionEvent(this, this.m_actionEventId++, null);
            for (ActionListener a : this.m_actionListenerList) {
                a.actionPerformed(e);
            }
        }
    }

    @Override
    public boolean isMoveable() {
        return true;
    }

    @Override
    public void snapToData(boolean isCtrlOrShiftDown) {
        if (!this.m_snapToData) {
            return;
        }
        this.m_value = this.m_plotPanel.getNearestXData(this.m_value);
        XAxis xAxis = this.m_plotPanel.getXAxis();
        this.m_positionX = xAxis.valueToPixel(this.m_value);
    }
}

