/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.graphics.marker;

import fr.proline.studio.graphics.BasePlotPanel;
import fr.proline.studio.graphics.marker.AbstractMarker;
import fr.proline.studio.graphics.marker.coordinates.AbstractCoordinates;
import java.awt.Color;
import java.awt.Graphics2D;

public class PointMarker
extends AbstractMarker {
    private AbstractCoordinates m_coordinates;
    private Color m_markerColor = null;
    private static final int OVAL_WIDTH = 6;

    public PointMarker(BasePlotPanel plotPanel, AbstractCoordinates coordinates) {
        super(plotPanel);
        this.m_coordinates = coordinates;
    }

    public PointMarker(BasePlotPanel plotPanel, AbstractCoordinates coordinates, Color color) {
        super(plotPanel);
        this.m_coordinates = coordinates;
        this.m_markerColor = color;
    }

    public void setCoordinates(AbstractCoordinates coordinates) {
        this.m_coordinates = coordinates;
    }

    public AbstractCoordinates getCoordinates() {
        return this.m_coordinates;
    }

    @Override
    public void paint(Graphics2D g) {
        if (this.m_markerColor == null) {
            return;
        }
        int pixelX = this.m_coordinates.getPixelX(this.m_plotPanel);
        int pixelY = this.m_coordinates.getPixelY(this.m_plotPanel);
        g.setColor(this.m_markerColor);
        g.fillOval(pixelX - 3, pixelY - 3, 6, 6);
    }
}

