/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.parameter;

import fr.proline.studio.WindowManager;
import fr.proline.studio.parameter.DefaultParameterDialog;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.utils.IconManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;

public class SettingsButton
extends JButton
implements ActionListener {
    private ProgressInterface m_progressInterface = null;
    private SettingsInterface m_settingsInterface = null;

    public SettingsButton(ProgressInterface progressInterface, SettingsInterface settingsInterface) {
        this.m_settingsInterface = settingsInterface;
        this.m_progressInterface = progressInterface;
        this.setIcon(IconManager.getIcon(IconManager.IconType.SETTINGS));
        this.setToolTipText("Settings...");
        this.setFocusPainted(false);
        this.addActionListener(this);
    }

    public final void setProgressInterface(ProgressInterface progressInterface) {
        this.m_progressInterface = progressInterface;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<ParameterList> parameterListArray;
        if (this.m_progressInterface != null && !this.m_progressInterface.isLoaded()) {
            ProgressBarDialog dialog = ProgressBarDialog.getDialog(WindowManager.getDefault().getMainWindow(), this.m_progressInterface, "Data loading", "Settings dialog is not available while data is loading. Please Wait.");
            dialog.setLocation(this.getLocationOnScreen().x + this.getWidth() + 5, this.getLocationOnScreen().y + this.getHeight() + 5);
            dialog.setVisible(true);
            if (!dialog.isWaitingFinished()) {
                return;
            }
        }
        if ((parameterListArray = this.m_settingsInterface.getParameters()) == null) {
            return;
        }
        DefaultParameterDialog parameterDialog = new DefaultParameterDialog((Window)WindowManager.getDefault().getMainWindow(), "Settings", parameterListArray);
        parameterDialog.setDocumentationSuffix("h.u8efk3coyb70");
        parameterDialog.setLocationRelativeTo(this);
        parameterDialog.setVisible(true);
        if (parameterDialog.getButtonClicked() == 0) {
            this.m_settingsInterface.parametersChanged();
        } else {
            this.m_settingsInterface.parametersCanceled();
        }
    }
}

