/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.export.ExportFontData;
import fr.proline.studio.extendedtablemodel.ExtraDataType;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.ConvertValueInterface;
import fr.proline.studio.filter.Filter;
import fr.proline.studio.filter.StringDiffFilter;
import fr.proline.studio.graphics.PlotInformation;
import fr.proline.studio.graphics.PlotType;
import fr.proline.studio.table.DataGroup;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.LazyData;
import fr.proline.studio.table.renderer.PropertiesRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;

public abstract class PropertiesTableModel
extends DecoratedTableModel
implements GlobalTableModelInterface {
    protected PropertiesRenderer m_propertiesOkRenderer = new PropertiesRenderer(false);
    protected PropertiesRenderer m_propertiesNonOkRenderer = new PropertiesRenderer(true);
    protected ArrayList<String> m_datasetNameArray = null;
    protected ArrayList<DataGroup> m_dataGroupList = null;
    private HashMap<Integer, DataGroup> m_dataGroupMap = null;
    protected int m_rowCount = -1;
    protected String m_modelName;
    protected boolean m_loaded = false;

    public HashMap<Integer, DataGroup> getDataGroupMap() {
        return this.m_dataGroupMap;
    }

    @Override
    public String getColumnName(int col) {
        if (col <= 1) {
            return DataGroup.COLUMN_NAMES[col];
        }
        return this.m_datasetNameArray.get(col - 2);
    }

    @Override
    public int getColumnCount() {
        if (this.m_datasetNameArray == null) {
            return 2;
        }
        return 2 + this.m_datasetNameArray.size();
    }

    @Override
    public int getRowCount() {
        if (this.m_rowCount != -1) {
            return this.m_rowCount;
        }
        if (this.m_dataGroupList == null) {
            return 0;
        }
        this.m_rowCount = 0;
        this.m_dataGroupMap = new HashMap();
        for (DataGroup dataGroup : this.m_dataGroupList) {
            int start = this.m_rowCount;
            this.m_rowCount += dataGroup.getRowCount();
            for (int i = start; i < this.m_rowCount; ++i) {
                this.m_dataGroupMap.put(i, dataGroup);
            }
        }
        return this.m_rowCount;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DataGroup dataGroup = this.m_dataGroupMap.get(rowIndex);
        DataGroup.GroupObject v = (DataGroup.GroupObject)dataGroup.getValueAt(rowIndex, columnIndex);
        return v;
    }

    @Override
    public String getToolTipForHeader(int col) {
        return this.getColumnName(col);
    }

    @Override
    public String getTootlTipValue(int row, int col) {
        return null;
    }

    @Override
    public TableCellRenderer getRenderer(int row, int col) {
        int nbCol;
        DataGroup.GroupObject groupObject = (DataGroup.GroupObject)this.getValueAt(row, col);
        DataGroup dataGroup = groupObject.m_group;
        boolean isFirstRow = groupObject.m_coloredRow;
        if (isFirstRow) {
            return dataGroup.getRenderer(row);
        }
        if (col == 0) {
            return dataGroup.getRenderer(row);
        }
        if (col == 1 && (nbCol = this.getColumnCount()) > 3) {
            String value = ((DataGroup.GroupObject)this.getValueAt(row, 2)).stringForFilter();
            for (int i = 3; i < nbCol; ++i) {
                String valueCur = ((DataGroup.GroupObject)this.getValueAt(row, i)).stringForFilter();
                if (value == null && valueCur == null || !(value != null && valueCur == null || value == null && valueCur != null) && value.compareTo(valueCur) == 0) continue;
                return this.m_propertiesNonOkRenderer;
            }
        }
        return this.m_propertiesOkRenderer;
    }

    @Override
    public GlobalTableModelInterface getFrozzenModel() {
        return this;
    }

    @Override
    public Long getTaskId() {
        return -1L;
    }

    @Override
    public LazyData getLazyData(int row, int col) {
        return null;
    }

    @Override
    public void givePriorityTo(Long taskId, int row, int col) {
    }

    @Override
    public void sortingChanged(int col) {
    }

    @Override
    public int getSubTaskId(int col) {
        return -1;
    }

    @Override
    public String getDataColumnIdentifier(int columnIndex) {
        return this.getColumnName(columnIndex);
    }

    @Override
    public Class getDataColumnClass(int columnIndex) {
        return this.getColumnClass(columnIndex);
    }

    @Override
    public Object getDataValueAt(int rowIndex, int columnIndex) {
        return this.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public int[] getKeysColumn() {
        return null;
    }

    @Override
    public int getInfoColumn() {
        return 0;
    }

    @Override
    public void setName(String name) {
        this.m_modelName = name;
    }

    @Override
    public String getName() {
        return this.m_modelName;
    }

    @Override
    public Map<String, Object> getExternalData() {
        return null;
    }

    @Override
    public PlotInformation getPlotInformation() {
        return null;
    }

    @Override
    public ArrayList<ExtraDataType> getExtraDataTypes() {
        return null;
    }

    @Override
    public Object getValue(Class c) {
        return null;
    }

    @Override
    public Object getRowValue(Class c, int row) {
        return null;
    }

    @Override
    public Object getColValue(Class c, int col) {
        return null;
    }

    @Override
    public void addFilters(LinkedHashMap<Integer, Filter> filtersMap) {
        ConvertValueInterface convertValueInterface = new ConvertValueInterface(){

            @Override
            public Object convertValue(Object o) {
                return ((DataGroup.GroupObject)o).m_valueFiltering;
            }
        };
        filtersMap.put(0, new StringDiffFilter(this.getColumnName(0), convertValueInterface, 0));
        filtersMap.put(1, new StringDiffFilter(this.getColumnName(1), convertValueInterface, 1));
    }

    @Override
    public boolean isLoaded() {
        return this.m_loaded;
    }

    @Override
    public int getLoadingPercentage() {
        if (this.m_loaded) {
            return 100;
        }
        return 0;
    }

    @Override
    public PlotType getBestPlotType() {
        return null;
    }

    @Override
    public int[] getBestColIndex(PlotType plotType) {
        return null;
    }

    @Override
    public String getExportRowCell(int row, int col) {
        return null;
    }

    @Override
    public ArrayList<ExportFontData> getExportFonts(int row, int col) {
        return null;
    }

    @Override
    public String getExportColumnName(int col) {
        return this.getColumnName(col);
    }
}

