/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;

class ScrollableMenu
extends JMenu {
    private final int scrollSpeed = 150;
    private Timer timerUp;
    private Timer timerDown;
    private int visibleItems;
    private int indexVisible;
    private JButton upButton;
    private JButton downButton;
    private List<JMenuItem> subMenus = new ArrayList<JMenuItem>();
    private double screenHeight;
    private double menuHeight;
    public static final Icon STANDARD_UP_ARROW = IconManager.getIcon(IconManager.IconType.ARROW_UP);
    public static final Icon STANDARD_DOWN_ARROW = IconManager.getIcon(IconManager.IconType.ARROW_DOWN);

    public ScrollableMenu() {
        this.init();
    }

    private void init() {
        this.timerUp = new Timer(150, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScrollableMenu.this.scrollUp();
            }
        });
        this.timerDown = new Timer(150, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScrollableMenu.this.scrollDown();
            }
        });
        this.screenHeight = 500.0;
        this.createButtons();
        this.hideButtons();
        this.subMenus.clear();
        this.indexVisible = 0;
        this.visibleItems = 0;
        this.menuHeight = 0.0;
    }

    @Override
    public JMenuItem add(JMenuItem menuItem) {
        this.add((Component)menuItem, this.subMenus.size() + 1);
        this.subMenus.add(menuItem);
        this.menuHeight += menuItem.getPreferredSize().getHeight();
        if (this.menuHeight > this.screenHeight) {
            menuItem.setVisible(false);
            this.downButton.setVisible(true);
        } else {
            ++this.visibleItems;
        }
        return menuItem;
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.init();
    }

    private void closeOpenedSubMenus() {
        int i;
        MenuSelectionManager manager = MenuSelectionManager.defaultManager();
        MenuElement[] path = manager.getSelectedPath();
        JPopupMenu popup = this.getPopupMenu();
        for (i = 0; i < path.length && path[i] != popup; ++i) {
        }
        MenuElement[] subPath = new MenuElement[i + 1];
        try {
            System.arraycopy(path, 0, subPath, 0, i + 1);
            manager.setSelectedPath(subPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void scrollUp() {
        this.closeOpenedSubMenus();
        if (this.indexVisible == 0) {
            this.upButton.setVisible(false);
            return;
        }
        --this.indexVisible;
        ((JComponent)this.subMenus.get(this.indexVisible + this.visibleItems)).setVisible(false);
        ((JComponent)this.subMenus.get(this.indexVisible)).setVisible(true);
        this.downButton.setVisible(true);
        if (this.indexVisible == 0) {
            this.upButton.setVisible(false);
        }
    }

    private void scrollDown() {
        this.closeOpenedSubMenus();
        if (this.indexVisible + this.visibleItems == this.subMenus.size()) {
            this.downButton.setVisible(false);
            return;
        }
        if (this.indexVisible + this.visibleItems > this.subMenus.size()) {
            return;
        }
        try {
            ((JComponent)this.subMenus.get(this.indexVisible)).setVisible(false);
            ((JComponent)this.subMenus.get(this.indexVisible + this.visibleItems)).setVisible(true);
            this.upButton.setVisible(true);
            ++this.indexVisible;
            if (this.indexVisible + this.visibleItems == this.subMenus.size()) {
                this.downButton.setVisible(false);
            }
        }
        catch (Exception eks) {
            eks.printStackTrace();
        }
    }

    private void createButtons() {
        this.upButton = new JButton(STANDARD_UP_ARROW);
        this.upButton.setBorderPainted(false);
        this.upButton.setFocusPainted(false);
        this.upButton.setRolloverEnabled(true);
        class Up
        extends MouseAdapter {
            Up() {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                try {
                    ScrollableMenu.this.timerUp.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                try {
                    ScrollableMenu.this.timerUp.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Up scrollUpListener = new Up();
        this.upButton.addMouseListener(scrollUpListener);
        this.add(this.upButton);
        this.downButton = new JButton(STANDARD_DOWN_ARROW);
        this.downButton.setBorderPainted(false);
        this.downButton.setFocusPainted(false);
        class Down
        extends MouseAdapter {
            Down() {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                try {
                    ScrollableMenu.this.timerDown.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                try {
                    ScrollableMenu.this.timerDown.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Down scrollDownListener = new Down();
        this.downButton.addMouseListener(scrollDownListener);
        this.add(this.downButton);
    }

    public void hideButtons() {
        this.upButton.setVisible(false);
        this.downButton.setVisible(false);
    }
}

