/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.table;

import fr.proline.studio.table.DecoratedTable;
import fr.proline.studio.table.TablePopupMenu;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public class TablePopupMouseAdapter
extends MouseAdapter {
    private final DecoratedTable m_table;

    public TablePopupMouseAdapter(DecoratedTable table) {
        this.m_table = table;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            int row;
            int[] selectedRows = this.m_table.getSelectedRows();
            int nbSelectedRows = selectedRows.length;
            if (nbSelectedRows == 0) {
                row = this.m_table.rowAtPoint(e.getPoint());
                if (row != -1) {
                    this.m_table.getSelectionModel().setSelectionInterval(row, row);
                }
            } else if (nbSelectedRows == 1) {
                row = this.m_table.rowAtPoint(e.getPoint());
                if (row != -1 && (e.isShiftDown() || e.isControlDown())) {
                    this.m_table.getSelectionModel().addSelectionInterval(row, row);
                } else if (row != -1 && row != selectedRows[0]) {
                    this.m_table.getSelectionModel().setSelectionInterval(row, row);
                }
            } else if ((e.isShiftDown() || e.isControlDown()) && (row = this.m_table.rowAtPoint(e.getPoint())) != -1) {
                this.m_table.getSelectionModel().addSelectionInterval(row, row);
            }
            TablePopupMenu popup = this.m_table.getTablePopup();
            if (popup != null) {
                this.m_table.prepostPopupMenu();
                popup.show(e.getX(), e.getY(), (JTable)((Object)this.m_table));
            }
        }
    }
}

