/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ontology.obo;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.biojava.nbio.ontology.Synonym;
import org.biojava.nbio.ontology.obo.NestedValue;
import org.biojava.nbio.ontology.obo.OboFileEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OboFileParser {
    private static final Logger logger = LoggerFactory.getLogger(OboFileParser.class);
    List<OboFileEventListener> listeners;
    protected String line;
    protected int linenum = 0;
    protected int totalSize = 0;
    protected int bytesRead = 0;
    protected StringBuffer tempBuffer = new StringBuffer();
    protected SimpleDateFormat dateFormat = new SimpleDateFormat("dd:MM:yyyy HH:mm", Locale.US);
    protected static final Map<Character, Character> escapeChars = new HashMap<Character, Character>();
    protected static final Map<Character, Character> unescapeChars = new HashMap<Character, Character>();

    public OboFileParser() {
        this.listeners = new ArrayList<OboFileEventListener>();
    }

    public void addOboFileEventListener(OboFileEventListener listener) {
        this.listeners.add(listener);
    }

    public List<OboFileEventListener> getOboFileEventListener() {
        return this.listeners;
    }

    public void parseOBO(BufferedReader oboFile) throws IOException {
        String line;
        while ((line = oboFile.readLine()) != null) {
            int valueStopIndex;
            int i;
            if (line.length() == 0) continue;
            if (line.charAt(0) == '[') {
                if (line.charAt(line.length() - 1) != ']') {
                    throw new IOException("Unclosed stanza: \"" + line + "\"");
                }
                String stanzaname = line.substring(1, line.length() - 1);
                if (stanzaname.length() < 1) {
                    throw new IOException("Empty stanza: \"" + line + "\"");
                }
                String currentStanza = stanzaname;
                this.triggerNewStanza(currentStanza);
                continue;
            }
            SOPair pair = this.unescape(line, ':', 0, true);
            String name = pair.str;
            int lineEnd = OboFileParser.findUnescaped(line, '!', 0, line.length(), true);
            if (lineEnd == -1) {
                lineEnd = line.length();
            }
            NestedValue nv = null;
            int trailingStartIndex = -1;
            int trailingEndIndex = -1;
            for (i = lineEnd - 1; i >= 0; --i) {
                if (Character.isWhitespace(line.charAt(i))) continue;
                if (line.charAt(i) != '}') break;
                if (i >= 1 && line.charAt(i - 1) == '\\') continue;
                trailingEndIndex = i;
                break;
            }
            if (trailingEndIndex != -1) {
                for (i = trailingEndIndex - 1; i >= 0; --i) {
                    if (line.charAt(i) != '{' || i >= 1 && line.charAt(i - 1) == '\\') continue;
                    trailingStartIndex = i + 1;
                }
            }
            if (trailingStartIndex == -1 && trailingEndIndex != -1) {
                throw new IOException("Unterminated trailing modifier. " + line);
            }
            if (trailingStartIndex != -1) {
                valueStopIndex = trailingStartIndex - 1;
                String trailing = line.substring(trailingStartIndex, trailingEndIndex).trim();
                nv = new NestedValue();
                this.getNestedValue(nv, trailing, 0);
            } else {
                valueStopIndex = lineEnd;
            }
            String value = line.substring(pair.index + 1, valueStopIndex).trim();
            if (value.length() == 0) {
                throw new IOException("Tag found with no value " + line);
            }
            if (this.isSynonym(name)) {
                Synonym synonym = this.parseSynonym(name, value);
                this.triggerNewSynonym(synonym);
                continue;
            }
            this.triggerNewKey(name, value);
        }
    }

    private boolean isSynonym(String key) {
        return key.equals("synonym") || key.equals("exact_synonym");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Synonym parseSynonym(String key, String value) throws IOException {
        Map<String, Object>[] refs;
        int startIndex = OboFileParser.findUnescaped(value, '\"', 0, value.length());
        if (startIndex == -1) {
            throw new IOException("Expected \"" + this.line + " " + this.linenum);
        }
        SOPair p = this.unescape(value, '\"', startIndex + 1, value.length(), true);
        int defIndex = OboFileParser.findUnescaped(value, '[', p.index, value.length());
        if (defIndex == -1) {
            throw new IOException("Badly formatted synonym. No dbxref list found." + this.line + " " + this.linenum);
        }
        String leftovers = value.substring(p.index + 1, defIndex).trim();
        StringTokenizer tokenizer = new StringTokenizer(leftovers, " \t");
        int scope = 0;
        if (key.equals("exact_synonym")) {
            scope = 1;
        } else if (key.equals("broad_synonym")) {
            scope = 3;
        } else if (key.equals("narrow_synonym")) {
            scope = 2;
        }
        String catID = null;
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (i == 0) {
                if (token.equals("RELATED")) {
                    scope = 0;
                } else if (token.equals("UNSPECIFIED")) {
                    scope = 0;
                } else if (token.equals("EXACT")) {
                    scope = 1;
                } else if (token.equals("BROAD")) {
                    scope = 3;
                } else {
                    if (!token.equals("NARROW")) throw new IOException("Found unexpected scope identifier " + token + this.line);
                    scope = 2;
                }
            } else {
                if (i != true) throw new IOException("Expected dbxref list, instead found " + token + this.line);
                catID = token;
            }
            ++i;
        }
        Synonym synonym = new Synonym();
        synonym.setScope(scope);
        synonym.setCategory(catID);
        synonym.setName(p.str);
        for (Map<String, Object> ref : refs = this.getDbxrefList(value, defIndex + 1, value.length())) {
            String xref = (String)ref.get("xref");
            String desc = (String)ref.get("desc");
            NestedValue nestedValue = (NestedValue)ref.get("nv");
        }
        return synonym;
    }

    protected Map<String, Object>[] getDbxrefList(String line, int startoffset, int endoffset) throws IOException {
        Vector<Map<String, Object>> temp = new Vector<Map<String, Object>>();
        boolean stop = false;
        while (!stop) {
            Map<String, Object> pair;
            int braceIndex = OboFileParser.findUnescaped(line, '{', startoffset, endoffset);
            int endIndex = OboFileParser.findUnescaped(line, ',', startoffset, endoffset, true);
            boolean trailing = false;
            if (endIndex == -1) {
                endIndex = OboFileParser.findUnescaped(line, ']', startoffset, endoffset, true);
                if (endIndex == -1) {
                    throw new IOException("Unterminated xref list " + line);
                }
                stop = true;
            }
            if (braceIndex != -1 && braceIndex < endIndex) {
                endIndex = braceIndex;
                trailing = true;
            }
            if ((pair = this.parseXref(line, startoffset, endIndex)) == null) {
                ++startoffset;
                continue;
            }
            NestedValue nv = null;
            if (trailing) {
                nv = new NestedValue();
                if ((endIndex = this.getNestedValue(nv, line, endIndex + 1)) == -1) {
                    throw new IOException("Badly formatted trailing properties " + line);
                }
                pair.put("nv", nv);
            }
            temp.add(pair);
            startoffset = endIndex + 1;
        }
        HashMap[] out = new HashMap[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            Map pair = (Map)temp.get(i);
            out[i] = pair;
        }
        return out;
    }

    protected Map<String, Object> parseXref(String line, int startoffset, int endoffset) throws IOException {
        String xref_str = null;
        String desc_str = null;
        SOPair xref = this.unescape(line, '\"', startoffset, endoffset, false);
        xref_str = xref.str.trim();
        if (xref_str.length() == 0) {
            return null;
        }
        if (xref.index != -1) {
            SOPair desc = this.unescape(line, '\"', xref.index + 1, endoffset, true);
            desc_str = desc.str.trim();
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("xref", xref_str);
        m.put("desc", desc_str);
        return m;
    }

    private void triggerNewStanza(String stanza) {
        for (OboFileEventListener li : this.listeners) {
            li.newStanza(stanza);
        }
    }

    private void triggerNewKey(String key, String value) {
        for (OboFileEventListener li : this.listeners) {
            li.newKey(key, value);
        }
    }

    private void triggerNewSynonym(Synonym synonym) {
        for (OboFileEventListener li : this.listeners) {
            li.newSynonym(synonym);
        }
    }

    public static String escape(String str, boolean escapespaces) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            Character o = unescapeChars.get(new Character(c));
            if (o == null) {
                out.append(c);
                continue;
            }
            if (escapespaces || !escapespaces && c != ' ' && c != '\t') {
                out.append("\\").append(o);
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public String unescape(String str) throws IOException {
        return this.unescape((String)str, (char)'\u0000', (int)0, (int)str.length(), (boolean)false).str;
    }

    public SOPair unescape(String str, char toChar, int startindex, boolean mustFindChar) throws IOException {
        return this.unescape(str, toChar, startindex, str.length(), mustFindChar);
    }

    public SOPair unescape(String str, char toChar, int startindex, int endindex, boolean mustFindChar) throws IOException {
        StringBuffer out = new StringBuffer();
        int endValue = -1;
        for (int i = startindex; i < endindex; ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                Character mapchar;
                if ((mapchar = escapeChars.get(new Character(c = str.charAt(++i)))) == null) {
                    throw new IOException("Unrecognized escape character " + c + " found.");
                }
                out.append(mapchar);
                continue;
            }
            if (c == toChar) {
                endValue = i;
                break;
            }
            out.append(c);
        }
        if (endValue == -1 && mustFindChar) {
            throw new IOException("Expected " + toChar + "." + str);
        }
        return new SOPair(out.toString(), endValue);
    }

    public static int findUnescaped(String str, char toChar) {
        return OboFileParser.findUnescaped(str, toChar, 0, str.length());
    }

    public static int findUnescaped(String str, char toChar, int startIndex, int endIndex) {
        return OboFileParser.findUnescaped(str, toChar, startIndex, endIndex, false);
    }

    public static int findUnescaped(String str, char toChar, int startindex, int endindex, boolean honorQuotes) {
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        for (int i = startindex; i < endindex; ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                ++i;
                continue;
            }
            if (inQuotes) {
                if (c != quoteChar) continue;
                inQuotes = false;
                continue;
            }
            if (c == toChar) {
                return i;
            }
            if (!honorQuotes || !OboFileParser.isQuote(c)) continue;
            inQuotes = true;
            quoteChar = c;
        }
        return -1;
    }

    public static boolean isEscapeStarter(char c) {
        return c == '\\';
    }

    public static boolean isQuote(char c) {
        return c == '\"';
    }

    protected StringBuffer getTempBuffer() {
        this.tempBuffer.delete(0, this.tempBuffer.length());
        return this.tempBuffer;
    }

    protected SOPair readQuotedString(String value, int startIndex, int stopIndex, char terminatingChar, boolean requireQuotes, boolean legalEndOfLine) throws IOException {
        int i;
        char quoteChar = '\u0000';
        StringBuffer out = this.getTempBuffer();
        boolean useQuotes = false;
        for (i = startIndex; i < stopIndex; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            if (!OboFileParser.isQuote(value.charAt(i))) {
                if (requireQuotes) {
                    throw new IOException("Expected start of quoted string. " + this.line + " " + value + " at linenr " + this.linenum);
                }
                useQuotes = false;
                break;
            }
            useQuotes = true;
            quoteChar = value.charAt(i);
            ++i;
            break;
        }
        while (i < stopIndex) {
            if (OboFileParser.isEscapeStarter(value.charAt(i))) {
                if (++i >= value.length()) {
                    throw new IOException("Incomplete escape sequence. " + this.line);
                }
                out.append(value.charAt(i));
            } else {
                if (useQuotes && value.charAt(i) == quoteChar || !useQuotes && value.charAt(i) == terminatingChar) {
                    if (!useQuotes) {
                        return new SOPair(out.toString().trim(), startIndex, i - 1);
                    }
                    return new SOPair(out.toString(), startIndex, i);
                }
                out.append(value.charAt(i));
            }
            ++i;
        }
        if (!useQuotes && legalEndOfLine) {
            return new SOPair(out.toString().trim(), startIndex, i);
        }
        throw new IOException("Unterminated quoted string. " + this.line);
    }

    protected int getNestedValue(NestedValue nv, String str, int startIndex) throws IOException {
        block0: while (startIndex < str.length()) {
            int equalsIndex = OboFileParser.findUnescaped(str, '=', startIndex, str.length());
            if (equalsIndex == -1) {
                throw new IOException("Expected = in trailing modifier " + this.line);
            }
            String name = str.substring(startIndex, equalsIndex).trim();
            SOPair value = this.readQuotedString(str, equalsIndex + 1, str.length(), ',', false, true);
            Properties pv = new Properties();
            pv.setProperty(this.unescape(name), value.str);
            nv.addPropertyValue(pv);
            for (startIndex = value.endIndex + 1; startIndex < str.length(); ++startIndex) {
                if (Character.isWhitespace(str.charAt(startIndex))) continue;
                if (str.charAt(startIndex) == ',') {
                    ++startIndex;
                    continue block0;
                }
                logger.error("found character |{}|", (Object)Character.valueOf(str.charAt(startIndex)));
                throw new IOException("Expected comma in trailing modifier. " + this.line + " linenr: " + this.linenum);
            }
        }
        return str.length();
    }

    static {
        escapeChars.put(new Character('n'), new Character('\n'));
        escapeChars.put(new Character('W'), new Character(' '));
        escapeChars.put(new Character('t'), new Character('\t'));
        escapeChars.put(new Character(':'), new Character(':'));
        escapeChars.put(new Character(','), new Character(','));
        escapeChars.put(new Character('\"'), new Character('\"'));
        escapeChars.put(new Character('\''), new Character('\''));
        escapeChars.put(new Character('\\'), new Character('\\'));
        escapeChars.put(new Character('{'), new Character('{'));
        escapeChars.put(new Character('}'), new Character('}'));
        escapeChars.put(new Character('('), new Character('('));
        escapeChars.put(new Character(')'), new Character(')'));
        escapeChars.put(new Character('['), new Character('['));
        escapeChars.put(new Character(']'), new Character(']'));
        escapeChars.put(new Character('!'), new Character('!'));
        for (Character key : escapeChars.keySet()) {
            Character value = escapeChars.get(key);
            unescapeChars.put(value, key);
        }
    }

    public static class SOPair {
        public String str = null;
        public int index = -1;
        public int endIndex = -1;

        public SOPair(String str, int index) {
            this(str, index, -1);
        }

        public SOPair(String str, int index, int endIndex) {
            this.str = str;
            this.index = index;
            this.endIndex = endIndex;
        }
    }
}

