/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.internal.operators;

import com.github.davidmoten.rtree.internal.util.BoundedPriorityQueue;
import java.util.Comparator;
import java.util.List;
import rx.Observable;
import rx.Subscriber;

public final class OperatorBoundedPriorityQueue<T>
implements Observable.Operator<T, T> {
    private final int maximumSize;
    private final Comparator<? super T> comparator;

    public OperatorBoundedPriorityQueue(int maximumSize, Comparator<? super T> comparator) {
        this.maximumSize = maximumSize;
        this.comparator = comparator;
    }

    public Subscriber<? super T> call(final Subscriber<? super T> child) {
        final BoundedPriorityQueue<? super T> q = new BoundedPriorityQueue<T>(this.maximumSize, this.comparator);
        return new Subscriber<T>(child){

            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            public void onCompleted() {
                List list = q.asOrderedList();
                for (Object t : list) {
                    if (this.isUnsubscribed()) {
                        return;
                    }
                    child.onNext(t);
                }
                if (!this.isUnsubscribed()) {
                    child.onCompleted();
                }
            }

            public void onError(Throwable t) {
                if (!this.isUnsubscribed()) {
                    child.onError(t);
                }
            }

            public void onNext(T t) {
                if (!this.isUnsubscribed()) {
                    q.add(t);
                }
            }
        };
    }
}

