/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree.internal.util;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;

public final class BoundedPriorityQueue<T> {
    private final PriorityQueue<T> queue;
    private final Comparator<? super T> comparator;
    private final int maxSize;

    public BoundedPriorityQueue(int maxSize, Comparator<? super T> comparator) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (String)"maxSize must be > 0");
        Preconditions.checkNotNull(comparator, (String)"comparator cannot be null");
        this.queue = new PriorityQueue<T>(BoundedPriorityQueue.reverse(comparator));
        this.comparator = comparator;
        this.maxSize = maxSize;
    }

    private static <T> Comparator<T> reverse(Comparator<T> comparator) {
        return (o1, o2) -> comparator.compare(o2, o1);
    }

    public static <T> BoundedPriorityQueue<T> create(int maxSize, Comparator<? super T> comparator) {
        return new BoundedPriorityQueue<T>(maxSize, comparator);
    }

    public void add(T t) {
        if (t == null) {
            throw new NullPointerException("cannot add null to the queue");
        }
        if (this.queue.size() >= this.maxSize) {
            T maxElement = this.queue.peek();
            if (this.comparator.compare(maxElement, t) < 1) {
                return;
            }
            this.queue.poll();
        }
        this.queue.add(t);
    }

    public List<T> asList() {
        return Collections.unmodifiableList(new ArrayList<T>(this.queue));
    }

    public List<T> asOrderedList() {
        ArrayList<T> list = new ArrayList<T>(this.queue);
        list.sort(this.comparator);
        return list;
    }
}

