/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.Internal;
import com.almworks.sqlite4java.SQLiteBusyException;
import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteController;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SWIGTYPE_p_sqlite3_backup;
import com.almworks.sqlite4java._SQLiteSwigged;

public class SQLiteBackup {
    private final SQLiteConnection mySource;
    private final SQLiteConnection myDestination;
    private SWIGTYPE_p_sqlite3_backup myHandle;
    private SQLiteController myDestinationController;
    private SQLiteController mySourceController;
    private boolean myFinished;

    SQLiteBackup(SQLiteController sourceController, SQLiteController destinationController, SWIGTYPE_p_sqlite3_backup handle, SQLiteConnection source, SQLiteConnection destination) {
        this.mySourceController = sourceController;
        this.myDestinationController = destinationController;
        this.myHandle = handle;
        this.myDestination = destination;
        this.mySource = source;
        Internal.logFine(this, "instantiated");
    }

    public boolean backupStep(int pagesToBackup) throws SQLiteException, SQLiteBusyException {
        this.mySource.checkThread();
        this.myDestination.checkThread();
        if (this.myFinished) {
            Internal.logWarn(this, "already finished");
            return true;
        }
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "backupStep(" + pagesToBackup + ")");
        }
        SWIGTYPE_p_sqlite3_backup handle = this.handle();
        int rc = _SQLiteSwigged.sqlite3_backup_step(handle, pagesToBackup);
        this.throwResult(rc, "backupStep failed");
        if (rc == 101) {
            if (Internal.isFineLogging()) {
                Internal.logFine(this, "finished");
            }
            this.myFinished = true;
        }
        return this.myFinished;
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    public SQLiteConnection getDestinationConnection() {
        return this.myDestination;
    }

    public void dispose(boolean disposeDestination) {
        try {
            this.mySourceController.validate();
            this.myDestinationController.validate();
        }
        catch (SQLiteException e) {
            Internal.recoverableError(this, "invalid dispose: " + e, true);
            return;
        }
        Internal.logFine(this, "disposing");
        SWIGTYPE_p_sqlite3_backup handle = this.myHandle;
        if (handle != null) {
            _SQLiteSwigged.sqlite3_backup_finish(handle);
            this.myHandle = null;
            this.mySourceController = SQLiteController.getDisposed(this.mySourceController);
            this.myDestinationController = SQLiteController.getDisposed(this.myDestinationController);
        }
        if (disposeDestination) {
            this.myDestination.dispose();
        }
    }

    public void dispose() {
        this.dispose(true);
    }

    public int getPageCount() throws SQLiteException {
        this.mySourceController.validate();
        this.myDestinationController.validate();
        SWIGTYPE_p_sqlite3_backup handle = this.handle();
        return _SQLiteSwigged.sqlite3_backup_pagecount(handle);
    }

    public int getRemaining() throws SQLiteException {
        this.mySourceController.validate();
        this.myDestinationController.validate();
        SWIGTYPE_p_sqlite3_backup handle = this.handle();
        return _SQLiteSwigged.sqlite3_backup_remaining(handle);
    }

    public String toString() {
        return "Backup [" + this.mySource + " -> " + this.myDestination + "]";
    }

    private SWIGTYPE_p_sqlite3_backup handle() throws SQLiteException {
        SWIGTYPE_p_sqlite3_backup handle = this.myHandle;
        if (handle == null) {
            throw new SQLiteException(-113, null);
        }
        return handle;
    }

    private void throwResult(int rc, String operation) throws SQLiteException {
        if (rc == 101) {
            return;
        }
        this.myDestination.throwResult(rc, operation);
    }
}

