/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms;

import jwave.exceptions.JWaveException;
import jwave.tools.MathToolKit;
import jwave.transforms.BasicTransform;

public class AncientEgyptianDecomposition
extends BasicTransform {
    protected BasicTransform _basicTransform;
    private int _initialWaveletSpaceSize;

    public AncientEgyptianDecomposition(BasicTransform basicTransform) {
        this._basicTransform = basicTransform;
        this._initialWaveletSpaceSize = 0;
    }

    public AncientEgyptianDecomposition(BasicTransform waveTransform, int initialWaveletSpaceSize) {
        this._basicTransform = waveTransform;
        this._initialWaveletSpaceSize = initialWaveletSpaceSize;
    }

    @Override
    public double[] forward(double[] arrTime) throws JWaveException {
        double[] arrHilb = new double[arrTime.length];
        int[] ancientEgyptianMultipliers = null;
        ancientEgyptianMultipliers = MathToolKit.decompose(arrTime.length);
        int offSet = 0;
        for (int m = 0; m < ancientEgyptianMultipliers.length; ++m) {
            int ancientEgyptianMultiplier = ancientEgyptianMultipliers[m];
            int arrTimeSubLength = (int)MathToolKit.scalb(1.0, ancientEgyptianMultiplier);
            double[] arrTimeSub = new double[arrTimeSubLength];
            for (int i = 0; i < arrTimeSub.length; ++i) {
                arrTimeSub[i] = arrTime[i + offSet];
            }
            double[] arrHilbSub = this._basicTransform.forward(arrTimeSub);
            for (int i = 0; i < arrHilbSub.length; ++i) {
                arrHilb[i + offSet] = arrHilbSub[i];
            }
            offSet += arrHilbSub.length;
        }
        return arrHilb;
    }

    @Override
    public double[] reverse(double[] arrHilb) throws JWaveException {
        double[] arrTime = new double[arrHilb.length];
        int[] ancientEgyptianMultipliers = null;
        try {
            ancientEgyptianMultipliers = MathToolKit.decompose(arrHilb.length);
        }
        catch (JWaveException e) {
            e.printStackTrace();
        }
        int offSet = 0;
        for (int m = 0; m < ancientEgyptianMultipliers.length; ++m) {
            int ancientEgyptianMultiplier = ancientEgyptianMultipliers[m];
            int arrHilbSubLength = (int)MathToolKit.scalb(1.0, ancientEgyptianMultiplier);
            double[] arrHilbSub = new double[arrHilbSubLength];
            for (int i = 0; i < arrHilbSub.length; ++i) {
                arrHilbSub[i] = arrHilb[i + offSet];
            }
            double[] arrTimeSub = this._basicTransform.reverse(arrHilbSub);
            for (int i = 0; i < arrTimeSub.length; ++i) {
                arrTime[i + offSet] = arrTimeSub[i];
            }
            offSet += arrHilbSub.length;
        }
        return arrTime;
    }
}

