/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms;

import jwave.exceptions.JWaveException;
import jwave.exceptions.JWaveFailure;
import jwave.transforms.BasicTransform;
import jwave.transforms.wavelets.Wavelet;

public abstract class WaveletTransform
extends BasicTransform {
    protected Wavelet _wavelet;

    protected WaveletTransform(Wavelet wavelet) {
        this._wavelet = wavelet;
    }

    @Override
    public Wavelet getWavelet() {
        return this._wavelet;
    }

    @Override
    public double[] forward(double[] arrTime) throws JWaveException {
        if (!this.isBinary(arrTime.length)) {
            throw new JWaveFailure("WaveletTransform#forward - given array length is not 2^p | p \u20ac N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int maxLevel = this.calcExponent(arrTime.length);
        return this.forward(arrTime, maxLevel);
    }

    @Override
    public double[] reverse(double[] arrHilb) throws JWaveException {
        if (!this.isBinary(arrHilb.length)) {
            throw new JWaveFailure("WaveletTransform#reverse - given array length is not 2^p | p \u20ac N ... = 1, 2, 4, 8, 16, 32, .. please use the Ancient Egyptian Decomposition for any other array length!");
        }
        int maxLevel = this.calcExponent(arrHilb.length);
        return this.reverse(arrHilb, maxLevel);
    }

    @Override
    public double[][] decompose(double[] arrTime) throws JWaveException {
        int length = arrTime.length;
        int levels = this.calcExponent(length);
        double[][] matDeComp = new double[levels + 1][length];
        for (int p = 0; p <= levels; ++p) {
            System.arraycopy(this.forward(arrTime, p), 0, matDeComp[p], 0, length);
        }
        return matDeComp;
    }

    @Override
    public double[] recompose(double[][] matDeComp, int level) throws JWaveException {
        if (level < 0 || level >= matDeComp.length) {
            throw new JWaveFailure("WaveletTransform#recompose - given level is out of range");
        }
        return this.reverse(matDeComp[level], level);
    }
}

