/*
 * Decompiled with CFR 0.152.
 */
package jwave.transforms.wavelets.haar;

import jwave.transforms.wavelets.Wavelet;

public class Haar1Orthogonal
extends Wavelet {
    public Haar1Orthogonal() {
        this._name = "Haar orthogonal";
        this._transformWavelength = 2;
        this._motherWavelength = 2;
        this._scalingDeCom = new double[this._motherWavelength];
        this._scalingDeCom[0] = 1.0;
        this._scalingDeCom[1] = 1.0;
        this._waveletDeCom = new double[this._motherWavelength];
        this._waveletDeCom[0] = this._scalingDeCom[1];
        this._waveletDeCom[1] = -this._scalingDeCom[0];
        this._scalingReCon = new double[this._motherWavelength];
        this._waveletReCon = new double[this._motherWavelength];
        for (int i = 0; i < this._motherWavelength; ++i) {
            this._scalingReCon[i] = this._scalingDeCom[i];
            this._waveletReCon[i] = this._waveletDeCom[i];
        }
    }

    @Override
    public double[] reverse(double[] arrHilb, int arrHilbLength) {
        double[] arrTime = new double[arrHilbLength];
        for (int i = 0; i < arrTime.length; ++i) {
            arrTime[i] = 0.0;
        }
        int h = arrTime.length >> 1;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < this._motherWavelength; ++j) {
                int k;
                for (k = i * 2 + j; k >= arrTime.length; k -= arrTime.length) {
                }
                int n = k;
                arrTime[n] = arrTime[n] + 0.5 * (arrHilb[i] * this._scalingReCon[j] + arrHilb[i + h] * this._waveletReCon[j]);
            }
        }
        return arrTime;
    }
}

