/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.NavException;
import com.ximpleware.NodeTest;
import com.ximpleware.VTDNav;
import com.ximpleware.xpath.Predicate;

public class Step {
    public int axis_type;
    public NodeTest nt;
    public Predicate p;
    public Predicate pt;
    public Step nextS;
    public Step prevS;
    public Object o;
    public boolean ft;
    public boolean hasPredicate;
    public boolean nt_eval;
    public boolean out_of_range;

    public Step() {
        this.nextS = this.prevS = (Step)null;
        this.pt = null;
        this.p = null;
        this.nt = null;
        this.ft = true;
        this.hasPredicate = false;
        this.nt_eval = false;
        this.out_of_range = false;
    }

    public final void reset(VTDNav vn) {
        this.ft = true;
        if (this.hasPredicate) {
            this.resetP(vn);
        }
    }

    public final void resetP(VTDNav vn) {
        Predicate temp = this.p;
        while (temp != null) {
            temp.reset(vn);
            temp = temp.nextP;
        }
    }

    public final void setStep4Predicates() {
        Predicate temp = this.p;
        while (temp != null) {
            temp.s = this;
            temp = temp.nextP;
        }
    }

    public final void resetP(VTDNav vn, Predicate p1) {
        Predicate temp = this.p;
        while (temp != p1) {
            temp.reset(vn);
            temp = temp.nextP;
        }
    }

    public final void adjust(int n) {
        Predicate temp = this.p;
        while (temp != null) {
            temp.adjust(n);
            temp = temp.nextP;
        }
    }

    public final NodeTest getNodeTest() {
        return this.nt;
    }

    public final Step getNextStep() {
        return this.nextS;
    }

    public final void setNextStep(Step s) {
        this.nextS = s;
    }

    public final boolean get_ft() {
        return this.ft;
    }

    public final void set_ft(boolean b) {
        this.ft = b;
    }

    public final Step getPrevStep() {
        return this.prevS;
    }

    public final void setPrevStep(Step s) {
        this.prevS = s;
    }

    public final void setNodeTest(NodeTest n) {
        this.nt = n;
        if (this.axis_type == 1 && n.testType == 0) {
            this.axis_type = 0;
        } else if (this.axis_type == 7 && n.testType == 0) {
            this.axis_type = 3;
        } else if (this.axis_type == 6 && n.testType == 0) {
            this.axis_type = 2;
        } else if (this.axis_type == 9 && n.testType == 0) {
            this.axis_type = 5;
        } else if (this.axis_type == 8 && n.testType == 0) {
            this.axis_type = 4;
        } else if (this.axis_type == 14 && n.testType == 0) {
            this.axis_type = 15;
        } else if (this.axis_type == 16 && n.testType == 0) {
            this.axis_type = 17;
        }
        if (n.testType == 1 || n.testType == 0 && n.nodeName.equals("*")) {
            this.nt_eval = true;
        }
    }

    public final void setPredicate(Predicate p1) {
        if (this.p == null) {
            this.p = this.pt = p1;
        } else {
            this.pt = this.pt.nextP = p1;
        }
        this.setStep4Predicates();
        if (p1 != null) {
            this.hasPredicate = true;
        }
    }

    public final boolean eval(VTDNav vn) throws NavException {
        return this.nt.eval(vn) && (!this.hasPredicate || this.evalPredicates(vn));
    }

    public final boolean eval2(VTDNav vn) throws NavException {
        return this.nt.eval2(vn) && (!this.hasPredicate || this.evalPredicates(vn));
    }

    public final boolean eval(VTDNav vn, Predicate p) throws NavException {
        return this.nt.eval(vn) && this.evalPredicates(vn, p);
    }

    public final boolean eval2(VTDNav vn, Predicate p) throws NavException {
        return this.nt.eval2(vn) && this.evalPredicates(vn, p);
    }

    public final boolean evalPredicates(VTDNav vn) throws NavException {
        Predicate temp = this.p;
        while (temp != null) {
            if (!temp.eval(vn)) {
                return false;
            }
            temp = temp.nextP;
        }
        return true;
    }

    public final boolean evalPredicates(VTDNav vn, Predicate p) throws NavException {
        Predicate temp = this.p;
        while (temp != p) {
            if (!temp.eval(vn)) {
                return false;
            }
            temp = temp.nextP;
        }
        return true;
    }

    public final void setAxisType(int st) {
        this.axis_type = st;
    }

    public final String toString() {
        String s = this.p == null ? this.axisName(this.axis_type) + this.nt : this.axisName(this.axis_type) + this.nt + " " + this.p;
        if (this.nextS == null) {
            return s;
        }
        return s + "/" + this.nextS.toString();
    }

    public final String axisName(int i) {
        switch (i) {
            case 0: 
            case 1: {
                return "child::";
            }
            case 2: {
                return "descendant-or-self::";
            }
            case 3: {
                return "descendant::";
            }
            case 4: {
                return "preceding::";
            }
            case 5: {
                return "following::";
            }
            case 6: {
                return "descendant-or-self::";
            }
            case 7: {
                return "descendant::";
            }
            case 8: {
                return "preceding::";
            }
            case 9: {
                return "following::";
            }
            case 10: {
                return "parent::";
            }
            case 11: {
                return "ancestor::";
            }
            case 12: {
                return "ancestor-or-self::";
            }
            case 13: {
                return "self::";
            }
            case 14: {
                return "following-sibling::";
            }
            case 15: {
                return "following-sibling::";
            }
            case 16: {
                return "preceding-sibling::";
            }
            case 17: {
                return "preceding-sibling::";
            }
            case 18: {
                return "attribute::";
            }
        }
        return "namespace::";
    }
}

