/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.xpath;

import com.ximpleware.Expr;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;

public class UnaryExpr
extends Expr {
    public int op;
    public Expr operand;

    public UnaryExpr(int o, Expr e) {
        this.op = o;
        this.operand = e;
    }

    public final String toString() {
        return "-" + this.operand;
    }

    public final boolean evalBoolean(VTDNav vn) {
        return this.operand.evalBoolean(vn);
    }

    public final double evalNumber(VTDNav vn) {
        return -1.0 * this.operand.evalNumber(vn);
    }

    public final int evalNodeSet(VTDNav vn) throws XPathEvalException {
        throw new XPathEvalException("UnaryExpr can't eval to a node set!");
    }

    public final String evalString(VTDNav vn) {
        double dval = this.operand.evalNumber(vn);
        if (dval == (double)((int)dval)) {
            return "" + (int)dval;
        }
        return "" + dval;
    }

    public final void reset(VTDNav vn) {
        this.operand.reset(vn);
    }

    public final boolean isNodeSet() {
        return false;
    }

    public final boolean isNumerical() {
        return true;
    }

    public final boolean isString() {
        return false;
    }

    public final boolean isBoolean() {
        return false;
    }

    public final boolean requireContextSize() {
        return this.operand.requireContextSize();
    }

    public final void setContextSize(int size) {
        this.operand.setContextSize(size);
    }

    public final void setPosition(int pos) {
        this.operand.setPosition(pos);
    }

    public final int adjust(int n) {
        return 0;
    }

    public final boolean isFinal() {
        return this.operand.isFinal();
    }

    public final void markCacheable() {
        this.operand.markCacheable();
    }

    public final void markCacheable2() {
        this.operand.markCacheable2();
    }

    public final void clearCache() {
        this.operand.clearCache();
    }
}

