/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.bruker.timstof.io;

import fr.profi.bruker.timstof.TDFLibrary;
import fr.profi.bruker.timstof.TDFNativeLibrariesFactory;
import fr.profi.bruker.timstof.io.TDFMetadataReader;
import fr.profi.bruker.timstof.model.AbstractTimsFrame;
import fr.profi.bruker.timstof.model.Precursor;
import fr.profi.bruker.timstof.model.TimsPASEFFrame;
import fr.profi.bruker.timstof.util.ArraysUtil;
import it.unimi.dsi.fastutil.doubles.Double2FloatMap;
import it.unimi.dsi.fastutil.doubles.Double2FloatOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimstofReader {
    private static final Logger LOG = LoggerFactory.getLogger(TimstofReader.class);
    private static TDFLibrary m_tdfLib;
    private static TimstofReader m_instance;
    private static Long2ObjectMap<File> m_ttFilesByHandle;
    private static Long2ObjectMap<TDFMetadataReader> m_cachedMetaReaderByHandle;

    public static TimstofReader getTimstofReader() {
        if (m_instance == null) {
            m_tdfLib = TDFNativeLibrariesFactory.loadAndGetNativeLibraries();
            m_instance = new TimstofReader();
            m_ttFilesByHandle = new Long2ObjectOpenHashMap();
            m_cachedMetaReaderByHandle = new Long2ObjectOpenHashMap();
        }
        return m_instance;
    }

    private TimstofReader() {
    }

    public Long openTimstofFile(File f) throws IllegalArgumentException {
        long handle = m_tdfLib.tims_open(f.getAbsolutePath(), 0L);
        LOG.info(" Open file " + f.getAbsolutePath() + ", handle= " + handle);
        if (handle == 0L) {
            byte[] errorBuffer = new byte[64];
            long len = m_tdfLib.tims_get_last_error_string(errorBuffer, errorBuffer.length);
            StringBuilder errMsg = new StringBuilder(new String(errorBuffer, StandardCharsets.UTF_8));
            if (len > 64L) {
                errMsg.append("...");
            }
            LOG.error("TimsToff errorBuffer " + errMsg.toString());
            throw new IllegalArgumentException(errMsg.toString());
        }
        m_ttFilesByHandle.put(handle, (Object)f);
        return handle;
    }

    public void closeTimstofFile(long fileHandle) {
        m_ttFilesByHandle.remove(fileHandle);
        m_cachedMetaReaderByHandle.remove(fileHandle);
        m_tdfLib.tims_close(fileHandle);
    }

    private void checkFileHandle(long fileHandle) {
        if (!m_ttFilesByHandle.containsKey(fileHandle)) {
            throw new IllegalArgumentException(" No Timstof file associated to handle " + fileHandle);
        }
    }

    public List<AbstractTimsFrame> getFullTimsFrames(long fileHandle) {
        List<AbstractTimsFrame> timsFrames = this.getTimsFrames(fileHandle);
        ArrayList<TimsPASEFFrame> pasefFrames = new ArrayList<TimsPASEFFrame>();
        timsFrames.forEach(f -> {
            if (f.getMsmsType().equals((Object)AbstractTimsFrame.MsMsType.PASEF)) {
                pasefFrames.add((TimsPASEFFrame)f);
            }
        });
        this.fillFramesWithMsMsInfo(fileHandle, pasefFrames);
        return timsFrames;
    }

    public List<AbstractTimsFrame> getTimsFrames(long fileHandle) {
        this.checkFileHandle(fileHandle);
        if (!m_cachedMetaReaderByHandle.containsKey(fileHandle)) {
            m_cachedMetaReaderByHandle.put(fileHandle, (Object)new TDFMetadataReader((File)m_ttFilesByHandle.get(fileHandle)));
        }
        TDFMetadataReader metaDataReader = (TDFMetadataReader)m_cachedMetaReaderByHandle.get(fileHandle);
        int nbrFrames = metaDataReader.getFrameCount();
        IntArrayList framesIds = new IntArrayList(nbrFrames * 4 / 3 + 1);
        for (int i = 1; i <= nbrFrames; ++i) {
            framesIds.add(i);
        }
        return metaDataReader.readFramesInfo((IntList)framesIds);
    }

    public void fillFramesWithMsMsInfo(long fileHandle, List<TimsPASEFFrame> frames) {
        this.checkFileHandle(fileHandle);
        if (!m_cachedMetaReaderByHandle.containsKey(fileHandle)) {
            m_cachedMetaReaderByHandle.put(fileHandle, (Object)new TDFMetadataReader((File)m_ttFilesByHandle.get(fileHandle)));
        }
        TDFMetadataReader metaDataReader = (TDFMetadataReader)m_cachedMetaReaderByHandle.get(fileHandle);
        metaDataReader.readPasefMsMsInfo(frames);
    }

    public void fillFramesWithSpectrumData(Long fileHandle, List<? extends AbstractTimsFrame> frames) {
        this.checkFileHandle(fileHandle);
        for (AbstractTimsFrame abstractTimsFrame : frames) {
            long frameId = abstractTimsFrame.getId();
            int nbrScans = abstractTimsFrame.getNbrScans();
            int inputBufferLen = abstractTimsFrame.getMsmsType().equals((Object)AbstractTimsFrame.MsMsType.PASEF) ? 200000 : 3000000;
            byte[] buffer = new byte[inputBufferLen];
            long buf_len = m_tdfLib.tims_read_scans_v2(fileHandle, frameId, 0L, nbrScans, buffer, inputBufferLen);
            if (buf_len == 0L) {
                LOG.error(" !!!! Error reading scans for frame %d" + frameId);
            }
            if (buf_len > (long)inputBufferLen) {
                LOG.trace(" !!!! Error: missing data " + buf_len);
                int newSize = (int)buf_len + 10;
                buffer = new byte[newSize];
                m_tdfLib.tims_read_scans_v2(fileHandle, frameId, 0L, nbrScans, buffer, newSize);
            }
            IntBuffer intBuf = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
            int[] scanBuffer = new int[intBuf.remaining()];
            intBuf.get(scanBuffer);
            Int2ObjectOpenHashMap scanIndices2IntensityMap = new Int2ObjectOpenHashMap(nbrScans * 4 / 3 + 1);
            int d = nbrScans;
            int nbPeaksTotal = 0;
            for (int i = 0; i < nbrScans; ++i) {
                nbPeaksTotal += scanBuffer[i];
            }
            int[] indicesToSearch = new int[nbPeaksTotal];
            int indicesToSearchIndex = 0;
            for (int i = 0; i < nbrScans; ++i) {
                int numberPeaks = scanBuffer[i];
                if (numberPeaks == 0) continue;
                int startIndices = d;
                int startScanIntensities = d += numberPeaks;
                d += numberPeaks;
                Int2FloatOpenHashMap indiceIntensityMap = new Int2FloatOpenHashMap(numberPeaks * 4 / 3 + 1);
                for (int peakIndex = 0; peakIndex < numberPeaks; ++peakIndex) {
                    int indix = scanBuffer[startIndices + peakIndex];
                    indicesToSearch[indicesToSearchIndex++] = indix;
                    indiceIntensityMap.put(indix, (float)scanBuffer[startScanIntensities + peakIndex]);
                }
                scanIndices2IntensityMap.put(i, (Object)indiceIntensityMap);
            }
            double[] scanMasses = new double[nbPeaksTotal];
            long error_stat = m_tdfLib.tims_index_to_mz(fileHandle, frameId, ArraysUtil.copyFromIntArray(indicesToSearch), scanMasses, scanMasses.length);
            if (0L == error_stat) {
                LOG.error(" !!! could not convert indices to masses for frame {}.", (Object)frameId);
            }
            Int2DoubleOpenHashMap indiceToMassMap = new Int2DoubleOpenHashMap(nbPeaksTotal * 4 / 3 + 1);
            for (int indiceIndex = 0; indiceIndex < scanMasses.length; ++indiceIndex) {
                indiceToMassMap.put(indicesToSearch[indiceIndex], scanMasses[indiceIndex]);
            }
            Int2ObjectOpenHashMap scanMsMsDataMap = new Int2ObjectOpenHashMap(nbrScans * 4 / 3 + 1);
            for (Int2ObjectMap.Entry scansEntry : scanIndices2IntensityMap.int2ObjectEntrySet()) {
                int scanId = scansEntry.getIntKey();
                Int2FloatMap indiceToIntensity = (Int2FloatMap)scansEntry.getValue();
                Double2FloatOpenHashMap massIntensityMap = new Double2FloatOpenHashMap(indiceToIntensity.size() * 4 / 3 + 1);
                for (Int2FloatMap.Entry nextInd2IntensityEntry : indiceToIntensity.int2FloatEntrySet()) {
                    int nextIndice = nextInd2IntensityEntry.getIntKey();
                    massIntensityMap.put(indiceToMassMap.get(nextIndice), nextInd2IntensityEntry.getFloatValue());
                }
                scanMsMsDataMap.put(scanId, (Object)massIntensityMap);
            }
            abstractTimsFrame.setMassIntensityByScan((Int2ObjectMap<Double2FloatMap>)scanMsMsDataMap);
        }
    }

    public TDFLibrary getTDFLib() {
        return m_tdfLib;
    }

    public Int2ObjectMap<Precursor> getPrecursorInfoById(long fileHandle) {
        if (!m_cachedMetaReaderByHandle.containsKey(fileHandle)) {
            m_cachedMetaReaderByHandle.put(fileHandle, (Object)new TDFMetadataReader((File)m_ttFilesByHandle.get(fileHandle)));
        }
        TDFMetadataReader metaDataReader = (TDFMetadataReader)m_cachedMetaReaderByHandle.get(fileHandle);
        return metaDataReader.getPrecursorInfoById();
    }

    public Map<String, String> readGlobalProperties(long fileHandle) {
        if (!m_cachedMetaReaderByHandle.containsKey(fileHandle)) {
            m_cachedMetaReaderByHandle.put(fileHandle, (Object)new TDFMetadataReader((File)m_ttFilesByHandle.get(fileHandle)));
        }
        TDFMetadataReader metaDataReader = (TDFMetadataReader)m_cachedMetaReaderByHandle.get(fileHandle);
        return metaDataReader.readGlobalMetaData();
    }

    public List<Pair<Integer, Double>> getIonMobilityIndexes(long fileHandle) {
        if (!m_cachedMetaReaderByHandle.containsKey(fileHandle)) {
            m_cachedMetaReaderByHandle.put(fileHandle, (Object)new TDFMetadataReader((File)m_ttFilesByHandle.get(fileHandle)));
        }
        TDFMetadataReader metaDataReader = (TDFMetadataReader)m_cachedMetaReaderByHandle.get(fileHandle);
        Map<String, String> propertyGroup = metaDataReader.readPropertyGroup(1);
        int n = 0;
        if (propertyGroup.containsKey("IMS_Cycle_RampTime_Trig")) {
            n = Integer.parseInt(propertyGroup.get("IMS_Cycle_RampTime_Trig")) + 1;
        } else {
            Map<String, String> propertyFrame = metaDataReader.readFrameProperty(1);
            if (propertyFrame.containsKey("IMS_Cycle_RampTime_Trig")) {
                n = Integer.parseInt(propertyFrame.get("IMS_Cycle_RampTime_Trig")) + 1;
            }
        }
        if (n > 0) {
            double[] scanAsDbl = new double[n];
            double[] ionMobilities = new double[n];
            for (int i = 0; i < n; ++i) {
                scanAsDbl[i] = i;
            }
            long error_stat = m_tdfLib.tims_scannum_to_oneoverk0(fileHandle, 1L, scanAsDbl, ionMobilities, ionMobilities.length);
            if (0L == error_stat) {
                LOG.error(" !!! could not convert scans to ion mobility for frame 1");
            } else {
                ArrayList<Pair<Integer, Double>> indices = new ArrayList<Pair<Integer, Double>>(n);
                for (int i = 0; i < n; ++i) {
                    indices.add((Pair<Integer, Double>)new ImmutablePair((Object)((int)scanAsDbl[i]), (Object)ionMobilities[i]));
                }
                return indices;
            }
        }
        return new ArrayList<Pair<Integer, Double>>();
    }

    static {
        m_instance = null;
    }
}

