/*
 * Decompiled with CFR 0.152.
 */
package org.jsuffixarrays;

import com.carrotsearch.hppc.sorting.IndirectComparator;
import com.carrotsearch.hppc.sorting.IndirectSort;
import com.google.common.primitives.Ints;
import org.jsuffixarrays.ISuffixArrayBuilder;
import org.jsuffixarrays.SuffixComparator;
import org.jsuffixarrays.Tools;

public final class NaiveSort
implements ISuffixArrayBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] buildSuffixArray(int[] input, int start, int length) {
        Tools.assertAlways(input != null, "input must not be null");
        Tools.assertAlways(input.length >= start + length + 1, "no extra space after input end");
        assert (Ints.asList((int[])input).subList(start, start + length).indexOf(Integer.MIN_VALUE) < 0) : "Integer.MIN_VALUE must not occur in the input";
        int saveEOS = input[start + length];
        try {
            input[start + length] = Integer.MIN_VALUE;
            int[] sa = IndirectSort.sort((int)start, (int)length, (IndirectComparator)new SuffixComparator(input));
            int i = 0;
            while (i < sa.length) {
                int n = i++;
                sa[n] = sa[n] - start;
            }
            int[] nArray = sa;
            return nArray;
        }
        finally {
            input[start + length] = saveEOS;
        }
    }

    public static int[] computeLCP(int[] input, int start, int length, int[] suffixArray) {
        assert (length == suffixArray.length);
        int[] lcpArray = new int[length];
        lcpArray[0] = -1;
        for (int i = 1; i < length; ++i) {
            int lcp = 0;
            while (input[suffixArray[i - 1] + lcp] == input[suffixArray[i] + lcp]) {
                ++lcp;
            }
            lcpArray[i] = lcp;
        }
        return lcpArray;
    }
}

