/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BinomialDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGenInt;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BinomialGen
extends RandomVariateGenInt {
    protected int n = -1;
    protected double p = -1.0;

    public BinomialGen(RandomStream s, int n, double p) {
        super(s, new BinomialDist(n, p));
        this.setParams(n, p);
    }

    public BinomialGen(RandomStream s, BinomialDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getN(), dist.getP());
        }
    }

    public static int nextInt(RandomStream s, int n, double p) {
        return BinomialDist.inverseF(n, p, s.nextDouble());
    }

    public int getN() {
        return this.n;
    }

    public double getP() {
        return this.p;
    }

    protected void setParams(int n, double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("p not in range [0, 1]");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        this.p = p;
        this.n = n;
    }
}

