/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.util.Random;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.rng.WELL607;
import umontreal.iro.lecuyer.rng.WELL607base;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class F2NL607
extends WELL607base {
    private static final long serialVersionUID = 70510L;
    private static int[] curr_stream;
    private static int[][] nlData;
    private static int[] nlJumpW;
    private static int[] nlJumpZ;
    private int[] nlState;
    private int[] nlStream;
    private int[] nlSubstream;
    private static int[] curr_nlStream;
    private static boolean constructed;

    private static void scramble(int[] data, Random rand) {
        for (int i = 0; i < data.length - 1; ++i) {
            int j = (int)(rand.nextDouble() * (double)(data.length - i)) + i;
            int buffer = data[i];
            data[i] = data[j];
            data[j] = buffer;
        }
    }

    private static void scramble(int[] data, RandomStream rand) {
        for (int i = 0; i < data.length - 1; ++i) {
            int j = rand.nextInt(i, data.length - 1);
            int buffer = data[i];
            data[i] = data[j];
            data[j] = buffer;
        }
    }

    public F2NL607() {
        int i;
        F2NL607.initialisation();
        constructed = true;
        this.state = new int[32];
        this.stream = new int[19];
        this.substream = new int[19];
        for (i = 0; i < 19; ++i) {
            this.stream[i] = curr_stream[i];
        }
        this.advanceSeed(curr_stream, WELL607.pz);
        this.nlState = new int[nlData.length];
        this.nlStream = new int[nlData.length];
        this.nlSubstream = new int[nlData.length];
        for (i = 0; i < nlData.length; ++i) {
            this.nlStream[i] = curr_nlStream[i];
            int n = i;
            curr_nlStream[n] = curr_nlStream[n] + nlJumpZ[i];
        }
        this.resetStartStream();
    }

    public F2NL607(String name) {
        this();
        this.name = name;
    }

    public void resetStartStream() {
        int i;
        for (i = 0; i < 19; ++i) {
            this.substream[i] = this.stream[i];
        }
        for (i = 0; i < this.nlSubstream.length; ++i) {
            this.nlSubstream[i] = this.nlStream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        int i;
        this.state_i = 0;
        for (i = 0; i < 19; ++i) {
            this.state[i] = this.substream[i];
        }
        for (i = 0; i < this.nlState.length; ++i) {
            this.nlState[i] = this.nlSubstream[i];
        }
    }

    public void resetNextSubstream() {
        this.advanceSeed(this.substream, WELL607.pw);
        for (int i = 0; i < this.nlState.length; ++i) {
            this.nlSubstream[i] = (this.nlSubstream[i] + nlJumpW[i]) % nlData[i].length;
        }
        this.resetStartSubstream();
    }

    public static void setPackageLinearSeed(int[] seed) {
        F2NL607.verifySeed(seed);
        for (int i = 0; i < 19; ++i) {
            F2NL607.curr_stream[i] = seed[i];
        }
    }

    public void setLinearSeed(int[] seed) {
        F2NL607.verifySeed(seed);
        for (int i = 0; i < 19; ++i) {
            this.stream[i] = seed[i];
        }
        this.resetStartStream();
    }

    public int[] getLinearState() {
        return this.getState();
    }

    public static void setPackageNonLinearSeed(int[] seed) {
        int i;
        if (seed.length < nlData.length) {
            throw new IllegalArgumentException("Seed must contain " + nlData.length + " values");
        }
        for (i = 0; i < nlData.length; ++i) {
            if (seed[i] >= 0 && seed[i] < nlData[i].length) continue;
            throw new IllegalArgumentException("Seed number " + i + " must be between 0 and " + (nlData[i].length - 1));
        }
        for (i = 0; i < nlData.length; ++i) {
            F2NL607.curr_nlStream[i] = seed[i];
        }
    }

    public void setNonLinearSeed(int[] seed) {
        int i;
        if (seed.length != nlData.length) {
            throw new IllegalArgumentException("Seed must contain " + nlData.length + " values");
        }
        for (i = 0; i < nlData.length; ++i) {
            if (seed[i] >= 0 && seed[i] < nlData[i].length) continue;
            throw new IllegalArgumentException("Seed number " + i + " must be between 0 and " + (nlData[i].length - 1));
        }
        for (i = 0; i < nlData.length; ++i) {
            this.nlStream[i] = seed[i];
        }
        this.resetStartStream();
    }

    public int[] getNonLinearState() {
        int[] state = new int[this.nlState.length];
        for (int i = 0; i < this.nlState.length; ++i) {
            state[i] = this.nlState[i];
        }
        return state;
    }

    public static int[][] getNonLinearData() {
        int[][] data = new int[nlData.length][];
        for (int i = 0; i < nlData.length; ++i) {
            data[i] = new int[nlData[i].length];
            for (int j = 0; j < nlData[i].length; ++j) {
                data[i][j] = nlData[i][j];
            }
        }
        return data;
    }

    public static void setNonLinearData(int[][] data) {
        int i;
        if (constructed) {
            throw new IllegalStateException("setNonLinearData can only be called before the creation of any F2NL607");
        }
        nlData = new int[data.length][];
        curr_nlStream = new int[data.length];
        for (i = 0; i < data.length; ++i) {
            F2NL607.nlData[i] = new int[data[i].length];
            for (int j = 0; j < data[i].length; ++j) {
                F2NL607.nlData[i][j] = data[i][j];
            }
            F2NL607.curr_nlStream[i] = 0;
        }
        nlJumpW = new int[data.length];
        nlJumpZ = new int[data.length];
        for (i = 0; i < nlJumpW.length; ++i) {
            int j;
            int temp = 1;
            for (j = 0; j < 250; ++j) {
                temp = 2 * temp % nlData[i].length;
            }
            F2NL607.nlJumpW[i] = temp;
            for (j = 0; j < 150; ++j) {
                temp = 2 * temp % nlData[i].length;
            }
            F2NL607.nlJumpZ[i] = temp;
        }
    }

    public static void setScrambleData(RandomStream rand, int steps, int[] size) {
        int i;
        if (constructed) {
            throw new IllegalStateException("setScrambleData can only be called before the creation of any F2NL607");
        }
        curr_nlStream = new int[size.length];
        for (i = 0; i < size.length; ++i) {
            F2NL607.curr_nlStream[i] = 0;
        }
        nlData = new int[size.length][];
        for (i = 0; i < size.length; ++i) {
            F2NL607.nlData[i] = new int[size[i]];
        }
        for (i = 0; i < nlData.length; ++i) {
            int j;
            for (j = 0; j < nlData[i].length; ++j) {
                F2NL607.nlData[i][j] = (int)(((long)j << 32) / (long)nlData[i].length);
            }
            for (j = 0; j < steps; ++j) {
                F2NL607.scramble(nlData[i], rand);
            }
        }
        nlJumpW = new int[size.length];
        nlJumpZ = new int[size.length];
        for (i = 0; i < nlJumpW.length; ++i) {
            int j;
            int temp = 1;
            for (j = 0; j < 250; ++j) {
                temp = 2 * temp % nlData[i].length;
            }
            F2NL607.nlJumpW[i] = temp;
            for (j = 0; j < 150; ++j) {
                temp = 2 * temp % nlData[i].length;
            }
            F2NL607.nlJumpZ[i] = temp;
        }
    }

    public F2NL607 clone() {
        int i;
        F2NL607 retour = null;
        retour = (F2NL607)super.clone();
        retour.state = new int[32];
        retour.substream = new int[19];
        retour.stream = new int[19];
        retour.nlState = new int[nlData.length];
        retour.nlStream = new int[nlData.length];
        retour.nlSubstream = new int[nlData.length];
        for (i = 0; i < 19; ++i) {
            retour.substream[i] = this.substream[i];
            retour.stream[i] = this.stream[i];
        }
        for (i = 0; i < 32; ++i) {
            retour.state[i] = this.state[i];
        }
        for (i = 0; i < nlData.length; ++i) {
            retour.nlState[i] = this.nlState[i];
            retour.nlStream[i] = this.nlStream[i];
            retour.nlSubstream[i] = this.nlSubstream[i];
        }
        return retour;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.name == null) {
            sb.append("The state of this F2NL607 is : " + PrintfFormat.NEWLINE);
        } else {
            sb.append("The state of " + this.name + " is : " + PrintfFormat.NEWLINE);
        }
        sb.append(" Linear part : { ");
        sb.append(super.stringState());
        sb.append(PrintfFormat.NEWLINE + " Non-linear part : { ");
        for (int i = 0; i < this.nlState.length; ++i) {
            sb.append(this.nlState[i] + " ");
        }
        sb.append("}");
        return sb.toString();
    }

    protected double nextValue() {
        for (int i = 0; i < nlData.length; ++i) {
            if (this.nlState[i] >= nlData[i].length - 1) {
                this.nlState[i] = 0;
                continue;
            }
            int n = i;
            this.nlState[n] = this.nlState[n] + 1;
        }
        int nonLin = 0;
        for (int i = 0; i < nlData.length; ++i) {
            nonLin += nlData[i][this.nlState[i]];
        }
        long result = this.nextInt() ^ nonLin;
        if (result <= 0L) {
            result += 0x100000000L;
        }
        return (double)result * 2.3283064359965952E-10;
    }

    static {
        int i;
        curr_stream = new int[]{-693127396, -2102546034, 846098766, -1309785418, -240634643, 78534433, -974510013, -100396693, 1791890671, -849903200, 1797223196, 2117832253, -1959469526, 1961629173, -2064924138, -2081805215, -458736866, -1512559431, -1642435447};
        constructed = false;
        curr_nlStream = new int[]{0, 0, 0};
        nlData = new int[][]{new int[1019], new int[1021], new int[1031]};
        Random rand = new Random(0L);
        for (i = 0; i < nlData.length; ++i) {
            for (int j = 0; j < nlData[i].length; ++j) {
                F2NL607.nlData[i][j] = (int)(((long)j << 32) / (long)nlData[i].length);
            }
            F2NL607.scramble(nlData[i], rand);
        }
        nlJumpW = new int[3];
        nlJumpZ = new int[3];
        for (i = 0; i < nlJumpW.length; ++i) {
            int j;
            int temp = 1;
            for (j = 0; j < 250; ++j) {
                temp = 2 * temp % nlData[i].length;
            }
            F2NL607.nlJumpW[i] = temp;
            for (j = 0; j < 150; ++j) {
                temp = 2 * temp % nlData[i].length;
            }
            F2NL607.nlJumpZ[i] = temp;
        }
    }
}

