/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Formatter;
import java.util.Locale;
import umontreal.iro.lecuyer.util.Num;

public class PrintfFormat
implements CharSequence,
Appendable {
    private static NumberFormat nf = NumberFormat.getInstance(Locale.US);
    private static DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
    private static final int NDEC = 50;
    private static DecimalFormat[] dfe = new DecimalFormat[51];
    private static DecimalFormat[] dfg = new DecimalFormat[51];
    private StringBuffer sb;
    public static final String NEWLINE = System.getProperty("line.separator");
    @Deprecated
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public PrintfFormat() {
        this.sb = new StringBuffer();
    }

    public PrintfFormat(int length) {
        this.sb = new StringBuffer(length);
    }

    public PrintfFormat(String str) {
        this.sb = new StringBuffer(str);
    }

    public PrintfFormat append(String str) {
        this.sb.append(str);
        return this;
    }

    public PrintfFormat append(int fieldwidth, String str) {
        this.sb.append(PrintfFormat.s(fieldwidth, str));
        return this;
    }

    public PrintfFormat append(double x) {
        this.sb.append(x);
        return this;
    }

    public PrintfFormat append(int fieldwidth, double x) {
        this.sb.append(PrintfFormat.f(fieldwidth, x));
        return this;
    }

    public PrintfFormat append(int fieldwidth, int precision, double x) {
        this.sb.append(PrintfFormat.f(fieldwidth, precision, x));
        return this;
    }

    public PrintfFormat append(int x) {
        this.sb.append(x);
        return this;
    }

    public PrintfFormat append(int fieldwidth, int x) {
        this.sb.append(PrintfFormat.d(fieldwidth, x));
        return this;
    }

    public PrintfFormat append(long x) {
        this.sb.append(x);
        return this;
    }

    public PrintfFormat append(int fieldwidth, long x) {
        this.sb.append(PrintfFormat.d(fieldwidth, x));
        return this;
    }

    public PrintfFormat append(int fieldwidth, int accuracy, int precision, double x) {
        this.sb.append(PrintfFormat.format(fieldwidth, accuracy, precision, x));
        return this;
    }

    public PrintfFormat append(char c) {
        this.sb.append(c);
        return this;
    }

    public void clear() {
        this.sb.setLength(0);
    }

    public StringBuffer getBuffer() {
        return this.sb;
    }

    public String toString() {
        return this.sb.toString();
    }

    public static String s(String str) {
        if (str == null) {
            return "null";
        }
        return str;
    }

    public static String s(int fieldwidth, String str) {
        if (str == null) {
            return PrintfFormat.s(fieldwidth, "null");
        }
        int fw = Math.abs(fieldwidth);
        if (str.length() < fw) {
            StringBuffer buf = new StringBuffer();
            int sl = str.length();
            for (int i = 0; i < fw - sl; ++i) {
                buf.append(' ');
            }
            return fieldwidth >= 0 ? buf.toString() + str : str + buf.toString();
        }
        return str;
    }

    public static String d(long x) {
        return PrintfFormat.d(0, 1, x);
    }

    public static String d(int fieldwidth, long x) {
        return PrintfFormat.d(fieldwidth, 1, x);
    }

    public static String d(int fieldwidth, int precision, long x) {
        if (precision < 0) {
            throw new IllegalArgumentException("precision must not be negative.");
        }
        if (precision == 0 && x == 0L) {
            return PrintfFormat.s(fieldwidth, "");
        }
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(precision);
        nf.setMaximumFractionDigits(0);
        return PrintfFormat.s(fieldwidth, nf.format(x));
    }

    public static String format(long x) {
        return PrintfFormat.d(0, 1, x);
    }

    public static String format(int fieldwidth, long x) {
        return PrintfFormat.d(fieldwidth, 1, x);
    }

    public static String formatBase(int b, long x) {
        return PrintfFormat.formatBase(0, b, x);
    }

    public static String formatBase(int fieldwidth, int b, long x) {
        boolean neg = false;
        if (b < 2 || b > 10) {
            throw new IllegalArgumentException("base must be between 2 and 10.");
        }
        if (x < 0L) {
            neg = true;
            x = -x;
        } else {
            if (x == 0L) {
                return "0";
            }
            neg = false;
        }
        StringBuffer sb = new StringBuffer();
        while (x > 0L) {
            sb.insert(0, x % (long)b);
            x /= (long)b;
        }
        if (neg) {
            sb.insert(0, '-');
        }
        return PrintfFormat.s(fieldwidth, sb.toString());
    }

    public static String E(double x) {
        return PrintfFormat.E(0, 6, x);
    }

    public static String E(int fieldwidth, double x) {
        return PrintfFormat.E(fieldwidth, 6, x);
    }

    public static String E(int fieldwidth, int precision, double x) {
        DecimalFormat df;
        if (precision < 0) {
            throw new IllegalArgumentException("precision must not be negative.");
        }
        if (Double.isNaN(x)) {
            return PrintfFormat.s(fieldwidth, "NaN");
        }
        if (Double.isInfinite(x)) {
            return PrintfFormat.s(fieldwidth, (x < 0.0 ? "-" : "") + "Infinite");
        }
        if (precision >= dfe.length || dfe[precision] == null) {
            StringBuffer pattern = new StringBuffer("0.");
            for (int i = 0; i < precision; ++i) {
                pattern.append("0");
            }
            pattern.append("E00");
            df = new DecimalFormat(pattern.toString(), dfs);
            df.setGroupingUsed(false);
            if (precision < dfe.length) {
                PrintfFormat.dfe[precision] = df;
            }
        } else {
            df = dfe[precision];
        }
        String res = df.format(x);
        int exppos = res.indexOf(69);
        if (exppos != -1 && res.charAt(exppos + 1) != '-') {
            res = res.substring(0, exppos + 1) + "+" + res.substring(exppos + 1);
        }
        return PrintfFormat.s(fieldwidth, res);
    }

    public static String e(double x) {
        return PrintfFormat.e(0, 6, x);
    }

    public static String e(int fieldwidth, double x) {
        return PrintfFormat.e(fieldwidth, 6, x);
    }

    public static String e(int fieldwidth, int precision, double x) {
        String res = PrintfFormat.E(fieldwidth, precision, x);
        int exppos = res.indexOf(69);
        return exppos == -1 ? res : res.substring(0, exppos) + 'e' + res.substring(exppos + 1);
    }

    public static String f(double x) {
        return PrintfFormat.f(0, 6, x);
    }

    public static String f(int fieldwidth, double x) {
        return PrintfFormat.f(fieldwidth, 6, x);
    }

    public static String f(int fieldwidth, int precision, double x) {
        if (precision < 0) {
            throw new IllegalArgumentException("precision must not be negative.");
        }
        if (Double.isNaN(x)) {
            return PrintfFormat.s(fieldwidth, "NaN");
        }
        if (Double.isInfinite(x)) {
            return PrintfFormat.s(fieldwidth, (x < 0.0 ? "-" : "") + "Infinite");
        }
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(1);
        nf.setMinimumFractionDigits(precision);
        nf.setMaximumFractionDigits(precision);
        return PrintfFormat.s(fieldwidth, nf.format(x));
    }

    public static String G(double x) {
        return PrintfFormat.G(0, 6, x);
    }

    public static String G(int fieldwidth, double x) {
        return PrintfFormat.G(fieldwidth, 6, x);
    }

    public static String G(int fieldwidth, int precision, double x) {
        DecimalFormat df;
        if (precision < 0) {
            throw new IllegalArgumentException("precision must not be negative.");
        }
        if (precision == 0) {
            precision = 1;
        }
        if (Double.isNaN(x)) {
            return PrintfFormat.s(fieldwidth, "NaN");
        }
        if (Double.isInfinite(x)) {
            return PrintfFormat.s(fieldwidth, (x < 0.0 ? "-" : "") + "Infinite");
        }
        if (precision >= dfg.length || dfg[precision] == null) {
            StringBuffer pattern = new StringBuffer("0.");
            for (int i = 0; i < precision - 1; ++i) {
                pattern.append("#");
            }
            pattern.append("E00");
            df = new DecimalFormat(pattern.toString(), dfs);
            df.setGroupingUsed(false);
            if (precision < dfg.length) {
                PrintfFormat.dfg[precision] = df;
            }
        } else {
            df = dfg[precision];
        }
        String res = df.format(x);
        int exppos = res.indexOf(69);
        if (exppos == -1) {
            return res;
        }
        int expval = Integer.parseInt(res.substring(exppos + 1));
        if (expval < -4 || expval >= precision) {
            if (res.charAt(exppos + 1) != '-') {
                return PrintfFormat.s(fieldwidth, res.substring(0, exppos + 1) + "+" + res.substring(exppos + 1));
            }
            return PrintfFormat.s(fieldwidth, res);
        }
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(1);
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(precision - expval - 1);
        res = nf.format(x);
        return PrintfFormat.s(fieldwidth, res);
    }

    public static String g(double x) {
        return PrintfFormat.g(0, 6, x);
    }

    public static String g(int fieldwidth, double x) {
        return PrintfFormat.g(fieldwidth, 6, x);
    }

    public static String g(int fieldwidth, int precision, double x) {
        String res = PrintfFormat.G(fieldwidth, precision, x);
        int exppos = res.indexOf(69);
        return exppos == -1 ? res : res.substring(0, exppos) + 'e' + res.substring(exppos + 1);
    }

    public static String format(int fieldwidth, int accuracy, int precision, double x) {
        if (Double.isNaN(x)) {
            return PrintfFormat.s(fieldwidth, "NaN");
        }
        if (Double.isInfinite(x)) {
            return PrintfFormat.s(fieldwidth, (x < 0.0 ? "-" : "") + "Infinite");
        }
        if (PrintfFormat.canUseDecimalNotation(fieldwidth, accuracy, precision, x)) {
            return PrintfFormat.f(fieldwidth, accuracy, x);
        }
        String S = PrintfFormat.E(fieldwidth, precision - 1, x);
        return PrintfFormat.processExp(S);
    }

    private static boolean canUseDecimalNotation(int fieldwidth, int accuracy, int precision, double x) {
        int EntierSign;
        int PosEntier = 0;
        int Neg2 = 0;
        if (x == 0.0) {
            EntierSign = 1;
        } else {
            EntierSign = PosEntier = (int)Math.floor(Math.log10(Math.abs(x)) + 1.0);
            if (x < 0.0) {
                Neg2 = 1;
            }
        }
        if (EntierSign <= 0) {
            PosEntier = 1;
        }
        return x == 0.0 || EntierSign + accuracy >= precision && fieldwidth >= PosEntier + accuracy + Neg2 + 1;
    }

    private static int getMinAccuracy(double x) {
        if (Math.abs(x) >= 1.0 || x == 0.0) {
            return 0;
        }
        return -((int)Math.floor(Math.log10(Math.abs(x))));
    }

    private static String processExp(String s) {
        int p = s.indexOf("E+0");
        if (p == -1) {
            p = s.indexOf("E-0");
        }
        if (p != -1) {
            s = " " + s.substring(0, p + 2) + s.substring(p + 3);
        }
        if ((p = s.indexOf(".E")) != -1) {
            s = " " + s.substring(0, p) + s.substring(p + 1);
        }
        return s;
    }

    public static String format(Locale locale, int fieldwidth, int accuracy, int precision, double x) {
        Formatter fmt = new Formatter(locale);
        if (Double.isNaN(x)) {
            return fmt.format("%" + fieldwidth + "s", "NaN").toString();
        }
        if (Double.isInfinite(x)) {
            return fmt.format("%" + fieldwidth + "s", (x < 0.0 ? "-" : "") + "Infinite").toString();
        }
        if (PrintfFormat.canUseDecimalNotation(fieldwidth, accuracy, precision, x)) {
            return fmt.format("%" + fieldwidth + "." + accuracy + "f", x).toString();
        }
        String S = fmt.format("%" + fieldwidth + "." + (precision - 1) + "E", x).toString();
        return PrintfFormat.processExp(S);
    }

    public static String formatBase(int fieldwidth, int accuracy, int b, double x) {
        int j;
        if (Double.isNaN(x)) {
            return PrintfFormat.s(fieldwidth, "NaN");
        }
        if (Double.isInfinite(x)) {
            return PrintfFormat.s(fieldwidth, (x < 0.0 ? "-" : "") + "Infinite");
        }
        if (0.0 == x || -0.0 == x) {
            return PrintfFormat.s(fieldwidth, "0");
        }
        if (Math.abs(x) >= Num.TWOEXP[63]) {
            throw new UnsupportedOperationException("   |x| >= 2^63");
        }
        long n = (long)x;
        String mant = PrintfFormat.formatBase(-1, b, n);
        if ((double)n == x) {
            return PrintfFormat.s(fieldwidth, mant);
        }
        if (n == 0L) {
            mant = x < 0.0 ? "-0" : "0";
        }
        if (x > 0.0) {
            x += 0.5 * Math.pow(b, -accuracy - 1);
        } else if (x < 0.0) {
            x -= 0.5 * Math.pow(b, -accuracy - 1);
        }
        x -= (double)n;
        if (x < 0.0) {
            x = -x;
        }
        StringBuffer frac = new StringBuffer(".");
        for (j = 0; j < accuracy; ++j) {
            long y = (long)(x *= (double)b);
            frac.append(y);
            if ((x -= (double)y) == 0.0) break;
        }
        StringBuffer number = new StringBuffer(mant);
        number.append(frac);
        for (j = number.length() - 1; j > 0 && (number.charAt(j) == '0' || number.charAt(j) == ' '); --j) {
            number.deleteCharAt(j);
        }
        return PrintfFormat.s(fieldwidth, number.toString());
    }

    public char charAt(int index) {
        return this.sb.charAt(index);
    }

    public int length() {
        return this.sb.length();
    }

    public CharSequence subSequence(int start, int end) {
        return this.sb.subSequence(start, end);
    }

    public Appendable append(CharSequence csq) {
        return this.sb.append(csq);
    }

    public Appendable append(CharSequence csq, int start, int end) {
        return this.sb.append(csq, start, end);
    }

    public static void formatWithError(int fieldwidth, int fieldwidtherr, int accuracy, int precision, double x, double error, String[] res) {
        if (res.length != 2) {
            throw new IllegalArgumentException("The given res array must contain two elements");
        }
        if (Double.isNaN(x)) {
            res[0] = PrintfFormat.s(fieldwidth, "NaN");
            res[1] = PrintfFormat.s(fieldwidtherr, "");
            return;
        }
        if (Double.isInfinite(x)) {
            res[0] = PrintfFormat.s(fieldwidth, (x < 0.0 ? "-" : "") + "Infinite");
            res[1] = PrintfFormat.s(fieldwidtherr, "");
            return;
        }
        if (accuracy < 0) {
            accuracy = 0;
        }
        if (PrintfFormat.canUseDecimalNotation(fieldwidth, accuracy, precision, x)) {
            res[0] = PrintfFormat.f(fieldwidth, accuracy, x);
            res[1] = PrintfFormat.f(fieldwidtherr, accuracy, error);
        } else {
            int errorExp;
            res[0] = PrintfFormat.processExp(PrintfFormat.E(fieldwidth, precision - 1, x));
            int xExp = x == 0.0 ? 0 : (int)Math.floor(Math.log10(Math.abs(x)));
            int errorPrecision = precision - 1 - (xExp - (errorExp = error == 0.0 ? 0 : (int)Math.floor(Math.log10(Math.abs(error)))));
            if (errorPrecision < 0) {
                errorPrecision = 0;
            }
            res[1] = PrintfFormat.processExp(PrintfFormat.E(fieldwidtherr, errorPrecision, error));
        }
    }

    public static void formatWithError(int fieldwidth, int fieldwidtherr, int precision, double x, double error, String[] res) {
        int accuracy = PrintfFormat.getMinAccuracy(error);
        if (!PrintfFormat.canUseDecimalNotation(fieldwidth, accuracy, precision, x)) {
            int newAccuracy;
            int posEntier = (int)Math.floor(Math.log(Math.abs(x)) / Math.log(10.0) + 1.0);
            if (posEntier < 0) {
                posEntier = 1;
            }
            if (PrintfFormat.canUseDecimalNotation(fieldwidth, newAccuracy = precision - posEntier, precision, x)) {
                accuracy = newAccuracy;
            }
        }
        PrintfFormat.formatWithError(fieldwidth, fieldwidtherr, accuracy, precision, x, error, res);
    }

    public static void formatWithError(Locale locale, int fieldwidth, int fieldwidtherr, int accuracy, int precision, double x, double error, String[] res) {
        if (res.length != 2) {
            throw new IllegalArgumentException("The given res array must contain two elements");
        }
        Formatter fmt = new Formatter(locale);
        Formatter fmtErr = new Formatter(locale);
        if (Double.isNaN(x)) {
            res[0] = fmt.format("%" + fieldwidth + "s", "NaN").toString();
            res[1] = fmtErr.format("%" + fieldwidtherr + "s", "").toString();
            return;
        }
        if (Double.isInfinite(x)) {
            res[0] = fmt.format("%" + fieldwidth + "s", (x < 0.0 ? "-" : "") + "Infinite").toString();
            res[1] = fmtErr.format("%" + fieldwidtherr + "s", "").toString();
            return;
        }
        if (accuracy < 0) {
            accuracy = 0;
        }
        if (PrintfFormat.canUseDecimalNotation(fieldwidth, accuracy, precision, x)) {
            res[0] = fmt.format("%" + fieldwidth + "." + accuracy + "f", x).toString();
            res[1] = fmtErr.format("%" + fieldwidtherr + "." + accuracy + "f", error).toString();
        } else {
            int errorExp;
            res[0] = PrintfFormat.processExp(fmt.format("%" + fieldwidth + "." + (precision - 1) + "E", x).toString());
            int xExp = x == 0.0 ? 0 : (int)Math.floor(Math.log10(Math.abs(x)));
            int errorPrecision = precision - 1 - (xExp - (errorExp = error == 0.0 ? 0 : (int)Math.floor(Math.log10(Math.abs(error)))));
            if (errorPrecision < 0) {
                errorPrecision = 0;
            }
            res[1] = PrintfFormat.processExp(fmtErr.format("%" + fieldwidtherr + "." + errorPrecision + "E", error).toString());
        }
    }

    public static void formatWithError(Locale locale, int fieldwidth, int fieldwidtherr, int precision, double x, double error, String[] res) {
        int accuracy = PrintfFormat.getMinAccuracy(error);
        if (!PrintfFormat.canUseDecimalNotation(fieldwidth, accuracy, precision, x)) {
            int newAccuracy;
            int posEntier = (int)Math.floor(Math.log(Math.abs(x)) / Math.log(10.0) + 1.0);
            if (posEntier < 0) {
                posEntier = 1;
            }
            if (PrintfFormat.canUseDecimalNotation(fieldwidth, newAccuracy = precision - posEntier, precision, x)) {
                accuracy = newAccuracy;
            }
        }
        PrintfFormat.formatWithError(locale, fieldwidth, fieldwidtherr, accuracy, precision, x, error, res);
    }
}

