/*
 * Decompiled with CFR 0.152.
 */
package MZIDparser;

import MZIDparser.PAminoAcid;
import Preprocessing.Config;
import Preprocessing.JPeak;
import Preprocessing.JSpectrum;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import java.util.ArrayList;
import java.util.HashMap;

public class CalcFeature {
    private double nearTol = 0.3;
    private JSpectrum jSpectrum;
    public HashMap<Double, ArrayList<Double>> featureVal = new HashMap();
    public HashMap<Double, ArrayList<String>> featureTag = new HashMap();

    public CalcFeature(JSpectrum js) {
        this.jSpectrum = js;
    }

    public JSpectrum getSpectrum() {
        return this.jSpectrum;
    }

    public boolean classifyPeakIntensities() {
        boolean yes = false;
        int totalPeaks = this.jSpectrum.getPeaks().size();
        if (totalPeaks >= 7) {
            int i;
            yes = true;
            int npeak = (int)Math.floor(1.0 * (double)totalPeaks / 7.0);
            this.jSpectrum.sortPeaksByIntensity();
            int nclass1 = npeak;
            int nclass2 = 2 * npeak;
            for (i = totalPeaks - 1; i >= totalPeaks - nclass1; --i) {
                this.jSpectrum.getPeaks().get(i).setIntenClass(0);
            }
            for (i = totalPeaks - 1 - nclass1; i >= totalPeaks - nclass1 - nclass2; --i) {
                this.jSpectrum.getPeaks().get(i).setIntenClass(1);
            }
            for (i = totalPeaks - 1 - nclass1 - nclass2; i >= 0; --i) {
                this.jSpectrum.getPeaks().get(i).setIntenClass(2);
            }
        } else {
            for (int i = 0; i < this.jSpectrum.getPeaks().size(); ++i) {
                this.jSpectrum.getPeaks().get(i).setIntenClass(-1);
            }
        }
        return yes;
    }

    public void run() {
        this.classifyPeakIntensities();
        this.jSpectrum.sortPeaksByMZ();
        int npeaks = this.jSpectrum.getPeaks().size();
        double maxInt = this.jSpectrum.getMaxIntensityFragmentIonPeak().getIntensity();
        double sumInt = this.jSpectrum.getTotalIntensity();
        PAminoAcid pAminoAcid = new PAminoAcid();
        for (int i = 0; i < npeaks; ++i) {
            JPeak jPeak = this.jSpectrum.getPeaks().get(i);
            double mz = jPeak.getMz();
            double intensity = jPeak.getIntensity();
            this.featureVal.put(mz, new ArrayList());
            this.featureTag.put(mz, new ArrayList());
            this.featureVal.get(mz).add(mz);
            this.featureTag.get(mz).add("mz");
            this.featureVal.get(mz).add(Math.log(intensity));
            this.featureTag.get(mz).add("log(rawInt)");
            this.featureVal.get(mz).add(intensity / maxInt);
            this.featureTag.get(mz).add("ratio2MaxInt");
            this.featureVal.get(mz).add(Math.log(intensity / maxInt));
            this.featureTag.get(mz).add("log(ratio2MaxInt)");
            this.featureVal.get(mz).add(Double.valueOf(jPeak.getIntenClass()));
            this.featureTag.get(mz).add("peakClass");
            double mzDelta2right = 0.0;
            double mzDelta2left = 0.0;
            if (i == 0) {
                mzDelta2left = 0.0;
                mzDelta2right = this.jSpectrum.getPeaks().get(1).getMz() - mz;
            } else if (i == npeaks - 1) {
                mzDelta2right = 0.0;
                mzDelta2left = mz - this.jSpectrum.getPeaks().get(i - 1).getMz();
            } else {
                mzDelta2right = this.jSpectrum.getPeaks().get(i + 1).getMz() - mz;
                mzDelta2left = mz - this.jSpectrum.getPeaks().get(i - 1).getMz();
            }
            this.featureVal.get(mz).add(mzDelta2left);
            this.featureTag.get(mz).add("mzDelta2left");
            this.featureVal.get(mz).add(mzDelta2right);
            this.featureTag.get(mz).add("mzDelta2right");
            double mzLeftBorder = mz - 50.0 < 0.0 ? 0.0 : mz - 50.0;
            double mzRightBorder = mz + 50.0;
            double nRegionPeak = 1.0;
            double intSumRegionPeak = intensity;
            double maxIntRegion = intensity;
            double nearPeaks = 0.0;
            double greatPeaks = 0.0;
            double match2aa = 0.0;
            double match2aaInt = 0.0;
            double match2aaIntGreat50 = 0.0;
            double match2aaIntGreat30 = 0.0;
            double match2aaIntGreat20 = 0.0;
            double match2aaIntGreat10 = 0.0;
            double match2aaIntGreat5 = 0.0;
            double maxInt50 = 0.5 * maxInt;
            double maxInt30 = 0.3 * maxInt;
            double maxInt20 = 0.2 * maxInt;
            double maxInt10 = 0.1 * maxInt;
            double maxInt5 = 0.05 * maxInt;
            double minms2Delta = 100.0;
            double pairPeaks = 0.0;
            for (int j = 0; j < npeaks; ++j) {
                if (i == j) continue;
                double mzNext = this.jSpectrum.getPeaks().get(j).getMz();
                double intNext = this.jSpectrum.getPeaks().get(j).getIntensity();
                long mzDelta = Math.round(Math.abs(mz - mzNext));
                if (pAminoAcid.aa.containsKey(mzDelta) && Math.abs(Math.abs(mz - mzNext) - pAminoAcid.aa.get(mzDelta)) <= Config.ms2tol) {
                    double tol = Math.abs(Math.abs(mz - mzNext) - pAminoAcid.aa.get(mzDelta));
                    match2aa += 1.0;
                    match2aaInt += intNext;
                    double d = minms2Delta = tol < minms2Delta ? tol : minms2Delta;
                    if (intNext >= maxInt50) {
                        match2aaIntGreat50 += 1.0;
                    }
                    if (intNext >= maxInt30) {
                        match2aaIntGreat30 += 1.0;
                    }
                    if (intNext >= maxInt20) {
                        match2aaIntGreat20 += 1.0;
                    }
                    if (intNext >= maxInt10) {
                        match2aaIntGreat10 += 1.0;
                    }
                    if (intNext >= maxInt5) {
                        match2aaIntGreat5 += 1.0;
                    }
                    System.err.println(mz + "=" + mzNext + "," + Math.abs(mz - mzNext) + "," + pAminoAcid.aa.get(mzDelta));
                }
                if (mz + mzNext - this.jSpectrum.getParentMassToCharge() <= 2.0) {
                    pairPeaks += 1.0;
                }
                if (Math.abs(intensity - intNext) < this.nearTol * intensity) {
                    nearPeaks += 1.0;
                }
                if (intNext >= intensity) {
                    greatPeaks += 1.0;
                }
                if (!(mzNext >= mzLeftBorder) || !(mzNext <= mzRightBorder)) continue;
                nRegionPeak += 1.0;
                intSumRegionPeak += intNext;
                maxIntRegion = intNext > maxIntRegion ? intNext : maxIntRegion;
            }
            this.featureVal.get(mz).add(match2aa);
            this.featureTag.get(mz).add("match2aa");
            this.featureVal.get(mz).add(match2aa / (double)npeaks);
            this.featureTag.get(mz).add("match2aa2npeaks");
            this.featureVal.get(mz).add(minms2Delta);
            this.featureTag.get(mz).add("minms2Delta");
            this.featureVal.get(mz).add(minms2Delta * 1000000.0 / mz);
            this.featureTag.get(mz).add("minms2DeltaPPM");
            this.featureVal.get(mz).add(match2aaInt);
            this.featureTag.get(mz).add("match2aaInt");
            this.featureVal.get(mz).add(Math.log(match2aaInt + 1.0));
            this.featureTag.get(mz).add("log(match2aaInt)");
            this.featureVal.get(mz).add(match2aaInt / maxInt);
            this.featureTag.get(mz).add("match2aaInt2maxInt");
            this.featureVal.get(mz).add(match2aaInt / sumInt);
            this.featureTag.get(mz).add("match2aaInt2sumInt");
            this.featureVal.get(mz).add(match2aaIntGreat50);
            this.featureTag.get(mz).add("match2aaIntGreat50");
            this.featureVal.get(mz).add(match2aaIntGreat30);
            this.featureTag.get(mz).add("match2aaIntGreat30");
            this.featureVal.get(mz).add(match2aaIntGreat20);
            this.featureTag.get(mz).add("match2aaIntGreat20");
            this.featureVal.get(mz).add(match2aaIntGreat10);
            this.featureTag.get(mz).add("match2aaIntGreat10");
            this.featureVal.get(mz).add(match2aaIntGreat5);
            this.featureTag.get(mz).add("match2aaIntGreat5");
            this.featureVal.get(mz).add(match2aaIntGreat50 / (double)npeaks);
            this.featureTag.get(mz).add("match2aaIntGreat502npeaks");
            this.featureVal.get(mz).add(match2aaIntGreat30 / (double)npeaks);
            this.featureTag.get(mz).add("match2aaIntGreat302npeaks");
            this.featureVal.get(mz).add(match2aaIntGreat20 / (double)npeaks);
            this.featureTag.get(mz).add("match2aaIntGreat202npeaks");
            this.featureVal.get(mz).add(match2aaIntGreat10 / (double)npeaks);
            this.featureTag.get(mz).add("match2aaIntGreat102npeaks");
            this.featureVal.get(mz).add(match2aaIntGreat5 / (double)npeaks);
            this.featureTag.get(mz).add("match2aaIntGreat52npeaks");
            this.featureVal.get(mz).add(pairPeaks);
            this.featureTag.get(mz).add("pairPeaks");
            this.featureVal.get(mz).add(nearPeaks);
            this.featureTag.get(mz).add("nearPeaks");
            this.featureVal.get(mz).add(nearPeaks / (double)npeaks);
            this.featureTag.get(mz).add("nearPeaks2npeaks");
            this.featureVal.get(mz).add(greatPeaks);
            this.featureTag.get(mz).add("greatPeaks");
            this.featureVal.get(mz).add(greatPeaks / (double)npeaks);
            this.featureTag.get(mz).add("greatPeaks2npeaks");
            this.featureVal.get(mz).add(intensity / intSumRegionPeak);
            this.featureTag.get(mz).add("intRatio2regionSum");
            this.featureVal.get(mz).add(nRegionPeak);
            this.featureTag.get(mz).add("nRegionPeak");
            this.featureVal.get(mz).add(intensity / maxIntRegion);
            this.featureTag.get(mz).add("intRatio2regionMax");
            this.featureVal.get(mz).add(intSumRegionPeak / sumInt);
            this.featureTag.get(mz).add("intRegionRatio2totalSum");
            this.featureVal.get(mz).add(nRegionPeak / (double)npeaks);
            this.featureTag.get(mz).add("nRegionPeak2npeaks");
        }
    }

    public void addMatch(ArrayList<IonMatch> ionMatchs) {
        HashMap<Double, IonMatch> mzMatch = new HashMap<Double, IonMatch>();
        for (IonMatch im : ionMatchs) {
            mzMatch.put(im.peak.getMz(), im);
        }
        for (int i = 0; i < this.jSpectrum.getPeaks().size(); ++i) {
            if (!mzMatch.containsKey(this.jSpectrum.getPeaks().get(i).getMz())) continue;
            this.jSpectrum.getPeaks().get((int)i).isMatch = 1.0;
            IonMatch ionMatch = (IonMatch)mzMatch.get(this.jSpectrum.getPeaks().get(i).getMz());
            PeptideFragmentIon fragmentIon = (PeptideFragmentIon)ionMatch.ion;
            String label = ionMatch.ion.getSubTypeAsString() + fragmentIon.getNumber() + ionMatch.ion.getNeutralLossesAsString() + ionMatch.charge;
            this.jSpectrum.getPeaks().get(i).setIonType(label);
        }
    }
}

