/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzml;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import javolution.text.CharArray;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import javolution.xml.sax.Attributes;
import javolution.xml.stream.XMLStreamException;
import javolution.xml.stream.XMLUnexpectedEndOfDocumentException;
import javolution.xml.stream.XMLUnexpectedEndTagException;
import org.apache.commons.pool2.ObjectPool;
import org.biojava.nbio.ontology.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.scan.IScan;
import umich.ms.datatypes.scan.PeaksCompression;
import umich.ms.datatypes.scan.impl.ScanDefault;
import umich.ms.datatypes.scan.props.ActivationInfo;
import umich.ms.datatypes.scan.props.InjectionInfo;
import umich.ms.datatypes.scan.props.Instrument;
import umich.ms.datatypes.scan.props.Polarity;
import umich.ms.datatypes.scan.props.PrecursorInfo;
import umich.ms.datatypes.scan.props.ScanType;
import umich.ms.datatypes.spectrum.impl.SpectrumDefault;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzml.MZMLFile;
import umich.ms.fileio.filetypes.mzml.MZMLIndex;
import umich.ms.fileio.filetypes.mzml.MZMLIndexElement;
import umich.ms.fileio.filetypes.mzml.MZMLPeaksDecoder;
import umich.ms.fileio.filetypes.mzml.MZMLRunInfo;
import umich.ms.fileio.filetypes.mzml.MzmlVars;
import umich.ms.fileio.filetypes.mzml.util.PSIMSCV;
import umich.ms.fileio.filetypes.xmlbased.MultiSpectraParser;
import umich.ms.logging.LogHelper;
import umich.ms.util.base64.Base64;
import umich.ms.util.base64.Base64Context;
import umich.ms.util.base64.Base64ContextPooled;

public class MZMLMultiSpectraParser
extends MultiSpectraParser {
    private static final Logger log = LoggerFactory.getLogger(MZMLMultiSpectraParser.class);
    protected final MZMLFile source;
    protected MZMLRunInfo runInfo;
    protected MZMLIndex index;
    protected ArrayList<IScan> parsedScans;
    protected MzmlVars vars;
    protected ObjectPool<XMLStreamReaderImpl> readerPool = null;
    private int numOpeningScanTagsFound;

    public MZMLMultiSpectraParser(InputStream is, LCMSDataSubset subset, MZMLFile source) throws FileParsingException {
        super(is, subset);
        this.source = source;
        this.vars = new MzmlVars();
    }

    public MZMLFile getSource() {
        return this.source;
    }

    public ObjectPool<XMLStreamReaderImpl> getReaderPool() {
        return this.readerPool;
    }

    public void setReaderPool(ObjectPool<XMLStreamReaderImpl> readerPool) {
        this.readerPool = readerPool;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<IScan> call() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void tagPrecursorStart(XMLStreamReaderImpl reader) throws FileParsingException {
        if (this.flushVarsIfNoCurScan()) {
            return;
        }
        PrecursorInfo precursorInfo = new PrecursorInfo();
        ActivationInfo activationInfo = precursorInfo.getActivationInfo();
        Attributes attrs = reader.getAttributes();
        CharArray attr = attrs.getValue((CharSequence)ATTR.PRECURSOR_SPEC_REF.name);
        if (attr != null) {
            precursorInfo.setParentScanRefRaw(attr.toString());
            try {
                int scanNumInternal = this.mapIdRefToInternalScanNum(attr);
                precursorInfo.setParentScanNum(scanNumInternal);
            }
            catch (FileParsingException scanNumInternal) {
                // empty catch block
            }
        }
        int eventType = 8;
        CharArray localName = TAG.PRECURSOR.charArray;
        block16: do {
            try {
                eventType = reader.next();
                if (eventType != 1 && eventType != 2) {
                    continue;
                }
            }
            catch (XMLStreamException e) {
                if (e instanceof XMLUnexpectedEndTagException) continue;
                throw new FileParsingException(e);
            }
            localName = reader.getLocalName();
            if (eventType != 1) continue;
            attrs = reader.getAttributes();
            if (!localName.contentEquals((CharSequence)TAG.CV_PARAM.name)) continue;
            attr = attrs.getValue((CharSequence)ATTR.CV_PARAM_ACCESSION.name);
            CharArray val = attrs.getValue((CharSequence)ATTR.CV_PARAM_VALUE.name);
            if (attr == null) {
                throw new FileParsingException("cvParam did not have an 'accession' or 'value' attribute, which are required");
            }
            PSIMSCV cvEntry = PSIMSCV.fromAccession(attr);
            if (cvEntry == null) {
                String activationMethod = PSIMSCV.activationMethodFromAccession(attr);
                if (activationMethod == null) continue;
                activationInfo.setActivationMethod(activationMethod);
                continue;
            }
            switch (cvEntry) {
                case MS_PRECURSOR_ISO_WND_TARGET: {
                    this.vars.precursorIsoWndTarget = val.toDouble();
                    break;
                }
                case MS_PRECURSOR_INTENSITY: {
                    this.vars.precursorIntensity = val.toDouble();
                    precursorInfo.setIntensity(this.vars.precursorIntensity);
                    break;
                }
                case MS_PRECURSOR_ISO_WND_LO_OFFSET: {
                    this.vars.precursorIsoWndLoOffset = val.toDouble();
                    break;
                }
                case MS_PRECURSOR_ISO_WND_HI_OFFSET: {
                    this.vars.precursorIsoWndHiOffset = val.toDouble();
                    break;
                }
                case MS_PRECURSOR_ISO_WND_LO_OBSOLETE: {
                    precursorInfo.setMzRangeStart(val.toDouble());
                    break;
                }
                case MS_PRECURSOR_ISO_WND_HI_OBSOLETE: {
                    precursorInfo.setMzRangeEnd(val.toDouble());
                    break;
                }
                case MS_PRECURSOR_MZ: {
                    double v = val.toDouble();
                    if (v == 0.0) break;
                    precursorInfo.setMzTargetMono(v);
                    break;
                }
                case MS_PRECURSOR_CHARGE: {
                    precursorInfo.setCharge(val.toInt());
                    break;
                }
                case MS_ACTIVATION_ENERGY_1: 
                case MS_ACTIVATION_ENERGY_2: 
                case MS_ACTIVATION_ENERGY_LO: 
                case MS_ACTIVATION_ENERGY_SUP: {
                    activationInfo.setActivationEnergyLo(val.toDouble());
                    Double eHi = activationInfo.getActivationEnergyHi();
                    if (eHi != null && !Double.isNaN(eHi)) continue block16;
                    activationInfo.setActivationEnergyHi(val.toDouble());
                    break;
                }
                case MS_ACTIVATION_ENERGY_HI: {
                    activationInfo.setActivationEnergyHi(val.toDouble());
                }
            }
        } while (eventType != 2 || !localName.contentEquals((CharSequence)TAG.PRECURSOR.name));
        if (this.vars.precursorIsoWndTarget != null && this.vars.precursorIsoWndLoOffset != null && this.vars.precursorIsoWndHiOffset != null) {
            precursorInfo.setMzTarget(this.vars.precursorIsoWndTarget);
            precursorInfo.setMzRangeStart(this.vars.precursorIsoWndTarget - this.vars.precursorIsoWndLoOffset);
            precursorInfo.setMzRangeEnd(this.vars.precursorIsoWndTarget + this.vars.precursorIsoWndHiOffset);
        }
        this.vars.precursors.add(precursorInfo);
        this.vars.curScan.setPrecursor(precursorInfo);
    }

    /*
     * Unable to fully structure code
     */
    private void tagBinaryDataListStart(XMLStreamReaderImpl reader, Attributes attrs) throws FileParsingException, DataFormatException, IllegalStateException, IOException {
        if (this.flushVarsIfNoCurScan() || !this.doesNeedSpectrumParsing(this.vars.curScan)) {
            return;
        }
        eventType = 8;
        localName = TAG.BINARY_DATA_LIST.charArray;
        block33: do {
            try {
                eventType = reader.next();
                if (eventType != 1 && eventType != 2) {
                    continue;
                }
            }
            catch (XMLStreamException e) {
                if (e instanceof XMLUnexpectedEndTagException) continue;
                throw new FileParsingException(e);
            }
            localName = reader.getLocalName();
            if (eventType != 1) continue;
            if (localName.contentEquals((CharSequence)TAG.CV_PARAM.name)) {
                attr = attrs.getValue((CharSequence)ATTR.CV_PARAM_ACCESSION.name);
                if (attr == null) {
                    throw new FileParsingException("cvParam did not have an 'accession' or 'value' attribute, which are required");
                }
                cvEntry = PSIMSCV.fromAccession(attr);
                if (cvEntry == null) continue;
                switch (1.$SwitchMap$umich$ms$fileio$filetypes$mzml$util$PSIMSCV[cvEntry.ordinal()]) {
                    case 14: {
                        this.vars.precision = 32;
                        break;
                    }
                    case 15: {
                        this.vars.precision = 64;
                        break;
                    }
                    case 16: {
                        this.vars.getCompressions().add(PeaksCompression.ZLIB);
                        break;
                    }
                    case 17: {
                        this.vars.getCompressions().add(PeaksCompression.NONE);
                        break;
                    }
                    case 18: {
                        this.vars.getCompressions().add(PeaksCompression.NUMPRESS_LINPRED);
                        break;
                    }
                    case 19: {
                        this.vars.getCompressions().add(PeaksCompression.NUMPRESS_SHLOGF);
                        break;
                    }
                    case 20: {
                        this.vars.getCompressions().add(PeaksCompression.NUMPRESS_POSINT);
                        break;
                    }
                    case 21: {
                        this.vars.getCompressions().add(PeaksCompression.NUMPRESS_LINPRED);
                        this.vars.getCompressions().add(PeaksCompression.ZLIB);
                        break;
                    }
                    case 22: {
                        this.vars.getCompressions().add(PeaksCompression.NUMPRESS_SHLOGF);
                        this.vars.getCompressions().add(PeaksCompression.ZLIB);
                        break;
                    }
                    case 23: {
                        this.vars.getCompressions().add(PeaksCompression.NUMPRESS_POSINT);
                        this.vars.getCompressions().add(PeaksCompression.ZLIB);
                        break;
                    }
                    case 24: {
                        this.vars.binDataType = MzmlVars.BIN_DATA_TYPE.MZ;
                        break;
                    }
                    case 25: {
                        this.vars.binDataType = MzmlVars.BIN_DATA_TYPE.INTENSITY;
                        break;
                    }
                    case 26: {
                        this.vars.binDataType = MzmlVars.BIN_DATA_TYPE.IM;
                    }
                }
                continue;
            }
            if (!localName.contentEquals((CharSequence)TAG.BINARY.name)) continue;
            try {
                if (this.vars.binDataType == null) continue;
                eventType = reader.next();
                if (eventType != 4) {
                    if (eventType == 2) {
                        localName = reader.getLocalName();
                        if (!localName.contentEquals((CharSequence)TAG.BINARY.name)) continue;
                        switch (1.$SwitchMap$umich$ms$fileio$filetypes$mzml$MzmlVars$BIN_DATA_TYPE[this.vars.binDataType.ordinal()]) {
                            case 1: {
                                this.vars.mzData = MZMLPeaksDecoder.DecodedData.createEmpty();
                                continue block33;
                            }
                            case 2: {
                                this.vars.intensityData = MZMLPeaksDecoder.DecodedData.createEmpty();
                                continue block33;
                            }
                            case 3: {
                                this.vars.imData = MZMLPeaksDecoder.DecodedData.createEmpty();
                                continue block33;
                            }
                            default: {
                                throw new IllegalStateException("Binary data was decoded, but we did not finda specification if this was mz, intensity, or ion mobility data.");
                            }
                        }
                    }
                    throw new FileParsingException("Binary data tag <binary> wasn't immediately followed by Base64 encoded string");
                }
                base64 = new Base64();
                ctx = new Base64ContextPooled();
                chars = reader.getText();
                decodedB64 = base64.decode(chars.array(), chars.offset(), chars.length(), (Base64Context)ctx);
                bah = decodedB64.readResults();
                decoded = MZMLPeaksDecoder.decode(bah.getUnderlyingBytes(), bah.getPosition(), this.vars.precision, this.vars.defaultArrayLength, this.vars.getCompressions());
                ctx.close();
                switch (1.$SwitchMap$umich$ms$fileio$filetypes$mzml$MzmlVars$BIN_DATA_TYPE[this.vars.binDataType.ordinal()]) {
                    case 1: {
                        this.vars.mzData = decoded;
                        ** break;
lbl108:
                        // 1 sources

                        continue block33;
                    }
                    case 2: {
                        this.vars.intensityData = decoded;
                        ** break;
lbl112:
                        // 1 sources

                        continue block33;
                    }
                    case 3: {
                        this.vars.imData = decoded;
                        ** break;
lbl116:
                        // 1 sources

                        continue block33;
                    }
                    default: {
                        throw new IllegalStateException("Binary data was decoded, but we did not finda specification if this was mz, intensity, or ion mobility data.");
                    }
                }
            }
            catch (XMLStreamException e) {
                throw new FileParsingException(e);
            }
            finally {
                this.vars.flushBinDataDescription();
            }
        } while (eventType != 2 || !localName.contentEquals((CharSequence)TAG.BINARY_DATA_LIST.name));
        if (this.vars.intensityData == null || this.vars.mzData == null || this.vars.mzData.arr == null) {
            this.vars.isNonMassSpectrum = true;
        } else {
            basePeakMz = this.vars.intensityData.valMaxPos < 0 ? 0.0 : this.vars.mzData.arr[this.vars.intensityData.valMaxPos];
            imData = this.vars.imData == null ? null : this.vars.imData.arr;
            spectrum = new SpectrumDefault(this.vars.mzData.arr, this.vars.intensityData.arr, imData, this.vars.intensityData.valMin, this.vars.intensityData.valMinNonZero, this.vars.intensityData.valMax, basePeakMz, this.vars.intensityData.sum);
            this.vars.curScan.setSpectrum(spectrum, false);
        }
    }

    private void tagSpectrumInstarumentStart(Attributes attrs) throws FileParsingException {
        CharArray attr = attrs.getValue((CharSequence)ATTR.SPECTRUM_INSTRUMENT.name);
        Instrument instrument = this.runInfo.getDefaultInstrument();
        if (attr != null && (instrument = this.runInfo.getInstrument(attr.toString())) == null) {
            throw new FileParsingException(String.format("An instrument ref was not present for scan  index #%d, but run header did not contain that ref.", this.vars.spectrumIndex));
        }
        this.vars.curScan.setInstrument(instrument);
    }

    private void tagCvParamStart(Attributes attrs) throws FileParsingException {
        if (this.flushVarsIfNoCurScan()) {
            return;
        }
        CharArray attr = attrs.getValue((CharSequence)ATTR.CV_PARAM_ACCESSION.name);
        CharArray val = attrs.getValue((CharSequence)ATTR.CV_PARAM_VALUE.name);
        if (attr == null) {
            throw new FileParsingException("cvParam did not have an 'accession' attribute, which is required");
        }
        PSIMSCV cvEntry = PSIMSCV.fromAccession(attr);
        if (cvEntry == null) {
            Term term = PSIMSCV.MAP_NOT_MASS_SPECTRUM.get(attr);
            if (term != null) {
                this.vars.isNonMassSpectrum = true;
            }
            return;
        }
        block0 : switch (cvEntry) {
            case MS_LEVEL: {
                this.vars.curScan.setMsLevel(val.toInt());
                break;
            }
            case MS_POLARITY_POS_OBSOLETE: 
            case MS_POLARITY_POS: {
                this.vars.curScan.setPolarity(Polarity.POSITIVE);
                break;
            }
            case MS_POLARITY_NEG_OBSOLETE: 
            case MS_POLARITY_NEG: {
                this.vars.curScan.setPolarity(Polarity.NEGATIVE);
                break;
            }
            case MS_CENTROIDED: {
                this.vars.curScan.setCentroided(true);
                break;
            }
            case MS_PROFILE: {
                this.vars.curScan.setCentroided(false);
                break;
            }
            case MS_MZ_OBSERVED_LO: 
            case MS_MZ_OBSERVED_LO_INST_SETTING: {
                this.vars.curScan.setScanMzWindowLower(val.toDouble());
                break;
            }
            case MS_MZ_OBSERVED_HI: 
            case MS_MZ_OBSERVED_HI_INST_SETTING: {
                this.vars.curScan.setScanMzWindowUpper(val.toDouble());
                break;
            }
            case MS_BASEPEAK_MZ: {
                this.vars.curScan.setBasePeakMz(val.toDouble());
                break;
            }
            case MS_BASEPEAK_INTENSITY: {
                this.vars.curScan.setBasePeakIntensity(val.toDouble());
                break;
            }
            case MS_TIC: {
                this.vars.curScan.setTic(val.toDouble());
                break;
            }
            case MS_SCAN_TYPE_FULL: {
                this.vars.curScan.setScanType(ScanType.FULL);
                break;
            }
            case MS_SCAN_TYPE_CRM: {
                this.vars.curScan.setScanType(ScanType.CRM);
                break;
            }
            case MS_SCAN_TYPE_SRM: {
                this.vars.curScan.setScanType(ScanType.CRM);
                break;
            }
            case MS_SCAN_TYPE_SIM: {
                this.vars.curScan.setScanType(ScanType.SIM);
                break;
            }
            case MS_SCAN_TYPE_ZOOM: {
                this.vars.curScan.setScanType(ScanType.ZOOM);
                break;
            }
            case MS_ION_INJECTION_TIME: {
                cvEntry = PSIMSCV.UO_MILLISECONDS;
                attr = attrs.getValue((CharSequence)ATTR.CV_PARAM_UNIT_ACCESSION.name);
                if (attr != null) {
                    cvEntry = PSIMSCV.fromAccession(attr.toString());
                }
                if (cvEntry == null) {
                    throw new FileParsingException(String.format("Unknown ion injection time units accession encountered: '%s', claims to be: '%s'", attr.toString(), attrs.getValue((CharSequence)ATTR.CV_PARAM_UNIT_NAME.name).toString()));
                }
                InjectionInfo injectionInfo = this.vars.curScan.getInjectionInfo();
                if (injectionInfo == null) {
                    injectionInfo = new InjectionInfo();
                    this.vars.curScan.setInjectionInfo(injectionInfo);
                }
                switch (cvEntry) {
                    case UO_MILLISECONDS: {
                        injectionInfo.setDuration(val.toDouble());
                        break;
                    }
                    case UO_MICROSECONDS: {
                        injectionInfo.setDuration(val.toDouble() / 1000.0);
                        break;
                    }
                    case UO_NANOSECONDS: {
                        injectionInfo.setDuration(val.toDouble() / 1000000.0);
                        break;
                    }
                    case UO_SECONDS: {
                        injectionInfo.setDuration(val.toDouble() * 1000.0);
                        break;
                    }
                    case UO_MINUTES: {
                        injectionInfo.setDuration(val.toDouble() * 60.0 * 1000.0);
                        break;
                    }
                    case UO_HOURS: {
                        injectionInfo.setDuration(val.toDouble() * 60.0 * 1000000.0);
                    }
                }
                break;
            }
            case MS_IM: {
                this.vars.curScan.setIm(val.toDouble());
                break;
            }
            case MS_RT_SCAN_START: 
            case MS_RT_RETENTION_TIME: 
            case MS_RT_RETENTION_TIME_LOCAL: 
            case MS_RT_RETENTION_TIME_NORMALIZED: {
                cvEntry = PSIMSCV.UO_SECONDS;
                attr = attrs.getValue((CharSequence)ATTR.CV_PARAM_UNIT_ACCESSION.name);
                if (attr != null) {
                    cvEntry = PSIMSCV.fromAccession(attr.toString());
                }
                if (cvEntry == null) {
                    throw new FileParsingException(String.format("Unknown RT time units accession encountered: '%s', claims to be: '%s'", attr.toString(), attrs.getValue((CharSequence)ATTR.CV_PARAM_UNIT_NAME.name).toString()));
                }
                switch (cvEntry) {
                    case UO_SECONDS: {
                        this.vars.curScan.setRt(val.toDouble() / 60.0);
                        break block0;
                    }
                    case UO_MINUTES: {
                        this.vars.curScan.setRt(val.toDouble());
                        break block0;
                    }
                    case UO_HOURS: {
                        this.vars.curScan.setRt(val.toDouble() * 60.0);
                        break block0;
                    }
                    case UO_MILLISECONDS: {
                        this.vars.curScan.setRt(val.toDouble() / 1000.0 * 60.0);
                        break block0;
                    }
                    case UO_MICROSECONDS: {
                        this.vars.curScan.setRt(val.toDouble() / 1000000.0 * 60.0);
                        break block0;
                    }
                    case UO_NANOSECONDS: {
                        this.vars.curScan.setRt(val.toDouble() / 1.0E9 * 60.0);
                    }
                }
            }
        }
    }

    private void tagSpectrumStart(Attributes attrs) throws FileParsingException {
        ++this.numOpeningScanTagsFound;
        if (this.vars.curScan != null) {
            this.addCurScanAndFlushVars();
        }
        try {
            this.vars.spectrumIndex = attrs.getValue((CharSequence)ATTR.SPECTRUM_INDEX.name).toInt();
            this.vars.defaultArrayLength = attrs.getValue((CharSequence)ATTR.SPECTRUM_DEFAULT_ARRAY_LENGTH.name).toInt();
        }
        catch (NumberFormatException e) {
            throw new FileParsingException("One of the required attributes for <scan> was missing", e);
        }
        int scanNumInternal = this.mapRawNumToInternalScanNum(this.vars.spectrumIndex);
        this.vars.curScan = new ScanDefault(scanNumInternal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int findThisStreamFirstScanLen() throws FileParsingException {
        int length = -1;
        this.numOpeningScanTagsFound = 0;
        this.vars = new MzmlVars();
        XMLStreamReaderImpl reader = null;
        try {
            reader = this.readerPool == null ? new XMLStreamReaderImpl() : (XMLStreamReaderImpl)this.readerPool.borrowObject();
            reader.setInput(this.is, StandardCharsets.UTF_8.name());
            LogHelper.setJavolutionLogLevelFatal();
            int eventType = 8;
            block22: do {
                try {
                    eventType = reader.next();
                }
                catch (XMLStreamException e) {
                    if (e instanceof XMLUnexpectedEndTagException) continue;
                    if (!(e instanceof XMLUnexpectedEndOfDocumentException)) throw new FileParsingException(e);
                    int n = length;
                    if (this.readerPool == null) return n;
                    if (reader == null) return n;
                    try {
                        this.readerPool.returnObject((Object)reader);
                        return n;
                    }
                    catch (Exception e2) {
                        throw new FileParsingException(e2);
                    }
                }
                switch (eventType) {
                    case 1: {
                        CharArray localName = reader.getLocalName();
                        if (!localName.contentEquals((CharSequence)TAG.SPECTRUM.name)) continue block22;
                        ++this.numOpeningScanTagsFound;
                        break;
                    }
                    case 2: {
                        CharArray localName = reader.getLocalName();
                        if (!localName.contentEquals((CharSequence)TAG.SPECTRUM.name) || this.numOpeningScanTagsFound != 1) continue block22;
                        XMLStreamReaderImpl.LocationImpl loc = reader.getLocation();
                        int n = length = loc.getCharacterOffset() + loc.getBomLength();
                        return n;
                    }
                }
            } while (eventType != 8);
            return length;
        }
        catch (IOException | DataFormatException | XMLStreamException e) {
            throw new FileParsingException(e);
        }
        catch (Exception e) {
            throw new FileParsingException(e);
        }
        finally {
            if (this.readerPool != null && reader != null) {
                try {
                    this.readerPool.returnObject((Object)reader);
                }
                catch (Exception e) {
                    throw new FileParsingException(e);
                }
            }
        }
    }

    protected void addCurScanAndFlushVars() {
        try {
            boolean needSpectrumParsing;
            if (this.vars.curScan != null && !this.vars.isNonMassSpectrum && (!(needSpectrumParsing = this.doesNeedSpectrumParsing(this.vars.curScan)) || this.vars.mzData != null && this.vars.intensityData != null)) {
                boolean isNotEmptyScan;
                boolean bl = isNotEmptyScan = this.vars.curScan.getSpectrum() != null && this.vars.curScan.getSpectrum().getMZs() != null && this.vars.curScan.getSpectrum().getMZs().length > 0 && this.vars.curScan.getSpectrum().getIntensities() != null && this.vars.curScan.getSpectrum().getIntensities().length > 0 && (this.vars.curScan.getSpectrum().getIMs() == null || this.vars.curScan.getSpectrum().getIMs().length > 0);
                if (!this.source.isExcludeEmptyScans() || isNotEmptyScan) {
                    if (this.vars.precursors.size() > 1) {
                        System.err.printf("Found multiple precursors for scan #%d, this is not really supported", this.vars.curScan.getNum());
                    }
                    if (this.vars.curScan.getInstrument() == null) {
                        this.vars.curScan.setInstrument(this.runInfo.getDefaultInstrument());
                    }
                    this.parsedScans.add(this.vars.curScan);
                }
            }
        }
        finally {
            this.vars.reset();
        }
    }

    protected boolean flushVarsIfNoCurScan() {
        if (this.vars.curScan == null) {
            this.vars.reset();
            return true;
        }
        return false;
    }

    protected int mapIdRefToInternalScanNum(CharArray id) throws FileParsingException {
        String idStr = id.toString();
        MZMLIndexElement byId = (MZMLIndexElement)this.index.getById(idStr);
        if (byId == null) {
            String msg = String.format("Could not find a mapping from spectrum id ref to an internal scan number for\n\t file: %s\n\t spectrum index of the spectrum in which the error occured: #%d\n\t idRef searched for: %s", this.source.getPath(), this.vars.spectrumIndex, idStr);
            throw new FileParsingException(msg);
        }
        return byId.getNumber();
    }

    protected int mapRawNumToInternalScanNum(int spectrumIndex) throws FileParsingException {
        MZMLIndexElement byRawNum = (MZMLIndexElement)this.index.getByRawNum(spectrumIndex);
        if (byRawNum == null) {
            String msg = String.format("Could not find a mapping from spectrum index ref to an internal scan number for\n\t file: %s\n\t spectrum index searched for: #%d\n\t spectrum index of the spectrum in which the error occured: #%d", this.source.getPath(), spectrumIndex, this.vars.spectrumIndex);
            throw new FileParsingException(msg);
        }
        return byRawNum.getNumber();
    }

    protected boolean doesNeedSpectrumParsing(IScan scan) {
        return this.subset.isInSubset(scan);
    }

    protected static enum ATTR {
        SPECTRUM_INDEX("index", true),
        SPECTRUM_ID("id", true),
        SPECTRUM_INSTRUMENT("instrumentConfigurationRef", false),
        SPECTRUM_DEFAULT_ARRAY_LENGTH("defaultArrayLength", true),
        CV_PARAM_ACCESSION("accession", true),
        CV_PARAM_VALUE("value", true),
        CV_PARAM_UNIT_ACCESSION("unitAccession", true),
        CV_PARAM_UNIT_NAME("unitName", true),
        PRECURSOR_SPEC_REF("spectrumRef", false),
        REF("ref", false);

        public final String name;
        public final CharArray charArray;
        public final boolean isRequired;

        private ATTR(String name, boolean isRequired) {
            this.name = name;
            this.charArray = new CharArray(name);
            this.isRequired = isRequired;
        }
    }

    protected static enum TAG {
        SPECTRUM("spectrum"),
        CV_PARAM("cvParam"),
        SCAN_LIST("scanList"),
        SCAN("scan"),
        PRECURSOR_LIST("precursorList"),
        PRECURSOR("precursor"),
        SELECTED_ION_LIST("selectedIonList"),
        SELECTED_ION("selectedIon"),
        ACTIVATION("activation"),
        BINARY_DATA_LIST("binaryDataArrayList"),
        BINARY_DATA_ARRAY("binaryDataArray"),
        BINARY("binary"),
        REF_PARAM_GROUP_LIST("referenceableParamGroupList"),
        REF_PARAM_GROUP("referenceableParamGroup"),
        REF_PARAM_GROUP_REF("referenceableParamGroupRef");

        public final String name;
        public final CharArray charArray;

        private TAG(String name) {
            this.name = name;
            this.charArray = new CharArray(name);
        }
    }
}

