/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLStreamReader;
import org.biojava.nbio.ontology.Term;
import org.biojava.nbio.ontology.Triple;
import umich.ms.datatypes.lcmsrun.Hash;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.datatypes.lcmsrun.MsSoftware;
import umich.ms.datatypes.lcmsrun.OriginalFile;
import umich.ms.datatypes.scan.props.Instrument;
import umich.ms.fileio.exceptions.RunHeaderParsingException;
import umich.ms.fileio.filetypes.mzml.MZMLFile;
import umich.ms.fileio.filetypes.mzml.MZMLRunInfo;
import umich.ms.fileio.filetypes.mzml.jaxb.CVParamType;
import umich.ms.fileio.filetypes.mzml.jaxb.ComponentListType;
import umich.ms.fileio.filetypes.mzml.jaxb.ComponentType;
import umich.ms.fileio.filetypes.mzml.jaxb.DataProcessingType;
import umich.ms.fileio.filetypes.mzml.jaxb.FileDescriptionType;
import umich.ms.fileio.filetypes.mzml.jaxb.InstrumentConfigurationListType;
import umich.ms.fileio.filetypes.mzml.jaxb.InstrumentConfigurationType;
import umich.ms.fileio.filetypes.mzml.jaxb.MzMLType;
import umich.ms.fileio.filetypes.mzml.jaxb.ProcessingMethodType;
import umich.ms.fileio.filetypes.mzml.jaxb.ReferenceableParamGroupListType;
import umich.ms.fileio.filetypes.mzml.jaxb.ReferenceableParamGroupRefType;
import umich.ms.fileio.filetypes.mzml.jaxb.ReferenceableParamGroupType;
import umich.ms.fileio.filetypes.mzml.jaxb.RunType;
import umich.ms.fileio.filetypes.mzml.jaxb.SoftwareListType;
import umich.ms.fileio.filetypes.mzml.jaxb.SoftwareType;
import umich.ms.fileio.filetypes.mzml.jaxb.SourceFileListType;
import umich.ms.fileio.filetypes.mzml.jaxb.SourceFileType;
import umich.ms.fileio.filetypes.mzml.util.InstrumentModelCVTerm;
import umich.ms.fileio.filetypes.mzml.util.PSIMSCV;
import umich.ms.fileio.filetypes.mzxml.XmlBasedRunHeaderParser;
import umich.ms.logging.LogHelper;
import umich.ms.util.OffsetLength;
import umich.ms.util.StringUtils;
import umich.ms.util.jaxb.JaxbUtils;
import umich.ms.util.xml.POSITION;
import umich.ms.util.xml.XmlUtils;

public class MZMLRunHeaderParser
implements XmlBasedRunHeaderParser {
    private static final String TAG_MZML = "mzML";
    private static final String TAG_RUN = "run";
    protected MZMLFile source;

    public MZMLRunHeaderParser(MZMLFile source) {
        this.source = source;
        LogHelper.setJavolutionLogLevelFatal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MZMLRunInfo parse() throws RunHeaderParsingException {
        InstrumentConfigurationListType instrumentConfigurationList;
        SoftwareListType softwareList;
        SourceFileListType sourceFileList;
        FileDescriptionType fileDescription;
        List<ReferenceableParamGroupType> referenceableParamGroups;
        MzMLType mzml;
        String header;
        Object suffix;
        OffsetLength loc;
        Charset utf8 = Charset.forName("UTF-8");
        long maxOffset = 0xA00000L;
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(this.source.getPath()));){
            String search1 = "<mzML";
            String search2 = "<run";
            String search3 = ">";
            List<byte[]> targets = Arrays.asList(search1.getBytes(utf8), search2.getBytes(utf8), search3.getBytes(utf8));
            List<POSITION> locations = Arrays.asList(POSITION.START, POSITION.START, POSITION.END);
            List<Long> locate = XmlUtils.locate(targets, locations, bis, 0xA00000L);
            if (locate == null || locate.size() != targets.size()) {
                throw new RunHeaderParsingException("Could not locate the header within 10485760 bytes of the file.");
            }
            loc = new OffsetLength(locate.get(0), (int)(locate.get(2) - locate.get(0) + 1L));
        }
        catch (IOException | RunHeaderParsingException e) {
            LCMSRunInfo dummyInfo = LCMSRunInfo.createDummyInfo();
            return new MZMLRunInfo(dummyInfo);
        }
        RandomAccessFile raf = null;
        try {
            raf = this.source.getRandomAccessFile();
            raf.seek(loc.offset);
            byte[] bytes = new byte[loc.length];
            raf.readFully(bytes);
            String body = new String(bytes, utf8);
            suffix = String.format("</%s></%s>", TAG_RUN, TAG_MZML);
            header = body + (String)suffix;
        }
        catch (IOException e) {
            LCMSRunInfo dummyInfo = LCMSRunInfo.createDummyInfo();
            suffix = new MZMLRunInfo(dummyInfo);
            return suffix;
        }
        finally {
            if (raf != null) {
                this.source.close();
            }
        }
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(header.getBytes(Charset.forName("UTF-8")));
            suffix = null;
            try {
                XMLStreamReader xsr = JaxbUtils.createXmlStreamReader(is, false);
                mzml = JaxbUtils.unmarshal(MzMLType.class, xsr);
            }
            catch (Throwable xsr) {
                suffix = xsr;
                throw xsr;
            }
            finally {
                if (is != null) {
                    if (suffix != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable xsr) {
                            ((Throwable)suffix).addSuppressed(xsr);
                        }
                    } else {
                        ((InputStream)is).close();
                    }
                }
            }
        }
        catch (IOException | JAXBException e1) {
            LCMSRunInfo dummyInfo = LCMSRunInfo.createDummyInfo();
            return new MZMLRunInfo(dummyInfo);
        }
        MZMLRunInfo runInfo = new MZMLRunInfo(mzml);
        ReferenceableParamGroupListType referenceableParamGroupList = mzml.getReferenceableParamGroupList();
        if (referenceableParamGroupList != null && (referenceableParamGroups = referenceableParamGroupList.getReferenceableParamGroup()) != null) {
            for (ReferenceableParamGroupType grp : referenceableParamGroups) {
                runInfo.addRefParamGroup(grp.getId(), grp.getCvParam());
            }
        }
        if ((fileDescription = mzml.getFileDescription()) != null && (sourceFileList = fileDescription.getSourceFileList()) != null) {
            List<SourceFileType> sourceFiles = sourceFileList.getSourceFile();
            for (SourceFileType sourceFileType : sourceFiles) {
                String location = sourceFileType.getLocation();
                String name = sourceFileType.getName();
                Hash hash = null;
                for (CVParamType cvParam : sourceFileType.getCvParam()) {
                    if (PSIMSCV.MS_HASH_SHA1.accession.equals(cvParam.getAccession())) {
                        hash = new Hash(cvParam.getValue(), Hash.TYPE.SHA1);
                        continue;
                    }
                    if (!PSIMSCV.MS_HASH_MD5.accession.equals(cvParam.getAccession())) continue;
                    hash = new Hash(cvParam.getValue(), Hash.TYPE.MD5);
                }
                runInfo.getOriginalFiles().add(new OriginalFile(location, name, hash));
            }
        }
        if ((softwareList = mzml.getSoftwareList()) != null) {
            List<SoftwareType> software = softwareList.getSoftware();
            for (SoftwareType softwareType : software) {
                String name = softwareType.getId();
                String id = softwareType.getId();
                String version = softwareType.getVersion();
                for (CVParamType cv : softwareType.getCvParam()) {
                    if (cv.getName() == null || cv.getName().isEmpty()) continue;
                    name = cv.getName();
                }
                runInfo.getSoftware().add(new MsSoftware(name, version));
            }
        }
        if ((instrumentConfigurationList = mzml.getInstrumentConfigurationList()) != null) {
            List<InstrumentConfigurationType> instruments = instrumentConfigurationList.getInstrumentConfiguration();
            if (instruments != null && instruments.size() > 0) {
                for (InstrumentConfigurationType i : instruments) {
                    if (i.getId() == null) {
                        throw new RunHeaderParsingException("Could not find instrument ID attribute. Should be <instrumentConfiguration id=\"xxx\">");
                    }
                    String msInstrumentID = i.getId();
                    Instrument instrument = new Instrument();
                    boolean isInstrumentCvParamFound = false;
                    boolean isVendorCvParamFound = false;
                    if (!i.getCvParam().isEmpty()) {
                        for (CVParamType cVParamType : i.getCvParam()) {
                            if (this.lookupInstrumentCV(cVParamType, instrument)) {
                                isInstrumentCvParamFound = true;
                            }
                            if (this.lookupInstrumentVendor(cVParamType, instrument)) {
                                isVendorCvParamFound = true;
                            }
                            if (!PSIMSCV.MS_INSTRUMENT_SERIAL_NUMBER.accession.equals(cVParamType.getAccession())) continue;
                            instrument.setSerialNumber(cVParamType.getValue());
                        }
                    }
                    if (!isInstrumentCvParamFound && !i.getReferenceableParamGroupRef().isEmpty()) {
                        List<ReferenceableParamGroupRefType> refGrps = i.getReferenceableParamGroupRef();
                        for (ReferenceableParamGroupRefType refGrpRef : refGrps) {
                            ReferenceableParamGroupType refGrp = (ReferenceableParamGroupType)refGrpRef.getRef();
                            for (CVParamType cvParam2 : refGrp.getCvParam()) {
                                if (this.lookupInstrumentCV(cvParam2, instrument)) {
                                    isInstrumentCvParamFound = true;
                                }
                                if (this.lookupInstrumentVendor(cvParam2, instrument)) {
                                    isVendorCvParamFound = true;
                                }
                                if (!PSIMSCV.MS_INSTRUMENT_SERIAL_NUMBER.accession.equals(cvParam2.getAccession())) continue;
                                instrument.setSerialNumber(cvParam2.getValue());
                            }
                        }
                    }
                    if (!isInstrumentCvParamFound && !isVendorCvParamFound) {
                        instrument.setManufacturer("Vendor N/A");
                        instrument.setModel("Model N/A");
                    } else if (!isInstrumentCvParamFound && isVendorCvParamFound) {
                        instrument.setModel("Model N/A");
                    }
                    ComponentListType componentList = i.getComponentList();
                    if (componentList != null) {
                        String string = this.componentTypeListToString(componentList.getAnalyzer(), PSIMSCV.MAP_ANALYZER_TYPE);
                        instrument.setAnalyzer(string);
                        instrument.setDetector("");
                        String ionization = this.componentTypeListToString(componentList.getSource(), PSIMSCV.MAP_IONIZATION_TYPE);
                        instrument.setIonisation(ionization);
                    }
                    runInfo.addInstrument(instrument, msInstrumentID);
                }
            }
        } else {
            runInfo.addInstrument(Instrument.getDummy(), "ID_UNKNOWN");
        }
        RunType run = mzml.getRun();
        if (run == null) {
            throw new RunHeaderParsingException("Could not find <run> tag, which is needed to get default instrument ID");
        }
        Object object = run.getDefaultInstrumentConfigurationRef();
        if (!(object instanceof InstrumentConfigurationType)) {
            throw new RunHeaderParsingException("Could not find \"defaultInstrumentConfigurationRef\" attribute of <run> tag, it is required by mzML standard");
        }
        InstrumentConfigurationType instrument = (InstrumentConfigurationType)object;
        runInfo.setDefaultInstrumentID(instrument.getId());
        XMLGregorianCalendar startTimeStamp = run.getStartTimeStamp();
        if (startTimeStamp != null) {
            GregorianCalendar cal = startTimeStamp.toGregorianCalendar();
            Date date = cal.getTime();
            runInfo.setRunStartTime(date);
        }
        List<DataProcessingType> dataProcessings = mzml.getDataProcessingList().getDataProcessing();
        block36: for (DataProcessingType dataProcessing : dataProcessings) {
            for (ProcessingMethodType processingMethodType : dataProcessing.getProcessingMethod()) {
                for (CVParamType cvParam : processingMethodType.getCvParam()) {
                    if (!PSIMSCV.isPeakPickingTerm(cvParam.getAccession())) continue;
                    runInfo.setCentroided(true);
                    break block36;
                }
            }
        }
        return runInfo;
    }

    private boolean lookupInstrumentCV(CVParamType cvParam, Instrument instrument) {
        InstrumentModelCVTerm instrumentModelCVTerm = PSIMSCV.instrumentFromAccession(cvParam.getAccession());
        if (instrumentModelCVTerm != null) {
            instrument.setManufacturer(instrumentModelCVTerm.vendor);
            instrument.setModel(instrumentModelCVTerm.model);
            return true;
        }
        return false;
    }

    private boolean lookupInstrumentVendor(CVParamType cvParam, Instrument instrument) {
        String accession = cvParam.getAccession();
        try {
            Triple triple;
            Term object;
            Term term = PSIMSCV.ONTOLOGY.getTerm(accession);
            Set term_is_a = PSIMSCV.ONTOLOGY.getTriples(term, null, null);
            if (term_is_a.size() == 1 && (object = (triple = (Triple)term_is_a.iterator().next()).getObject()).getName().equalsIgnoreCase(PSIMSCV.MS_INSTRUMENT_MODEL.accession)) {
                String vendor = term.getDescription();
                vendor = vendor.replaceAll(PSIMSCV.MS_INSTRUMENT_MODEL.description, "");
                instrument.setManufacturer(vendor);
                return true;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return false;
    }

    private String componentTypeListToString(List<? extends ComponentType> comps, Map<String, Term> whitelist) {
        ArrayList<String> strings = new ArrayList<String>();
        for (ComponentType componentType : comps) {
            List<CVParamType> cvParams = componentType.getCvParam();
            for (CVParamType cvParam : cvParams) {
                String accession = cvParam.getAccession();
                if (accession.equals(PSIMSCV.MS_INSTRUMENT_COMPONENT_SOURCE.accession) || accession.equals(PSIMSCV.MS_INSTRUMENT_COMPONENT_ANALYZER.accession) || accession.equals(PSIMSCV.MS_INSTRUMENT_COMPONENT_DETECTOR.accession) || whitelist != null && !whitelist.containsKey(accession)) continue;
                strings.add(cvParam.getName());
            }
        }
        return StringUtils.join(strings, ", ");
    }
}

