/*
 * Decompiled with CFR 0.152.
 */
package umich.ms.fileio.filetypes.mzxml;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javolution.xml.internal.stream.XMLStreamReaderImpl;
import org.apache.commons.pool2.ObjectPool;
import umich.ms.datatypes.LCMSDataSubset;
import umich.ms.datatypes.lcmsrun.LCMSRunInfo;
import umich.ms.fileio.exceptions.FileParsingException;
import umich.ms.fileio.filetypes.mzxml.MZXMLIndex;
import umich.ms.fileio.filetypes.mzxml.MZXMLIndexBuilder;
import umich.ms.fileio.filetypes.mzxml.MZXMLIndexElement;
import umich.ms.fileio.filetypes.mzxml.MZXMLIndexParser;
import umich.ms.fileio.filetypes.mzxml.MZXMLMultiSpectraParser;
import umich.ms.fileio.filetypes.mzxml.MZXMLRunHeaderParser;
import umich.ms.fileio.filetypes.xmlbased.AbstractXMLBasedDataSource;
import umich.ms.fileio.filetypes.xmlbased.IndexBuilder;

public class MZXMLFile
extends AbstractXMLBasedDataSource<MZXMLIndexElement, MZXMLIndex> {
    private volatile MZXMLIndex index;

    public MZXMLFile(String path) {
        super(path);
    }

    public MZXMLFile(String path, boolean excludeEmptyScans) {
        super(path);
        this.excludeEmptyScans = excludeEmptyScans;
    }

    public ObjectPool<XMLStreamReaderImpl> getReaderPool() {
        return this.readerPool;
    }

    @Override
    public MZXMLIndex getIndex() {
        return this.index;
    }

    @Override
    public MZXMLIndex parseIndex() throws FileParsingException {
        MZXMLIndexParser parser = new MZXMLIndexParser(this);
        return parser.parse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MZXMLIndex fetchIndex() throws FileParsingException {
        MZXMLIndex tmp = this.index;
        if (tmp == null) {
            MZXMLFile mZXMLFile = this;
            synchronized (mZXMLFile) {
                tmp = this.getIndex();
                if (tmp == null) {
                    this.index = tmp = this.parseIndex();
                }
            }
        }
        return tmp;
    }

    @Override
    public LCMSRunInfo parseRunInfo() throws FileParsingException {
        MZXMLRunHeaderParser parser = new MZXMLRunHeaderParser(this);
        return parser.parse();
    }

    @Override
    protected void releaseResources() {
        this.index = null;
    }

    @Override
    public MZXMLMultiSpectraParser getSpectraParser(InputStream inputStream, LCMSDataSubset subset, ObjectPool<XMLStreamReaderImpl> readerPool, Integer numSpectra) {
        MZXMLMultiSpectraParser parser;
        try {
            parser = new MZXMLMultiSpectraParser(inputStream, subset, this);
        }
        catch (FileParsingException ex) {
            throw new IllegalStateException(ex);
        }
        parser.setNumScansToProcess(numSpectra);
        parser.setReaderPool(readerPool);
        return parser;
    }

    @Override
    public IndexBuilder<MZXMLIndexElement> getIndexBuilder(IndexBuilder.Info info) {
        return new MZXMLIndexBuilder(info, this.getReaderPool());
    }

    @Override
    protected MZXMLIndex fixIndex(MZXMLIndex idx) {
        super.fixIndex(idx);
        int curInternalNum = 1;
        MZXMLIndex newIndex = new MZXMLIndex();
        Set entries = idx.getMapByNum().entrySet();
        for (Map.Entry entry : entries) {
            MZXMLIndexElement eOld = (MZXMLIndexElement)entry.getValue();
            MZXMLIndexElement eNew = new MZXMLIndexElement(curInternalNum, eOld.getRawNumber(), eOld.getOffsetLength());
            newIndex.add(eNew);
            ++curInternalNum;
        }
        return newIndex;
    }
}

