/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui.command;

import com.google.gson.Gson;
import fr.profi.mgfboost.ui.command.ICommand;
import fr.profi.mgfboost.ui.command.ui.AbstractCommandPanel;
import java.io.File;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public abstract class AbstractCommand<T>
implements ICommand<T> {
    static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    protected T command;
    protected CommandType commandType = CommandType.SINGLE_INPUT;
    protected AbstractCommandPanel<T> configurationPanel;

    protected abstract AbstractCommandPanel<T> getConfigurationPanel();

    public T getCommand() {
        return this.command;
    }

    @Override
    public String getCommandName() {
        return this.command.getClass().getSimpleName();
    }

    @Override
    public String toJSON() {
        return new Gson().toJson(this.command);
    }

    @Override
    public boolean fromJSON(String jsonString) {
        try {
            Object t = new Gson().fromJson(jsonString, this.command.getClass());
            this.getConfigurationPanel().updatePanelFromCommand(t);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean buildCommand() {
        if (this.configurationPanel != null) {
            return this.configurationPanel.buildCommand(this.command);
        }
        return false;
    }

    @Override
    public void showErrorMessage() {
    }

    protected static File getDestFile(File inputFile, String parentFolder, String defaultExtension) {
        String inputFileName = inputFile.getName();
        Object dstFilePath = inputFileName.substring(0, inputFileName.lastIndexOf(46)) + defaultExtension;
        File dstFile = new File(parentFolder, (String)dstFilePath);
        if (dstFile.exists()) {
            String timestamp = MessageFormat.format("{0}", LocalDateTime.now().format(DATETIME_FORMATTER));
            dstFilePath = inputFileName.substring(0, inputFileName.lastIndexOf(46)) + "-" + timestamp + defaultExtension;
            dstFile = new File(parentFolder, (String)dstFilePath);
        }
        return dstFile;
    }

    public static enum CommandType {
        SINGLE_INPUT,
        BATCH_INPUT;

    }
}

