/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mgfboost.ui.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fr.profi.mgfboost.ui.MainPanel;
import fr.profi.mgfboost.ui.command.AbstractCommand;
import fr.profi.mgfboost.ui.command.ICommand;
import fr.profi.mgfboost.ui.command.PCleanMgfCommand;
import fr.profi.mgfboost.ui.command.ui.AbstractCommandPanel;
import fr.profi.mgfboost.ui.command.ui.MzdbCreateMgfPanel;
import fr.profi.mgfboost.ui.command.ui.OutputFilePanel;
import fr.profi.mgfboost.ui.model.MS2Collection;
import fr.profi.mzknife.CommandArguments;
import fr.profi.mzknife.MzDbProcessing;
import fr.profi.mzknife.mzdb.MgfBoostConfigTemplate;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MzdbCreateMgfCommand
extends AbstractCommand<CommandArguments.MzDBCreateMgfCommand> {
    private static final Logger logger = LoggerFactory.getLogger(PCleanMgfCommand.class);

    public MzdbCreateMgfCommand() {
        this.command = new CommandArguments.MzDBCreateMgfCommand();
        ((CommandArguments.MzDBCreateMgfCommand)this.command).exportProlineTitle = true;
    }

    @Override
    public MS2Collection execute(File ... files) throws Exception {
        ((CommandArguments.MzDBCreateMgfCommand)this.command).mzdbFile = files[0].getAbsolutePath();
        String originalOutFilePath = ((CommandArguments.MzDBCreateMgfCommand)this.command).outputFile;
        if (this.commandType.equals((Object)AbstractCommand.CommandType.BATCH_INPUT)) {
            ((CommandArguments.MzDBCreateMgfCommand)this.command).outputFile = MzdbCreateMgfCommand.getDestFile(files[0], ((CommandArguments.MzDBCreateMgfCommand)this.command).outputFile, ".mgf").getAbsolutePath();
        }
        logger.info("Execute command " + this.getCommandName() + " on " + Arrays.stream(files).map(f -> f.getName()).collect(Collectors.joining()));
        logger.info("Command args : " + ToStringBuilder.reflectionToString(this.command));
        MzDbProcessing.mzdbcreateMgf((CommandArguments.MzDBCreateMgfCommand)((CommandArguments.MzDBCreateMgfCommand)this.command));
        MS2Collection ms2Collection = new MS2Collection(new File(((CommandArguments.MzDBCreateMgfCommand)this.command).outputFile), MainPanel.FileType.MGF);
        ((CommandArguments.MzDBCreateMgfCommand)this.command).outputFile = originalOutFilePath;
        return ms2Collection;
    }

    @Override
    public void showErrorMessage() {
        if (this.configurationPanel != null) {
            this.configurationPanel.showErrorMessage();
        }
    }

    @Override
    public ICommand.ExecutionMode getExecutionMode() {
        return ICommand.ExecutionMode.BATCH_OF_SINGLE_FILES;
    }

    @Override
    protected AbstractCommandPanel<CommandArguments.MzDBCreateMgfCommand> getConfigurationPanel() {
        if (this.configurationPanel == null) {
            this.configurationPanel = new MzdbCreateMgfPanel().updatePanelFromCommand((CommandArguments.MzDBCreateMgfCommand)this.command);
        }
        return this.configurationPanel;
    }

    @Override
    public AbstractCommandPanel<CommandArguments.MzDBCreateMgfCommand> getConfigurationPanel(List<MS2Collection> selectedCollections) {
        this.commandType = selectedCollections.size() > 1 ? AbstractCommand.CommandType.BATCH_INPUT : AbstractCommand.CommandType.SINGLE_INPUT;
        this.configurationPanel = new MzdbCreateMgfPanel().updatePanelFromCommand((CommandArguments.MzDBCreateMgfCommand)this.command);
        this.configurationPanel.setOutputRootFolder(selectedCollections.get(0).getFile().getParentFile());
        this.configurationPanel.setOutputType(selectedCollections.size() > 1 ? OutputFilePanel.OutputType.FOLDER : OutputFilePanel.OutputType.FILE);
        return this.configurationPanel;
    }

    @Override
    public boolean fromJSON(String jsonString) {
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonElement jsonElement = (JsonElement)gson.fromJson(jsonString, JsonElement.class);
            MgfBoostConfigTemplate boostConfigTemplate = null;
            if (((JsonObject)jsonElement).get("mgfBoostConfigTemplate") != null) {
                String boostConfigTemplateStr = ((JsonObject)jsonElement).get("mgfBoostConfigTemplate").getAsString();
                boostConfigTemplate = MgfBoostConfigTemplate.valueOf((String)boostConfigTemplateStr);
            }
            CommandArguments.MzDBCreateMgfCommand newCommand = (CommandArguments.MzDBCreateMgfCommand)gson.fromJson(((JsonObject)jsonElement).get("command"), CommandArguments.MzDBCreateMgfCommand.class);
            this.getConfigurationPanel().updatePanelFromCommand(newCommand);
            ((MzdbCreateMgfPanel)this.getConfigurationPanel()).setMgfBoostConfigTemplate(boostConfigTemplate);
            return true;
        }
        catch (Exception e) {
            logger.debug("Error while loading settings :", (Throwable)e);
            return false;
        }
    }

    @Override
    public String toJSON() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("command", this.command);
        values.put("mgfBoostConfigTemplate", ((MzdbCreateMgfPanel)this.getConfigurationPanel()).getMgfBoostConfigTemplate());
        return gson.toJson(values);
    }
}

