/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.cli.modifications;

import com.compomics.cli.modifications.ModificationsCLIParams;
import com.compomics.software.cli.CommandParameter;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AtomChain;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;

public class ModificationsCLIInputBean {
    private File fileIn = null;
    private File fileOut = null;
    private boolean list = false;
    private String modificationToRemove = null;
    private PTM modificationToAdd = null;

    public static boolean isValidStartup(CommandLine aLine) {
        String arg;
        PTM ptm;
        String arg2;
        if (aLine.getOptions().length == 0) {
            return false;
        }
        PTMFactory ptmFactory = null;
        if (aLine.hasOption(ModificationsCLIParams.IN.id)) {
            arg2 = aLine.getOptionValue(ModificationsCLIParams.IN.id);
            if (arg2.equals("")) {
                System.out.println(System.getProperty("line.separator") + "No input file specified!" + System.getProperty("line.separator"));
                return false;
            }
            File fileIn = new File(arg2);
            if (!fileIn.exists()) {
                System.out.println(System.getProperty("line.separator") + "File " + fileIn + " not found." + System.getProperty("line.separator"));
                return false;
            }
            try {
                ptmFactory = PTMFactory.loadFromFile(fileIn);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing " + fileIn + "." + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
        }
        if (aLine.hasOption(ModificationsCLIParams.LIST.id)) {
            return true;
        }
        if (aLine.hasOption(ModificationsCLIParams.RM.id) && (ptm = ptmFactory.getPTM(arg2 = aLine.getOptionValue(ModificationsCLIParams.RM.id))) == null) {
            String file = aLine.getOptionValue(ModificationsCLIParams.IN.id);
            System.out.println(System.getProperty("line.separator") + "Enzyme " + arg2 + " not found in " + file + "." + System.getProperty("line.separator"));
            return false;
        }
        boolean name = aLine.hasOption(ModificationsCLIParams.NAME.id);
        boolean composition = false;
        boolean pattern = false;
        if (aLine.hasOption(ModificationsCLIParams.COMPOSITION_ADDED.id)) {
            if (!name) {
                System.out.println(System.getProperty("line.separator") + "No name provided for the PTM to add." + System.getProperty("line.separator"));
                return false;
            }
            arg = aLine.getOptionValue(ModificationsCLIParams.COMPOSITION_ADDED.id);
            try {
                AtomChain.getAtomChain(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the added atomic composition of the PTM (see below)." + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
            composition = true;
        }
        if (aLine.hasOption(ModificationsCLIParams.COMPOSITION_REMOVED.id)) {
            if (!name) {
                System.out.println(System.getProperty("line.separator") + "No name provided for the PTM to add." + System.getProperty("line.separator"));
                return false;
            }
            arg = aLine.getOptionValue(ModificationsCLIParams.COMPOSITION_REMOVED.id);
            try {
                AtomChain.getAtomChain(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the removed atomic composition of the PTM (see below)." + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
            composition = true;
        }
        if (name && !composition) {
            System.out.println(System.getProperty("line.separator") + "No atomic composition found for the PTM to add." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(ModificationsCLIParams.PATTERN.id)) {
            if (!name) {
                System.out.println(System.getProperty("line.separator") + "No name provided for the PTM to add." + System.getProperty("line.separator"));
                return false;
            }
            arg = aLine.getOptionValue(ModificationsCLIParams.PATTERN.id);
            try {
                AminoAcidPattern.getAminoAcidPatternFromString(arg);
            }
            catch (Exception e) {
                System.out.println(System.getProperty("line.separator") + "An error occurred while parsing the amino acid pattern of the PTM (see below)." + System.getProperty("line.separator"));
                e.printStackTrace();
                return false;
            }
            pattern = true;
        }
        if (aLine.hasOption(ModificationsCLIParams.TYPE.id)) {
            arg = aLine.getOptionValue(ModificationsCLIParams.COMPOSITION_REMOVED.id);
            if (!CommandParameter.isPositiveInteger(ModificationsCLIParams.COMPOSITION_REMOVED.id, arg, true)) {
                return false;
            }
            Integer type = new Integer(arg);
            if (type >= 9) {
                System.out.println(System.getProperty("line.separator") + "Invalid PTM type " + arg + "." + System.getProperty("line.separator"));
                return false;
            }
            if (!(pattern || type != 0 && type != 4 && type != 2 && type != 8 && type != 6)) {
                System.out.println(System.getProperty("line.separator") + "No amino acid pattern found for PTM targetting specific amino acids." + System.getProperty("line.separator"));
                return false;
            }
            if (pattern && (type == 3 || type == 1 || type == 7 || type == 5)) {
                System.out.println(System.getProperty("line.separator") + "Amino acid pattern found for PTM targetting a terminus." + System.getProperty("line.separator"));
                return false;
            }
        } else if (name) {
            System.out.println(System.getProperty("line.separator") + "No PTM type found for the PTM to add." + System.getProperty("line.separator"));
            return false;
        }
        if (aLine.hasOption(ModificationsCLIParams.PATTERN_INDEX.id)) {
            if (!name) {
                System.out.println(System.getProperty("line.separator") + "No name provided for the enzyme to add." + System.getProperty("line.separator"));
                return false;
            }
            arg = aLine.getOptionValue(ModificationsCLIParams.PATTERN_INDEX.id);
            if (!CommandParameter.isInteger(ModificationsCLIParams.PATTERN_INDEX.id, arg)) {
                return false;
            }
        }
        return true;
    }

    public ModificationsCLIInputBean(CommandLine aLine) throws IOException {
        String arg;
        if (aLine.hasOption(ModificationsCLIParams.IN.id)) {
            arg = aLine.getOptionValue(ModificationsCLIParams.IN.id);
            this.fileIn = new File(arg);
        }
        if (aLine.hasOption(ModificationsCLIParams.LIST.id)) {
            this.list = true;
            return;
        }
        if (aLine.hasOption(ModificationsCLIParams.OUT.id)) {
            arg = aLine.getOptionValue(ModificationsCLIParams.OUT.id);
            this.fileOut = new File(arg);
        }
        if (aLine.hasOption(ModificationsCLIParams.RM.id)) {
            this.modificationToRemove = aLine.getOptionValue(ModificationsCLIParams.RM.id);
        }
        if (aLine.hasOption(ModificationsCLIParams.NAME.id)) {
            String arg2;
            String enzymeName = aLine.getOptionValue(ModificationsCLIParams.NAME.id);
            int index = new Integer(aLine.getOptionValue(ModificationsCLIParams.TYPE.id));
            AtomChain atomChainAdded = null;
            if (aLine.hasOption(ModificationsCLIParams.COMPOSITION_ADDED.id)) {
                String arg3 = aLine.getOptionValue(ModificationsCLIParams.COMPOSITION_ADDED.id);
                atomChainAdded = AtomChain.getAtomChain(arg3);
            }
            AtomChain atomChainRemoved = null;
            if (aLine.hasOption(ModificationsCLIParams.COMPOSITION_REMOVED.id)) {
                String arg4 = aLine.getOptionValue(ModificationsCLIParams.COMPOSITION_REMOVED.id);
                atomChainRemoved = AtomChain.getAtomChain(arg4);
            }
            AminoAcidPattern aminoAcidPattern = null;
            if (aLine.hasOption(ModificationsCLIParams.PATTERN.id)) {
                arg2 = aLine.getOptionValue(ModificationsCLIParams.PATTERN.id);
                aminoAcidPattern = AminoAcidPattern.getAminoAcidPatternFromString(arg2);
                Integer target = 0;
                if (aLine.hasOption(ModificationsCLIParams.PATTERN_INDEX.id)) {
                    arg2 = aLine.getOptionValue(ModificationsCLIParams.PATTERN_INDEX.id);
                    target = new Integer(arg2);
                }
                aminoAcidPattern.setTarget(target);
            }
            this.modificationToAdd = new PTM(index, enzymeName, enzymeName, atomChainAdded, atomChainRemoved, aminoAcidPattern);
            if (aLine.hasOption(ModificationsCLIParams.SHORT_NAME.id)) {
                arg2 = aLine.getOptionValue(ModificationsCLIParams.SHORT_NAME.id);
                this.modificationToAdd.setShortName(arg2);
            }
        }
    }

    public File getFileIn() {
        return this.fileIn;
    }

    public File getFileOut() {
        return this.fileOut;
    }

    public boolean isList() {
        return this.list;
    }

    public String getModificationToRemove() {
        return this.modificationToRemove;
    }

    public PTM getModificationToAdd() {
        return this.modificationToAdd;
    }
}

