/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.settings;

import com.compomics.software.settings.PathKey;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.genes.GeneFactory;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationParametersFactory;
import com.compomics.util.experiment.identification.protein_inference.proteintree.ProteinTreeComponentsFactory;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.pride.PrideObjectsFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class UtilitiesPathPreferences {
    public static final String configurationFileName = "resources/conf/paths.txt";
    public static final String separator = "=";
    public static final String defaultPath = "default";

    public static void loadPathPreferencesFromFile(File inputFile) throws FileNotFoundException, IOException {
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
            }
        }
        finally {
            br.close();
        }
    }

    public static void loadPathPreferenceFromLine(String line) throws FileNotFoundException {
        String id = UtilitiesPathPreferences.getPathID(line);
        if (id.equals("")) {
            throw new IllegalArgumentException("Impossible to parse path in " + line + ".");
        }
        UtilitiesPathKey utilitiesPathKey = UtilitiesPathKey.getKeyFromId(id);
        if (utilitiesPathKey == null) {
            throw new IllegalArgumentException("Path " + id + " not recognized");
        }
        String path = UtilitiesPathPreferences.getPath(line);
        if (!path.equals(defaultPath)) {
            File file = new File(path);
            if (!file.exists()) {
                throw new FileNotFoundException("File " + path + " not found.");
            }
            if (utilitiesPathKey.isDirectory && !file.isDirectory()) {
                throw new FileNotFoundException("Found a file when expecting a directory for " + utilitiesPathKey.id + ".");
            }
            UtilitiesPathPreferences.setPathPreference(utilitiesPathKey, path);
        }
    }

    public static void setPathPreference(UtilitiesPathKey utilitiesPathKey, String path) {
        switch (utilitiesPathKey) {
            case fastaIndexesKey: {
                ProteinTreeComponentsFactory.setDefaultDbFolderPath(path);
                return;
            }
            case geneMappingKey: {
                GeneFactory.setGeneMappingFolder(path);
                return;
            }
            case prideAnnotationKey: {
                PrideObjectsFactory.setPrideFolder(path);
                return;
            }
            case ptmFactoryKey: {
                PTMFactory.setSerializationFolder(path);
                return;
            }
            case enzymeFactoryKey: {
                EnzymeFactory.setSerializationFile(path);
                return;
            }
            case utilitiesPreferencesKey: {
                UtilitiesUserPreferences.setUserPreferencesFolder(path);
                return;
            }
            case identificationParametersKey: {
                IdentificationParametersFactory.setParentFolder(path);
                return;
            }
        }
        throw new UnsupportedOperationException("Path " + utilitiesPathKey.id + " not implemented.");
    }

    public static String getPathPreference(UtilitiesPathKey utilitiesPathKey) {
        switch (utilitiesPathKey) {
            case fastaIndexesKey: {
                return ProteinTreeComponentsFactory.getDefaultDbFolderPath();
            }
            case geneMappingKey: {
                return GeneFactory.getGeneMappingFolder().getAbsolutePath();
            }
            case prideAnnotationKey: {
                return PrideObjectsFactory.getPrideFolder();
            }
            case ptmFactoryKey: {
                return PTMFactory.getSerializationFolder();
            }
            case enzymeFactoryKey: {
                return EnzymeFactory.getSerializationFile();
            }
            case utilitiesPreferencesKey: {
                return UtilitiesUserPreferences.getUserPreferencesFolder();
            }
            case identificationParametersKey: {
                return IdentificationParametersFactory.getParentFolder();
            }
        }
        throw new UnsupportedOperationException("Path " + utilitiesPathKey.id + " not implemented.");
    }

    public static String getPathID(String line) {
        int separatorIndex = line.indexOf(separator);
        if (separatorIndex > 0) {
            return line.substring(0, separatorIndex);
        }
        return "";
    }

    public static String getPath(String line) {
        int separatorIndex = line.indexOf(separator);
        if (separatorIndex > 0 && separatorIndex < line.length()) {
            return line.substring(separatorIndex + 1);
        }
        return "";
    }

    public static void setAllPathsIn(String path) throws FileNotFoundException {
        for (UtilitiesPathKey utilitiesPathKey : UtilitiesPathKey.values()) {
            String subDirectory = utilitiesPathKey.defaultSubDirectory;
            File newFile = new File(path, subDirectory);
            if (!newFile.exists()) {
                newFile.mkdirs();
            }
            if (!newFile.exists()) {
                throw new FileNotFoundException(newFile.getAbsolutePath() + " could not be created.");
            }
            UtilitiesPathPreferences.setPathPreference(utilitiesPathKey, newFile.getAbsolutePath());
        }
    }

    public static void writeConfigurationToFile(File file) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        try {
            UtilitiesPathPreferences.writeConfigurationToFile(bw);
        }
        finally {
            bw.close();
        }
    }

    public static void writeConfigurationToFile(BufferedWriter bw) throws IOException {
        for (UtilitiesPathKey pathKey : UtilitiesPathKey.values()) {
            UtilitiesPathPreferences.writePathToFile(bw, pathKey);
        }
    }

    public static void writePathToFile(BufferedWriter bw, UtilitiesPathKey pathKey) throws IOException {
        bw.write(pathKey.id + separator);
        switch (pathKey) {
            case fastaIndexesKey: {
                String toWrite = ProteinTreeComponentsFactory.getDefaultDbFolderPath();
                if (toWrite == null) {
                    toWrite = defaultPath;
                }
                bw.write(toWrite);
                break;
            }
            case geneMappingKey: {
                String toWrite = GeneFactory.getGeneMappingFolder().getAbsolutePath();
                if (toWrite == null) {
                    toWrite = defaultPath;
                }
                bw.write(toWrite);
                break;
            }
            case prideAnnotationKey: {
                String toWrite = PrideObjectsFactory.getPrideFolder();
                if (toWrite == null) {
                    toWrite = defaultPath;
                }
                bw.write(toWrite);
                break;
            }
            case ptmFactoryKey: {
                String toWrite = PTMFactory.getSerializationFolder();
                if (toWrite == null) {
                    toWrite = defaultPath;
                }
                bw.write(toWrite);
                break;
            }
            case enzymeFactoryKey: {
                String toWrite = EnzymeFactory.getSerializationFile();
                if (toWrite == null) {
                    toWrite = defaultPath;
                }
                bw.write(toWrite);
                break;
            }
            case utilitiesPreferencesKey: {
                String toWrite = UtilitiesUserPreferences.getUserPreferencesFolder();
                if (toWrite == null) {
                    toWrite = defaultPath;
                }
                bw.write(toWrite);
                break;
            }
            case identificationParametersKey: {
                String toWrite = IdentificationParametersFactory.getParentFolder();
                if (toWrite == null) {
                    toWrite = "identification_parameters";
                }
                bw.write(toWrite);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Path " + pathKey.id + " not implemented.");
            }
        }
        bw.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testPath(String destinationPath) {
        try {
            File destinationFile = new File(destinationPath);
            if (!destinationFile.exists()) {
                try {
                    if (!destinationFile.mkdirs()) {
                        return false;
                    }
                }
                catch (Exception e) {
                    return false;
                }
            }
            File testFile = new File(destinationPath, "test_path_configuration.tmp");
            BufferedWriter bw = new BufferedWriter(new FileWriter(testFile));
            try {
                bw.write("test");
            }
            finally {
                try {
                    bw.close();
                }
                finally {
                    if (testFile.exists()) {
                        testFile.delete();
                    }
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static ArrayList<PathKey> getErrorKeys() throws IOException {
        ArrayList<PathKey> result = new ArrayList<PathKey>();
        for (UtilitiesPathKey utilitiesPathKey : UtilitiesPathKey.values()) {
            String folder = UtilitiesPathPreferences.getPathPreference(utilitiesPathKey);
            if (folder == null || UtilitiesPathPreferences.testPath(folder)) continue;
            result.add(utilitiesPathKey);
        }
        return result;
    }

    public static enum UtilitiesPathKey implements PathKey
    {
        utilitiesPreferencesKey("utilities_user_preferences", "Folder containing the compomics utilities user preferences file.", "", true),
        ptmFactoryKey("ptm_configuration", "Folder containing the supported PTMs.", "", true),
        enzymeFactoryKey("enzyme_configuration", "File containing the supported enzymes.", "", true),
        fastaIndexesKey("fasta_indexes", "Folder containing the indexes of the protein sequences databases.", "fasta_indexes", true),
        geneMappingKey("gene_mapping", "Folder containing the gene mapping files.", "gene_mapping", true),
        prideAnnotationKey("pride_annotation", "Folder containing the PRIDE annotation preferences.", "pride", true),
        identificationParametersKey("identification_parameters", "Folder containing the identification parameters.", "identification_parameters", true);

        private String id;
        private String description;
        private String defaultSubDirectory;
        private boolean isDirectory;

        private UtilitiesPathKey(String id, String description, String defaultSubDirectory, boolean isDirectory) {
            this.id = id;
            this.description = description;
            this.defaultSubDirectory = defaultSubDirectory;
            this.isDirectory = isDirectory;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public static UtilitiesPathKey getKeyFromId(String id) {
            for (UtilitiesPathKey pathKey : UtilitiesPathKey.values()) {
                if (!pathKey.id.equals(id)) continue;
                return pathKey;
            }
            return null;
        }
    }
}

