/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db;

import com.compomics.util.db.ObjectsDB;
import com.compomics.util.maps.MapMutex;
import com.compomics.util.waiting.WaitingHandler;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.Semaphore;

public class ObjectsCache {
    private HashMap<String, ObjectsDB> databases = new HashMap();
    private int cacheSize = 0;
    private boolean automatedMemoryManagement = true;
    private double memoryShare = 0.8;
    private HashMap<String, HashMap<String, HashMap<String, CacheEntry>>> loadedObjectsMap = new HashMap(1);
    private HashMap<String, MapMutex<String>> dbCacheMutexMap = new HashMap(1);
    private LinkedBlockingDeque<String> loadedObjectsKeys = new LinkedBlockingDeque();
    private Semaphore loadedObjectKeysMutex = new Semaphore(1);
    private static final String cacheSeparator = "_ccs_";
    private int batchSize = 1000;
    private boolean readOnly = false;
    private boolean updating = false;
    private boolean reducingMemoryConsumption = false;

    public boolean isAutomatedMemoryManagement() {
        return this.automatedMemoryManagement;
    }

    public void setAutomatedMemoryManagement(boolean automatedMemoryManagement) {
        this.automatedMemoryManagement = automatedMemoryManagement;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public double getMemoryShare() {
        return this.memoryShare;
    }

    public void setMemoryShare(double memoryShare) {
        this.memoryShare = memoryShare;
    }

    public synchronized void addDb(ObjectsDB objectsDB) {
        if (this.readOnly) {
            throw new IllegalArgumentException("Cannot add db, cache read only.");
        }
        String dbName = objectsDB.getName();
        if (dbName.contains(cacheSeparator)) {
            throw new IllegalArgumentException("Database name (" + dbName + ") should not contain " + cacheSeparator);
        }
        this.databases.put(dbName, objectsDB);
        this.loadedObjectsMap.put(dbName, new HashMap());
    }

    public void removeObject(String dbName, String tableName, String objectKey) throws InterruptedException {
        if (!this.readOnly) {
            String cacheKey = this.getCacheKey(dbName, tableName, objectKey);
            this.loadedObjectKeysMutex.acquire();
            this.loadedObjectsKeys.remove(cacheKey);
            this.loadedObjectKeysMutex.release();
            HashMap<String, HashMap<String, CacheEntry>> dbObjects = this.loadedObjectsMap.get(dbName);
            if (dbObjects != null) {
                MapMutex<String> dbMutexMap = this.getMapMutex(dbName);
                dbMutexMap.acquire(tableName);
                HashMap<String, CacheEntry> tableObjects = dbObjects.get(tableName);
                if (tableObjects != null) {
                    tableObjects.remove(objectKey);
                }
                dbMutexMap.release(tableName);
            }
        }
    }

    private CacheEntry getEntry(String dbName, String tableName, String objectKey) {
        HashMap<String, CacheEntry> tableObjects;
        HashMap<String, HashMap<String, CacheEntry>> dbObjects = this.loadedObjectsMap.get(dbName);
        if (dbObjects != null && (tableObjects = dbObjects.get(tableName)) != null) {
            return tableObjects.get(objectKey);
        }
        return null;
    }

    public Object getObject(String dbName, String tableName, String objectKey) {
        CacheEntry entry = this.getEntry(dbName, tableName, objectKey);
        if (entry != null) {
            return entry.getObject();
        }
        return null;
    }

    public boolean updateObject(String dbName, String tableName, String objectKey, Object object) throws InterruptedException {
        if (!this.readOnly) {
            CacheEntry entry = this.getEntry(dbName, tableName, objectKey);
            if (entry != null) {
                MapMutex<String> dbMutexMap = this.getMapMutex(dbName);
                dbMutexMap.acquire(tableName);
                entry = this.getEntry(dbName, tableName, objectKey);
                boolean result = false;
                if (entry != null && !this.readOnly) {
                    entry.setModified(true);
                    entry.setObject(object);
                    result = true;
                }
                dbMutexMap.release(tableName);
                return result;
            }
            return false;
        }
        return false;
    }

    public void addObject(String dbName, String tableName, String objectKey, Object object, boolean modifiedOrNew, boolean updateCache) throws IOException, SQLException, InterruptedException {
        if (!this.readOnly) {
            if (objectKey.contains(cacheSeparator)) {
                throw new IllegalArgumentException("Object key (" + objectKey + ") should not contain " + cacheSeparator + ".");
            }
            HashMap<String, HashMap<String, CacheEntry>> dbCache = this.loadedObjectsMap.get(dbName);
            MapMutex<String> dbMutexMap = this.getMapMutex(dbName);
            dbMutexMap.acquire(tableName);
            HashMap<String, CacheEntry> tableCache = dbCache.get(tableName);
            if (tableCache == null && (tableCache = dbCache.get(tableName)) == null) {
                if (tableName.contains(cacheSeparator)) {
                    throw new IllegalArgumentException("Table name (" + tableName + ") should not contain " + cacheSeparator + ".");
                }
                tableCache = new HashMap(512);
                dbCache.put(tableName, tableCache);
            }
            if (!tableCache.containsKey(objectKey)) {
                String key = this.getCacheKey(dbName, tableName, objectKey);
                this.loadedObjectKeysMutex.acquire();
                this.loadedObjectsKeys.add(key);
                this.loadedObjectKeysMutex.release();
            }
            tableCache.put(objectKey, new CacheEntry(object, modifiedOrNew));
            dbMutexMap.release(tableName);
            if (updateCache) {
                this.updateCache();
            }
        }
    }

    public boolean memoryCheck() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() < (long)(this.memoryShare * (double)Runtime.getRuntime().maxMemory());
    }

    public void saveObjects(ArrayList<String> entryKeys) throws IOException, SQLException, InterruptedException {
        this.saveObjects(entryKeys, null, true);
    }

    public void saveObjects(ArrayList<String> entryKeys, WaitingHandler waitingHandler) throws IOException, SQLException, InterruptedException {
        this.saveObjects(entryKeys, waitingHandler, true);
    }

    public synchronized void saveObjects(ArrayList<String> entryKeys, WaitingHandler waitingHandler, boolean clearEntries) throws IOException, SQLException, InterruptedException {
        if (!this.readOnly) {
            String objectKey;
            String tableName2;
            Object dbName;
            String[] splittedKey;
            if (waitingHandler != null) {
                waitingHandler.resetSecondaryProgressCounter();
                if (clearEntries) {
                    waitingHandler.setMaxSecondaryProgressCounter(3 * entryKeys.size());
                } else {
                    waitingHandler.setMaxSecondaryProgressCounter(2 * entryKeys.size());
                }
            }
            HashMap toSave = new HashMap(1);
            HashMap blockedTablesMap = new HashMap(1);
            for (String entryKey : entryKeys) {
                CacheEntry entry;
                splittedKey = this.getKeyComponents(entryKey);
                dbName = splittedKey[0];
                tableName2 = splittedKey[1];
                objectKey = splittedKey[2];
                HashSet<String> blockedTables = (HashSet<String>)blockedTablesMap.get(dbName);
                if (blockedTables == null) {
                    blockedTables = new HashSet<String>();
                    blockedTablesMap.put(dbName, blockedTables);
                }
                if (!blockedTables.contains(tableName2)) {
                    MapMutex<String> mapMutex = this.getMapMutex((String)dbName);
                    mapMutex.acquire(tableName2);
                    blockedTables.add(tableName2);
                }
                if ((entry = this.getEntry((String)dbName, tableName2, objectKey)) == null) {
                    throw new IllegalArgumentException("Object " + objectKey + " corresponding to entry " + entryKey + " not found in cache when saving.");
                }
                if (entry.isModified()) {
                    HashMap<String, Object> tableMap;
                    HashMap<String, HashMap<String, Object>> dbMap = (HashMap<String, HashMap<String, Object>>)toSave.get(dbName);
                    if (dbMap == null) {
                        dbMap = new HashMap<String, HashMap<String, Object>>();
                        toSave.put(dbName, dbMap);
                    }
                    if ((tableMap = (HashMap<String, Object>)dbMap.get(tableName2)) == null) {
                        tableMap = new HashMap<String, Object>();
                        dbMap.put(tableName2, tableMap);
                    }
                    tableMap.put(objectKey, entry.getObject());
                }
                if (waitingHandler == null) continue;
                waitingHandler.increaseSecondaryProgressCounter();
                if (!waitingHandler.isRunCanceled()) continue;
                return;
            }
            for (String dbName2 : toSave.keySet()) {
                ObjectsDB objectsDB = this.databases.get(dbName2);
                for (String tableName2 : ((HashMap)toSave.get(dbName2)).keySet()) {
                    objectsDB.insertObjects(tableName2, (HashMap)((HashMap)toSave.get(dbName2)).get(tableName2), waitingHandler);
                }
            }
            if ((waitingHandler == null || !waitingHandler.isRunCanceled()) && clearEntries) {
                for (String entryKey : entryKeys) {
                    splittedKey = this.getKeyComponents(entryKey);
                    dbName = splittedKey[0];
                    tableName2 = splittedKey[1];
                    objectKey = splittedKey[2];
                    HashMap<String, HashMap<String, CacheEntry>> dbMap = this.loadedObjectsMap.get(dbName);
                    if (dbMap != null) {
                        HashMap<String, CacheEntry> tableMap = dbMap.get(tableName2);
                        if (tableMap != null) {
                            tableMap.remove(objectKey);
                            if (tableMap.isEmpty()) {
                                dbMap.remove(tableName2);
                            }
                        }
                        if (dbMap.isEmpty()) {
                            this.loadedObjectsMap.remove(dbName);
                        }
                    }
                    if (waitingHandler == null) continue;
                    waitingHandler.increaseSecondaryProgressCounter();
                    if (!waitingHandler.isRunCanceled()) continue;
                    return;
                }
            }
            for (String dbName2 : blockedTablesMap.keySet()) {
                HashSet blockedTables = (HashSet)blockedTablesMap.get(dbName2);
                MapMutex<String> mapMutex = this.getMapMutex(dbName2);
                for (String blockedTable : blockedTables) {
                    mapMutex.release(blockedTable);
                }
            }
        }
    }

    public synchronized void saveObject(String entryKey) throws IOException, SQLException, InterruptedException {
        this.saveObject(entryKey, true);
    }

    public synchronized void saveObject(String entryKey, boolean clearEntry) throws IOException, SQLException, InterruptedException {
        if (!this.readOnly) {
            String[] splittedKey = this.getKeyComponents(entryKey);
            String dbName = splittedKey[0];
            String tableName = splittedKey[1];
            String objectKey = splittedKey[2];
            MapMutex<String> mapMutex = this.getMapMutex(dbName);
            mapMutex.acquire(tableName);
            CacheEntry entry = this.loadedObjectsMap.get(dbName).get(tableName).get(objectKey);
            if (entry.isModified()) {
                try {
                    ObjectsDB objectsDB = this.databases.get(dbName);
                    if (objectsDB == null) {
                        throw new IllegalStateException("Database " + dbName + " not loaded in cache");
                    }
                    if (objectsDB.inDB(tableName, objectKey, false)) {
                        objectsDB.updateObject(tableName, objectKey, entry.getObject(), false);
                    } else {
                        objectsDB.insertObject(tableName, objectKey, entry.getObject(), false);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IOException("Error while writing match " + objectKey + " in table " + tableName + " in database" + dbName + ".");
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new SQLException("Error while writing match " + objectKey + " in table " + tableName + " in database" + dbName + ".");
                }
            }
            if (clearEntry) {
                this.loadedObjectKeysMutex.acquire();
                this.loadedObjectsKeys.remove(entryKey);
                this.loadedObjectKeysMutex.release();
                HashMap<String, HashMap<String, CacheEntry>> dbCache = this.loadedObjectsMap.get(dbName);
                HashMap<String, CacheEntry> tableCache = dbCache.get(tableName);
                tableCache.remove(objectKey);
                if (tableCache.isEmpty()) {
                    dbCache.remove(tableName);
                }
            }
            mapMutex.release(tableName);
        }
    }

    public void updateCache() throws IOException, SQLException, InterruptedException {
        if (!this.readOnly && !this.updating) {
            this.updateCacheSynchronized();
        }
    }

    public synchronized void updateCacheSynchronized() throws IOException, SQLException, InterruptedException {
        this.updating = true;
        while (!this.automatedMemoryManagement && this.loadedObjectsKeys.size() > this.cacheSize || this.automatedMemoryManagement && !this.memoryCheck()) {
            int toRemove = (int)((double)this.loadedObjectsKeys.size() * 0.25);
            if (toRemove <= 1) {
                this.loadedObjectKeysMutex.acquire();
                String objectKey = this.loadedObjectsKeys.take();
                this.loadedObjectKeysMutex.release();
                this.saveObject(objectKey);
            } else {
                ArrayList<String> keysToRemove = new ArrayList<String>(toRemove);
                this.loadedObjectKeysMutex.acquire();
                this.loadedObjectsKeys.drainTo(keysToRemove, toRemove);
                this.loadedObjectKeysMutex.release();
                this.saveObjects(keysToRemove);
            }
            if (!this.loadedObjectsKeys.isEmpty()) continue;
            break;
        }
        this.updating = false;
    }

    public void reduceMemoryConsumption(double share, WaitingHandler waitingHandler) throws IOException, SQLException, InterruptedException {
        if (!this.reducingMemoryConsumption) {
            this.reduceMemoryConsumptionSynchronized(share, waitingHandler);
        }
    }

    private synchronized void reduceMemoryConsumptionSynchronized(double share, WaitingHandler waitingHandler) throws IOException, SQLException, InterruptedException {
        this.reducingMemoryConsumption = true;
        int toRemove = (int)(share * (double)this.loadedObjectsKeys.size());
        ArrayList<String> keysToRemove = new ArrayList<String>(toRemove);
        this.loadedObjectKeysMutex.acquire();
        this.loadedObjectsKeys.drainTo(keysToRemove, toRemove);
        this.loadedObjectKeysMutex.release();
        this.saveObjects(keysToRemove, waitingHandler);
        this.reducingMemoryConsumption = false;
    }

    public boolean inCache(String dbName, String tableName, String objectKey) {
        return this.getEntry(dbName, tableName, objectKey) != null;
    }

    public synchronized void saveCache(WaitingHandler waitingHandler, boolean emptyCache) throws IOException, SQLException, InterruptedException {
        if (waitingHandler != null) {
            waitingHandler.setMaxSecondaryProgressCounter(this.loadedObjectsKeys.size() * 2 + 1);
            waitingHandler.setSecondaryProgressCounterIndeterminate(false);
            waitingHandler.setSecondaryProgressCounter(0);
        }
        for (String dbName : this.loadedObjectsMap.keySet()) {
            ObjectsDB objectsDB = this.databases.get(dbName);
            if (objectsDB == null) {
                throw new IllegalStateException("Database " + dbName + " not loaded in cache");
            }
            for (String tableName : this.loadedObjectsMap.get(dbName).keySet()) {
                MapMutex<String> mapMutex = this.getMapMutex(dbName);
                mapMutex.acquire(tableName);
                HashMap<String, CacheEntry> data = this.loadedObjectsMap.get(dbName).get(tableName);
                HashMap<String, Object> objectsToStore = new HashMap<String, Object>(data.size());
                for (String objectKey : data.keySet()) {
                    CacheEntry entry = data.get(objectKey);
                    if (entry.isModified()) {
                        objectsToStore.put(objectKey, entry.getObject());
                    }
                    if (waitingHandler == null) continue;
                    waitingHandler.increaseSecondaryProgressCounter();
                    if (!waitingHandler.isRunCanceled()) continue;
                    return;
                }
                objectsDB.insertObjects(tableName, objectsToStore, waitingHandler);
                mapMutex.release(tableName);
            }
        }
        if (emptyCache && !this.readOnly) {
            this.loadedObjectsMap.clear();
            this.loadedObjectKeysMutex.acquire();
            this.loadedObjectsKeys.clear();
            this.loadedObjectKeysMutex.release();
        }
    }

    private String getCacheKey(String dbName, String tableName, String objectKey) {
        StringBuilder stringBuilder = new StringBuilder(2 * cacheSeparator.length() + dbName.length() + tableName.length() + objectKey.length());
        stringBuilder.append(dbName).append(cacheSeparator).append(tableName).append(cacheSeparator).append(objectKey);
        return stringBuilder.toString();
    }

    private String[] getKeyComponents(String cacheKey) {
        return cacheKey.split(cacheSeparator);
    }

    public boolean isEmpty() {
        return this.loadedObjectsKeys.isEmpty();
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    private synchronized MapMutex<String> addMapMutex(String dbName) {
        MapMutex<String> mapMutex = this.dbCacheMutexMap.get(dbName);
        if (mapMutex == null) {
            mapMutex = new MapMutex();
            this.dbCacheMutexMap.put(dbName, mapMutex);
        }
        return mapMutex;
    }

    private MapMutex<String> getMapMutex(String dbName) {
        MapMutex<String> dbMutexMap = this.dbCacheMutexMap.get(dbName);
        if (dbMutexMap == null) {
            dbMutexMap = this.addMapMutex(dbName);
        }
        return dbMutexMap;
    }

    private class CacheEntry {
        private Object object;
        private boolean modified;

        public CacheEntry(Object object, boolean modified) {
            this.object = object;
            this.modified = modified;
        }

        public boolean isModified() {
            return this.modified;
        }

        public void setModified(boolean modified) {
            this.modified = modified;
        }

        public Object getObject() {
            return this.object;
        }

        public void setObject(Object object) {
            this.object = object;
        }
    }
}

