/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.io.json.JsonMarshaller;
import com.compomics.util.pride.CvTerm;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class EnzymeFactory {
    private HashMap<String, Enzyme> enzymes = new HashMap();
    private static EnzymeFactory instance = null;
    private static String SERIALIZATION_FILE = null;

    private EnzymeFactory() {
    }

    public static EnzymeFactory getInstance() {
        return EnzymeFactory.getInstance(null);
    }

    public static EnzymeFactory getInstance(File enzymeFile) {
        if (instance == null) {
            try {
                if (enzymeFile == null && EnzymeFactory.getSerializationFile() != null) {
                    enzymeFile = new File(EnzymeFactory.getSerializationFile());
                }
                instance = enzymeFile != null && enzymeFile.exists() ? EnzymeFactory.loadFromFile(enzymeFile) : EnzymeFactory.getDefault();
            }
            catch (Exception e) {
                instance = EnzymeFactory.getDefault();
            }
        }
        return instance;
    }

    public static EnzymeFactory getDefault() {
        EnzymeFactory enzymeFactory = new EnzymeFactory();
        for (Enzyme enzyme : EnzymeFactory.getDefaultEnzymes()) {
            enzymeFactory.addEnzyme(enzyme);
        }
        return enzymeFactory;
    }

    public static EnzymeFactory loadFromFile(File file) throws IOException {
        JsonMarshaller jsonMarshaller = new JsonMarshaller();
        EnzymeFactory result = (EnzymeFactory)jsonMarshaller.fromJson(EnzymeFactory.class, file);
        return result;
    }

    public static void saveToFile(EnzymeFactory enzymeFactory, File file) throws IOException {
        JsonMarshaller jsonMarshaller = new JsonMarshaller();
        jsonMarshaller.saveObjectToJson(enzymeFactory, file);
    }

    public static String getSerializationFile() {
        return SERIALIZATION_FILE;
    }

    public static void setSerializationFile(String serializationFilePath) {
        SERIALIZATION_FILE = serializationFilePath;
    }

    public ArrayList<Enzyme> getEnzymes() {
        return new ArrayList<Enzyme>(this.enzymes.values());
    }

    public Enzyme getEnzyme(String enzymeName) {
        return this.enzymes.get(enzymeName);
    }

    public void addEnzyme(Enzyme enzyme) {
        this.enzymes.put(enzyme.getName(), enzyme);
    }

    public void removeEnzyme(String enzymeName) {
        this.enzymes.remove(enzymeName);
    }

    public boolean enzymeLoaded(String enzyme) {
        return this.enzymes.containsKey(enzyme);
    }

    public Enzyme getUtilitiesEnzyme(String cvTermAccession) {
        for (Enzyme enzyme : this.enzymes.values()) {
            if (enzyme.getCvTerm() == null || !enzyme.getCvTerm().getAccession().equals(cvTermAccession)) continue;
            return enzyme;
        }
        return null;
    }

    public void writeMsAmandaEnzymeFile(File file) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        String toWrite = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        bw.write(toWrite);
        bw.newLine();
        bw.write("<enzymes>");
        bw.newLine();
        for (Enzyme enzyme : this.getEnzymes()) {
            String position;
            bw.write("  <enzyme>");
            bw.newLine();
            bw.write("    <name>" + enzyme.getName() + "</name>");
            bw.newLine();
            String cleavageSite = "";
            String inhibitors = "";
            if (!enzyme.getAminoAcidBefore().isEmpty()) {
                position = "after";
                for (Character aminoAcid : enzyme.getAminoAcidBefore()) {
                    cleavageSite = cleavageSite + aminoAcid;
                }
                for (Character aminoAcid : enzyme.getRestrictionAfter()) {
                    inhibitors = inhibitors + aminoAcid;
                }
            } else {
                position = "before";
                for (Character aminoAcid : enzyme.getAminoAcidAfter()) {
                    cleavageSite = cleavageSite + aminoAcid;
                }
                for (Character aminoAcid : enzyme.getRestrictionBefore()) {
                    inhibitors = inhibitors + aminoAcid;
                }
            }
            bw.write("    <cleavage_sites>" + cleavageSite + "</cleavage_sites>");
            bw.newLine();
            if (!inhibitors.isEmpty()) {
                bw.write("    <inhibitors>" + inhibitors + "</inhibitors>");
                bw.newLine();
            }
            bw.write("    <position>" + position + "</position>");
            bw.newLine();
            bw.write("  </enzyme>");
            bw.newLine();
        }
        bw.write("</enzymes>");
        bw.flush();
        bw.close();
    }

    private static ArrayList<Enzyme> getDefaultEnzymes() {
        ArrayList<Enzyme> enzymes = new ArrayList<Enzyme>();
        Enzyme enzyme = new Enzyme("Trypsin");
        enzyme.addAminoAcidBefore(Character.valueOf('R'));
        enzyme.addAminoAcidBefore(Character.valueOf('K'));
        enzyme.addRestrictionAfter(Character.valueOf('P'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001251", "Trypsin", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Trypsin (no P rule)");
        enzyme.addAminoAcidBefore(Character.valueOf('R'));
        enzyme.addAminoAcidBefore(Character.valueOf('K'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001313", "Trypsin/P", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Arg-C");
        enzyme.addAminoAcidBefore(Character.valueOf('R'));
        enzyme.addRestrictionAfter(Character.valueOf('P'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001303", "Arg-C", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Arg-C (no P rule)");
        enzyme.addAminoAcidBefore(Character.valueOf('R'));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Arg-N");
        enzyme.addAminoAcidAfter(Character.valueOf('R'));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Glu-C");
        enzyme.addAminoAcidBefore(Character.valueOf('E'));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Lys-C");
        enzyme.addAminoAcidBefore(Character.valueOf('K'));
        enzyme.addRestrictionAfter(Character.valueOf('P'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001309", "Lys-C", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Lys-C (no P rule)");
        enzyme.addAminoAcidBefore(Character.valueOf('K'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001310", "Lys-C/P", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Lys-N");
        enzyme.addAminoAcidAfter(Character.valueOf('K'));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Asp-N");
        enzyme.addAminoAcidAfter(Character.valueOf('D'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001304", "Asp-N", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Asp-N (ambic)");
        enzyme.addAminoAcidAfter(Character.valueOf('D'));
        enzyme.addAminoAcidAfter(Character.valueOf('E'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001305", "Asp-N_ambic", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Chymotrypsin");
        enzyme.addAminoAcidBefore(Character.valueOf('F'));
        enzyme.addAminoAcidBefore(Character.valueOf('Y'));
        enzyme.addAminoAcidBefore(Character.valueOf('W'));
        enzyme.addAminoAcidBefore(Character.valueOf('L'));
        enzyme.addRestrictionAfter(Character.valueOf('P'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001306", "Chymotrypsin", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Chymotrypsin (no P rule)");
        enzyme.addAminoAcidBefore(Character.valueOf('F'));
        enzyme.addAminoAcidBefore(Character.valueOf('Y'));
        enzyme.addAminoAcidBefore(Character.valueOf('W'));
        enzyme.addAminoAcidBefore(Character.valueOf('L'));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Pepsin A");
        enzyme.addAminoAcidBefore(Character.valueOf('F'));
        enzyme.addAminoAcidBefore(Character.valueOf('L'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001311", "Pepsin A", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("CNBr");
        enzyme.addAminoAcidBefore(Character.valueOf('M'));
        enzyme.setCvTerm(new CvTerm("PSI-MS", "MS:1001307", "CNBr", null));
        enzymes.add(enzyme);
        enzyme = new Enzyme("Thermolysin");
        enzyme.addAminoAcidAfter(Character.valueOf('A'));
        enzyme.addAminoAcidAfter(Character.valueOf('F'));
        enzyme.addAminoAcidAfter(Character.valueOf('I'));
        enzyme.addAminoAcidAfter(Character.valueOf('L'));
        enzyme.addAminoAcidAfter(Character.valueOf('M'));
        enzyme.addAminoAcidAfter(Character.valueOf('V'));
        enzymes.add(enzyme);
        enzyme = new Enzyme("LysargiNase");
        enzyme.addAminoAcidAfter(Character.valueOf('R'));
        enzyme.addAminoAcidAfter(Character.valueOf('K'));
        enzymes.add(enzyme);
        return enzymes;
    }
}

