/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.SequenceMatchingPreferences;

public class MassGap
extends ExperimentObject
implements TagComponent {
    private double value;
    private String sequence = null;

    public MassGap(double value) {
        this.value = value;
    }

    public void setMass(double value) {
        this.value = value;
        this.sequence = null;
    }

    @Override
    public String asSequence() {
        if (this.sequence == null) {
            String valueAsString = this.value + "";
            StringBuilder stringBuilder = new StringBuilder(valueAsString.length() + 2);
            stringBuilder.append('<').append(valueAsString).append('>');
            this.sequence = stringBuilder.toString();
        }
        return this.sequence;
    }

    @Override
    public Double getMass() {
        return this.value;
    }

    @Override
    public boolean isSameAs(TagComponent anotherCompontent, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return anotherCompontent instanceof MassGap && anotherCompontent.getMass() == this.value;
    }

    @Override
    public boolean isSameSequenceAndModificationStatusAs(TagComponent anotherCompontent, SequenceMatchingPreferences sequenceMatchingPreferences) {
        return this.isSameAs(anotherCompontent, sequenceMatchingPreferences);
    }
}

