/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.AtomChain;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;
import java.util.HashMap;

public class RelatedIon
extends Ion {
    static final long serialVersionUID = -4605345486425465764L;
    private static int subTypeCounter = 0;
    private static HashMap<Character, ArrayList<RelatedIon>> implementedIons = new HashMap();
    public static final RelatedIon RELATED_R_1 = new RelatedIon(AminoAcid.R, AtomChain.getAtomChain("C(4)H(7)N"), subTypeCounter++);
    public static final RelatedIon RELATED_R_2 = new RelatedIon(AminoAcid.R, AtomChain.getAtomChain("C(4)H(10)N(2)"), subTypeCounter++);
    public static final RelatedIon RELATED_R_3 = new RelatedIon(AminoAcid.R, AtomChain.getAtomChain("C(5)H(9)N(3)"), subTypeCounter++);
    public static final RelatedIon RELATED_R_4 = new RelatedIon(AminoAcid.R, AtomChain.getAtomChain("C(5)H(10)N(2)O"), subTypeCounter++);
    public static final RelatedIon RELATED_N_1 = new RelatedIon(AminoAcid.N, AtomChain.getAtomChain("C(3)H(3)NO"), subTypeCounter++);
    public static final RelatedIon RELATED_D_1 = new RelatedIon(AminoAcid.D, AtomChain.getAtomChain("C(3)H(3)NO"), subTypeCounter++);
    public static final RelatedIon RELATED_C_1 = new RelatedIon(AminoAcid.C, AtomChain.getAtomChain("C(4)H(8)N(2)SO"), subTypeCounter++);
    public static final RelatedIon RELATED_C_2 = new RelatedIon(AminoAcid.C, AtomChain.getAtomChain("C(4)H(5)NSO"), subTypeCounter++);
    public static final RelatedIon RELATED_E_1 = new RelatedIon(AminoAcid.E, AtomChain.getAtomChain("C(4)H(5)NO"), subTypeCounter++);
    public static final RelatedIon RELATED_Q_1 = new RelatedIon(AminoAcid.Q, AtomChain.getAtomChain("C(4)H(5)NO"), subTypeCounter++);
    public static final RelatedIon RELATED_Q_2 = new RelatedIon(AminoAcid.Q, AtomChain.getAtomChain("C(5)H(8)N(2)O(2)"), subTypeCounter++);
    public static final RelatedIon RELATED_H_1 = new RelatedIon(AminoAcid.H, AtomChain.getAtomChain("C(4)H(5)N(2)"), subTypeCounter++);
    public static final RelatedIon RELATED_H_2 = new RelatedIon(AminoAcid.H, AtomChain.getAtomChain("C(6)H(7)N(3)O"), subTypeCounter++);
    public static final RelatedIon RELATED_K_1 = new RelatedIon(AminoAcid.K, AtomChain.getAtomChain("C(5)H(9)N"), subTypeCounter++);
    public static final RelatedIon RELATED_K_2 = new RelatedIon(AminoAcid.K, AtomChain.getAtomChain("C(6)H(9)NO"), subTypeCounter++);
    public static final RelatedIon RELATED_K_3 = new RelatedIon(AminoAcid.K, AtomChain.getAtomChain("C(6)H(12)N(2)O"), subTypeCounter++);
    public static final RelatedIon RELATED_M_1 = new RelatedIon(AminoAcid.M, AtomChain.getAtomChain("C(2)H(4)S"), subTypeCounter++);
    public static final RelatedIon RELATED_F_1 = new RelatedIon(AminoAcid.F, AtomChain.getAtomChain("C(7)H(6)"), subTypeCounter++);
    public static final RelatedIon RELATED_W_1 = new RelatedIon(AminoAcid.W, AtomChain.getAtomChain("C(9)H(7)N"), subTypeCounter++);
    public static final RelatedIon RELATED_Y_1 = new RelatedIon(AminoAcid.Y, AtomChain.getAtomChain("C(7)H(7)O"), subTypeCounter);
    private AminoAcid aminoAcidTarget;
    private int subType;

    public RelatedIon(AminoAcid aminoAcidTarget, AtomChain atomChain, int subType) {
        this(aminoAcidTarget, atomChain, subType, true);
    }

    public RelatedIon(AminoAcid aminoAcidTarget, AtomChain atomChain, int subType, boolean save) {
        this.type = Ion.IonType.RELATED_ION;
        this.aminoAcidTarget = aminoAcidTarget;
        this.atomChain = atomChain;
        this.subType = subType;
        if (save) {
            Character aminoAcidChar = Character.valueOf(aminoAcidTarget.getSingleLetterCodeAsChar());
            ArrayList<RelatedIon> relatedIons = implementedIons.get(aminoAcidChar);
            if (relatedIons == null) {
                relatedIons = new ArrayList(1);
                implementedIons.put(Character.valueOf(aminoAcidTarget.getSingleLetterCodeAsChar()), relatedIons);
            }
            relatedIons.add(this);
        }
    }

    public static ArrayList<RelatedIon> getRelatedIons(char aa) {
        return implementedIons.get(Character.valueOf(aa));
    }

    public static ArrayList<RelatedIon> getRelatedIons(AminoAcid aminoAcidTarget) {
        return RelatedIon.getRelatedIons(aminoAcidTarget.getSingleLetterCodeAsChar());
    }

    @Override
    public String getName() {
        return "r" + this.aminoAcidTarget.singleLetterCode;
    }

    @Override
    public CvTerm getPrideCvTerm() {
        return null;
    }

    @Override
    public CvTerm getPsiMsCvTerm() {
        return null;
    }

    public boolean isSameAs(RelatedIon anotherRelatedIon) {
        return this.atomChain.isSameCompositionAs(anotherRelatedIon.getAtomicComposition());
    }

    @Override
    public int getSubType() {
        return this.subType;
    }

    @Override
    public String getSubTypeAsString() {
        return "r" + this.subType;
    }

    public static ArrayList<Integer> getPossibleSubtypes() {
        ArrayList<Integer> possibleTypes = new ArrayList<Integer>();
        for (int i = 0; i < subTypeCounter; ++i) {
            possibleTypes.add(i);
        }
        return possibleTypes;
    }

    @Override
    public NeutralLoss[] getNeutralLosses() {
        return null;
    }

    @Override
    public boolean isSameAs(Ion anotherIon) {
        if (anotherIon instanceof RelatedIon) {
            RelatedIon otherIon = (RelatedIon)anotherIon;
            return this.isSameAs(otherIon);
        }
        return false;
    }
}

