/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.taxonomy.mappings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

public class EnsemblGenomesSpecies {
    public static final String SEPARATOR = "\t";
    private HashMap<Integer, String> idToNameMap = new HashMap();
    private HashMap<Integer, String> idToDivisionMap = new HashMap();
    private HashMap<Integer, String> idToAssemblyMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMapping(File speciesFile) throws IOException {
        FileReader r = new FileReader(speciesFile);
        try {
            BufferedReader br = new BufferedReader(r);
            try {
                String line = br.readLine();
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0) continue;
                    String[] elements = line.split(SEPARATOR);
                    Integer id = new Integer(elements[3].trim());
                    String name = elements[0].trim();
                    String division = elements[2].trim();
                    String assembly = elements[4].trim();
                    this.idToNameMap.put(id, name);
                    this.idToDivisionMap.put(id, division);
                    this.idToAssemblyMap.put(id, assembly);
                }
            }
            finally {
                br.close();
            }
        }
        finally {
            r.close();
        }
    }

    public String getName(Integer taxon) {
        return this.idToNameMap.get(taxon);
    }

    public EnsemblGenomeDivision getDivision(Integer taxon) {
        String ensemblDivisionName = this.idToDivisionMap.get(taxon);
        if (ensemblDivisionName == null) {
            return null;
        }
        return EnsemblGenomeDivision.getEnsemblGenomeDivisionFromName(ensemblDivisionName);
    }

    public String getAssembly(Integer taxon) {
        return this.idToAssemblyMap.get(taxon);
    }

    public HashSet<Integer> getTaxons() {
        return new HashSet<Integer>(this.idToAssemblyMap.keySet());
    }

    public static enum EnsemblGenomeDivision {
        bacteria("EnsemblBacteria", "bacteria"),
        fungi("EnsemblFungi", "fungi"),
        metazoa("EnsemblMetazoa", "metazoa"),
        plants("EnsemblPlants", "plants"),
        protists("EnsemblProtists", "protists");

        public final String ensemblName;
        public final String ensemblType;

        private EnsemblGenomeDivision(String ensemblName, String ensemblType) {
            this.ensemblName = ensemblName;
            this.ensemblType = ensemblType;
        }

        public static EnsemblGenomeDivision getEnsemblGenomeDivisionFromName(String ensemblName) {
            for (EnsemblGenomeDivision ensemblGenomeDivision : EnsemblGenomeDivision.values()) {
                if (!ensemblGenomeDivision.ensemblName.equals(ensemblName)) continue;
                return ensemblGenomeDivision;
            }
            return null;
        }
    }
}

