/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationAlgorithmParameter;
import com.compomics.util.experiment.identification.identification_parameters.PtmSettings;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.AndromedaParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.CometParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.DirecTagParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MsAmandaParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MsgfParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MyriMatchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.NovorParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.OmssaParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.PNovoParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.PepnovoParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.TideParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.XtandemParameters;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.io.SerializationUtils;
import com.compomics.util.io.json.marshallers.IdentificationParametersMarshaller;
import com.compomics.util.preferences.DigestionPreferences;
import com.compomics.util.preferences.DummyParameters;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.preferences.MarshallableParameter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import no.uib.jsparklines.data.XYDataPoint;

public class SearchParameters
implements Serializable,
MarshallableParameter {
    static final long serialVersionUID = -2773993307168773763L;
    private String marshallableParameterType = null;
    public static final String[] implementedForwardIons = new String[]{"a", "b", "c"};
    public static final String[] implementedRewindIons = new String[]{"x", "y", "z"};
    private MassAccuracyType precursorAccuracyType = MassAccuracyType.PPM;
    private MassAccuracyType fragmentAccuracyType = MassAccuracyType.DA;
    private Double precursorTolerance = 10.0;
    private Double precursorToleranceDalton = 0.5;
    private Double fragmentIonMZTolerance = 0.5;
    private PtmSettings ptmSettings = new PtmSettings();
    private Enzyme enzyme;
    private Integer nMissedCleavages = 2;
    private DigestionPreferences digestionPreferences;
    private File fastaFile;
    private File parametersFile;
    private HashMap<String, XYDataPoint> fractionMolecularWeightRanges;
    private Integer forwardIon;
    private ArrayList<Integer> forwardIons;
    private Integer rewindIon;
    private ArrayList<Integer> rewindIons;
    private Charge minChargeSearched = new Charge(1, 2);
    private Charge maxChargeSearched = new Charge(1, 4);
    private Integer minIsotopicCorrection = 0;
    private Integer maxIsotopicCorrection = 1;
    private Double refMass = 2000.0;
    private HashMap<Integer, IdentificationAlgorithmParameter> algorithmParameters;

    public SearchParameters() {
        this.forwardIons = new ArrayList(1);
        this.forwardIons.add(1);
        this.rewindIons = new ArrayList(1);
        this.rewindIons.add(4);
        this.setDefaultAdvancedSettings();
    }

    public SearchParameters(SearchParameters searchParameters) {
        this.precursorAccuracyType = searchParameters.getPrecursorAccuracyType();
        this.fragmentAccuracyType = searchParameters.getFragmentAccuracyType();
        this.precursorTolerance = searchParameters.getPrecursorAccuracy();
        this.precursorToleranceDalton = searchParameters.getPrecursorAccuracyDalton();
        this.fragmentIonMZTolerance = searchParameters.getFragmentIonAccuracy();
        this.ptmSettings = new PtmSettings(searchParameters.getPtmSettings());
        this.digestionPreferences = searchParameters.getDigestionPreferences();
        this.fastaFile = searchParameters.getFastaFile();
        this.forwardIons = new ArrayList<Integer>(searchParameters.getForwardIons());
        this.rewindIons = new ArrayList<Integer>(searchParameters.getRewindIons());
        this.minChargeSearched = searchParameters.getMinChargeSearched();
        this.maxChargeSearched = searchParameters.getMaxChargeSearched();
        this.minIsotopicCorrection = searchParameters.getMinIsotopicCorrection();
        this.maxIsotopicCorrection = searchParameters.getMaxIsotopicCorrection();
        this.refMass = searchParameters.getRefMass();
        this.setDefaultAdvancedSettings(searchParameters);
    }

    public void setDefaultAdvancedSettings() {
        this.setDefaultAdvancedSettings(null);
    }

    public void setDefaultAdvancedSettings(SearchParameters searchParameters) {
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.omssa.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.omssa.getIndex(), new OmssaParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.omssa.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.omssa.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.xtandem.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.xtandem.getIndex(), new XtandemParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.xtandem.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.xtandem.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.msgf.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.msgf.getIndex(), new MsgfParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.msgf.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.msgf.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex(), new MsAmandaParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex(), new MyriMatchParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.comet.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.comet.getIndex(), new CometParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.comet.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.comet.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.tide.getIndex(), new TideParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.tide.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.andromeda.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.andromeda.getIndex(), new AndromedaParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.andromeda.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.andromeda.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.pepnovo.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.pepnovo.getIndex(), new PepnovoParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.pepnovo.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.pepnovo.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.direcTag.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.direcTag.getIndex(), new DirecTagParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.direcTag.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.direcTag.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.pNovo.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.pNovo.getIndex(), new PNovoParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.pNovo.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.pNovo.getIndex()));
        }
        if (searchParameters == null || searchParameters.getIdentificationAlgorithmParameter(Advocate.novor.getIndex()) == null) {
            this.setIdentificationAlgorithmParameter(Advocate.novor.getIndex(), new NovorParameters());
        } else {
            this.setIdentificationAlgorithmParameter(Advocate.novor.getIndex(), searchParameters.getIdentificationAlgorithmParameter(Advocate.novor.getIndex()));
        }
    }

    public Double getRefMass() {
        if (this.refMass == null) {
            this.refMass = 2000.0;
        }
        return this.refMass;
    }

    public void setRefMass(Double refMass) {
        this.refMass = refMass;
    }

    public PtmSettings getPtmSettings() {
        return this.ptmSettings;
    }

    public void setPtmSettings(PtmSettings ptmSettings) {
        this.ptmSettings = ptmSettings;
    }

    public Double getFragmentIonAccuracy() {
        return this.fragmentIonMZTolerance;
    }

    public Double getFragmentIonAccuracyInDaltons() {
        return this.getFragmentIonAccuracyInDaltons(this.refMass);
    }

    public Double getFragmentIonAccuracyInDaltons(Double refMass) {
        switch (this.fragmentAccuracyType) {
            case DA: {
                return this.fragmentIonMZTolerance;
            }
            case PPM: {
                return this.fragmentIonMZTolerance * refMass / 1000000.0;
            }
        }
        throw new UnsupportedOperationException("Tolerance in " + (Object)((Object)this.fragmentAccuracyType) + " not implemented.");
    }

    public void setFragmentIonAccuracy(Double fragmentIonMZTolerance) {
        this.fragmentIonMZTolerance = fragmentIonMZTolerance;
    }

    public Enzyme getEnzyme() {
        return this.enzyme;
    }

    public DigestionPreferences getDigestionPreferences() {
        if (this.digestionPreferences == null && this.enzyme != null) {
            this.enzyme.backwardCompatibilityFix();
            this.digestionPreferences = new DigestionPreferences();
            if (this.enzyme.isWholeProtein()) {
                this.digestionPreferences.setCleavagePreference(DigestionPreferences.CleavagePreference.wholeProtein);
            } else if (this.enzyme.isUnspecific()) {
                this.digestionPreferences.setCleavagePreference(DigestionPreferences.CleavagePreference.unSpecific);
            } else {
                this.digestionPreferences.setCleavagePreference(DigestionPreferences.CleavagePreference.enzyme);
                this.digestionPreferences.addEnzyme(this.enzyme);
                String enzymeName = this.enzyme.getName();
                if (this.enzyme.isSemiSpecific()) {
                    this.digestionPreferences.setSpecificity(enzymeName, DigestionPreferences.Specificity.semiSpecific);
                } else {
                    this.digestionPreferences.setSpecificity(enzymeName, DigestionPreferences.Specificity.specific);
                }
                this.digestionPreferences.setnMissedCleavages(enzymeName, this.nMissedCleavages);
            }
        }
        return this.digestionPreferences;
    }

    public void setDigestionPreferences(DigestionPreferences digestionPreferences) {
        this.digestionPreferences = digestionPreferences;
    }

    public File getFastaFile() {
        return this.fastaFile;
    }

    public void setFastaFile(File fastaFile) {
        this.fastaFile = fastaFile;
    }

    public Integer getnMissedCleavages() {
        return this.nMissedCleavages;
    }

    public ArrayList<Integer> getForwardIons() {
        if (this.forwardIons == null) {
            this.forwardIons = new ArrayList(1);
            this.forwardIons.add(this.forwardIon);
        }
        return this.forwardIons;
    }

    public void setForwardIons(ArrayList<Integer> forwardIons) {
        this.forwardIons = forwardIons;
    }

    public ArrayList<Integer> getRewindIons() {
        if (this.rewindIons == null) {
            this.rewindIons = new ArrayList(1);
            this.rewindIons.add(this.rewindIon);
        }
        return this.rewindIons;
    }

    public void setRewindIons(ArrayList<Integer> rewindIons) {
        this.rewindIons = rewindIons;
    }

    public static String[] getIons() {
        int n;
        String[] ions = new String[implementedForwardIons.length + implementedRewindIons.length];
        String[] stringArray = implementedForwardIons;
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String forwardIon1;
            ions[ions.length] = forwardIon1 = stringArray[n];
        }
        stringArray = implementedRewindIons;
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            String rewindIon1;
            ions[ions.length] = rewindIon1 = stringArray[n];
        }
        return ions;
    }

    public Double getPrecursorAccuracy() {
        return this.precursorTolerance;
    }

    public void setPrecursorAccuracy(Double precursorTolerance) {
        this.precursorTolerance = precursorTolerance;
    }

    public Double getPrecursorAccuracyDalton() {
        return this.precursorToleranceDalton;
    }

    public void setPrecursorAccuracyDalton(Double precursorToleranceDalton) {
        this.precursorToleranceDalton = precursorToleranceDalton;
    }

    public MassAccuracyType getPrecursorAccuracyType() {
        return this.precursorAccuracyType;
    }

    public void setPrecursorAccuracyType(MassAccuracyType precursorAccuracyType) {
        this.precursorAccuracyType = precursorAccuracyType;
    }

    public MassAccuracyType getFragmentAccuracyType() {
        return this.fragmentAccuracyType;
    }

    public void setFragmentAccuracyType(MassAccuracyType fragmentAccuracyType) {
        this.fragmentAccuracyType = fragmentAccuracyType;
    }

    public Boolean isPrecursorAccuracyTypePpm() {
        return this.getPrecursorAccuracyType() == MassAccuracyType.PPM;
    }

    public Charge getMaxChargeSearched() {
        return this.maxChargeSearched;
    }

    public void setMaxChargeSearched(Charge maxChargeSearched) {
        this.maxChargeSearched = maxChargeSearched;
    }

    public Charge getMinChargeSearched() {
        return this.minChargeSearched;
    }

    public void setMinChargeSearched(Charge minChargeSearched) {
        this.minChargeSearched = minChargeSearched;
    }

    public HashMap<Integer, IdentificationAlgorithmParameter> getAlgorithmSpecificParameters() {
        return this.algorithmParameters;
    }

    public IdentificationAlgorithmParameter getIdentificationAlgorithmParameter(int algorithmID) {
        if (this.algorithmParameters == null) {
            return null;
        }
        return this.algorithmParameters.get(algorithmID);
    }

    public void setIdentificationAlgorithmParameter(int algorithmID, IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (this.algorithmParameters == null) {
            this.algorithmParameters = new HashMap();
        }
        this.algorithmParameters.put(algorithmID, identificationAlgorithmParameter);
    }

    public Set<Integer> getAlgorithms() {
        if (this.algorithmParameters == null) {
            return new HashSet<Integer>();
        }
        return this.algorithmParameters.keySet();
    }

    public Integer getMinIsotopicCorrection() {
        if (this.minIsotopicCorrection == null) {
            this.minIsotopicCorrection = 0;
        }
        return this.minIsotopicCorrection;
    }

    public void setMinIsotopicCorrection(Integer minIsotopicCorrection) {
        this.minIsotopicCorrection = minIsotopicCorrection;
    }

    public Integer getMaxIsotopicCorrection() {
        if (this.maxIsotopicCorrection == null) {
            this.maxIsotopicCorrection = 1;
        }
        return this.maxIsotopicCorrection;
    }

    public void setMaxIsotopicCorrection(Integer maxIsotopicCorrection) {
        this.maxIsotopicCorrection = maxIsotopicCorrection;
    }

    public static SearchParameters getIdentificationParameters(File searchParametersFile) throws IOException, ClassNotFoundException {
        SearchParameters searchParameters;
        Object savedObject;
        block10: {
            try {
                IdentificationParametersMarshaller jsonMarshaller = new IdentificationParametersMarshaller();
                Class expectedObjectType = DummyParameters.class;
                Object object = jsonMarshaller.fromJson(expectedObjectType, searchParametersFile);
                DummyParameters dummyParameters = (DummyParameters)object;
                if (dummyParameters.getType() == MarshallableParameter.Type.search_parameters) {
                    expectedObjectType = SearchParameters.class;
                    savedObject = jsonMarshaller.fromJson(expectedObjectType, searchParametersFile);
                    break block10;
                }
                if (dummyParameters.getType() == MarshallableParameter.Type.identification_parameters) {
                    expectedObjectType = IdentificationParameters.class;
                    savedObject = jsonMarshaller.fromJson(expectedObjectType, searchParametersFile);
                    break block10;
                }
                throw new IllegalArgumentException("Parameters file " + searchParametersFile + " not recognized.");
            }
            catch (Exception e1) {
                try {
                    savedObject = SerializationUtils.readObject(searchParametersFile);
                }
                catch (Exception e2) {
                    e1.printStackTrace();
                    e2.printStackTrace();
                    throw new IllegalArgumentException("Parameters file " + searchParametersFile + " not recognized.");
                }
            }
        }
        if (savedObject instanceof SearchParameters) {
            searchParameters = (SearchParameters)savedObject;
        } else if (savedObject instanceof IdentificationParameters) {
            IdentificationParameters identificationParameters = (IdentificationParameters)savedObject;
            searchParameters = identificationParameters.getSearchParameters();
        } else {
            throw new UnsupportedOperationException("Parameters of type " + savedObject.getClass() + " not supported.");
        }
        return searchParameters;
    }

    public static void saveIdentificationParameters(SearchParameters searchParameters, File searchParametersFile) throws IOException {
        IdentificationParametersMarshaller jsonMarshaller = new IdentificationParametersMarshaller();
        searchParameters.setType();
        jsonMarshaller.saveObjectToJson(searchParameters, searchParametersFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIdentificationParametersAsTextFile(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        try {
            BufferedWriter bw = new BufferedWriter(fw);
            try {
                bw.write(this.toString());
            }
            finally {
                bw.close();
            }
        }
        finally {
            fw.close();
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String getShortDescription() {
        boolean first;
        ArrayList<String> ptms;
        SearchParameters defaultParameters = new SearchParameters();
        String newLine = System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        if (this.digestionPreferences != null && !DigestionPreferences.getDefaultPreferences().equals(this.digestionPreferences)) {
            output.append(this.digestionPreferences.getShortDescription());
        }
        if (this.ptmSettings != null && !(ptms = this.ptmSettings.getFixedModifications()).isEmpty()) {
            output.append("Fixed: ");
            first = true;
            for (String ptm : ptms) {
                if (first) {
                    output.append(ptm);
                    first = false;
                    continue;
                }
                output.append(", ").append(ptm);
            }
            output.append(".").append(newLine);
        }
        if (this.ptmSettings != null && !(ptms = this.ptmSettings.getVariableModifications()).isEmpty()) {
            output.append("Variable: ");
            first = true;
            for (String ptm : ptms) {
                if (first) {
                    output.append(ptm);
                    first = false;
                    continue;
                }
                output.append(", ").append(ptm);
            }
            output.append(".").append(newLine);
        }
        if (!this.precursorTolerance.equals(defaultParameters.getPrecursorAccuracy()) || !this.getPrecursorAccuracyType().equals((Object)defaultParameters.getPrecursorAccuracyType())) {
            output.append("Precursor Tolerance: ").append(this.precursorTolerance).append(" ").append((Object)this.precursorAccuracyType).append(".").append(newLine);
        }
        if (!this.fragmentIonMZTolerance.equals(defaultParameters.getFragmentIonAccuracy()) || !this.getFragmentAccuracyType().equals((Object)defaultParameters.getFragmentAccuracyType())) {
            output.append("Fragment Tolerance: ").append(this.fragmentIonMZTolerance).append(" ").append((Object)this.fragmentAccuracyType).append(".").append(newLine);
        }
        if (!Util.sameLists(this.forwardIons, defaultParameters.getForwardIons()) || !Util.sameLists(this.rewindIons, defaultParameters.getRewindIons())) {
            StringBuilder ions1 = new StringBuilder();
            Collections.sort(this.forwardIons);
            for (Integer ion : this.forwardIons) {
                if (ions1.length() > 0) {
                    ions1.append(", ");
                }
                ions1.append(PeptideFragmentIon.getSubTypeAsString(ion));
            }
            StringBuilder ions2 = new StringBuilder();
            Collections.sort(this.rewindIons);
            for (Integer ion : this.rewindIons) {
                if (ions2.length() > 0) {
                    ions2.append(", ");
                }
                ions2.append(PeptideFragmentIon.getSubTypeAsString(ion));
            }
            output.append("Ion Types: ").append((CharSequence)ions1).append(" and ").append((CharSequence)ions2).append(".").append(newLine);
        }
        if (!this.minChargeSearched.equals(defaultParameters.getMinChargeSearched()) || !this.maxChargeSearched.equals(defaultParameters.getMaxChargeSearched())) {
            output.append("Charge: ").append(this.minChargeSearched.value).append("-").append(this.maxChargeSearched.value).append(".").append(newLine);
        }
        if (!this.getMinIsotopicCorrection().equals(defaultParameters.getMinIsotopicCorrection()) || !this.getMaxIsotopicCorrection().equals(defaultParameters.getMaxIsotopicCorrection())) {
            output.append("Isotopic Correction: ").append(this.minIsotopicCorrection).append("-").append(this.maxIsotopicCorrection).append(".").append(newLine);
        }
        output.append("DB: ");
        if (this.fastaFile != null) {
            output.append(this.fastaFile.getName());
        } else {
            output.append("not set");
        }
        output.append(".").append(newLine);
        return output.toString();
    }

    public String toString(boolean html) {
        boolean first;
        ArrayList<String> fixedPtms;
        String newLine = html ? "<br>" : System.getProperty("line.separator");
        StringBuilder output = new StringBuilder();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# General Search Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("DATABASE_FILE=");
        if (this.fastaFile != null) {
            output.append(this.fastaFile.getAbsolutePath());
        }
        output.append(newLine);
        if (this.digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.enzyme) {
            ArrayList<Enzyme> enzymes = this.digestionPreferences.getEnzymes();
            for (int i = 0; i < enzymes.size(); ++i) {
                Iterator<String> tempEnzyme = enzymes.get(i);
                String enzymeName = ((Enzyme)((Object)tempEnzyme)).getName();
                output.append("ENZYME").append(i).append("=");
                output.append(enzymeName).append(", ").append((Object)this.digestionPreferences.getSpecificity(enzymeName));
                Integer nmc = this.digestionPreferences.getnMissedCleavages(enzymeName);
                if (nmc != null) {
                    output.append(", ").append(nmc).append(" missed cleavages");
                }
                output.append(newLine);
            }
        } else {
            output.append("ENZYME").append("=").append(this.digestionPreferences.getCleavagePreference().name);
        }
        output.append("FIXED_MODIFICATIONS=");
        if (this.ptmSettings != null) {
            fixedPtms = this.ptmSettings.getFixedModifications();
            first = true;
            for (String ptm : fixedPtms) {
                if (first) {
                    output.append(ptm);
                    first = false;
                    continue;
                }
                output.append("//").append(ptm);
            }
        }
        output.append(newLine);
        output.append("VARIABLE_MODIFICATIONS=");
        if (this.ptmSettings != null) {
            fixedPtms = this.ptmSettings.getVariableModifications();
            first = true;
            for (String ptm : fixedPtms) {
                if (first) {
                    output.append(ptm);
                    first = false;
                    continue;
                }
                output.append("//").append(ptm);
            }
        }
        output.append(newLine);
        output.append("REFINEMENT_FIXED_MODIFICATIONS=");
        if (this.ptmSettings != null && this.ptmSettings.getRefinementFixedModifications() != null) {
            fixedPtms = this.ptmSettings.getRefinementFixedModifications();
            first = true;
            for (String ptm : fixedPtms) {
                if (first) {
                    output.append(ptm);
                    first = false;
                    continue;
                }
                output.append("//").append(ptm);
            }
        }
        output.append(newLine);
        output.append("REFINEMENT_VARIABLE_MODIFICATIONS=");
        if (this.ptmSettings != null && this.ptmSettings.getRefinementVariableModifications() != null) {
            fixedPtms = this.ptmSettings.getRefinementVariableModifications();
            first = true;
            for (String ptm : fixedPtms) {
                if (first) {
                    output.append(ptm);
                    first = false;
                    continue;
                }
                output.append("//").append(ptm);
            }
        }
        output.append(newLine);
        output.append("PRECURSOR_MASS_TOLERANCE=");
        output.append(this.precursorTolerance);
        output.append(newLine);
        output.append("PRECURSOR_MASS_TOLERANCE_UNIT=");
        if (this.getPrecursorAccuracyType() == MassAccuracyType.PPM) {
            output.append("ppm");
        } else {
            output.append("Da");
        }
        output.append(newLine);
        output.append("FRAGMENT_MASS_TOLERANCE=");
        output.append(this.fragmentIonMZTolerance);
        output.append(newLine);
        output.append("FRAGMENT_MASS_TOLERANCE_UNIT=");
        if (this.getFragmentAccuracyType() == MassAccuracyType.PPM) {
            output.append("ppm");
        } else {
            output.append("Da");
        }
        output.append(newLine);
        output.append("PPM_TO_DA_CONVERSION_REF_MASS=");
        output.append(this.getRefMass());
        output.append(newLine);
        output.append("FORWARD_FRAGMENT_ION_TYPE=");
        StringBuilder ions1 = new StringBuilder();
        Collections.sort(this.forwardIons);
        for (Integer ion : this.forwardIons) {
            if (ions1.length() > 0) {
                ions1.append(", ");
            }
            ions1.append(PeptideFragmentIon.getSubTypeAsString(ion));
        }
        output.append((CharSequence)ions1);
        output.append(newLine);
        output.append("FRAGMENT_ION_TYPE_2=");
        StringBuilder ions2 = new StringBuilder();
        Collections.sort(this.rewindIons);
        for (Integer ion : this.rewindIons) {
            if (ions2.length() > 0) {
                ions2.append(", ");
            }
            ions2.append(PeptideFragmentIon.getSubTypeAsString(ion));
        }
        output.append((CharSequence)ions2);
        output.append(newLine);
        output.append("PRECURSOR_CHARGE_LOWER_BOUND=");
        output.append(this.minChargeSearched);
        output.append(newLine);
        output.append("PRECURSOR_CHARGE_UPPER_BOUND=");
        output.append(this.maxChargeSearched);
        output.append(newLine);
        output.append("ISOTOPIC_CORRECTION_LOWER_BOUND=");
        output.append(this.getMinIsotopicCorrection());
        output.append(newLine);
        output.append("ISOTOPIC_CORRECTION_UPPER_BOUND=");
        output.append(this.getMaxIsotopicCorrection());
        output.append(newLine);
        for (int index : this.algorithmParameters.keySet()) {
            output.append(newLine);
            output.append(newLine);
            output.append(this.algorithmParameters.get(index).toString(html));
        }
        return output.toString();
    }

    public boolean equals(SearchParameters otherSearchParameters) {
        if (otherSearchParameters == null) {
            return false;
        }
        if (this.getPrecursorAccuracyType() != otherSearchParameters.getPrecursorAccuracyType()) {
            return false;
        }
        if (!this.getPrecursorAccuracy().equals(otherSearchParameters.getPrecursorAccuracy())) {
            return false;
        }
        if (!this.getFragmentAccuracyType().equals((Object)otherSearchParameters.getFragmentAccuracyType())) {
            return false;
        }
        if (!this.getFragmentIonAccuracy().equals(otherSearchParameters.getFragmentIonAccuracy())) {
            return false;
        }
        if (this.getFastaFile() == null && otherSearchParameters.getFastaFile() != null || this.getFastaFile() != null && otherSearchParameters.getFastaFile() == null) {
            return false;
        }
        if (this.getFastaFile() != null && otherSearchParameters.getFastaFile() != null && !this.getFastaFile().getAbsolutePath().equalsIgnoreCase(otherSearchParameters.getFastaFile().getAbsolutePath())) {
            return false;
        }
        if (this.getDigestionPreferences() != null && otherSearchParameters.getDigestionPreferences() == null || this.getDigestionPreferences() == null && otherSearchParameters.getDigestionPreferences() != null) {
            return false;
        }
        if (this.getDigestionPreferences() != null && otherSearchParameters.getDigestionPreferences() != null && !this.getDigestionPreferences().isSameAs(otherSearchParameters.getDigestionPreferences())) {
            return false;
        }
        if (!Util.sameLists(this.forwardIons, otherSearchParameters.getForwardIons())) {
            return false;
        }
        if (!Util.sameLists(this.rewindIons, otherSearchParameters.getRewindIons())) {
            return false;
        }
        if (!this.getMinChargeSearched().equals(otherSearchParameters.getMinChargeSearched())) {
            return false;
        }
        if (!this.getMaxChargeSearched().equals(otherSearchParameters.getMaxChargeSearched())) {
            return false;
        }
        if (!this.getMinIsotopicCorrection().equals(otherSearchParameters.getMinIsotopicCorrection())) {
            return false;
        }
        if (!this.getMaxIsotopicCorrection().equals(otherSearchParameters.getMaxIsotopicCorrection())) {
            return false;
        }
        if (!this.getPtmSettings().equals(otherSearchParameters.getPtmSettings())) {
            return false;
        }
        if (this.getAlgorithms().size() != otherSearchParameters.getAlgorithms().size()) {
            return false;
        }
        for (int se : this.getAlgorithms()) {
            IdentificationAlgorithmParameter otherParameter = otherSearchParameters.getIdentificationAlgorithmParameter(se);
            if (otherParameter == null) {
                return false;
            }
            IdentificationAlgorithmParameter thisParameter = this.getIdentificationAlgorithmParameter(se);
            if (otherParameter.equals(thisParameter)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setType() {
        this.marshallableParameterType = MarshallableParameter.Type.search_parameters.name();
    }

    @Override
    public MarshallableParameter.Type getType() {
        if (this.marshallableParameterType == null) {
            return null;
        }
        return MarshallableParameter.Type.valueOf(this.marshallableParameterType);
    }

    public static enum MassAccuracyType {
        PPM,
        DA;


        public String toString() {
            switch (this) {
                case PPM: {
                    return "ppm";
                }
                case DA: {
                    return "Da";
                }
            }
            throw new UnsupportedOperationException("Name of tolerance type " + this.name() + " not implemented.");
        }
    }
}

