/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters.tool_specific;

import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationAlgorithmParameter;
import java.util.HashMap;

public class PNovoParameters
implements IdentificationAlgorithmParameter {
    static final long serialVersionUID = 7525455518683797145L;
    private int numberOfPeptides = 10;
    private int lowerPrecursorMass = 300;
    private int upperPrecursorMass = 5000;
    private String acticationType = "HCD";
    private HashMap<Character, String> pNovoPtmMap;
    private HashMap<Character, Character> pNovoResidueMap;

    @Override
    public Advocate getAlgorithm() {
        return Advocate.pNovo;
    }

    @Override
    public boolean equals(IdentificationAlgorithmParameter identificationAlgorithmParameter) {
        if (identificationAlgorithmParameter instanceof PNovoParameters) {
            PNovoParameters pNovoParameters = (PNovoParameters)identificationAlgorithmParameter;
            if (this.getNumberOfPeptides() != pNovoParameters.getNumberOfPeptides()) {
                return false;
            }
            if (this.getLowerPrecursorMass() != pNovoParameters.getLowerPrecursorMass()) {
                return false;
            }
            if (this.getUpperPrecursorMass() != pNovoParameters.getUpperPrecursorMass()) {
                return false;
            }
            if (!this.getActicationType().equalsIgnoreCase(pNovoParameters.getActicationType())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString(boolean html) {
        String newLine = System.getProperty("line.separator");
        if (html) {
            newLine = "<br>";
        }
        StringBuilder output = new StringBuilder();
        Advocate advocate = this.getAlgorithm();
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append("# ").append(advocate.getName()).append(" Specific Parameters");
        output.append(newLine);
        output.append("# ------------------------------------------------------------------");
        output.append(newLine);
        output.append(newLine);
        output.append("NUMBER_PEPTIDES=");
        output.append(this.numberOfPeptides);
        output.append(newLine);
        output.append("LOWER_PRECURSOR_MASS=");
        output.append(this.lowerPrecursorMass);
        output.append(newLine);
        output.append("UPPER_PRECURSOR_MASS=");
        output.append(this.upperPrecursorMass);
        output.append(newLine);
        output.append("ACTIVATION_TYPE=");
        output.append(this.acticationType);
        output.append(newLine);
        return output.toString();
    }

    public int getNumberOfPeptides() {
        return this.numberOfPeptides;
    }

    public void setNumberOfPeptides(int numberOfPeptides) {
        this.numberOfPeptides = numberOfPeptides;
    }

    public int getLowerPrecursorMass() {
        return this.lowerPrecursorMass;
    }

    public void setLowerPrecursorMass(int lowerPrecursorMass) {
        this.lowerPrecursorMass = lowerPrecursorMass;
    }

    public int getUpperPrecursorMass() {
        return this.upperPrecursorMass;
    }

    public void setUpperPrecursorMass(int upperPrecursorMass) {
        this.upperPrecursorMass = upperPrecursorMass;
    }

    public String getActicationType() {
        return this.acticationType;
    }

    public void setActicationType(String acticationType) {
        this.acticationType = acticationType;
    }

    public HashMap<Character, String> getPNovoPtmMap() {
        return this.pNovoPtmMap;
    }

    public String getUtilitiesPtmName(Character pNovoPtmCharacter) {
        if (this.pNovoPtmMap == null) {
            return null;
        }
        return this.pNovoPtmMap.get(pNovoPtmCharacter);
    }

    public void setPNovoPtmMap(HashMap<Character, String> pNovoPtmMap) {
        this.pNovoPtmMap = pNovoPtmMap;
    }

    public HashMap<Character, Character> getPNovoPtmResiduesMap() {
        return this.pNovoResidueMap;
    }

    public Character getPtmResidue(Character pNovoPtmCharacter) {
        if (this.pNovoPtmMap == null) {
            return null;
        }
        return this.pNovoResidueMap.get(pNovoPtmCharacter);
    }

    public void setPNovoPtmResiduesMap(HashMap<Character, Character> pNovoResidueMap) {
        this.pNovoResidueMap = pNovoResidueMap;
    }
}

